/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.AvailabilityZoneIdListCopier;
import software.amazon.awssdk.services.outposts.model.AvailabilityZoneListCopier;
import software.amazon.awssdk.services.outposts.model.LifeCycleStatusListCopier;
import software.amazon.awssdk.services.outposts.model.OutpostsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOutpostsRequest
extends OutpostsRequest
implements ToCopyableBuilder<Builder, ListOutpostsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListOutpostsRequest.getter(ListOutpostsRequest::nextToken)).setter(ListOutpostsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListOutpostsRequest.getter(ListOutpostsRequest::maxResults)).setter(ListOutpostsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final SdkField<List<String>> LIFE_CYCLE_STATUS_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LifeCycleStatusFilter").getter(ListOutpostsRequest.getter(ListOutpostsRequest::lifeCycleStatusFilter)).setter(ListOutpostsRequest.setter(Builder::lifeCycleStatusFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("LifeCycleStatusFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZoneFilter").getter(ListOutpostsRequest.getter(ListOutpostsRequest::availabilityZoneFilter)).setter(ListOutpostsRequest.setter(Builder::availabilityZoneFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("AvailabilityZoneFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONE_ID_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZoneIdFilter").getter(ListOutpostsRequest.getter(ListOutpostsRequest::availabilityZoneIdFilter)).setter(ListOutpostsRequest.setter(Builder::availabilityZoneIdFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("AvailabilityZoneIdFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, LIFE_CYCLE_STATUS_FILTER_FIELD, AVAILABILITY_ZONE_FILTER_FIELD, AVAILABILITY_ZONE_ID_FILTER_FIELD));
    private final String nextToken;
    private final Integer maxResults;
    private final List<String> lifeCycleStatusFilter;
    private final List<String> availabilityZoneFilter;
    private final List<String> availabilityZoneIdFilter;

    private ListOutpostsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.lifeCycleStatusFilter = builder.lifeCycleStatusFilter;
        this.availabilityZoneFilter = builder.availabilityZoneFilter;
        this.availabilityZoneIdFilter = builder.availabilityZoneIdFilter;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasLifeCycleStatusFilter() {
        return this.lifeCycleStatusFilter != null && !(this.lifeCycleStatusFilter instanceof SdkAutoConstructList);
    }

    public final List<String> lifeCycleStatusFilter() {
        return this.lifeCycleStatusFilter;
    }

    public final boolean hasAvailabilityZoneFilter() {
        return this.availabilityZoneFilter != null && !(this.availabilityZoneFilter instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZoneFilter() {
        return this.availabilityZoneFilter;
    }

    public final boolean hasAvailabilityZoneIdFilter() {
        return this.availabilityZoneIdFilter != null && !(this.availabilityZoneIdFilter instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZoneIdFilter() {
        return this.availabilityZoneIdFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLifeCycleStatusFilter() ? this.lifeCycleStatusFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZoneFilter() ? this.availabilityZoneFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZoneIdFilter() ? this.availabilityZoneIdFilter() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOutpostsRequest)) {
            return false;
        }
        ListOutpostsRequest other = (ListOutpostsRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasLifeCycleStatusFilter() == other.hasLifeCycleStatusFilter() && Objects.equals(this.lifeCycleStatusFilter(), other.lifeCycleStatusFilter()) && this.hasAvailabilityZoneFilter() == other.hasAvailabilityZoneFilter() && Objects.equals(this.availabilityZoneFilter(), other.availabilityZoneFilter()) && this.hasAvailabilityZoneIdFilter() == other.hasAvailabilityZoneIdFilter() && Objects.equals(this.availabilityZoneIdFilter(), other.availabilityZoneIdFilter());
    }

    public final String toString() {
        return ToString.builder((String)"ListOutpostsRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("LifeCycleStatusFilter", this.hasLifeCycleStatusFilter() ? this.lifeCycleStatusFilter() : null).add("AvailabilityZoneFilter", this.hasAvailabilityZoneFilter() ? this.availabilityZoneFilter() : null).add("AvailabilityZoneIdFilter", this.hasAvailabilityZoneIdFilter() ? this.availabilityZoneIdFilter() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "LifeCycleStatusFilter": {
                return Optional.ofNullable(clazz.cast(this.lifeCycleStatusFilter()));
            }
            case "AvailabilityZoneFilter": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneFilter()));
            }
            case "AvailabilityZoneIdFilter": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneIdFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOutpostsRequest, T> g) {
        return obj -> g.apply((ListOutpostsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private List<String> lifeCycleStatusFilter = DefaultSdkAutoConstructList.getInstance();
        private List<String> availabilityZoneFilter = DefaultSdkAutoConstructList.getInstance();
        private List<String> availabilityZoneIdFilter = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListOutpostsRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.lifeCycleStatusFilter(model.lifeCycleStatusFilter);
            this.availabilityZoneFilter(model.availabilityZoneFilter);
            this.availabilityZoneIdFilter(model.availabilityZoneIdFilter);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getLifeCycleStatusFilter() {
            if (this.lifeCycleStatusFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lifeCycleStatusFilter;
        }

        public final void setLifeCycleStatusFilter(Collection<String> lifeCycleStatusFilter) {
            this.lifeCycleStatusFilter = LifeCycleStatusListCopier.copy(lifeCycleStatusFilter);
        }

        @Override
        public final Builder lifeCycleStatusFilter(Collection<String> lifeCycleStatusFilter) {
            this.lifeCycleStatusFilter = LifeCycleStatusListCopier.copy(lifeCycleStatusFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifeCycleStatusFilter(String ... lifeCycleStatusFilter) {
            this.lifeCycleStatusFilter(Arrays.asList(lifeCycleStatusFilter));
            return this;
        }

        public final Collection<String> getAvailabilityZoneFilter() {
            if (this.availabilityZoneFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZoneFilter;
        }

        public final void setAvailabilityZoneFilter(Collection<String> availabilityZoneFilter) {
            this.availabilityZoneFilter = AvailabilityZoneListCopier.copy(availabilityZoneFilter);
        }

        @Override
        public final Builder availabilityZoneFilter(Collection<String> availabilityZoneFilter) {
            this.availabilityZoneFilter = AvailabilityZoneListCopier.copy(availabilityZoneFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZoneFilter(String ... availabilityZoneFilter) {
            this.availabilityZoneFilter(Arrays.asList(availabilityZoneFilter));
            return this;
        }

        public final Collection<String> getAvailabilityZoneIdFilter() {
            if (this.availabilityZoneIdFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZoneIdFilter;
        }

        public final void setAvailabilityZoneIdFilter(Collection<String> availabilityZoneIdFilter) {
            this.availabilityZoneIdFilter = AvailabilityZoneIdListCopier.copy(availabilityZoneIdFilter);
        }

        @Override
        public final Builder availabilityZoneIdFilter(Collection<String> availabilityZoneIdFilter) {
            this.availabilityZoneIdFilter = AvailabilityZoneIdListCopier.copy(availabilityZoneIdFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZoneIdFilter(String ... availabilityZoneIdFilter) {
            this.availabilityZoneIdFilter(Arrays.asList(availabilityZoneIdFilter));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListOutpostsRequest build() {
            return new ListOutpostsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OutpostsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOutpostsRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder lifeCycleStatusFilter(Collection<String> var1);

        public Builder lifeCycleStatusFilter(String ... var1);

        public Builder availabilityZoneFilter(Collection<String> var1);

        public Builder availabilityZoneFilter(String ... var1);

        public Builder availabilityZoneIdFilter(Collection<String> var1);

        public Builder availabilityZoneIdFilter(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

