/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccountStatus {
    ACTIVE("ACTIVE"),
    SUSPENDED("SUSPENDED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccountStatus> VALUE_MAP;
    private final String value;

    private AccountStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccountStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccountStatus> knownValues() {
        EnumSet<AccountStatus> knownValues = EnumSet.allOf(AccountStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccountStatus.class, AccountStatus::toString);
    }
}

