/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opsworkscm.model.OpsWorksCmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateServerRequest
extends OpsWorksCmRequest
implements ToCopyableBuilder<Builder, UpdateServerRequest> {
    private static final SdkField<Boolean> DISABLE_AUTOMATED_BACKUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisableAutomatedBackup").getter(UpdateServerRequest.getter(UpdateServerRequest::disableAutomatedBackup)).setter(UpdateServerRequest.setter(Builder::disableAutomatedBackup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableAutomatedBackup").build()}).build();
    private static final SdkField<Integer> BACKUP_RETENTION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BackupRetentionCount").getter(UpdateServerRequest.getter(UpdateServerRequest::backupRetentionCount)).setter(UpdateServerRequest.setter(Builder::backupRetentionCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionCount").build()}).build();
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerName").getter(UpdateServerRequest.getter(UpdateServerRequest::serverName)).setter(UpdateServerRequest.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMaintenanceWindow").getter(UpdateServerRequest.getter(UpdateServerRequest::preferredMaintenanceWindow)).setter(UpdateServerRequest.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredBackupWindow").getter(UpdateServerRequest.getter(UpdateServerRequest::preferredBackupWindow)).setter(UpdateServerRequest.setter(Builder::preferredBackupWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISABLE_AUTOMATED_BACKUP_FIELD, BACKUP_RETENTION_COUNT_FIELD, SERVER_NAME_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, PREFERRED_BACKUP_WINDOW_FIELD));
    private final Boolean disableAutomatedBackup;
    private final Integer backupRetentionCount;
    private final String serverName;
    private final String preferredMaintenanceWindow;
    private final String preferredBackupWindow;

    private UpdateServerRequest(BuilderImpl builder) {
        super(builder);
        this.disableAutomatedBackup = builder.disableAutomatedBackup;
        this.backupRetentionCount = builder.backupRetentionCount;
        this.serverName = builder.serverName;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.preferredBackupWindow = builder.preferredBackupWindow;
    }

    public final Boolean disableAutomatedBackup() {
        return this.disableAutomatedBackup;
    }

    public final Integer backupRetentionCount() {
        return this.backupRetentionCount;
    }

    public final String serverName() {
        return this.serverName;
    }

    public final String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public final String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.disableAutomatedBackup());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupRetentionCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredBackupWindow());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServerRequest)) {
            return false;
        }
        UpdateServerRequest other = (UpdateServerRequest)((Object)obj);
        return Objects.equals(this.disableAutomatedBackup(), other.disableAutomatedBackup()) && Objects.equals(this.backupRetentionCount(), other.backupRetentionCount()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.preferredBackupWindow(), other.preferredBackupWindow());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateServerRequest").add("DisableAutomatedBackup", (Object)this.disableAutomatedBackup()).add("BackupRetentionCount", (Object)this.backupRetentionCount()).add("ServerName", (Object)this.serverName()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("PreferredBackupWindow", (Object)this.preferredBackupWindow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DisableAutomatedBackup": {
                return Optional.ofNullable(clazz.cast(this.disableAutomatedBackup()));
            }
            case "BackupRetentionCount": {
                return Optional.ofNullable(clazz.cast(this.backupRetentionCount()));
            }
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "PreferredBackupWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredBackupWindow()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateServerRequest, T> g) {
        return obj -> g.apply((UpdateServerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksCmRequest.BuilderImpl
    implements Builder {
        private Boolean disableAutomatedBackup;
        private Integer backupRetentionCount;
        private String serverName;
        private String preferredMaintenanceWindow;
        private String preferredBackupWindow;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServerRequest model) {
            super(model);
            this.disableAutomatedBackup(model.disableAutomatedBackup);
            this.backupRetentionCount(model.backupRetentionCount);
            this.serverName(model.serverName);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.preferredBackupWindow(model.preferredBackupWindow);
        }

        public final Boolean getDisableAutomatedBackup() {
            return this.disableAutomatedBackup;
        }

        public final void setDisableAutomatedBackup(Boolean disableAutomatedBackup) {
            this.disableAutomatedBackup = disableAutomatedBackup;
        }

        @Override
        public final Builder disableAutomatedBackup(Boolean disableAutomatedBackup) {
            this.disableAutomatedBackup = disableAutomatedBackup;
            return this;
        }

        public final Integer getBackupRetentionCount() {
            return this.backupRetentionCount;
        }

        public final void setBackupRetentionCount(Integer backupRetentionCount) {
            this.backupRetentionCount = backupRetentionCount;
        }

        @Override
        public final Builder backupRetentionCount(Integer backupRetentionCount) {
            this.backupRetentionCount = backupRetentionCount;
            return this;
        }

        public final String getServerName() {
            return this.serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServerRequest build() {
            return new UpdateServerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksCmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateServerRequest> {
        public Builder disableAutomatedBackup(Boolean var1);

        public Builder backupRetentionCount(Integer var1);

        public Builder serverName(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder preferredBackupWindow(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

