/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opsworkscm.model.OpsWorksCmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreServerRequest
extends OpsWorksCmRequest
implements ToCopyableBuilder<Builder, RestoreServerRequest> {
    private static final SdkField<String> BACKUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupId").getter(RestoreServerRequest.getter(RestoreServerRequest::backupId)).setter(RestoreServerRequest.setter(Builder::backupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupId").build()}).build();
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerName").getter(RestoreServerRequest.getter(RestoreServerRequest::serverName)).setter(RestoreServerRequest.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(RestoreServerRequest.getter(RestoreServerRequest::instanceType)).setter(RestoreServerRequest.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> KEY_PAIR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyPair").getter(RestoreServerRequest.getter(RestoreServerRequest::keyPair)).setter(RestoreServerRequest.setter(Builder::keyPair)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPair").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_ID_FIELD, SERVER_NAME_FIELD, INSTANCE_TYPE_FIELD, KEY_PAIR_FIELD));
    private final String backupId;
    private final String serverName;
    private final String instanceType;
    private final String keyPair;

    private RestoreServerRequest(BuilderImpl builder) {
        super(builder);
        this.backupId = builder.backupId;
        this.serverName = builder.serverName;
        this.instanceType = builder.instanceType;
        this.keyPair = builder.keyPair;
    }

    public final String backupId() {
        return this.backupId;
    }

    public final String serverName() {
        return this.serverName;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String keyPair() {
        return this.keyPair;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPair());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreServerRequest)) {
            return false;
        }
        RestoreServerRequest other = (RestoreServerRequest)((Object)obj);
        return Objects.equals(this.backupId(), other.backupId()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.keyPair(), other.keyPair());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreServerRequest").add("BackupId", (Object)this.backupId()).add("ServerName", (Object)this.serverName()).add("InstanceType", (Object)this.instanceType()).add("KeyPair", (Object)this.keyPair()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupId": {
                return Optional.ofNullable(clazz.cast(this.backupId()));
            }
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "KeyPair": {
                return Optional.ofNullable(clazz.cast(this.keyPair()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreServerRequest, T> g) {
        return obj -> g.apply((RestoreServerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksCmRequest.BuilderImpl
    implements Builder {
        private String backupId;
        private String serverName;
        private String instanceType;
        private String keyPair;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreServerRequest model) {
            super(model);
            this.backupId(model.backupId);
            this.serverName(model.serverName);
            this.instanceType(model.instanceType);
            this.keyPair(model.keyPair);
        }

        public final String getBackupId() {
            return this.backupId;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final String getServerName() {
            return this.serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getKeyPair() {
            return this.keyPair;
        }

        public final void setKeyPair(String keyPair) {
            this.keyPair = keyPair;
        }

        @Override
        public final Builder keyPair(String keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreServerRequest build() {
            return new RestoreServerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksCmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreServerRequest> {
        public Builder backupId(String var1);

        public Builder serverName(String var1);

        public Builder instanceType(String var1);

        public Builder keyPair(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

