/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum LayerType {
    AWS_FLOW_RUBY("aws-flow-ruby"),
    ECS_CLUSTER("ecs-cluster"),
    JAVA_APP("java-app"),
    LB("lb"),
    WEB("web"),
    PHP_APP("php-app"),
    RAILS_APP("rails-app"),
    NODEJS_APP("nodejs-app"),
    MEMCACHED("memcached"),
    DB_MASTER("db-master"),
    MONITORING_MASTER("monitoring-master"),
    CUSTOM("custom"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private LayerType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LayerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(LayerType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LayerType> knownValues() {
        return Stream.of(LayerType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

