/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a reference store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReferenceStoreDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ReferenceStoreDetail.Builder, ReferenceStoreDetail> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ReferenceStoreDetail::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ReferenceStoreDetail::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ReferenceStoreDetail::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ReferenceStoreDetail::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<SseConfig> SSE_CONFIG_FIELD = SdkField.<SseConfig> builder(MarshallingType.SDK_POJO)
            .memberName("sseConfig").getter(getter(ReferenceStoreDetail::sseConfig)).setter(setter(Builder::sseConfig))
            .constructor(SseConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sseConfig").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(ReferenceStoreDetail::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, SSE_CONFIG_FIELD, CREATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String id;

    private final String name;

    private final String description;

    private final SseConfig sseConfig;

    private final Instant creationTime;

    private ReferenceStoreDetail(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.sseConfig = builder.sseConfig;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The store's ARN.
     * </p>
     * 
     * @return The store's ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The store's ID.
     * </p>
     * 
     * @return The store's ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The store's name.
     * </p>
     * 
     * @return The store's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The store's description.
     * </p>
     * 
     * @return The store's description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The store's server-side encryption (SSE) settings.
     * </p>
     * 
     * @return The store's server-side encryption (SSE) settings.
     */
    public final SseConfig sseConfig() {
        return sseConfig;
    }

    /**
     * <p>
     * When the store was created.
     * </p>
     * 
     * @return When the store was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(sseConfig());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceStoreDetail)) {
            return false;
        }
        ReferenceStoreDetail other = (ReferenceStoreDetail) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(sseConfig(), other.sseConfig())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReferenceStoreDetail").add("Arn", arn()).add("Id", id()).add("Name", name())
                .add("Description", description()).add("SseConfig", sseConfig()).add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "sseConfig":
            return Optional.ofNullable(clazz.cast(sseConfig()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReferenceStoreDetail, T> g) {
        return obj -> g.apply((ReferenceStoreDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReferenceStoreDetail> {
        /**
         * <p>
         * The store's ARN.
         * </p>
         * 
         * @param arn
         *        The store's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The store's ID.
         * </p>
         * 
         * @param id
         *        The store's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The store's name.
         * </p>
         * 
         * @param name
         *        The store's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The store's description.
         * </p>
         * 
         * @param description
         *        The store's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The store's server-side encryption (SSE) settings.
         * </p>
         * 
         * @param sseConfig
         *        The store's server-side encryption (SSE) settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseConfig(SseConfig sseConfig);

        /**
         * <p>
         * The store's server-side encryption (SSE) settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link SseConfig.Builder} avoiding the need to
         * create one manually via {@link SseConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SseConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #sseConfig(SseConfig)}.
         * 
         * @param sseConfig
         *        a consumer that will call methods on {@link SseConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sseConfig(SseConfig)
         */
        default Builder sseConfig(Consumer<SseConfig.Builder> sseConfig) {
            return sseConfig(SseConfig.builder().applyMutation(sseConfig).build());
        }

        /**
         * <p>
         * When the store was created.
         * </p>
         * 
         * @param creationTime
         *        When the store was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String name;

        private String description;

        private SseConfig sseConfig;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceStoreDetail model) {
            arn(model.arn);
            id(model.id);
            name(model.name);
            description(model.description);
            sseConfig(model.sseConfig);
            creationTime(model.creationTime);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SseConfig.Builder getSseConfig() {
            return sseConfig != null ? sseConfig.toBuilder() : null;
        }

        public final void setSseConfig(SseConfig.BuilderImpl sseConfig) {
            this.sseConfig = sseConfig != null ? sseConfig.build() : null;
        }

        @Override
        public final Builder sseConfig(SseConfig sseConfig) {
            this.sseConfig = sseConfig;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public ReferenceStoreDetail build() {
            return new ReferenceStoreDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
