/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileInformation implements SdkPojo, Serializable, ToCopyableBuilder<FileInformation.Builder, FileInformation> {
    private static final SdkField<Integer> TOTAL_PARTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalParts").getter(getter(FileInformation::totalParts)).setter(setter(Builder::totalParts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalParts").build()).build();

    private static final SdkField<Long> PART_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("partSize")
            .getter(getter(FileInformation::partSize)).setter(setter(Builder::partSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partSize").build()).build();

    private static final SdkField<Long> CONTENT_LENGTH_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("contentLength").getter(getter(FileInformation::contentLength)).setter(setter(Builder::contentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentLength").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_PARTS_FIELD,
            PART_SIZE_FIELD, CONTENT_LENGTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer totalParts;

    private final Long partSize;

    private final Long contentLength;

    private FileInformation(BuilderImpl builder) {
        this.totalParts = builder.totalParts;
        this.partSize = builder.partSize;
        this.contentLength = builder.contentLength;
    }

    /**
     * <p>
     * The file's total parts.
     * </p>
     * 
     * @return The file's total parts.
     */
    public final Integer totalParts() {
        return totalParts;
    }

    /**
     * <p>
     * The file's part size.
     * </p>
     * 
     * @return The file's part size.
     */
    public final Long partSize() {
        return partSize;
    }

    /**
     * <p>
     * The file's content length.
     * </p>
     * 
     * @return The file's content length.
     */
    public final Long contentLength() {
        return contentLength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalParts());
        hashCode = 31 * hashCode + Objects.hashCode(partSize());
        hashCode = 31 * hashCode + Objects.hashCode(contentLength());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileInformation)) {
            return false;
        }
        FileInformation other = (FileInformation) obj;
        return Objects.equals(totalParts(), other.totalParts()) && Objects.equals(partSize(), other.partSize())
                && Objects.equals(contentLength(), other.contentLength());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileInformation").add("TotalParts", totalParts()).add("PartSize", partSize())
                .add("ContentLength", contentLength()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "totalParts":
            return Optional.ofNullable(clazz.cast(totalParts()));
        case "partSize":
            return Optional.ofNullable(clazz.cast(partSize()));
        case "contentLength":
            return Optional.ofNullable(clazz.cast(contentLength()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileInformation, T> g) {
        return obj -> g.apply((FileInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileInformation> {
        /**
         * <p>
         * The file's total parts.
         * </p>
         * 
         * @param totalParts
         *        The file's total parts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalParts(Integer totalParts);

        /**
         * <p>
         * The file's part size.
         * </p>
         * 
         * @param partSize
         *        The file's part size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partSize(Long partSize);

        /**
         * <p>
         * The file's content length.
         * </p>
         * 
         * @param contentLength
         *        The file's content length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentLength(Long contentLength);
    }

    static final class BuilderImpl implements Builder {
        private Integer totalParts;

        private Long partSize;

        private Long contentLength;

        private BuilderImpl() {
        }

        private BuilderImpl(FileInformation model) {
            totalParts(model.totalParts);
            partSize(model.partSize);
            contentLength(model.contentLength);
        }

        public final Integer getTotalParts() {
            return totalParts;
        }

        public final void setTotalParts(Integer totalParts) {
            this.totalParts = totalParts;
        }

        @Override
        public final Builder totalParts(Integer totalParts) {
            this.totalParts = totalParts;
            return this;
        }

        public final Long getPartSize() {
            return partSize;
        }

        public final void setPartSize(Long partSize) {
            this.partSize = partSize;
        }

        @Override
        public final Builder partSize(Long partSize) {
            this.partSize = partSize;
            return this;
        }

        public final Long getContentLength() {
            return contentLength;
        }

        public final void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        @Override
        public final Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        @Override
        public FileInformation build() {
            return new FileInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
