/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAnnotationStoreResponse extends OmicsResponse implements
        ToCopyableBuilder<CreateAnnotationStoreResponse.Builder, CreateAnnotationStoreResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateAnnotationStoreResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<ReferenceItem> REFERENCE_FIELD = SdkField.<ReferenceItem> builder(MarshallingType.SDK_POJO)
            .memberName("reference").getter(getter(CreateAnnotationStoreResponse::reference)).setter(setter(Builder::reference))
            .constructor(ReferenceItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reference").build()).build();

    private static final SdkField<String> STORE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storeFormat").getter(getter(CreateAnnotationStoreResponse::storeFormatAsString))
            .setter(setter(Builder::storeFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeFormat").build()).build();

    private static final SdkField<StoreOptions> STORE_OPTIONS_FIELD = SdkField.<StoreOptions> builder(MarshallingType.SDK_POJO)
            .memberName("storeOptions").getter(getter(CreateAnnotationStoreResponse::storeOptions))
            .setter(setter(Builder::storeOptions)).constructor(StoreOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeOptions").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateAnnotationStoreResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateAnnotationStoreResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionName").getter(getter(CreateAnnotationStoreResponse::versionName))
            .setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(CreateAnnotationStoreResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, REFERENCE_FIELD,
            STORE_FORMAT_FIELD, STORE_OPTIONS_FIELD, STATUS_FIELD, NAME_FIELD, VERSION_NAME_FIELD, CREATION_TIME_FIELD));

    private final String id;

    private final ReferenceItem reference;

    private final String storeFormat;

    private final StoreOptions storeOptions;

    private final String status;

    private final String name;

    private final String versionName;

    private final Instant creationTime;

    private CreateAnnotationStoreResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.reference = builder.reference;
        this.storeFormat = builder.storeFormat;
        this.storeOptions = builder.storeOptions;
        this.status = builder.status;
        this.name = builder.name;
        this.versionName = builder.versionName;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The store's ID.
     * </p>
     * 
     * @return The store's ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The store's genome reference. Required for all stores except TSV format with generic annotations.
     * </p>
     * 
     * @return The store's genome reference. Required for all stores except TSV format with generic annotations.
     */
    public final ReferenceItem reference() {
        return reference;
    }

    /**
     * <p>
     * The annotation file format of the store.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storeFormat} will
     * return {@link StoreFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storeFormatAsString}.
     * </p>
     * 
     * @return The annotation file format of the store.
     * @see StoreFormat
     */
    public final StoreFormat storeFormat() {
        return StoreFormat.fromValue(storeFormat);
    }

    /**
     * <p>
     * The annotation file format of the store.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storeFormat} will
     * return {@link StoreFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storeFormatAsString}.
     * </p>
     * 
     * @return The annotation file format of the store.
     * @see StoreFormat
     */
    public final String storeFormatAsString() {
        return storeFormat;
    }

    /**
     * <p>
     * The store's file parsing options.
     * </p>
     * 
     * @return The store's file parsing options.
     */
    public final StoreOptions storeOptions() {
        return storeOptions;
    }

    /**
     * <p>
     * The store's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The store's status.
     * @see StoreStatus
     */
    public final StoreStatus status() {
        return StoreStatus.fromValue(status);
    }

    /**
     * <p>
     * The store's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The store's status.
     * @see StoreStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The store's name.
     * </p>
     * 
     * @return The store's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name given to an annotation store version to distinguish it from other versions.
     * </p>
     * 
     * @return The name given to an annotation store version to distinguish it from other versions.
     */
    public final String versionName() {
        return versionName;
    }

    /**
     * <p>
     * When the store was created.
     * </p>
     * 
     * @return When the store was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(reference());
        hashCode = 31 * hashCode + Objects.hashCode(storeFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(storeOptions());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnnotationStoreResponse)) {
            return false;
        }
        CreateAnnotationStoreResponse other = (CreateAnnotationStoreResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(reference(), other.reference())
                && Objects.equals(storeFormatAsString(), other.storeFormatAsString())
                && Objects.equals(storeOptions(), other.storeOptions())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(versionName(), other.versionName()) && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAnnotationStoreResponse").add("Id", id()).add("Reference", reference())
                .add("StoreFormat", storeFormatAsString()).add("StoreOptions", storeOptions()).add("Status", statusAsString())
                .add("Name", name()).add("VersionName", versionName()).add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "reference":
            return Optional.ofNullable(clazz.cast(reference()));
        case "storeFormat":
            return Optional.ofNullable(clazz.cast(storeFormatAsString()));
        case "storeOptions":
            return Optional.ofNullable(clazz.cast(storeOptions()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "versionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAnnotationStoreResponse, T> g) {
        return obj -> g.apply((CreateAnnotationStoreResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAnnotationStoreResponse> {
        /**
         * <p>
         * The store's ID.
         * </p>
         * 
         * @param id
         *        The store's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The store's genome reference. Required for all stores except TSV format with generic annotations.
         * </p>
         * 
         * @param reference
         *        The store's genome reference. Required for all stores except TSV format with generic annotations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reference(ReferenceItem reference);

        /**
         * <p>
         * The store's genome reference. Required for all stores except TSV format with generic annotations.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReferenceItem.Builder} avoiding the need
         * to create one manually via {@link ReferenceItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReferenceItem.Builder#build()} is called immediately and its
         * result is passed to {@link #reference(ReferenceItem)}.
         * 
         * @param reference
         *        a consumer that will call methods on {@link ReferenceItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reference(ReferenceItem)
         */
        default Builder reference(Consumer<ReferenceItem.Builder> reference) {
            return reference(ReferenceItem.builder().applyMutation(reference).build());
        }

        /**
         * <p>
         * The annotation file format of the store.
         * </p>
         * 
         * @param storeFormat
         *        The annotation file format of the store.
         * @see StoreFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StoreFormat
         */
        Builder storeFormat(String storeFormat);

        /**
         * <p>
         * The annotation file format of the store.
         * </p>
         * 
         * @param storeFormat
         *        The annotation file format of the store.
         * @see StoreFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StoreFormat
         */
        Builder storeFormat(StoreFormat storeFormat);

        /**
         * <p>
         * The store's file parsing options.
         * </p>
         * 
         * @param storeOptions
         *        The store's file parsing options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storeOptions(StoreOptions storeOptions);

        /**
         * <p>
         * The store's file parsing options.
         * </p>
         * This is a convenience method that creates an instance of the {@link StoreOptions.Builder} avoiding the need
         * to create one manually via {@link StoreOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StoreOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #storeOptions(StoreOptions)}.
         * 
         * @param storeOptions
         *        a consumer that will call methods on {@link StoreOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storeOptions(StoreOptions)
         */
        default Builder storeOptions(Consumer<StoreOptions.Builder> storeOptions) {
            return storeOptions(StoreOptions.builder().applyMutation(storeOptions).build());
        }

        /**
         * <p>
         * The store's status.
         * </p>
         * 
         * @param status
         *        The store's status.
         * @see StoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StoreStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The store's status.
         * </p>
         * 
         * @param status
         *        The store's status.
         * @see StoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StoreStatus
         */
        Builder status(StoreStatus status);

        /**
         * <p>
         * The store's name.
         * </p>
         * 
         * @param name
         *        The store's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name given to an annotation store version to distinguish it from other versions.
         * </p>
         * 
         * @param versionName
         *        The name given to an annotation store version to distinguish it from other versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);

        /**
         * <p>
         * When the store was created.
         * </p>
         * 
         * @param creationTime
         *        When the store was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl extends OmicsResponse.BuilderImpl implements Builder {
        private String id;

        private ReferenceItem reference;

        private String storeFormat;

        private StoreOptions storeOptions;

        private String status;

        private String name;

        private String versionName;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnnotationStoreResponse model) {
            super(model);
            id(model.id);
            reference(model.reference);
            storeFormat(model.storeFormat);
            storeOptions(model.storeOptions);
            status(model.status);
            name(model.name);
            versionName(model.versionName);
            creationTime(model.creationTime);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final ReferenceItem.Builder getReference() {
            return reference != null ? reference.toBuilder() : null;
        }

        public final void setReference(ReferenceItem.BuilderImpl reference) {
            this.reference = reference != null ? reference.build() : null;
        }

        @Override
        public final Builder reference(ReferenceItem reference) {
            this.reference = reference;
            return this;
        }

        public final String getStoreFormat() {
            return storeFormat;
        }

        public final void setStoreFormat(String storeFormat) {
            this.storeFormat = storeFormat;
        }

        @Override
        public final Builder storeFormat(String storeFormat) {
            this.storeFormat = storeFormat;
            return this;
        }

        @Override
        public final Builder storeFormat(StoreFormat storeFormat) {
            this.storeFormat(storeFormat == null ? null : storeFormat.toString());
            return this;
        }

        public final StoreOptions.Builder getStoreOptions() {
            return storeOptions != null ? storeOptions.toBuilder() : null;
        }

        public final void setStoreOptions(StoreOptions.BuilderImpl storeOptions) {
            this.storeOptions = storeOptions != null ? storeOptions.build() : null;
        }

        @Override
        public final Builder storeOptions(StoreOptions storeOptions) {
            this.storeOptions = storeOptions;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StoreStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersionName() {
            return versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public CreateAnnotationStoreResponse build() {
            return new CreateAnnotationStoreResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
