/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReadSetMetadataResponse extends OmicsResponse implements
        ToCopyableBuilder<GetReadSetMetadataResponse.Builder, GetReadSetMetadataResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetReadSetMetadataResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetReadSetMetadataResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> SEQUENCE_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sequenceStoreId").getter(getter(GetReadSetMetadataResponse::sequenceStoreId))
            .setter(setter(Builder::sequenceStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sequenceStoreId").build()).build();

    private static final SdkField<String> SUBJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subjectId").getter(getter(GetReadSetMetadataResponse::subjectId)).setter(setter(Builder::subjectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjectId").build()).build();

    private static final SdkField<String> SAMPLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sampleId").getter(getter(GetReadSetMetadataResponse::sampleId)).setter(setter(Builder::sampleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetReadSetMetadataResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetReadSetMetadataResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetReadSetMetadataResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> FILE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileType").getter(getter(GetReadSetMetadataResponse::fileTypeAsString))
            .setter(setter(Builder::fileType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileType").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(GetReadSetMetadataResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<SequenceInformation> SEQUENCE_INFORMATION_FIELD = SdkField
            .<SequenceInformation> builder(MarshallingType.SDK_POJO).memberName("sequenceInformation")
            .getter(getter(GetReadSetMetadataResponse::sequenceInformation)).setter(setter(Builder::sequenceInformation))
            .constructor(SequenceInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sequenceInformation").build())
            .build();

    private static final SdkField<String> REFERENCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("referenceArn").getter(getter(GetReadSetMetadataResponse::referenceArn))
            .setter(setter(Builder::referenceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceArn").build()).build();

    private static final SdkField<ReadSetFiles> FILES_FIELD = SdkField.<ReadSetFiles> builder(MarshallingType.SDK_POJO)
            .memberName("files").getter(getter(GetReadSetMetadataResponse::files)).setter(setter(Builder::files))
            .constructor(ReadSetFiles::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("files").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(GetReadSetMetadataResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<String> CREATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("creationType").getter(getter(GetReadSetMetadataResponse::creationTypeAsString))
            .setter(setter(Builder::creationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            SEQUENCE_STORE_ID_FIELD, SUBJECT_ID_FIELD, SAMPLE_ID_FIELD, STATUS_FIELD, NAME_FIELD, DESCRIPTION_FIELD,
            FILE_TYPE_FIELD, CREATION_TIME_FIELD, SEQUENCE_INFORMATION_FIELD, REFERENCE_ARN_FIELD, FILES_FIELD,
            STATUS_MESSAGE_FIELD, CREATION_TYPE_FIELD));

    private final String id;

    private final String arn;

    private final String sequenceStoreId;

    private final String subjectId;

    private final String sampleId;

    private final String status;

    private final String name;

    private final String description;

    private final String fileType;

    private final Instant creationTime;

    private final SequenceInformation sequenceInformation;

    private final String referenceArn;

    private final ReadSetFiles files;

    private final String statusMessage;

    private final String creationType;

    private GetReadSetMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.sequenceStoreId = builder.sequenceStoreId;
        this.subjectId = builder.subjectId;
        this.sampleId = builder.sampleId;
        this.status = builder.status;
        this.name = builder.name;
        this.description = builder.description;
        this.fileType = builder.fileType;
        this.creationTime = builder.creationTime;
        this.sequenceInformation = builder.sequenceInformation;
        this.referenceArn = builder.referenceArn;
        this.files = builder.files;
        this.statusMessage = builder.statusMessage;
        this.creationType = builder.creationType;
    }

    /**
     * <p>
     * The read set's ID.
     * </p>
     * 
     * @return The read set's ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The read set's ARN.
     * </p>
     * 
     * @return The read set's ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The read set's sequence store ID.
     * </p>
     * 
     * @return The read set's sequence store ID.
     */
    public final String sequenceStoreId() {
        return sequenceStoreId;
    }

    /**
     * <p>
     * The read set's subject ID.
     * </p>
     * 
     * @return The read set's subject ID.
     */
    public final String subjectId() {
        return subjectId;
    }

    /**
     * <p>
     * The read set's sample ID.
     * </p>
     * 
     * @return The read set's sample ID.
     */
    public final String sampleId() {
        return sampleId;
    }

    /**
     * <p>
     * The read set's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReadSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The read set's status.
     * @see ReadSetStatus
     */
    public final ReadSetStatus status() {
        return ReadSetStatus.fromValue(status);
    }

    /**
     * <p>
     * The read set's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReadSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The read set's status.
     * @see ReadSetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The read set's name.
     * </p>
     * 
     * @return The read set's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The read set's description.
     * </p>
     * 
     * @return The read set's description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The read set's file type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileType} will
     * return {@link FileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileTypeAsString}.
     * </p>
     * 
     * @return The read set's file type.
     * @see FileType
     */
    public final FileType fileType() {
        return FileType.fromValue(fileType);
    }

    /**
     * <p>
     * The read set's file type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileType} will
     * return {@link FileType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileTypeAsString}.
     * </p>
     * 
     * @return The read set's file type.
     * @see FileType
     */
    public final String fileTypeAsString() {
        return fileType;
    }

    /**
     * <p>
     * When the read set was created.
     * </p>
     * 
     * @return When the read set was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The read set's sequence information.
     * </p>
     * 
     * @return The read set's sequence information.
     */
    public final SequenceInformation sequenceInformation() {
        return sequenceInformation;
    }

    /**
     * <p>
     * The read set's genome reference ARN.
     * </p>
     * 
     * @return The read set's genome reference ARN.
     */
    public final String referenceArn() {
        return referenceArn;
    }

    /**
     * <p>
     * The read set's files.
     * </p>
     * 
     * @return The read set's files.
     */
    public final ReadSetFiles files() {
        return files;
    }

    /**
     * <p>
     * The status message for a read set. It provides more detail as to why the read set has a status.
     * </p>
     * 
     * @return The status message for a read set. It provides more detail as to why the read set has a status.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The creation type of the read set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #creationType} will
     * return {@link CreationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #creationTypeAsString}.
     * </p>
     * 
     * @return The creation type of the read set.
     * @see CreationType
     */
    public final CreationType creationType() {
        return CreationType.fromValue(creationType);
    }

    /**
     * <p>
     * The creation type of the read set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #creationType} will
     * return {@link CreationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #creationTypeAsString}.
     * </p>
     * 
     * @return The creation type of the read set.
     * @see CreationType
     */
    public final String creationTypeAsString() {
        return creationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(sequenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(subjectId());
        hashCode = 31 * hashCode + Objects.hashCode(sampleId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(fileTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(sequenceInformation());
        hashCode = 31 * hashCode + Objects.hashCode(referenceArn());
        hashCode = 31 * hashCode + Objects.hashCode(files());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(creationTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReadSetMetadataResponse)) {
            return false;
        }
        GetReadSetMetadataResponse other = (GetReadSetMetadataResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(sequenceStoreId(), other.sequenceStoreId()) && Objects.equals(subjectId(), other.subjectId())
                && Objects.equals(sampleId(), other.sampleId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(fileTypeAsString(), other.fileTypeAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(sequenceInformation(), other.sequenceInformation())
                && Objects.equals(referenceArn(), other.referenceArn()) && Objects.equals(files(), other.files())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(creationTypeAsString(), other.creationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetReadSetMetadataResponse").add("Id", id()).add("Arn", arn())
                .add("SequenceStoreId", sequenceStoreId()).add("SubjectId", subjectId()).add("SampleId", sampleId())
                .add("Status", statusAsString()).add("Name", name()).add("Description", description())
                .add("FileType", fileTypeAsString()).add("CreationTime", creationTime())
                .add("SequenceInformation", sequenceInformation()).add("ReferenceArn", referenceArn()).add("Files", files())
                .add("StatusMessage", statusMessage()).add("CreationType", creationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "sequenceStoreId":
            return Optional.ofNullable(clazz.cast(sequenceStoreId()));
        case "subjectId":
            return Optional.ofNullable(clazz.cast(subjectId()));
        case "sampleId":
            return Optional.ofNullable(clazz.cast(sampleId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "fileType":
            return Optional.ofNullable(clazz.cast(fileTypeAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "sequenceInformation":
            return Optional.ofNullable(clazz.cast(sequenceInformation()));
        case "referenceArn":
            return Optional.ofNullable(clazz.cast(referenceArn()));
        case "files":
            return Optional.ofNullable(clazz.cast(files()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "creationType":
            return Optional.ofNullable(clazz.cast(creationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReadSetMetadataResponse, T> g) {
        return obj -> g.apply((GetReadSetMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetReadSetMetadataResponse> {
        /**
         * <p>
         * The read set's ID.
         * </p>
         * 
         * @param id
         *        The read set's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The read set's ARN.
         * </p>
         * 
         * @param arn
         *        The read set's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The read set's sequence store ID.
         * </p>
         * 
         * @param sequenceStoreId
         *        The read set's sequence store ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceStoreId(String sequenceStoreId);

        /**
         * <p>
         * The read set's subject ID.
         * </p>
         * 
         * @param subjectId
         *        The read set's subject ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectId(String subjectId);

        /**
         * <p>
         * The read set's sample ID.
         * </p>
         * 
         * @param sampleId
         *        The read set's sample ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleId(String sampleId);

        /**
         * <p>
         * The read set's status.
         * </p>
         * 
         * @param status
         *        The read set's status.
         * @see ReadSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReadSetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The read set's status.
         * </p>
         * 
         * @param status
         *        The read set's status.
         * @see ReadSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReadSetStatus
         */
        Builder status(ReadSetStatus status);

        /**
         * <p>
         * The read set's name.
         * </p>
         * 
         * @param name
         *        The read set's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The read set's description.
         * </p>
         * 
         * @param description
         *        The read set's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The read set's file type.
         * </p>
         * 
         * @param fileType
         *        The read set's file type.
         * @see FileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileType
         */
        Builder fileType(String fileType);

        /**
         * <p>
         * The read set's file type.
         * </p>
         * 
         * @param fileType
         *        The read set's file type.
         * @see FileType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileType
         */
        Builder fileType(FileType fileType);

        /**
         * <p>
         * When the read set was created.
         * </p>
         * 
         * @param creationTime
         *        When the read set was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The read set's sequence information.
         * </p>
         * 
         * @param sequenceInformation
         *        The read set's sequence information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceInformation(SequenceInformation sequenceInformation);

        /**
         * <p>
         * The read set's sequence information.
         * </p>
         * This is a convenience method that creates an instance of the {@link SequenceInformation.Builder} avoiding the
         * need to create one manually via {@link SequenceInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SequenceInformation.Builder#build()} is called immediately and
         * its result is passed to {@link #sequenceInformation(SequenceInformation)}.
         * 
         * @param sequenceInformation
         *        a consumer that will call methods on {@link SequenceInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sequenceInformation(SequenceInformation)
         */
        default Builder sequenceInformation(Consumer<SequenceInformation.Builder> sequenceInformation) {
            return sequenceInformation(SequenceInformation.builder().applyMutation(sequenceInformation).build());
        }

        /**
         * <p>
         * The read set's genome reference ARN.
         * </p>
         * 
         * @param referenceArn
         *        The read set's genome reference ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceArn(String referenceArn);

        /**
         * <p>
         * The read set's files.
         * </p>
         * 
         * @param files
         *        The read set's files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder files(ReadSetFiles files);

        /**
         * <p>
         * The read set's files.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReadSetFiles.Builder} avoiding the need
         * to create one manually via {@link ReadSetFiles#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReadSetFiles.Builder#build()} is called immediately and its
         * result is passed to {@link #files(ReadSetFiles)}.
         * 
         * @param files
         *        a consumer that will call methods on {@link ReadSetFiles.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #files(ReadSetFiles)
         */
        default Builder files(Consumer<ReadSetFiles.Builder> files) {
            return files(ReadSetFiles.builder().applyMutation(files).build());
        }

        /**
         * <p>
         * The status message for a read set. It provides more detail as to why the read set has a status.
         * </p>
         * 
         * @param statusMessage
         *        The status message for a read set. It provides more detail as to why the read set has a status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The creation type of the read set.
         * </p>
         * 
         * @param creationType
         *        The creation type of the read set.
         * @see CreationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CreationType
         */
        Builder creationType(String creationType);

        /**
         * <p>
         * The creation type of the read set.
         * </p>
         * 
         * @param creationType
         *        The creation type of the read set.
         * @see CreationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CreationType
         */
        Builder creationType(CreationType creationType);
    }

    static final class BuilderImpl extends OmicsResponse.BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String sequenceStoreId;

        private String subjectId;

        private String sampleId;

        private String status;

        private String name;

        private String description;

        private String fileType;

        private Instant creationTime;

        private SequenceInformation sequenceInformation;

        private String referenceArn;

        private ReadSetFiles files;

        private String statusMessage;

        private String creationType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReadSetMetadataResponse model) {
            super(model);
            id(model.id);
            arn(model.arn);
            sequenceStoreId(model.sequenceStoreId);
            subjectId(model.subjectId);
            sampleId(model.sampleId);
            status(model.status);
            name(model.name);
            description(model.description);
            fileType(model.fileType);
            creationTime(model.creationTime);
            sequenceInformation(model.sequenceInformation);
            referenceArn(model.referenceArn);
            files(model.files);
            statusMessage(model.statusMessage);
            creationType(model.creationType);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getSequenceStoreId() {
            return sequenceStoreId;
        }

        public final void setSequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
        }

        @Override
        public final Builder sequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
            return this;
        }

        public final String getSubjectId() {
            return subjectId;
        }

        public final void setSubjectId(String subjectId) {
            this.subjectId = subjectId;
        }

        @Override
        public final Builder subjectId(String subjectId) {
            this.subjectId = subjectId;
            return this;
        }

        public final String getSampleId() {
            return sampleId;
        }

        public final void setSampleId(String sampleId) {
            this.sampleId = sampleId;
        }

        @Override
        public final Builder sampleId(String sampleId) {
            this.sampleId = sampleId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReadSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFileType() {
            return fileType;
        }

        public final void setFileType(String fileType) {
            this.fileType = fileType;
        }

        @Override
        public final Builder fileType(String fileType) {
            this.fileType = fileType;
            return this;
        }

        @Override
        public final Builder fileType(FileType fileType) {
            this.fileType(fileType == null ? null : fileType.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final SequenceInformation.Builder getSequenceInformation() {
            return sequenceInformation != null ? sequenceInformation.toBuilder() : null;
        }

        public final void setSequenceInformation(SequenceInformation.BuilderImpl sequenceInformation) {
            this.sequenceInformation = sequenceInformation != null ? sequenceInformation.build() : null;
        }

        @Override
        public final Builder sequenceInformation(SequenceInformation sequenceInformation) {
            this.sequenceInformation = sequenceInformation;
            return this;
        }

        public final String getReferenceArn() {
            return referenceArn;
        }

        public final void setReferenceArn(String referenceArn) {
            this.referenceArn = referenceArn;
        }

        @Override
        public final Builder referenceArn(String referenceArn) {
            this.referenceArn = referenceArn;
            return this;
        }

        public final ReadSetFiles.Builder getFiles() {
            return files != null ? files.toBuilder() : null;
        }

        public final void setFiles(ReadSetFiles.BuilderImpl files) {
            this.files = files != null ? files.build() : null;
        }

        @Override
        public final Builder files(ReadSetFiles files) {
            this.files = files;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getCreationType() {
            return creationType;
        }

        public final void setCreationType(String creationType) {
            this.creationType = creationType;
        }

        @Override
        public final Builder creationType(String creationType) {
            this.creationType = creationType;
            return this;
        }

        @Override
        public final Builder creationType(CreationType creationType) {
            this.creationType(creationType == null ? null : creationType.toString());
            return this;
        }

        @Override
        public GetReadSetMetadataResponse build() {
            return new GetReadSetMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
