/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteReadSetRequest extends OmicsRequest implements
        ToCopyableBuilder<BatchDeleteReadSetRequest.Builder, BatchDeleteReadSetRequest> {
    private static final SdkField<List<String>> IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ids")
            .getter(getter(BatchDeleteReadSetRequest::ids))
            .setter(setter(Builder::ids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SEQUENCE_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sequenceStoreId").getter(getter(BatchDeleteReadSetRequest::sequenceStoreId))
            .setter(setter(Builder::sequenceStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sequenceStoreId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDS_FIELD,
            SEQUENCE_STORE_ID_FIELD));

    private final List<String> ids;

    private final String sequenceStoreId;

    private BatchDeleteReadSetRequest(BuilderImpl builder) {
        super(builder);
        this.ids = builder.ids;
        this.sequenceStoreId = builder.sequenceStoreId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ids property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasIds() {
        return ids != null && !(ids instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The read sets' IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIds} method.
     * </p>
     * 
     * @return The read sets' IDs.
     */
    public final List<String> ids() {
        return ids;
    }

    /**
     * <p>
     * The read sets' sequence store ID.
     * </p>
     * 
     * @return The read sets' sequence store ID.
     */
    public final String sequenceStoreId() {
        return sequenceStoreId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIds() ? ids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sequenceStoreId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteReadSetRequest)) {
            return false;
        }
        BatchDeleteReadSetRequest other = (BatchDeleteReadSetRequest) obj;
        return hasIds() == other.hasIds() && Objects.equals(ids(), other.ids())
                && Objects.equals(sequenceStoreId(), other.sequenceStoreId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteReadSetRequest").add("Ids", hasIds() ? ids() : null)
                .add("SequenceStoreId", sequenceStoreId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ids":
            return Optional.ofNullable(clazz.cast(ids()));
        case "sequenceStoreId":
            return Optional.ofNullable(clazz.cast(sequenceStoreId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteReadSetRequest, T> g) {
        return obj -> g.apply((BatchDeleteReadSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchDeleteReadSetRequest> {
        /**
         * <p>
         * The read sets' IDs.
         * </p>
         * 
         * @param ids
         *        The read sets' IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ids(Collection<String> ids);

        /**
         * <p>
         * The read sets' IDs.
         * </p>
         * 
         * @param ids
         *        The read sets' IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ids(String... ids);

        /**
         * <p>
         * The read sets' sequence store ID.
         * </p>
         * 
         * @param sequenceStoreId
         *        The read sets' sequence store ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceStoreId(String sequenceStoreId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private List<String> ids = DefaultSdkAutoConstructList.getInstance();

        private String sequenceStoreId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteReadSetRequest model) {
            super(model);
            ids(model.ids);
            sequenceStoreId(model.sequenceStoreId);
        }

        public final Collection<String> getIds() {
            if (ids instanceof SdkAutoConstructList) {
                return null;
            }
            return ids;
        }

        public final void setIds(Collection<String> ids) {
            this.ids = ReadSetIdListCopier.copy(ids);
        }

        @Override
        public final Builder ids(Collection<String> ids) {
            this.ids = ReadSetIdListCopier.copy(ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ids(String... ids) {
            ids(Arrays.asList(ids));
            return this;
        }

        public final String getSequenceStoreId() {
            return sequenceStoreId;
        }

        public final void setSequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
        }

        @Override
        public final Builder sequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteReadSetRequest build() {
            return new BatchDeleteReadSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
