/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The upload storage root location (folder) on streaming workstations where files are uploaded.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamingSessionStorageRoot implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamingSessionStorageRoot.Builder, StreamingSessionStorageRoot> {
    private static final SdkField<String> LINUX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("linux")
            .getter(getter(StreamingSessionStorageRoot::linux)).setter(setter(Builder::linux))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linux").build()).build();

    private static final SdkField<String> WINDOWS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("windows")
            .getter(getter(StreamingSessionStorageRoot::windows)).setter(setter(Builder::windows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("windows").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINUX_FIELD, WINDOWS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String linux;

    private final String windows;

    private StreamingSessionStorageRoot(BuilderImpl builder) {
        this.linux = builder.linux;
        this.windows = builder.windows;
    }

    /**
     * <p>
     * The folder path in Linux workstations where files are uploaded.
     * </p>
     * 
     * @return The folder path in Linux workstations where files are uploaded.
     */
    public final String linux() {
        return linux;
    }

    /**
     * <p>
     * The folder path in Windows workstations where files are uploaded.
     * </p>
     * 
     * @return The folder path in Windows workstations where files are uploaded.
     */
    public final String windows() {
        return windows;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(linux());
        hashCode = 31 * hashCode + Objects.hashCode(windows());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingSessionStorageRoot)) {
            return false;
        }
        StreamingSessionStorageRoot other = (StreamingSessionStorageRoot) obj;
        return Objects.equals(linux(), other.linux()) && Objects.equals(windows(), other.windows());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamingSessionStorageRoot")
                .add("Linux", linux() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Windows", windows() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "linux":
            return Optional.ofNullable(clazz.cast(linux()));
        case "windows":
            return Optional.ofNullable(clazz.cast(windows()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamingSessionStorageRoot, T> g) {
        return obj -> g.apply((StreamingSessionStorageRoot) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamingSessionStorageRoot> {
        /**
         * <p>
         * The folder path in Linux workstations where files are uploaded.
         * </p>
         * 
         * @param linux
         *        The folder path in Linux workstations where files are uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linux(String linux);

        /**
         * <p>
         * The folder path in Windows workstations where files are uploaded.
         * </p>
         * 
         * @param windows
         *        The folder path in Windows workstations where files are uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windows(String windows);
    }

    static final class BuilderImpl implements Builder {
        private String linux;

        private String windows;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingSessionStorageRoot model) {
            linux(model.linux);
            windows(model.windows);
        }

        public final String getLinux() {
            return linux;
        }

        public final void setLinux(String linux) {
            this.linux = linux;
        }

        @Override
        public final Builder linux(String linux) {
            this.linux = linux;
            return this;
        }

        public final String getWindows() {
            return windows;
        }

        public final void setWindows(String windows) {
            this.windows = windows;
        }

        @Override
        public final Builder windows(String windows) {
            this.windows = windows;
            return this;
        }

        @Override
        public StreamingSessionStorageRoot build() {
            return new StreamingSessionStorageRoot(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
