/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.nimble.model.NimbleRequest;
import software.amazon.awssdk.services.nimble.model.ScriptParameterKeyValue;
import software.amazon.awssdk.services.nimble.model.StudioComponentConfiguration;
import software.amazon.awssdk.services.nimble.model.StudioComponentInitializationScript;
import software.amazon.awssdk.services.nimble.model.StudioComponentInitializationScriptListCopier;
import software.amazon.awssdk.services.nimble.model.StudioComponentScriptParameterKeyValueListCopier;
import software.amazon.awssdk.services.nimble.model.StudioComponentSecurityGroupIdListCopier;
import software.amazon.awssdk.services.nimble.model.StudioComponentSubtype;
import software.amazon.awssdk.services.nimble.model.StudioComponentType;
import software.amazon.awssdk.services.nimble.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStudioComponentRequest
extends NimbleRequest
implements ToCopyableBuilder<Builder, CreateStudioComponentRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateStudioComponentRequest.getter(CreateStudioComponentRequest::clientToken)).setter(CreateStudioComponentRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<StudioComponentConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(CreateStudioComponentRequest.getter(CreateStudioComponentRequest::configuration)).setter(CreateStudioComponentRequest.setter(Builder::configuration)).constructor(StudioComponentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateStudioComponentRequest.getter(CreateStudioComponentRequest::description)).setter(CreateStudioComponentRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> EC2_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ec2SecurityGroupIds").getter(CreateStudioComponentRequest.getter(CreateStudioComponentRequest::ec2SecurityGroupIds)).setter(CreateStudioComponentRequest.setter(Builder::ec2SecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StudioComponentInitializationScript>> INITIALIZATION_SCRIPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("initializationScripts").getter(CreateStudioComponentRequest.getter(CreateStudioComponentRequest::initializationScripts)).setter(CreateStudioComponentRequest.setter(Builder::initializationScripts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initializationScripts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StudioComponentInitializationScript::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateStudioComponentRequest.getter(CreateStudioComponentRequest::name)).setter(CreateStudioComponentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> RUNTIME_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runtimeRoleArn").getter(CreateStudioComponentRequest.getter(CreateStudioComponentRequest::runtimeRoleArn)).setter(CreateStudioComponentRequest.setter(Builder::runtimeRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeRoleArn").build()}).build();
    private static final SdkField<List<ScriptParameterKeyValue>> SCRIPT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scriptParameters").getter(CreateStudioComponentRequest.getter(CreateStudioComponentRequest::scriptParameters)).setter(CreateStudioComponentRequest.setter(Builder::scriptParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScriptParameterKeyValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SECURE_INITIALIZATION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("secureInitializationRoleArn").getter(CreateStudioComponentRequest.getter(CreateStudioComponentRequest::secureInitializationRoleArn)).setter(CreateStudioComponentRequest.setter(Builder::secureInitializationRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secureInitializationRoleArn").build()}).build();
    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("studioId").getter(CreateStudioComponentRequest.getter(CreateStudioComponentRequest::studioId)).setter(CreateStudioComponentRequest.setter(Builder::studioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("studioId").build()}).build();
    private static final SdkField<String> SUBTYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subtype").getter(CreateStudioComponentRequest.getter(CreateStudioComponentRequest::subtypeAsString)).setter(CreateStudioComponentRequest.setter(Builder::subtype)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subtype").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateStudioComponentRequest.getter(CreateStudioComponentRequest::tags)).setter(CreateStudioComponentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CreateStudioComponentRequest.getter(CreateStudioComponentRequest::typeAsString)).setter(CreateStudioComponentRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, CONFIGURATION_FIELD, DESCRIPTION_FIELD, EC2_SECURITY_GROUP_IDS_FIELD, INITIALIZATION_SCRIPTS_FIELD, NAME_FIELD, RUNTIME_ROLE_ARN_FIELD, SCRIPT_PARAMETERS_FIELD, SECURE_INITIALIZATION_ROLE_ARN_FIELD, STUDIO_ID_FIELD, SUBTYPE_FIELD, TAGS_FIELD, TYPE_FIELD));
    private final String clientToken;
    private final StudioComponentConfiguration configuration;
    private final String description;
    private final List<String> ec2SecurityGroupIds;
    private final List<StudioComponentInitializationScript> initializationScripts;
    private final String name;
    private final String runtimeRoleArn;
    private final List<ScriptParameterKeyValue> scriptParameters;
    private final String secureInitializationRoleArn;
    private final String studioId;
    private final String subtype;
    private final Map<String, String> tags;
    private final String type;

    private CreateStudioComponentRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.configuration = builder.configuration;
        this.description = builder.description;
        this.ec2SecurityGroupIds = builder.ec2SecurityGroupIds;
        this.initializationScripts = builder.initializationScripts;
        this.name = builder.name;
        this.runtimeRoleArn = builder.runtimeRoleArn;
        this.scriptParameters = builder.scriptParameters;
        this.secureInitializationRoleArn = builder.secureInitializationRoleArn;
        this.studioId = builder.studioId;
        this.subtype = builder.subtype;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final StudioComponentConfiguration configuration() {
        return this.configuration;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasEc2SecurityGroupIds() {
        return this.ec2SecurityGroupIds != null && !(this.ec2SecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> ec2SecurityGroupIds() {
        return this.ec2SecurityGroupIds;
    }

    public final boolean hasInitializationScripts() {
        return this.initializationScripts != null && !(this.initializationScripts instanceof SdkAutoConstructList);
    }

    public final List<StudioComponentInitializationScript> initializationScripts() {
        return this.initializationScripts;
    }

    public final String name() {
        return this.name;
    }

    public final String runtimeRoleArn() {
        return this.runtimeRoleArn;
    }

    public final boolean hasScriptParameters() {
        return this.scriptParameters != null && !(this.scriptParameters instanceof SdkAutoConstructList);
    }

    public final List<ScriptParameterKeyValue> scriptParameters() {
        return this.scriptParameters;
    }

    public final String secureInitializationRoleArn() {
        return this.secureInitializationRoleArn;
    }

    public final String studioId() {
        return this.studioId;
    }

    public final StudioComponentSubtype subtype() {
        return StudioComponentSubtype.fromValue(this.subtype);
    }

    public final String subtypeAsString() {
        return this.subtype;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final StudioComponentType type() {
        return StudioComponentType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2SecurityGroupIds() ? this.ec2SecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInitializationScripts() ? this.initializationScripts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScriptParameters() ? this.scriptParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.secureInitializationRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.studioId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subtypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStudioComponentRequest)) {
            return false;
        }
        CreateStudioComponentRequest other = (CreateStudioComponentRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.description(), other.description()) && this.hasEc2SecurityGroupIds() == other.hasEc2SecurityGroupIds() && Objects.equals(this.ec2SecurityGroupIds(), other.ec2SecurityGroupIds()) && this.hasInitializationScripts() == other.hasInitializationScripts() && Objects.equals(this.initializationScripts(), other.initializationScripts()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.runtimeRoleArn(), other.runtimeRoleArn()) && this.hasScriptParameters() == other.hasScriptParameters() && Objects.equals(this.scriptParameters(), other.scriptParameters()) && Objects.equals(this.secureInitializationRoleArn(), other.secureInitializationRoleArn()) && Objects.equals(this.studioId(), other.studioId()) && Objects.equals(this.subtypeAsString(), other.subtypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateStudioComponentRequest").add("ClientToken", (Object)this.clientToken()).add("Configuration", (Object)this.configuration()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Ec2SecurityGroupIds", this.hasEc2SecurityGroupIds() ? this.ec2SecurityGroupIds() : null).add("InitializationScripts", this.hasInitializationScripts() ? this.initializationScripts() : null).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("RuntimeRoleArn", (Object)this.runtimeRoleArn()).add("ScriptParameters", (Object)(this.scriptParameters() == null ? null : "*** Sensitive Data Redacted ***")).add("SecureInitializationRoleArn", (Object)this.secureInitializationRoleArn()).add("StudioId", (Object)this.studioId()).add("Subtype", (Object)this.subtypeAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ec2SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.ec2SecurityGroupIds()));
            }
            case "initializationScripts": {
                return Optional.ofNullable(clazz.cast(this.initializationScripts()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "runtimeRoleArn": {
                return Optional.ofNullable(clazz.cast(this.runtimeRoleArn()));
            }
            case "scriptParameters": {
                return Optional.ofNullable(clazz.cast(this.scriptParameters()));
            }
            case "secureInitializationRoleArn": {
                return Optional.ofNullable(clazz.cast(this.secureInitializationRoleArn()));
            }
            case "studioId": {
                return Optional.ofNullable(clazz.cast(this.studioId()));
            }
            case "subtype": {
                return Optional.ofNullable(clazz.cast(this.subtypeAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStudioComponentRequest, T> g) {
        return obj -> g.apply((CreateStudioComponentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NimbleRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private StudioComponentConfiguration configuration;
        private String description;
        private List<String> ec2SecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<StudioComponentInitializationScript> initializationScripts = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String runtimeRoleArn;
        private List<ScriptParameterKeyValue> scriptParameters = DefaultSdkAutoConstructList.getInstance();
        private String secureInitializationRoleArn;
        private String studioId;
        private String subtype;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStudioComponentRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.configuration(model.configuration);
            this.description(model.description);
            this.ec2SecurityGroupIds(model.ec2SecurityGroupIds);
            this.initializationScripts(model.initializationScripts);
            this.name(model.name);
            this.runtimeRoleArn(model.runtimeRoleArn);
            this.scriptParameters(model.scriptParameters);
            this.secureInitializationRoleArn(model.secureInitializationRoleArn);
            this.studioId(model.studioId);
            this.subtype(model.subtype);
            this.tags(model.tags);
            this.type(model.type);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final StudioComponentConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(StudioComponentConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(StudioComponentConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getEc2SecurityGroupIds() {
            if (this.ec2SecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ec2SecurityGroupIds;
        }

        public final void setEc2SecurityGroupIds(Collection<String> ec2SecurityGroupIds) {
            this.ec2SecurityGroupIds = StudioComponentSecurityGroupIdListCopier.copy(ec2SecurityGroupIds);
        }

        @Override
        public final Builder ec2SecurityGroupIds(Collection<String> ec2SecurityGroupIds) {
            this.ec2SecurityGroupIds = StudioComponentSecurityGroupIdListCopier.copy(ec2SecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2SecurityGroupIds(String ... ec2SecurityGroupIds) {
            this.ec2SecurityGroupIds(Arrays.asList(ec2SecurityGroupIds));
            return this;
        }

        public final List<StudioComponentInitializationScript.Builder> getInitializationScripts() {
            List<StudioComponentInitializationScript.Builder> result = StudioComponentInitializationScriptListCopier.copyToBuilder(this.initializationScripts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInitializationScripts(Collection<StudioComponentInitializationScript.BuilderImpl> initializationScripts) {
            this.initializationScripts = StudioComponentInitializationScriptListCopier.copyFromBuilder(initializationScripts);
        }

        @Override
        public final Builder initializationScripts(Collection<StudioComponentInitializationScript> initializationScripts) {
            this.initializationScripts = StudioComponentInitializationScriptListCopier.copy(initializationScripts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder initializationScripts(StudioComponentInitializationScript ... initializationScripts) {
            this.initializationScripts(Arrays.asList(initializationScripts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder initializationScripts(Consumer<StudioComponentInitializationScript.Builder> ... initializationScripts) {
            this.initializationScripts(Stream.of(initializationScripts).map(c -> (StudioComponentInitializationScript)((StudioComponentInitializationScript.Builder)StudioComponentInitializationScript.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRuntimeRoleArn() {
            return this.runtimeRoleArn;
        }

        public final void setRuntimeRoleArn(String runtimeRoleArn) {
            this.runtimeRoleArn = runtimeRoleArn;
        }

        @Override
        public final Builder runtimeRoleArn(String runtimeRoleArn) {
            this.runtimeRoleArn = runtimeRoleArn;
            return this;
        }

        public final List<ScriptParameterKeyValue.Builder> getScriptParameters() {
            List<ScriptParameterKeyValue.Builder> result = StudioComponentScriptParameterKeyValueListCopier.copyToBuilder(this.scriptParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScriptParameters(Collection<ScriptParameterKeyValue.BuilderImpl> scriptParameters) {
            this.scriptParameters = StudioComponentScriptParameterKeyValueListCopier.copyFromBuilder(scriptParameters);
        }

        @Override
        public final Builder scriptParameters(Collection<ScriptParameterKeyValue> scriptParameters) {
            this.scriptParameters = StudioComponentScriptParameterKeyValueListCopier.copy(scriptParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scriptParameters(ScriptParameterKeyValue ... scriptParameters) {
            this.scriptParameters(Arrays.asList(scriptParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scriptParameters(Consumer<ScriptParameterKeyValue.Builder> ... scriptParameters) {
            this.scriptParameters(Stream.of(scriptParameters).map(c -> (ScriptParameterKeyValue)((ScriptParameterKeyValue.Builder)ScriptParameterKeyValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSecureInitializationRoleArn() {
            return this.secureInitializationRoleArn;
        }

        public final void setSecureInitializationRoleArn(String secureInitializationRoleArn) {
            this.secureInitializationRoleArn = secureInitializationRoleArn;
        }

        @Override
        public final Builder secureInitializationRoleArn(String secureInitializationRoleArn) {
            this.secureInitializationRoleArn = secureInitializationRoleArn;
            return this;
        }

        public final String getStudioId() {
            return this.studioId;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        public final String getSubtype() {
            return this.subtype;
        }

        public final void setSubtype(String subtype) {
            this.subtype = subtype;
        }

        @Override
        public final Builder subtype(String subtype) {
            this.subtype = subtype;
            return this;
        }

        @Override
        public final Builder subtype(StudioComponentSubtype subtype) {
            this.subtype(subtype == null ? null : subtype.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(StudioComponentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStudioComponentRequest build() {
            return new CreateStudioComponentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NimbleRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStudioComponentRequest> {
        public Builder clientToken(String var1);

        public Builder configuration(StudioComponentConfiguration var1);

        default public Builder configuration(Consumer<StudioComponentConfiguration.Builder> configuration) {
            return this.configuration((StudioComponentConfiguration)((StudioComponentConfiguration.Builder)StudioComponentConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder description(String var1);

        public Builder ec2SecurityGroupIds(Collection<String> var1);

        public Builder ec2SecurityGroupIds(String ... var1);

        public Builder initializationScripts(Collection<StudioComponentInitializationScript> var1);

        public Builder initializationScripts(StudioComponentInitializationScript ... var1);

        public Builder initializationScripts(Consumer<StudioComponentInitializationScript.Builder> ... var1);

        public Builder name(String var1);

        public Builder runtimeRoleArn(String var1);

        public Builder scriptParameters(Collection<ScriptParameterKeyValue> var1);

        public Builder scriptParameters(ScriptParameterKeyValue ... var1);

        public Builder scriptParameters(Consumer<ScriptParameterKeyValue.Builder> ... var1);

        public Builder secureInitializationRoleArn(String var1);

        public Builder studioId(String var1);

        public Builder subtype(String var1);

        public Builder subtype(StudioComponentSubtype var1);

        public Builder tags(Map<String, String> var1);

        public Builder type(String var1);

        public Builder type(StudioComponentType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

