/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptunedata.model.PredicatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubjectStructure
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubjectStructure> {
    private static final SdkField<Long> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("count").getter(SubjectStructure.getter(SubjectStructure::count)).setter(SubjectStructure.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final SdkField<List<String>> PREDICATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("predicates").getter(SubjectStructure.getter(SubjectStructure::predicates)).setter(SubjectStructure.setter(Builder::predicates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predicates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, PREDICATES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long count;
    private final List<String> predicates;

    private SubjectStructure(BuilderImpl builder) {
        this.count = builder.count;
        this.predicates = builder.predicates;
    }

    public final Long count() {
        return this.count;
    }

    public final boolean hasPredicates() {
        return this.predicates != null && !(this.predicates instanceof SdkAutoConstructList);
    }

    public final List<String> predicates() {
        return this.predicates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPredicates() ? this.predicates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubjectStructure)) {
            return false;
        }
        SubjectStructure other = (SubjectStructure)obj;
        return Objects.equals(this.count(), other.count()) && this.hasPredicates() == other.hasPredicates() && Objects.equals(this.predicates(), other.predicates());
    }

    public final String toString() {
        return ToString.builder((String)"SubjectStructure").add("Count", (Object)this.count()).add("Predicates", this.hasPredicates() ? this.predicates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "predicates": {
                return Optional.ofNullable(clazz.cast(this.predicates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubjectStructure, T> g) {
        return obj -> g.apply((SubjectStructure)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long count;
        private List<String> predicates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubjectStructure model) {
            this.count(model.count);
            this.predicates(model.predicates);
        }

        public final Long getCount() {
            return this.count;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final Collection<String> getPredicates() {
            if (this.predicates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.predicates;
        }

        public final void setPredicates(Collection<String> predicates) {
            this.predicates = PredicatesCopier.copy(predicates);
        }

        @Override
        public final Builder predicates(Collection<String> predicates) {
            this.predicates = PredicatesCopier.copy(predicates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predicates(String ... predicates) {
            this.predicates(Arrays.asList(predicates));
            return this;
        }

        public SubjectStructure build() {
            return new SubjectStructure(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubjectStructure> {
        public Builder count(Long var1);

        public Builder predicates(Collection<String> var1);

        public Builder predicates(String ... var1);
    }
}

