/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMlModelTransformJobRequest extends NeptunedataRequest implements
        ToCopyableBuilder<StartMlModelTransformJobRequest.Builder, StartMlModelTransformJobRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(StartMlModelTransformJobRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> DATA_PROCESSING_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataProcessingJobId").getter(getter(StartMlModelTransformJobRequest::dataProcessingJobId))
            .setter(setter(Builder::dataProcessingJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataProcessingJobId").build())
            .build();

    private static final SdkField<String> ML_MODEL_TRAINING_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mlModelTrainingJobId").getter(getter(StartMlModelTransformJobRequest::mlModelTrainingJobId))
            .setter(setter(Builder::mlModelTrainingJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mlModelTrainingJobId").build())
            .build();

    private static final SdkField<String> TRAINING_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainingJobName").getter(getter(StartMlModelTransformJobRequest::trainingJobName))
            .setter(setter(Builder::trainingJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingJobName").build()).build();

    private static final SdkField<String> MODEL_TRANSFORM_OUTPUT_S3_LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("modelTransformOutputS3Location")
            .getter(getter(StartMlModelTransformJobRequest::modelTransformOutputS3Location))
            .setter(setter(Builder::modelTransformOutputS3Location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelTransformOutputS3Location")
                    .build()).build();

    private static final SdkField<String> SAGEMAKER_IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sagemakerIamRoleArn").getter(getter(StartMlModelTransformJobRequest::sagemakerIamRoleArn))
            .setter(setter(Builder::sagemakerIamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sagemakerIamRoleArn").build())
            .build();

    private static final SdkField<String> NEPTUNE_IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("neptuneIamRoleArn").getter(getter(StartMlModelTransformJobRequest::neptuneIamRoleArn))
            .setter(setter(Builder::neptuneIamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neptuneIamRoleArn").build()).build();

    private static final SdkField<CustomModelTransformParameters> CUSTOM_MODEL_TRANSFORM_PARAMETERS_FIELD = SdkField
            .<CustomModelTransformParameters> builder(MarshallingType.SDK_POJO)
            .memberName("customModelTransformParameters")
            .getter(getter(StartMlModelTransformJobRequest::customModelTransformParameters))
            .setter(setter(Builder::customModelTransformParameters))
            .constructor(CustomModelTransformParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customModelTransformParameters")
                    .build()).build();

    private static final SdkField<String> BASE_PROCESSING_INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("baseProcessingInstanceType")
            .getter(getter(StartMlModelTransformJobRequest::baseProcessingInstanceType))
            .setter(setter(Builder::baseProcessingInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseProcessingInstanceType").build())
            .build();

    private static final SdkField<Integer> BASE_PROCESSING_INSTANCE_VOLUME_SIZE_IN_GB_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("baseProcessingInstanceVolumeSizeInGB")
            .getter(getter(StartMlModelTransformJobRequest::baseProcessingInstanceVolumeSizeInGB))
            .setter(setter(Builder::baseProcessingInstanceVolumeSizeInGB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("baseProcessingInstanceVolumeSizeInGB").build()).build();

    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnets")
            .getter(getter(StartMlModelTransformJobRequest::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("securityGroupIds")
            .getter(getter(StartMlModelTransformJobRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VOLUME_ENCRYPTION_KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("volumeEncryptionKMSKey").getter(getter(StartMlModelTransformJobRequest::volumeEncryptionKMSKey))
            .setter(setter(Builder::volumeEncryptionKMSKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeEncryptionKMSKey").build())
            .build();

    private static final SdkField<String> S3_OUTPUT_ENCRYPTION_KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3OutputEncryptionKMSKey").getter(getter(StartMlModelTransformJobRequest::s3OutputEncryptionKMSKey))
            .setter(setter(Builder::s3OutputEncryptionKMSKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3OutputEncryptionKMSKey").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            DATA_PROCESSING_JOB_ID_FIELD, ML_MODEL_TRAINING_JOB_ID_FIELD, TRAINING_JOB_NAME_FIELD,
            MODEL_TRANSFORM_OUTPUT_S3_LOCATION_FIELD, SAGEMAKER_IAM_ROLE_ARN_FIELD, NEPTUNE_IAM_ROLE_ARN_FIELD,
            CUSTOM_MODEL_TRANSFORM_PARAMETERS_FIELD, BASE_PROCESSING_INSTANCE_TYPE_FIELD,
            BASE_PROCESSING_INSTANCE_VOLUME_SIZE_IN_GB_FIELD, SUBNETS_FIELD, SECURITY_GROUP_IDS_FIELD,
            VOLUME_ENCRYPTION_KMS_KEY_FIELD, S3_OUTPUT_ENCRYPTION_KMS_KEY_FIELD));

    private final String id;

    private final String dataProcessingJobId;

    private final String mlModelTrainingJobId;

    private final String trainingJobName;

    private final String modelTransformOutputS3Location;

    private final String sagemakerIamRoleArn;

    private final String neptuneIamRoleArn;

    private final CustomModelTransformParameters customModelTransformParameters;

    private final String baseProcessingInstanceType;

    private final Integer baseProcessingInstanceVolumeSizeInGB;

    private final List<String> subnets;

    private final List<String> securityGroupIds;

    private final String volumeEncryptionKMSKey;

    private final String s3OutputEncryptionKMSKey;

    private StartMlModelTransformJobRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.dataProcessingJobId = builder.dataProcessingJobId;
        this.mlModelTrainingJobId = builder.mlModelTrainingJobId;
        this.trainingJobName = builder.trainingJobName;
        this.modelTransformOutputS3Location = builder.modelTransformOutputS3Location;
        this.sagemakerIamRoleArn = builder.sagemakerIamRoleArn;
        this.neptuneIamRoleArn = builder.neptuneIamRoleArn;
        this.customModelTransformParameters = builder.customModelTransformParameters;
        this.baseProcessingInstanceType = builder.baseProcessingInstanceType;
        this.baseProcessingInstanceVolumeSizeInGB = builder.baseProcessingInstanceVolumeSizeInGB;
        this.subnets = builder.subnets;
        this.securityGroupIds = builder.securityGroupIds;
        this.volumeEncryptionKMSKey = builder.volumeEncryptionKMSKey;
        this.s3OutputEncryptionKMSKey = builder.s3OutputEncryptionKMSKey;
    }

    /**
     * <p>
     * A unique identifier for the new job. The default is an autogenerated UUID.
     * </p>
     * 
     * @return A unique identifier for the new job. The default is an autogenerated UUID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The job ID of a completed data-processing job. You must include either <code>dataProcessingJobId</code> and a
     * <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     * </p>
     * 
     * @return The job ID of a completed data-processing job. You must include either <code>dataProcessingJobId</code>
     *         and a <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     */
    public final String dataProcessingJobId() {
        return dataProcessingJobId;
    }

    /**
     * <p>
     * The job ID of a completed model-training job. You must include either <code>dataProcessingJobId</code> and a
     * <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     * </p>
     * 
     * @return The job ID of a completed model-training job. You must include either <code>dataProcessingJobId</code>
     *         and a <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     */
    public final String mlModelTrainingJobId() {
        return mlModelTrainingJobId;
    }

    /**
     * <p>
     * The name of a completed SageMaker training job. You must include either <code>dataProcessingJobId</code> and a
     * <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     * </p>
     * 
     * @return The name of a completed SageMaker training job. You must include either <code>dataProcessingJobId</code>
     *         and a <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
     */
    public final String trainingJobName() {
        return trainingJobName;
    }

    /**
     * <p>
     * The location in Amazon S3 where the model artifacts are to be stored.
     * </p>
     * 
     * @return The location in Amazon S3 where the model artifacts are to be stored.
     */
    public final String modelTransformOutputS3Location() {
        return modelTransformOutputS3Location;
    }

    /**
     * <p>
     * The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or an
     * error will occur.
     * </p>
     * 
     * @return The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or
     *         an error will occur.
     */
    public final String sagemakerIamRoleArn() {
        return sagemakerIamRoleArn;
    }

    /**
     * <p>
     * The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in
     * your DB cluster parameter group or an error will occur.
     * </p>
     * 
     * @return The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be
     *         listed in your DB cluster parameter group or an error will occur.
     */
    public final String neptuneIamRoleArn() {
        return neptuneIamRoleArn;
    }

    /**
     * <p>
     * Configuration information for a model transform using a custom model. The
     * <code>customModelTransformParameters</code> object contains the following fields, which must have values
     * compatible with the saved model parameters from the training job:
     * </p>
     * 
     * @return Configuration information for a model transform using a custom model. The
     *         <code>customModelTransformParameters</code> object contains the following fields, which must have values
     *         compatible with the saved model parameters from the training job:
     */
    public final CustomModelTransformParameters customModelTransformParameters() {
        return customModelTransformParameters;
    }

    /**
     * <p>
     * The type of ML instance used in preparing and managing training of ML models. This is an ML compute instance
     * chosen based on memory requirements for processing the training data and model.
     * </p>
     * 
     * @return The type of ML instance used in preparing and managing training of ML models. This is an ML compute
     *         instance chosen based on memory requirements for processing the training data and model.
     */
    public final String baseProcessingInstanceType() {
        return baseProcessingInstanceType;
    }

    /**
     * <p>
     * The disk volume size of the training instance in gigabytes. The default is 0. Both input data and the output
     * model are stored on disk, so the volume size must be large enough to hold both data sets. If not specified or 0,
     * Neptune ML selects a disk volume size based on the recommendation generated in the data processing step.
     * </p>
     * 
     * @return The disk volume size of the training instance in gigabytes. The default is 0. Both input data and the
     *         output model are stored on disk, so the volume size must be large enough to hold both data sets. If not
     *         specified or 0, Neptune ML selects a disk volume size based on the recommendation generated in the data
     *         processing step.
     */
    public final Integer baseProcessingInstanceVolumeSizeInGB() {
        return baseProcessingInstanceVolumeSizeInGB;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subnets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnets() {
        return subnets != null && !(subnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the subnets in the Neptune VPC. The default is None.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnets} method.
     * </p>
     * 
     * @return The IDs of the subnets in the Neptune VPC. The default is None.
     */
    public final List<String> subnets() {
        return subnets;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The VPC security group IDs. The default is None.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return The VPC security group IDs. The default is None.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume attached to
     * the ML compute instances that run the training job. The default is None.
     * </p>
     * 
     * @return The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume
     *         attached to the ML compute instances that run the training job. The default is None.
     */
    public final String volumeEncryptionKMSKey() {
        return volumeEncryptionKMSKey;
    }

    /**
     * <p>
     * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the processing job. The
     * default is none.
     * </p>
     * 
     * @return The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the processing
     *         job. The default is none.
     */
    public final String s3OutputEncryptionKMSKey() {
        return s3OutputEncryptionKMSKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(dataProcessingJobId());
        hashCode = 31 * hashCode + Objects.hashCode(mlModelTrainingJobId());
        hashCode = 31 * hashCode + Objects.hashCode(trainingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(modelTransformOutputS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(sagemakerIamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(neptuneIamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(customModelTransformParameters());
        hashCode = 31 * hashCode + Objects.hashCode(baseProcessingInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(baseProcessingInstanceVolumeSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnets() ? subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(volumeEncryptionKMSKey());
        hashCode = 31 * hashCode + Objects.hashCode(s3OutputEncryptionKMSKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMlModelTransformJobRequest)) {
            return false;
        }
        StartMlModelTransformJobRequest other = (StartMlModelTransformJobRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(dataProcessingJobId(), other.dataProcessingJobId())
                && Objects.equals(mlModelTrainingJobId(), other.mlModelTrainingJobId())
                && Objects.equals(trainingJobName(), other.trainingJobName())
                && Objects.equals(modelTransformOutputS3Location(), other.modelTransformOutputS3Location())
                && Objects.equals(sagemakerIamRoleArn(), other.sagemakerIamRoleArn())
                && Objects.equals(neptuneIamRoleArn(), other.neptuneIamRoleArn())
                && Objects.equals(customModelTransformParameters(), other.customModelTransformParameters())
                && Objects.equals(baseProcessingInstanceType(), other.baseProcessingInstanceType())
                && Objects.equals(baseProcessingInstanceVolumeSizeInGB(), other.baseProcessingInstanceVolumeSizeInGB())
                && hasSubnets() == other.hasSubnets() && Objects.equals(subnets(), other.subnets())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(volumeEncryptionKMSKey(), other.volumeEncryptionKMSKey())
                && Objects.equals(s3OutputEncryptionKMSKey(), other.s3OutputEncryptionKMSKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartMlModelTransformJobRequest").add("Id", id())
                .add("DataProcessingJobId", dataProcessingJobId()).add("MlModelTrainingJobId", mlModelTrainingJobId())
                .add("TrainingJobName", trainingJobName())
                .add("ModelTransformOutputS3Location", modelTransformOutputS3Location())
                .add("SagemakerIamRoleArn", sagemakerIamRoleArn()).add("NeptuneIamRoleArn", neptuneIamRoleArn())
                .add("CustomModelTransformParameters", customModelTransformParameters())
                .add("BaseProcessingInstanceType", baseProcessingInstanceType())
                .add("BaseProcessingInstanceVolumeSizeInGB", baseProcessingInstanceVolumeSizeInGB())
                .add("Subnets", hasSubnets() ? subnets() : null)
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("VolumeEncryptionKMSKey", volumeEncryptionKMSKey())
                .add("S3OutputEncryptionKMSKey", s3OutputEncryptionKMSKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "dataProcessingJobId":
            return Optional.ofNullable(clazz.cast(dataProcessingJobId()));
        case "mlModelTrainingJobId":
            return Optional.ofNullable(clazz.cast(mlModelTrainingJobId()));
        case "trainingJobName":
            return Optional.ofNullable(clazz.cast(trainingJobName()));
        case "modelTransformOutputS3Location":
            return Optional.ofNullable(clazz.cast(modelTransformOutputS3Location()));
        case "sagemakerIamRoleArn":
            return Optional.ofNullable(clazz.cast(sagemakerIamRoleArn()));
        case "neptuneIamRoleArn":
            return Optional.ofNullable(clazz.cast(neptuneIamRoleArn()));
        case "customModelTransformParameters":
            return Optional.ofNullable(clazz.cast(customModelTransformParameters()));
        case "baseProcessingInstanceType":
            return Optional.ofNullable(clazz.cast(baseProcessingInstanceType()));
        case "baseProcessingInstanceVolumeSizeInGB":
            return Optional.ofNullable(clazz.cast(baseProcessingInstanceVolumeSizeInGB()));
        case "subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        case "securityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "volumeEncryptionKMSKey":
            return Optional.ofNullable(clazz.cast(volumeEncryptionKMSKey()));
        case "s3OutputEncryptionKMSKey":
            return Optional.ofNullable(clazz.cast(s3OutputEncryptionKMSKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMlModelTransformJobRequest, T> g) {
        return obj -> g.apply((StartMlModelTransformJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartMlModelTransformJobRequest> {
        /**
         * <p>
         * A unique identifier for the new job. The default is an autogenerated UUID.
         * </p>
         * 
         * @param id
         *        A unique identifier for the new job. The default is an autogenerated UUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The job ID of a completed data-processing job. You must include either <code>dataProcessingJobId</code> and a
         * <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
         * </p>
         * 
         * @param dataProcessingJobId
         *        The job ID of a completed data-processing job. You must include either
         *        <code>dataProcessingJobId</code> and a <code>mlModelTrainingJobId</code>, or a
         *        <code>trainingJobName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProcessingJobId(String dataProcessingJobId);

        /**
         * <p>
         * The job ID of a completed model-training job. You must include either <code>dataProcessingJobId</code> and a
         * <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
         * </p>
         * 
         * @param mlModelTrainingJobId
         *        The job ID of a completed model-training job. You must include either <code>dataProcessingJobId</code>
         *        and a <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelTrainingJobId(String mlModelTrainingJobId);

        /**
         * <p>
         * The name of a completed SageMaker training job. You must include either <code>dataProcessingJobId</code> and
         * a <code>mlModelTrainingJobId</code>, or a <code>trainingJobName</code>.
         * </p>
         * 
         * @param trainingJobName
         *        The name of a completed SageMaker training job. You must include either
         *        <code>dataProcessingJobId</code> and a <code>mlModelTrainingJobId</code>, or a
         *        <code>trainingJobName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJobName(String trainingJobName);

        /**
         * <p>
         * The location in Amazon S3 where the model artifacts are to be stored.
         * </p>
         * 
         * @param modelTransformOutputS3Location
         *        The location in Amazon S3 where the model artifacts are to be stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelTransformOutputS3Location(String modelTransformOutputS3Location);

        /**
         * <p>
         * The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group or an
         * error will occur.
         * </p>
         * 
         * @param sagemakerIamRoleArn
         *        The ARN of an IAM role for SageMaker execution. This must be listed in your DB cluster parameter group
         *        or an error will occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sagemakerIamRoleArn(String sagemakerIamRoleArn);

        /**
         * <p>
         * The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed
         * in your DB cluster parameter group or an error will occur.
         * </p>
         * 
         * @param neptuneIamRoleArn
         *        The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be
         *        listed in your DB cluster parameter group or an error will occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neptuneIamRoleArn(String neptuneIamRoleArn);

        /**
         * <p>
         * Configuration information for a model transform using a custom model. The
         * <code>customModelTransformParameters</code> object contains the following fields, which must have values
         * compatible with the saved model parameters from the training job:
         * </p>
         * 
         * @param customModelTransformParameters
         *        Configuration information for a model transform using a custom model. The
         *        <code>customModelTransformParameters</code> object contains the following fields, which must have
         *        values compatible with the saved model parameters from the training job:
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customModelTransformParameters(CustomModelTransformParameters customModelTransformParameters);

        /**
         * <p>
         * Configuration information for a model transform using a custom model. The
         * <code>customModelTransformParameters</code> object contains the following fields, which must have values
         * compatible with the saved model parameters from the training job:
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomModelTransformParameters.Builder}
         * avoiding the need to create one manually via {@link CustomModelTransformParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomModelTransformParameters.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #customModelTransformParameters(CustomModelTransformParameters)}.
         * 
         * @param customModelTransformParameters
         *        a consumer that will call methods on {@link CustomModelTransformParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customModelTransformParameters(CustomModelTransformParameters)
         */
        default Builder customModelTransformParameters(
                Consumer<CustomModelTransformParameters.Builder> customModelTransformParameters) {
            return customModelTransformParameters(CustomModelTransformParameters.builder()
                    .applyMutation(customModelTransformParameters).build());
        }

        /**
         * <p>
         * The type of ML instance used in preparing and managing training of ML models. This is an ML compute instance
         * chosen based on memory requirements for processing the training data and model.
         * </p>
         * 
         * @param baseProcessingInstanceType
         *        The type of ML instance used in preparing and managing training of ML models. This is an ML compute
         *        instance chosen based on memory requirements for processing the training data and model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseProcessingInstanceType(String baseProcessingInstanceType);

        /**
         * <p>
         * The disk volume size of the training instance in gigabytes. The default is 0. Both input data and the output
         * model are stored on disk, so the volume size must be large enough to hold both data sets. If not specified or
         * 0, Neptune ML selects a disk volume size based on the recommendation generated in the data processing step.
         * </p>
         * 
         * @param baseProcessingInstanceVolumeSizeInGB
         *        The disk volume size of the training instance in gigabytes. The default is 0. Both input data and the
         *        output model are stored on disk, so the volume size must be large enough to hold both data sets. If
         *        not specified or 0, Neptune ML selects a disk volume size based on the recommendation generated in the
         *        data processing step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseProcessingInstanceVolumeSizeInGB(Integer baseProcessingInstanceVolumeSizeInGB);

        /**
         * <p>
         * The IDs of the subnets in the Neptune VPC. The default is None.
         * </p>
         * 
         * @param subnets
         *        The IDs of the subnets in the Neptune VPC. The default is None.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<String> subnets);

        /**
         * <p>
         * The IDs of the subnets in the Neptune VPC. The default is None.
         * </p>
         * 
         * @param subnets
         *        The IDs of the subnets in the Neptune VPC. The default is None.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(String... subnets);

        /**
         * <p>
         * The VPC security group IDs. The default is None.
         * </p>
         * 
         * @param securityGroupIds
         *        The VPC security group IDs. The default is None.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The VPC security group IDs. The default is None.
         * </p>
         * 
         * @param securityGroupIds
         *        The VPC security group IDs. The default is None.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume
         * attached to the ML compute instances that run the training job. The default is None.
         * </p>
         * 
         * @param volumeEncryptionKMSKey
         *        The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt data on the storage volume
         *        attached to the ML compute instances that run the training job. The default is None.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeEncryptionKMSKey(String volumeEncryptionKMSKey);

        /**
         * <p>
         * The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the processing job.
         * The default is none.
         * </p>
         * 
         * @param s3OutputEncryptionKMSKey
         *        The Amazon Key Management Service (KMS) key that SageMaker uses to encrypt the output of the
         *        processing job. The default is none.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3OutputEncryptionKMSKey(String s3OutputEncryptionKMSKey);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptunedataRequest.BuilderImpl implements Builder {
        private String id;

        private String dataProcessingJobId;

        private String mlModelTrainingJobId;

        private String trainingJobName;

        private String modelTransformOutputS3Location;

        private String sagemakerIamRoleArn;

        private String neptuneIamRoleArn;

        private CustomModelTransformParameters customModelTransformParameters;

        private String baseProcessingInstanceType;

        private Integer baseProcessingInstanceVolumeSizeInGB;

        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String volumeEncryptionKMSKey;

        private String s3OutputEncryptionKMSKey;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMlModelTransformJobRequest model) {
            super(model);
            id(model.id);
            dataProcessingJobId(model.dataProcessingJobId);
            mlModelTrainingJobId(model.mlModelTrainingJobId);
            trainingJobName(model.trainingJobName);
            modelTransformOutputS3Location(model.modelTransformOutputS3Location);
            sagemakerIamRoleArn(model.sagemakerIamRoleArn);
            neptuneIamRoleArn(model.neptuneIamRoleArn);
            customModelTransformParameters(model.customModelTransformParameters);
            baseProcessingInstanceType(model.baseProcessingInstanceType);
            baseProcessingInstanceVolumeSizeInGB(model.baseProcessingInstanceVolumeSizeInGB);
            subnets(model.subnets);
            securityGroupIds(model.securityGroupIds);
            volumeEncryptionKMSKey(model.volumeEncryptionKMSKey);
            s3OutputEncryptionKMSKey(model.s3OutputEncryptionKMSKey);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDataProcessingJobId() {
            return dataProcessingJobId;
        }

        public final void setDataProcessingJobId(String dataProcessingJobId) {
            this.dataProcessingJobId = dataProcessingJobId;
        }

        @Override
        public final Builder dataProcessingJobId(String dataProcessingJobId) {
            this.dataProcessingJobId = dataProcessingJobId;
            return this;
        }

        public final String getMlModelTrainingJobId() {
            return mlModelTrainingJobId;
        }

        public final void setMlModelTrainingJobId(String mlModelTrainingJobId) {
            this.mlModelTrainingJobId = mlModelTrainingJobId;
        }

        @Override
        public final Builder mlModelTrainingJobId(String mlModelTrainingJobId) {
            this.mlModelTrainingJobId = mlModelTrainingJobId;
            return this;
        }

        public final String getTrainingJobName() {
            return trainingJobName;
        }

        public final void setTrainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
        }

        @Override
        public final Builder trainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
            return this;
        }

        public final String getModelTransformOutputS3Location() {
            return modelTransformOutputS3Location;
        }

        public final void setModelTransformOutputS3Location(String modelTransformOutputS3Location) {
            this.modelTransformOutputS3Location = modelTransformOutputS3Location;
        }

        @Override
        public final Builder modelTransformOutputS3Location(String modelTransformOutputS3Location) {
            this.modelTransformOutputS3Location = modelTransformOutputS3Location;
            return this;
        }

        public final String getSagemakerIamRoleArn() {
            return sagemakerIamRoleArn;
        }

        public final void setSagemakerIamRoleArn(String sagemakerIamRoleArn) {
            this.sagemakerIamRoleArn = sagemakerIamRoleArn;
        }

        @Override
        public final Builder sagemakerIamRoleArn(String sagemakerIamRoleArn) {
            this.sagemakerIamRoleArn = sagemakerIamRoleArn;
            return this;
        }

        public final String getNeptuneIamRoleArn() {
            return neptuneIamRoleArn;
        }

        public final void setNeptuneIamRoleArn(String neptuneIamRoleArn) {
            this.neptuneIamRoleArn = neptuneIamRoleArn;
        }

        @Override
        public final Builder neptuneIamRoleArn(String neptuneIamRoleArn) {
            this.neptuneIamRoleArn = neptuneIamRoleArn;
            return this;
        }

        public final CustomModelTransformParameters.Builder getCustomModelTransformParameters() {
            return customModelTransformParameters != null ? customModelTransformParameters.toBuilder() : null;
        }

        public final void setCustomModelTransformParameters(
                CustomModelTransformParameters.BuilderImpl customModelTransformParameters) {
            this.customModelTransformParameters = customModelTransformParameters != null ? customModelTransformParameters.build()
                    : null;
        }

        @Override
        public final Builder customModelTransformParameters(CustomModelTransformParameters customModelTransformParameters) {
            this.customModelTransformParameters = customModelTransformParameters;
            return this;
        }

        public final String getBaseProcessingInstanceType() {
            return baseProcessingInstanceType;
        }

        public final void setBaseProcessingInstanceType(String baseProcessingInstanceType) {
            this.baseProcessingInstanceType = baseProcessingInstanceType;
        }

        @Override
        public final Builder baseProcessingInstanceType(String baseProcessingInstanceType) {
            this.baseProcessingInstanceType = baseProcessingInstanceType;
            return this;
        }

        public final Integer getBaseProcessingInstanceVolumeSizeInGB() {
            return baseProcessingInstanceVolumeSizeInGB;
        }

        public final void setBaseProcessingInstanceVolumeSizeInGB(Integer baseProcessingInstanceVolumeSizeInGB) {
            this.baseProcessingInstanceVolumeSizeInGB = baseProcessingInstanceVolumeSizeInGB;
        }

        @Override
        public final Builder baseProcessingInstanceVolumeSizeInGB(Integer baseProcessingInstanceVolumeSizeInGB) {
            this.baseProcessingInstanceVolumeSizeInGB = baseProcessingInstanceVolumeSizeInGB;
            return this;
        }

        public final Collection<String> getSubnets() {
            if (subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getVolumeEncryptionKMSKey() {
            return volumeEncryptionKMSKey;
        }

        public final void setVolumeEncryptionKMSKey(String volumeEncryptionKMSKey) {
            this.volumeEncryptionKMSKey = volumeEncryptionKMSKey;
        }

        @Override
        public final Builder volumeEncryptionKMSKey(String volumeEncryptionKMSKey) {
            this.volumeEncryptionKMSKey = volumeEncryptionKMSKey;
            return this;
        }

        public final String getS3OutputEncryptionKMSKey() {
            return s3OutputEncryptionKMSKey;
        }

        public final void setS3OutputEncryptionKMSKey(String s3OutputEncryptionKMSKey) {
            this.s3OutputEncryptionKMSKey = s3OutputEncryptionKMSKey;
        }

        @Override
        public final Builder s3OutputEncryptionKMSKey(String s3OutputEncryptionKMSKey) {
            this.s3OutputEncryptionKMSKey = s3OutputEncryptionKMSKey;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMlModelTransformJobRequest build() {
            return new StartMlModelTransformJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
