/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRdfGraphSummaryResponse extends NeptunedataResponse implements
        ToCopyableBuilder<GetRdfGraphSummaryResponse.Builder, GetRdfGraphSummaryResponse> {
    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("statusCode").getter(getter(GetRdfGraphSummaryResponse::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("statusCode").build()).build();

    private static final SdkField<RDFGraphSummaryValueMap> PAYLOAD_FIELD = SdkField
            .<RDFGraphSummaryValueMap> builder(MarshallingType.SDK_POJO).memberName("payload")
            .getter(getter(GetRdfGraphSummaryResponse::payload)).setter(setter(Builder::payload))
            .constructor(RDFGraphSummaryValueMap::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_CODE_FIELD,
            PAYLOAD_FIELD));

    private final Integer statusCodeValue;

    private final RDFGraphSummaryValueMap payload;

    private GetRdfGraphSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.statusCodeValue = builder.statusCodeValue;
        this.payload = builder.payload;
    }

    /**
     * <p>
     * The HTTP return code of the request. If the request succeeded, the code is 200.
     * </p>
     * 
     * @return The HTTP return code of the request. If the request succeeded, the code is 200.
     */
    public final Integer statusCode() {
        return statusCodeValue;
    }

    /**
     * <p>
     * Payload for an RDF graph summary response
     * </p>
     * 
     * @return Payload for an RDF graph summary response
     */
    public final RDFGraphSummaryValueMap payload() {
        return payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRdfGraphSummaryResponse)) {
            return false;
        }
        GetRdfGraphSummaryResponse other = (GetRdfGraphSummaryResponse) obj;
        return Objects.equals(statusCode(), other.statusCode()) && Objects.equals(payload(), other.payload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRdfGraphSummaryResponse").add("StatusCode", statusCode()).add("Payload", payload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "payload":
            return Optional.ofNullable(clazz.cast(payload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRdfGraphSummaryResponse, T> g) {
        return obj -> g.apply((GetRdfGraphSummaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRdfGraphSummaryResponse> {
        /**
         * <p>
         * The HTTP return code of the request. If the request succeeded, the code is 200.
         * </p>
         * 
         * @param statusCodeValue
         *        The HTTP return code of the request. If the request succeeded, the code is 200.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(Integer statusCodeValue);

        /**
         * <p>
         * Payload for an RDF graph summary response
         * </p>
         * 
         * @param payload
         *        Payload for an RDF graph summary response
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(RDFGraphSummaryValueMap payload);

        /**
         * <p>
         * Payload for an RDF graph summary response
         * </p>
         * This is a convenience method that creates an instance of the {@link RDFGraphSummaryValueMap.Builder} avoiding
         * the need to create one manually via {@link RDFGraphSummaryValueMap#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RDFGraphSummaryValueMap.Builder#build()} is called immediately
         * and its result is passed to {@link #payload(RDFGraphSummaryValueMap)}.
         * 
         * @param payload
         *        a consumer that will call methods on {@link RDFGraphSummaryValueMap.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #payload(RDFGraphSummaryValueMap)
         */
        default Builder payload(Consumer<RDFGraphSummaryValueMap.Builder> payload) {
            return payload(RDFGraphSummaryValueMap.builder().applyMutation(payload).build());
        }
    }

    static final class BuilderImpl extends NeptunedataResponse.BuilderImpl implements Builder {
        private Integer statusCodeValue;

        private RDFGraphSummaryValueMap payload;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRdfGraphSummaryResponse model) {
            super(model);
            statusCode(model.statusCodeValue);
            payload(model.payload);
        }

        public final Integer getStatusCode() {
            return statusCodeValue;
        }

        public final void setStatusCode(Integer statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(Integer statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        public final RDFGraphSummaryValueMap.Builder getPayload() {
            return payload != null ? payload.toBuilder() : null;
        }

        public final void setPayload(RDFGraphSummaryValueMap.BuilderImpl payload) {
            this.payload = payload != null ? payload.build() : null;
        }

        @Override
        public final Builder payload(RDFGraphSummaryValueMap payload) {
            this.payload = payload;
            return this;
        }

        @Override
        public GetRdfGraphSummaryResponse build() {
            return new GetRdfGraphSummaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
