/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelOpenCypherQueryRequest extends NeptunedataRequest implements
        ToCopyableBuilder<CancelOpenCypherQueryRequest.Builder, CancelOpenCypherQueryRequest> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryId").getter(getter(CancelOpenCypherQueryRequest::queryId)).setter(setter(Builder::queryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("queryId").build()).build();

    private static final SdkField<Boolean> SILENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("silent").getter(getter(CancelOpenCypherQueryRequest::silent)).setter(setter(Builder::silent))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("silent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD, SILENT_FIELD));

    private final String queryId;

    private final Boolean silent;

    private CancelOpenCypherQueryRequest(BuilderImpl builder) {
        super(builder);
        this.queryId = builder.queryId;
        this.silent = builder.silent;
    }

    /**
     * <p>
     * The unique ID of the openCypher query to cancel.
     * </p>
     * 
     * @return The unique ID of the openCypher query to cancel.
     */
    public final String queryId() {
        return queryId;
    }

    /**
     * <p>
     * If set to <code>TRUE</code>, causes the cancelation of the openCypher query to happen silently.
     * </p>
     * 
     * @return If set to <code>TRUE</code>, causes the cancelation of the openCypher query to happen silently.
     */
    public final Boolean silent() {
        return silent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queryId());
        hashCode = 31 * hashCode + Objects.hashCode(silent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelOpenCypherQueryRequest)) {
            return false;
        }
        CancelOpenCypherQueryRequest other = (CancelOpenCypherQueryRequest) obj;
        return Objects.equals(queryId(), other.queryId()) && Objects.equals(silent(), other.silent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelOpenCypherQueryRequest").add("QueryId", queryId()).add("Silent", silent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queryId":
            return Optional.ofNullable(clazz.cast(queryId()));
        case "silent":
            return Optional.ofNullable(clazz.cast(silent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelOpenCypherQueryRequest, T> g) {
        return obj -> g.apply((CancelOpenCypherQueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataRequest.Builder, SdkPojo, CopyableBuilder<Builder, CancelOpenCypherQueryRequest> {
        /**
         * <p>
         * The unique ID of the openCypher query to cancel.
         * </p>
         * 
         * @param queryId
         *        The unique ID of the openCypher query to cancel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryId(String queryId);

        /**
         * <p>
         * If set to <code>TRUE</code>, causes the cancelation of the openCypher query to happen silently.
         * </p>
         * 
         * @param silent
         *        If set to <code>TRUE</code>, causes the cancelation of the openCypher query to happen silently.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder silent(Boolean silent);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptunedataRequest.BuilderImpl implements Builder {
        private String queryId;

        private Boolean silent;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelOpenCypherQueryRequest model) {
            super(model);
            queryId(model.queryId);
            silent(model.silent);
        }

        public final String getQueryId() {
            return queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final Boolean getSilent() {
            return silent;
        }

        public final void setSilent(Boolean silent) {
            this.silent = silent;
        }

        @Override
        public final Builder silent(Boolean silent) {
            this.silent = silent;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelOpenCypherQueryRequest build() {
            return new CancelOpenCypherQueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
