/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDbClusterSnapshotResponse extends NeptuneResponse implements
        ToCopyableBuilder<DeleteDbClusterSnapshotResponse.Builder, DeleteDbClusterSnapshotResponse> {
    private static final SdkField<DBClusterSnapshot> DB_CLUSTER_SNAPSHOT_FIELD = SdkField
            .<DBClusterSnapshot> builder(MarshallingType.SDK_POJO).memberName("DBClusterSnapshot")
            .getter(getter(DeleteDbClusterSnapshotResponse::dbClusterSnapshot)).setter(setter(Builder::dbClusterSnapshot))
            .constructor(DBClusterSnapshot::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterSnapshot").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_SNAPSHOT_FIELD));

    private final DBClusterSnapshot dbClusterSnapshot;

    private DeleteDbClusterSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.dbClusterSnapshot = builder.dbClusterSnapshot;
    }

    /**
     * Returns the value of the DBClusterSnapshot property for this object.
     * 
     * @return The value of the DBClusterSnapshot property for this object.
     */
    public final DBClusterSnapshot dbClusterSnapshot() {
        return dbClusterSnapshot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterSnapshot());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDbClusterSnapshotResponse)) {
            return false;
        }
        DeleteDbClusterSnapshotResponse other = (DeleteDbClusterSnapshotResponse) obj;
        return Objects.equals(dbClusterSnapshot(), other.dbClusterSnapshot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteDbClusterSnapshotResponse").add("DBClusterSnapshot", dbClusterSnapshot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterSnapshot":
            return Optional.ofNullable(clazz.cast(dbClusterSnapshot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDbClusterSnapshotResponse, T> g) {
        return obj -> g.apply((DeleteDbClusterSnapshotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteDbClusterSnapshotResponse> {
        /**
         * Sets the value of the DBClusterSnapshot property for this object.
         *
         * @param dbClusterSnapshot
         *        The new value for the DBClusterSnapshot property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterSnapshot(DBClusterSnapshot dbClusterSnapshot);

        /**
         * Sets the value of the DBClusterSnapshot property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DBClusterSnapshot.Builder} avoiding the
         * need to create one manually via {@link DBClusterSnapshot#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DBClusterSnapshot.Builder#build()} is called immediately and its
         * result is passed to {@link #dbClusterSnapshot(DBClusterSnapshot)}.
         * 
         * @param dbClusterSnapshot
         *        a consumer that will call methods on {@link DBClusterSnapshot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbClusterSnapshot(DBClusterSnapshot)
         */
        default Builder dbClusterSnapshot(Consumer<DBClusterSnapshot.Builder> dbClusterSnapshot) {
            return dbClusterSnapshot(DBClusterSnapshot.builder().applyMutation(dbClusterSnapshot).build());
        }
    }

    static final class BuilderImpl extends NeptuneResponse.BuilderImpl implements Builder {
        private DBClusterSnapshot dbClusterSnapshot;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDbClusterSnapshotResponse model) {
            super(model);
            dbClusterSnapshot(model.dbClusterSnapshot);
        }

        public final DBClusterSnapshot.Builder getDbClusterSnapshot() {
            return dbClusterSnapshot != null ? dbClusterSnapshot.toBuilder() : null;
        }

        public final void setDbClusterSnapshot(DBClusterSnapshot.BuilderImpl dbClusterSnapshot) {
            this.dbClusterSnapshot = dbClusterSnapshot != null ? dbClusterSnapshot.build() : null;
        }

        @Override
        public final Builder dbClusterSnapshot(DBClusterSnapshot dbClusterSnapshot) {
            this.dbClusterSnapshot = dbClusterSnapshot;
            return this;
        }

        @Override
        public DeleteDbClusterSnapshotResponse build() {
            return new DeleteDbClusterSnapshotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
