/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This data type represents the information you need to connect to an Amazon Neptune DB cluster. This data type is used
 * as a response element in the following actions:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>CreateDBClusterEndpoint</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DescribeDBClusterEndpoints</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ModifyDBClusterEndpoint</code>
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DeleteDBClusterEndpoint</code>
 * </p>
 * </li>
 * </ul>
 * <p>
 * For the data structure that represents Amazon RDS DB instance endpoints, see <code>Endpoint</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDbClusterEndpointResponse extends NeptuneResponse implements
        ToCopyableBuilder<DeleteDbClusterEndpointResponse.Builder, DeleteDbClusterEndpointResponse> {
    private static final SdkField<String> DB_CLUSTER_ENDPOINT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DBClusterEndpointIdentifier")
            .getter(getter(DeleteDbClusterEndpointResponse::dbClusterEndpointIdentifier))
            .setter(setter(Builder::dbClusterEndpointIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterEndpointIdentifier")
                    .build()).build();

    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(DeleteDbClusterEndpointResponse::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<String> DB_CLUSTER_ENDPOINT_RESOURCE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DBClusterEndpointResourceIdentifier")
            .getter(getter(DeleteDbClusterEndpointResponse::dbClusterEndpointResourceIdentifier))
            .setter(setter(Builder::dbClusterEndpointResourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DBClusterEndpointResourceIdentifier").build()).build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Endpoint").getter(getter(DeleteDbClusterEndpointResponse::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DeleteDbClusterEndpointResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointType").getter(getter(DeleteDbClusterEndpointResponse::endpointType))
            .setter(setter(Builder::endpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()).build();

    private static final SdkField<String> CUSTOM_ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomEndpointType").getter(getter(DeleteDbClusterEndpointResponse::customEndpointType))
            .setter(setter(Builder::customEndpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEndpointType").build())
            .build();

    private static final SdkField<List<String>> STATIC_MEMBERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StaticMembers")
            .getter(getter(DeleteDbClusterEndpointResponse::staticMembers))
            .setter(setter(Builder::staticMembers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticMembers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUDED_MEMBERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExcludedMembers")
            .getter(getter(DeleteDbClusterEndpointResponse::excludedMembers))
            .setter(setter(Builder::excludedMembers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedMembers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DB_CLUSTER_ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterEndpointArn").getter(getter(DeleteDbClusterEndpointResponse::dbClusterEndpointArn))
            .setter(setter(Builder::dbClusterEndpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterEndpointArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DB_CLUSTER_ENDPOINT_IDENTIFIER_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, DB_CLUSTER_ENDPOINT_RESOURCE_IDENTIFIER_FIELD,
            ENDPOINT_FIELD, STATUS_FIELD, ENDPOINT_TYPE_FIELD, CUSTOM_ENDPOINT_TYPE_FIELD, STATIC_MEMBERS_FIELD,
            EXCLUDED_MEMBERS_FIELD, DB_CLUSTER_ENDPOINT_ARN_FIELD));

    private final String dbClusterEndpointIdentifier;

    private final String dbClusterIdentifier;

    private final String dbClusterEndpointResourceIdentifier;

    private final String endpoint;

    private final String status;

    private final String endpointType;

    private final String customEndpointType;

    private final List<String> staticMembers;

    private final List<String> excludedMembers;

    private final String dbClusterEndpointArn;

    private DeleteDbClusterEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.dbClusterEndpointIdentifier = builder.dbClusterEndpointIdentifier;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbClusterEndpointResourceIdentifier = builder.dbClusterEndpointResourceIdentifier;
        this.endpoint = builder.endpoint;
        this.status = builder.status;
        this.endpointType = builder.endpointType;
        this.customEndpointType = builder.customEndpointType;
        this.staticMembers = builder.staticMembers;
        this.excludedMembers = builder.excludedMembers;
        this.dbClusterEndpointArn = builder.dbClusterEndpointArn;
    }

    /**
     * <p>
     * The identifier associated with the endpoint. This parameter is stored as a lowercase string.
     * </p>
     * 
     * @return The identifier associated with the endpoint. This parameter is stored as a lowercase string.
     */
    public final String dbClusterEndpointIdentifier() {
        return dbClusterEndpointIdentifier;
    }

    /**
     * <p>
     * The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase
     * string.
     * </p>
     * 
     * @return The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a
     *         lowercase string.
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.
     * </p>
     * 
     * @return A unique system-generated identifier for an endpoint. It remains the same for the whole life of the
     *         endpoint.
     */
    public final String dbClusterEndpointResourceIdentifier() {
        return dbClusterEndpointResourceIdentifier;
    }

    /**
     * <p>
     * The DNS address of the endpoint.
     * </p>
     * 
     * @return The DNS address of the endpoint.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>,
     * <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that cannot
     * be used for a certain kind of cluster, such as a <code>writer</code> endpoint for a read-only secondary cluster
     * in a global database.
     * </p>
     * 
     * @return The current status of the endpoint. One of: <code>creating</code>, <code>available</code>,
     *         <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state
     *         applies to an endpoint that cannot be used for a certain kind of cluster, such as a <code>writer</code>
     *         endpoint for a read-only secondary cluster in a global database.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.
     * </p>
     * 
     * @return The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.
     */
    public final String endpointType() {
        return endpointType;
    }

    /**
     * <p>
     * The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.
     * </p>
     * 
     * @return The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>,
     *         <code>ANY</code>.
     */
    public final String customEndpointType() {
        return customEndpointType;
    }

    /**
     * For responses, this returns true if the service returned a value for the StaticMembers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStaticMembers() {
        return staticMembers != null && !(staticMembers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of DB instance identifiers that are part of the custom endpoint group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStaticMembers} method.
     * </p>
     * 
     * @return List of DB instance identifiers that are part of the custom endpoint group.
     */
    public final List<String> staticMembers() {
        return staticMembers;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludedMembers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExcludedMembers() {
        return excludedMembers != null && !(excludedMembers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are
     * reachable through the custom endpoint. Only relevant if the list of static members is empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludedMembers} method.
     * </p>
     * 
     * @return List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible
     *         instances are reachable through the custom endpoint. Only relevant if the list of static members is
     *         empty.
     */
    public final List<String> excludedMembers() {
        return excludedMembers;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the endpoint.
     */
    public final String dbClusterEndpointArn() {
        return dbClusterEndpointArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterEndpointIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterEndpointResourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(endpointType());
        hashCode = 31 * hashCode + Objects.hashCode(customEndpointType());
        hashCode = 31 * hashCode + Objects.hashCode(hasStaticMembers() ? staticMembers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludedMembers() ? excludedMembers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterEndpointArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDbClusterEndpointResponse)) {
            return false;
        }
        DeleteDbClusterEndpointResponse other = (DeleteDbClusterEndpointResponse) obj;
        return Objects.equals(dbClusterEndpointIdentifier(), other.dbClusterEndpointIdentifier())
                && Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(dbClusterEndpointResourceIdentifier(), other.dbClusterEndpointResourceIdentifier())
                && Objects.equals(endpoint(), other.endpoint()) && Objects.equals(status(), other.status())
                && Objects.equals(endpointType(), other.endpointType())
                && Objects.equals(customEndpointType(), other.customEndpointType())
                && hasStaticMembers() == other.hasStaticMembers() && Objects.equals(staticMembers(), other.staticMembers())
                && hasExcludedMembers() == other.hasExcludedMembers()
                && Objects.equals(excludedMembers(), other.excludedMembers())
                && Objects.equals(dbClusterEndpointArn(), other.dbClusterEndpointArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteDbClusterEndpointResponse")
                .add("DBClusterEndpointIdentifier", dbClusterEndpointIdentifier())
                .add("DBClusterIdentifier", dbClusterIdentifier())
                .add("DBClusterEndpointResourceIdentifier", dbClusterEndpointResourceIdentifier()).add("Endpoint", endpoint())
                .add("Status", status()).add("EndpointType", endpointType()).add("CustomEndpointType", customEndpointType())
                .add("StaticMembers", hasStaticMembers() ? staticMembers() : null)
                .add("ExcludedMembers", hasExcludedMembers() ? excludedMembers() : null)
                .add("DBClusterEndpointArn", dbClusterEndpointArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBClusterEndpointIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterEndpointIdentifier()));
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "DBClusterEndpointResourceIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterEndpointResourceIdentifier()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "EndpointType":
            return Optional.ofNullable(clazz.cast(endpointType()));
        case "CustomEndpointType":
            return Optional.ofNullable(clazz.cast(customEndpointType()));
        case "StaticMembers":
            return Optional.ofNullable(clazz.cast(staticMembers()));
        case "ExcludedMembers":
            return Optional.ofNullable(clazz.cast(excludedMembers()));
        case "DBClusterEndpointArn":
            return Optional.ofNullable(clazz.cast(dbClusterEndpointArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDbClusterEndpointResponse, T> g) {
        return obj -> g.apply((DeleteDbClusterEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteDbClusterEndpointResponse> {
        /**
         * <p>
         * The identifier associated with the endpoint. This parameter is stored as a lowercase string.
         * </p>
         * 
         * @param dbClusterEndpointIdentifier
         *        The identifier associated with the endpoint. This parameter is stored as a lowercase string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterEndpointIdentifier(String dbClusterEndpointIdentifier);

        /**
         * <p>
         * The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a
         * lowercase string.
         * </p>
         * 
         * @param dbClusterIdentifier
         *        The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as
         *        a lowercase string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.
         * </p>
         * 
         * @param dbClusterEndpointResourceIdentifier
         *        A unique system-generated identifier for an endpoint. It remains the same for the whole life of the
         *        endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterEndpointResourceIdentifier(String dbClusterEndpointResourceIdentifier);

        /**
         * <p>
         * The DNS address of the endpoint.
         * </p>
         * 
         * @param endpoint
         *        The DNS address of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The current status of the endpoint. One of: <code>creating</code>, <code>available</code>,
         * <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies
         * to an endpoint that cannot be used for a certain kind of cluster, such as a <code>writer</code> endpoint for
         * a read-only secondary cluster in a global database.
         * </p>
         * 
         * @param status
         *        The current status of the endpoint. One of: <code>creating</code>, <code>available</code>,
         *        <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state
         *        applies to an endpoint that cannot be used for a certain kind of cluster, such as a
         *        <code>writer</code> endpoint for a read-only secondary cluster in a global database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.
         * </p>
         * 
         * @param endpointType
         *        The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointType(String endpointType);

        /**
         * <p>
         * The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>,
         * <code>ANY</code>.
         * </p>
         * 
         * @param customEndpointType
         *        The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>,
         *        <code>ANY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customEndpointType(String customEndpointType);

        /**
         * <p>
         * List of DB instance identifiers that are part of the custom endpoint group.
         * </p>
         * 
         * @param staticMembers
         *        List of DB instance identifiers that are part of the custom endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticMembers(Collection<String> staticMembers);

        /**
         * <p>
         * List of DB instance identifiers that are part of the custom endpoint group.
         * </p>
         * 
         * @param staticMembers
         *        List of DB instance identifiers that are part of the custom endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticMembers(String... staticMembers);

        /**
         * <p>
         * List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances
         * are reachable through the custom endpoint. Only relevant if the list of static members is empty.
         * </p>
         * 
         * @param excludedMembers
         *        List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible
         *        instances are reachable through the custom endpoint. Only relevant if the list of static members is
         *        empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedMembers(Collection<String> excludedMembers);

        /**
         * <p>
         * List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances
         * are reachable through the custom endpoint. Only relevant if the list of static members is empty.
         * </p>
         * 
         * @param excludedMembers
         *        List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible
         *        instances are reachable through the custom endpoint. Only relevant if the list of static members is
         *        empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedMembers(String... excludedMembers);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the endpoint.
         * </p>
         * 
         * @param dbClusterEndpointArn
         *        The Amazon Resource Name (ARN) for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterEndpointArn(String dbClusterEndpointArn);
    }

    static final class BuilderImpl extends NeptuneResponse.BuilderImpl implements Builder {
        private String dbClusterEndpointIdentifier;

        private String dbClusterIdentifier;

        private String dbClusterEndpointResourceIdentifier;

        private String endpoint;

        private String status;

        private String endpointType;

        private String customEndpointType;

        private List<String> staticMembers = DefaultSdkAutoConstructList.getInstance();

        private List<String> excludedMembers = DefaultSdkAutoConstructList.getInstance();

        private String dbClusterEndpointArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDbClusterEndpointResponse model) {
            super(model);
            dbClusterEndpointIdentifier(model.dbClusterEndpointIdentifier);
            dbClusterIdentifier(model.dbClusterIdentifier);
            dbClusterEndpointResourceIdentifier(model.dbClusterEndpointResourceIdentifier);
            endpoint(model.endpoint);
            status(model.status);
            endpointType(model.endpointType);
            customEndpointType(model.customEndpointType);
            staticMembers(model.staticMembers);
            excludedMembers(model.excludedMembers);
            dbClusterEndpointArn(model.dbClusterEndpointArn);
        }

        public final String getDbClusterEndpointIdentifier() {
            return dbClusterEndpointIdentifier;
        }

        public final void setDbClusterEndpointIdentifier(String dbClusterEndpointIdentifier) {
            this.dbClusterEndpointIdentifier = dbClusterEndpointIdentifier;
        }

        @Override
        public final Builder dbClusterEndpointIdentifier(String dbClusterEndpointIdentifier) {
            this.dbClusterEndpointIdentifier = dbClusterEndpointIdentifier;
            return this;
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final String getDbClusterEndpointResourceIdentifier() {
            return dbClusterEndpointResourceIdentifier;
        }

        public final void setDbClusterEndpointResourceIdentifier(String dbClusterEndpointResourceIdentifier) {
            this.dbClusterEndpointResourceIdentifier = dbClusterEndpointResourceIdentifier;
        }

        @Override
        public final Builder dbClusterEndpointResourceIdentifier(String dbClusterEndpointResourceIdentifier) {
            this.dbClusterEndpointResourceIdentifier = dbClusterEndpointResourceIdentifier;
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getEndpointType() {
            return endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        public final String getCustomEndpointType() {
            return customEndpointType;
        }

        public final void setCustomEndpointType(String customEndpointType) {
            this.customEndpointType = customEndpointType;
        }

        @Override
        public final Builder customEndpointType(String customEndpointType) {
            this.customEndpointType = customEndpointType;
            return this;
        }

        public final Collection<String> getStaticMembers() {
            if (staticMembers instanceof SdkAutoConstructList) {
                return null;
            }
            return staticMembers;
        }

        public final void setStaticMembers(Collection<String> staticMembers) {
            this.staticMembers = StringListCopier.copy(staticMembers);
        }

        @Override
        public final Builder staticMembers(Collection<String> staticMembers) {
            this.staticMembers = StringListCopier.copy(staticMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staticMembers(String... staticMembers) {
            staticMembers(Arrays.asList(staticMembers));
            return this;
        }

        public final Collection<String> getExcludedMembers() {
            if (excludedMembers instanceof SdkAutoConstructList) {
                return null;
            }
            return excludedMembers;
        }

        public final void setExcludedMembers(Collection<String> excludedMembers) {
            this.excludedMembers = StringListCopier.copy(excludedMembers);
        }

        @Override
        public final Builder excludedMembers(Collection<String> excludedMembers) {
            this.excludedMembers = StringListCopier.copy(excludedMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedMembers(String... excludedMembers) {
            excludedMembers(Arrays.asList(excludedMembers));
            return this;
        }

        public final String getDbClusterEndpointArn() {
            return dbClusterEndpointArn;
        }

        public final void setDbClusterEndpointArn(String dbClusterEndpointArn) {
            this.dbClusterEndpointArn = dbClusterEndpointArn;
        }

        @Override
        public final Builder dbClusterEndpointArn(String dbClusterEndpointArn) {
            this.dbClusterEndpointArn = dbClusterEndpointArn;
            return this;
        }

        @Override
        public DeleteDbClusterEndpointResponse build() {
            return new DeleteDbClusterEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
