/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mobile.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mobile.model.MobileRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProjectRequest
extends MobileRequest
implements ToCopyableBuilder<Builder, DescribeProjectRequest> {
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectId").getter(DescribeProjectRequest.getter(DescribeProjectRequest::projectId)).setter(DescribeProjectRequest.setter(Builder::projectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("projectId").build()}).build();
    private static final SdkField<Boolean> SYNC_FROM_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("syncFromResources").getter(DescribeProjectRequest.getter(DescribeProjectRequest::syncFromResources)).setter(DescribeProjectRequest.setter(Builder::syncFromResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("syncFromResources").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ID_FIELD, SYNC_FROM_RESOURCES_FIELD));
    private final String projectId;
    private final Boolean syncFromResources;

    private DescribeProjectRequest(BuilderImpl builder) {
        super(builder);
        this.projectId = builder.projectId;
        this.syncFromResources = builder.syncFromResources;
    }

    public final String projectId() {
        return this.projectId;
    }

    public final Boolean syncFromResources() {
        return this.syncFromResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncFromResources());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProjectRequest)) {
            return false;
        }
        DescribeProjectRequest other = (DescribeProjectRequest)((Object)obj);
        return Objects.equals(this.projectId(), other.projectId()) && Objects.equals(this.syncFromResources(), other.syncFromResources());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeProjectRequest").add("ProjectId", (Object)this.projectId()).add("SyncFromResources", (Object)this.syncFromResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectId": {
                return Optional.ofNullable(clazz.cast(this.projectId()));
            }
            case "syncFromResources": {
                return Optional.ofNullable(clazz.cast(this.syncFromResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProjectRequest, T> g) {
        return obj -> g.apply((DescribeProjectRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MobileRequest.BuilderImpl
    implements Builder {
        private String projectId;
        private Boolean syncFromResources;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProjectRequest model) {
            super(model);
            this.projectId(model.projectId);
            this.syncFromResources(model.syncFromResources);
        }

        public final String getProjectId() {
            return this.projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final Boolean getSyncFromResources() {
            return this.syncFromResources;
        }

        public final void setSyncFromResources(Boolean syncFromResources) {
            this.syncFromResources = syncFromResources;
        }

        @Override
        public final Builder syncFromResources(Boolean syncFromResources) {
            this.syncFromResources = syncFromResources;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeProjectRequest build() {
            return new DescribeProjectRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MobileRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeProjectRequest> {
        public Builder projectId(String var1);

        public Builder syncFromResources(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

