/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A wrapper object holding the Amazon API Gateway proxy summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApiGatewayProxySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ApiGatewayProxySummary.Builder, ApiGatewayProxySummary> {
    private static final SdkField<String> API_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApiGatewayId").getter(getter(ApiGatewayProxySummary::apiGatewayId))
            .setter(setter(Builder::apiGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiGatewayId").build()).build();

    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointType").getter(getter(ApiGatewayProxySummary::endpointTypeAsString))
            .setter(setter(Builder::endpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()).build();

    private static final SdkField<String> NLB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("NlbArn")
            .getter(getter(ApiGatewayProxySummary::nlbArn)).setter(setter(Builder::nlbArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NlbArn").build()).build();

    private static final SdkField<String> NLB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NlbName").getter(getter(ApiGatewayProxySummary::nlbName)).setter(setter(Builder::nlbName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NlbName").build()).build();

    private static final SdkField<String> PROXY_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyUrl").getter(getter(ApiGatewayProxySummary::proxyUrl)).setter(setter(Builder::proxyUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyUrl").build()).build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StageName").getter(getter(ApiGatewayProxySummary::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageName").build()).build();

    private static final SdkField<String> VPC_LINK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcLinkId").getter(getter(ApiGatewayProxySummary::vpcLinkId)).setter(setter(Builder::vpcLinkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcLinkId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_GATEWAY_ID_FIELD,
            ENDPOINT_TYPE_FIELD, NLB_ARN_FIELD, NLB_NAME_FIELD, PROXY_URL_FIELD, STAGE_NAME_FIELD, VPC_LINK_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String apiGatewayId;

    private final String endpointType;

    private final String nlbArn;

    private final String nlbName;

    private final String proxyUrl;

    private final String stageName;

    private final String vpcLinkId;

    private ApiGatewayProxySummary(BuilderImpl builder) {
        this.apiGatewayId = builder.apiGatewayId;
        this.endpointType = builder.endpointType;
        this.nlbArn = builder.nlbArn;
        this.nlbName = builder.nlbName;
        this.proxyUrl = builder.proxyUrl;
        this.stageName = builder.stageName;
        this.vpcLinkId = builder.vpcLinkId;
    }

    /**
     * <p>
     * The resource ID of the API Gateway for the proxy.
     * </p>
     * 
     * @return The resource ID of the API Gateway for the proxy.
     */
    public final String apiGatewayId() {
        return apiGatewayId;
    }

    /**
     * <p>
     * The type of API Gateway endpoint created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link ApiGatewayEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The type of API Gateway endpoint created.
     * @see ApiGatewayEndpointType
     */
    public final ApiGatewayEndpointType endpointType() {
        return ApiGatewayEndpointType.fromValue(endpointType);
    }

    /**
     * <p>
     * The type of API Gateway endpoint created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link ApiGatewayEndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The type of API Gateway endpoint created.
     * @see ApiGatewayEndpointType
     */
    public final String endpointTypeAsString() {
        return endpointType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Network Load Balancer configured by the API Gateway proxy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Network Load Balancer configured by the API Gateway proxy.
     */
    public final String nlbArn() {
        return nlbArn;
    }

    /**
     * <p>
     * The name of the Network Load Balancer that is configured by the API Gateway proxy.
     * </p>
     * 
     * @return The name of the Network Load Balancer that is configured by the API Gateway proxy.
     */
    public final String nlbName() {
        return nlbName;
    }

    /**
     * <p>
     * The endpoint URL of the API Gateway proxy.
     * </p>
     * 
     * @return The endpoint URL of the API Gateway proxy.
     */
    public final String proxyUrl() {
        return proxyUrl;
    }

    /**
     * <p>
     * The name of the API Gateway stage. The name defaults to <code>prod</code>.
     * </p>
     * 
     * @return The name of the API Gateway stage. The name defaults to <code>prod</code>.
     */
    public final String stageName() {
        return stageName;
    }

    /**
     * <p>
     * The <code>VpcLink</code> ID of the API Gateway proxy.
     * </p>
     * 
     * @return The <code>VpcLink</code> ID of the API Gateway proxy.
     */
    public final String vpcLinkId() {
        return vpcLinkId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nlbArn());
        hashCode = 31 * hashCode + Objects.hashCode(nlbName());
        hashCode = 31 * hashCode + Objects.hashCode(proxyUrl());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(vpcLinkId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiGatewayProxySummary)) {
            return false;
        }
        ApiGatewayProxySummary other = (ApiGatewayProxySummary) obj;
        return Objects.equals(apiGatewayId(), other.apiGatewayId())
                && Objects.equals(endpointTypeAsString(), other.endpointTypeAsString())
                && Objects.equals(nlbArn(), other.nlbArn()) && Objects.equals(nlbName(), other.nlbName())
                && Objects.equals(proxyUrl(), other.proxyUrl()) && Objects.equals(stageName(), other.stageName())
                && Objects.equals(vpcLinkId(), other.vpcLinkId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApiGatewayProxySummary").add("ApiGatewayId", apiGatewayId())
                .add("EndpointType", endpointTypeAsString()).add("NlbArn", nlbArn()).add("NlbName", nlbName())
                .add("ProxyUrl", proxyUrl()).add("StageName", stageName()).add("VpcLinkId", vpcLinkId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiGatewayId":
            return Optional.ofNullable(clazz.cast(apiGatewayId()));
        case "EndpointType":
            return Optional.ofNullable(clazz.cast(endpointTypeAsString()));
        case "NlbArn":
            return Optional.ofNullable(clazz.cast(nlbArn()));
        case "NlbName":
            return Optional.ofNullable(clazz.cast(nlbName()));
        case "ProxyUrl":
            return Optional.ofNullable(clazz.cast(proxyUrl()));
        case "StageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "VpcLinkId":
            return Optional.ofNullable(clazz.cast(vpcLinkId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApiGatewayProxySummary, T> g) {
        return obj -> g.apply((ApiGatewayProxySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApiGatewayProxySummary> {
        /**
         * <p>
         * The resource ID of the API Gateway for the proxy.
         * </p>
         * 
         * @param apiGatewayId
         *        The resource ID of the API Gateway for the proxy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiGatewayId(String apiGatewayId);

        /**
         * <p>
         * The type of API Gateway endpoint created.
         * </p>
         * 
         * @param endpointType
         *        The type of API Gateway endpoint created.
         * @see ApiGatewayEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiGatewayEndpointType
         */
        Builder endpointType(String endpointType);

        /**
         * <p>
         * The type of API Gateway endpoint created.
         * </p>
         * 
         * @param endpointType
         *        The type of API Gateway endpoint created.
         * @see ApiGatewayEndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApiGatewayEndpointType
         */
        Builder endpointType(ApiGatewayEndpointType endpointType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Network Load Balancer configured by the API Gateway proxy.
         * </p>
         * 
         * @param nlbArn
         *        The Amazon Resource Name (ARN) of the Network Load Balancer configured by the API Gateway proxy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nlbArn(String nlbArn);

        /**
         * <p>
         * The name of the Network Load Balancer that is configured by the API Gateway proxy.
         * </p>
         * 
         * @param nlbName
         *        The name of the Network Load Balancer that is configured by the API Gateway proxy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nlbName(String nlbName);

        /**
         * <p>
         * The endpoint URL of the API Gateway proxy.
         * </p>
         * 
         * @param proxyUrl
         *        The endpoint URL of the API Gateway proxy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proxyUrl(String proxyUrl);

        /**
         * <p>
         * The name of the API Gateway stage. The name defaults to <code>prod</code>.
         * </p>
         * 
         * @param stageName
         *        The name of the API Gateway stage. The name defaults to <code>prod</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * <p>
         * The <code>VpcLink</code> ID of the API Gateway proxy.
         * </p>
         * 
         * @param vpcLinkId
         *        The <code>VpcLink</code> ID of the API Gateway proxy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcLinkId(String vpcLinkId);
    }

    static final class BuilderImpl implements Builder {
        private String apiGatewayId;

        private String endpointType;

        private String nlbArn;

        private String nlbName;

        private String proxyUrl;

        private String stageName;

        private String vpcLinkId;

        private BuilderImpl() {
        }

        private BuilderImpl(ApiGatewayProxySummary model) {
            apiGatewayId(model.apiGatewayId);
            endpointType(model.endpointType);
            nlbArn(model.nlbArn);
            nlbName(model.nlbName);
            proxyUrl(model.proxyUrl);
            stageName(model.stageName);
            vpcLinkId(model.vpcLinkId);
        }

        public final String getApiGatewayId() {
            return apiGatewayId;
        }

        public final void setApiGatewayId(String apiGatewayId) {
            this.apiGatewayId = apiGatewayId;
        }

        @Override
        public final Builder apiGatewayId(String apiGatewayId) {
            this.apiGatewayId = apiGatewayId;
            return this;
        }

        public final String getEndpointType() {
            return endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(ApiGatewayEndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final String getNlbArn() {
            return nlbArn;
        }

        public final void setNlbArn(String nlbArn) {
            this.nlbArn = nlbArn;
        }

        @Override
        public final Builder nlbArn(String nlbArn) {
            this.nlbArn = nlbArn;
            return this;
        }

        public final String getNlbName() {
            return nlbName;
        }

        public final void setNlbName(String nlbName) {
            this.nlbName = nlbName;
        }

        @Override
        public final Builder nlbName(String nlbName) {
            this.nlbName = nlbName;
            return this;
        }

        public final String getProxyUrl() {
            return proxyUrl;
        }

        public final void setProxyUrl(String proxyUrl) {
            this.proxyUrl = proxyUrl;
        }

        @Override
        public final Builder proxyUrl(String proxyUrl) {
            this.proxyUrl = proxyUrl;
            return this;
        }

        public final String getStageName() {
            return stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final String getVpcLinkId() {
            return vpcLinkId;
        }

        public final void setVpcLinkId(String vpcLinkId) {
            this.vpcLinkId = vpcLinkId;
        }

        @Override
        public final Builder vpcLinkId(String vpcLinkId) {
            this.vpcLinkId = vpcLinkId;
            return this;
        }

        @Override
        public ApiGatewayProxySummary build() {
            return new ApiGatewayProxySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
