/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ErrorResourceType {
    ENVIRONMENT("ENVIRONMENT"),
    APPLICATION("APPLICATION"),
    ROUTE("ROUTE"),
    SERVICE("SERVICE"),
    TRANSIT_GATEWAY("TRANSIT_GATEWAY"),
    TRANSIT_GATEWAY_ATTACHMENT("TRANSIT_GATEWAY_ATTACHMENT"),
    API_GATEWAY("API_GATEWAY"),
    NLB("NLB"),
    TARGET_GROUP("TARGET_GROUP"),
    LOAD_BALANCER_LISTENER("LOAD_BALANCER_LISTENER"),
    VPC_LINK("VPC_LINK"),
    LAMBDA("LAMBDA"),
    VPC("VPC"),
    SUBNET("SUBNET"),
    ROUTE_TABLE("ROUTE_TABLE"),
    SECURITY_GROUP("SECURITY_GROUP"),
    VPC_ENDPOINT_SERVICE_CONFIGURATION("VPC_ENDPOINT_SERVICE_CONFIGURATION"),
    RESOURCE_SHARE("RESOURCE_SHARE"),
    IAM_ROLE("IAM_ROLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ErrorResourceType> VALUE_MAP;
    private final String value;

    private ErrorResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ErrorResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ErrorResourceType> knownValues() {
        EnumSet<ErrorResourceType> knownValues = EnumSet.allOf(ErrorResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ErrorResourceType.class, ErrorResourceType::toString);
    }
}

