/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhub.MigrationHubAsyncClient;
import software.amazon.awssdk.services.migrationhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsRequest;
import software.amazon.awssdk.services.migrationhub.model.ListProgressUpdateStreamsResponse;
import software.amazon.awssdk.services.migrationhub.model.ProgressUpdateStreamSummary;

public class ListProgressUpdateStreamsPublisher
implements SdkPublisher<ListProgressUpdateStreamsResponse> {
    private final MigrationHubAsyncClient client;
    private final ListProgressUpdateStreamsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProgressUpdateStreamsPublisher(MigrationHubAsyncClient client, ListProgressUpdateStreamsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProgressUpdateStreamsPublisher(MigrationHubAsyncClient client, ListProgressUpdateStreamsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProgressUpdateStreamsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProgressUpdateStreamsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProgressUpdateStreamSummary> progressUpdateStreamSummaryList() {
        Function<ListProgressUpdateStreamsResponse, Iterator> getIterator = response -> {
            if (response != null && response.progressUpdateStreamSummaryList() != null) {
                return response.progressUpdateStreamSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProgressUpdateStreamsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProgressUpdateStreamsResponseFetcher
    implements AsyncPageFetcher<ListProgressUpdateStreamsResponse> {
        private ListProgressUpdateStreamsResponseFetcher() {
        }

        public boolean hasNextPage(ListProgressUpdateStreamsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProgressUpdateStreamsResponse> nextPage(ListProgressUpdateStreamsResponse previousPage) {
            if (previousPage == null) {
                return ListProgressUpdateStreamsPublisher.this.client.listProgressUpdateStreams(ListProgressUpdateStreamsPublisher.this.firstRequest);
            }
            return ListProgressUpdateStreamsPublisher.this.client.listProgressUpdateStreams((ListProgressUpdateStreamsRequest)((Object)ListProgressUpdateStreamsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

