/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediatailor.MediaTailorClient;
import software.amazon.awssdk.services.mediatailor.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesRequest;
import software.amazon.awssdk.services.mediatailor.model.ListPrefetchSchedulesResponse;
import software.amazon.awssdk.services.mediatailor.model.PrefetchSchedule;

public class ListPrefetchSchedulesIterable
implements SdkIterable<ListPrefetchSchedulesResponse> {
    private final MediaTailorClient client;
    private final ListPrefetchSchedulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPrefetchSchedulesIterable(MediaTailorClient client, ListPrefetchSchedulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPrefetchSchedulesResponseFetcher();
    }

    public Iterator<ListPrefetchSchedulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PrefetchSchedule> items() {
        Function<ListPrefetchSchedulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPrefetchSchedulesResponseFetcher
    implements SyncPageFetcher<ListPrefetchSchedulesResponse> {
        private ListPrefetchSchedulesResponseFetcher() {
        }

        public boolean hasNextPage(ListPrefetchSchedulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPrefetchSchedulesResponse nextPage(ListPrefetchSchedulesResponse previousPage) {
            if (previousPage == null) {
                return ListPrefetchSchedulesIterable.this.client.listPrefetchSchedules(ListPrefetchSchedulesIterable.this.firstRequest);
            }
            return ListPrefetchSchedulesIterable.this.client.listPrefetchSchedules((ListPrefetchSchedulesRequest)((Object)ListPrefetchSchedulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

