/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediatailor.MediaTailorAsyncClient;
import software.amazon.awssdk.services.mediatailor.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest;
import software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleResponse;
import software.amazon.awssdk.services.mediatailor.model.ScheduleEntry;

public class GetChannelSchedulePublisher
implements SdkPublisher<GetChannelScheduleResponse> {
    private final MediaTailorAsyncClient client;
    private final GetChannelScheduleRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetChannelSchedulePublisher(MediaTailorAsyncClient client, GetChannelScheduleRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetChannelSchedulePublisher(MediaTailorAsyncClient client, GetChannelScheduleRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetChannelScheduleResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetChannelScheduleResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ScheduleEntry> items() {
        Function<GetChannelScheduleResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetChannelScheduleResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetChannelScheduleResponseFetcher
    implements AsyncPageFetcher<GetChannelScheduleResponse> {
        private GetChannelScheduleResponseFetcher() {
        }

        public boolean hasNextPage(GetChannelScheduleResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetChannelScheduleResponse> nextPage(GetChannelScheduleResponse previousPage) {
            if (previousPage == null) {
                return GetChannelSchedulePublisher.this.client.getChannelSchedule(GetChannelSchedulePublisher.this.firstRequest);
            }
            return GetChannelSchedulePublisher.this.client.getChannelSchedule((GetChannelScheduleRequest)((Object)GetChannelSchedulePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

