/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Splice insert message configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpliceInsertMessage implements SdkPojo, Serializable,
        ToCopyableBuilder<SpliceInsertMessage.Builder, SpliceInsertMessage> {
    private static final SdkField<Integer> AVAIL_NUM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AvailNum").getter(getter(SpliceInsertMessage::availNum)).setter(setter(Builder::availNum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailNum").build()).build();

    private static final SdkField<Integer> AVAILS_EXPECTED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AvailsExpected").getter(getter(SpliceInsertMessage::availsExpected))
            .setter(setter(Builder::availsExpected))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailsExpected").build()).build();

    private static final SdkField<Integer> SPLICE_EVENT_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SpliceEventId").getter(getter(SpliceInsertMessage::spliceEventId))
            .setter(setter(Builder::spliceEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpliceEventId").build()).build();

    private static final SdkField<Integer> UNIQUE_PROGRAM_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UniqueProgramId").getter(getter(SpliceInsertMessage::uniqueProgramId))
            .setter(setter(Builder::uniqueProgramId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniqueProgramId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAIL_NUM_FIELD,
            AVAILS_EXPECTED_FIELD, SPLICE_EVENT_ID_FIELD, UNIQUE_PROGRAM_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer availNum;

    private final Integer availsExpected;

    private final Integer spliceEventId;

    private final Integer uniqueProgramId;

    private SpliceInsertMessage(BuilderImpl builder) {
        this.availNum = builder.availNum;
        this.availsExpected = builder.availsExpected;
        this.spliceEventId = builder.spliceEventId;
        this.uniqueProgramId = builder.uniqueProgramId;
    }

    /**
     * <p>
     * This is written to <code>splice_insert.avail_num</code>, as defined in section 9.7.3.1 of the SCTE-35
     * specification. The default value is <code>0</code>. Values must be between <code>0</code> and <code>256</code>,
     * inclusive.
     * </p>
     * 
     * @return This is written to <code>splice_insert.avail_num</code>, as defined in section 9.7.3.1 of the SCTE-35
     *         specification. The default value is <code>0</code>. Values must be between <code>0</code> and
     *         <code>256</code>, inclusive.
     */
    public final Integer availNum() {
        return availNum;
    }

    /**
     * <p>
     * This is written to <code>splice_insert.avails_expected</code>, as defined in section 9.7.3.1 of the SCTE-35
     * specification. The default value is <code>0</code>. Values must be between <code>0</code> and <code>256</code>,
     * inclusive.
     * </p>
     * 
     * @return This is written to <code>splice_insert.avails_expected</code>, as defined in section 9.7.3.1 of the
     *         SCTE-35 specification. The default value is <code>0</code>. Values must be between <code>0</code> and
     *         <code>256</code>, inclusive.
     */
    public final Integer availsExpected() {
        return availsExpected;
    }

    /**
     * <p>
     * This is written to <code>splice_insert.splice_event_id</code>, as defined in section 9.7.3.1 of the SCTE-35
     * specification. The default value is <code>1</code>.
     * </p>
     * 
     * @return This is written to <code>splice_insert.splice_event_id</code>, as defined in section 9.7.3.1 of the
     *         SCTE-35 specification. The default value is <code>1</code>.
     */
    public final Integer spliceEventId() {
        return spliceEventId;
    }

    /**
     * <p>
     * This is written to <code>splice_insert.unique_program_id</code>, as defined in section 9.7.3.1 of the SCTE-35
     * specification. The default value is <code>0</code>. Values must be between <code>0</code> and <code>256</code>,
     * inclusive.
     * </p>
     * 
     * @return This is written to <code>splice_insert.unique_program_id</code>, as defined in section 9.7.3.1 of the
     *         SCTE-35 specification. The default value is <code>0</code>. Values must be between <code>0</code> and
     *         <code>256</code>, inclusive.
     */
    public final Integer uniqueProgramId() {
        return uniqueProgramId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availNum());
        hashCode = 31 * hashCode + Objects.hashCode(availsExpected());
        hashCode = 31 * hashCode + Objects.hashCode(spliceEventId());
        hashCode = 31 * hashCode + Objects.hashCode(uniqueProgramId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpliceInsertMessage)) {
            return false;
        }
        SpliceInsertMessage other = (SpliceInsertMessage) obj;
        return Objects.equals(availNum(), other.availNum()) && Objects.equals(availsExpected(), other.availsExpected())
                && Objects.equals(spliceEventId(), other.spliceEventId())
                && Objects.equals(uniqueProgramId(), other.uniqueProgramId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpliceInsertMessage").add("AvailNum", availNum()).add("AvailsExpected", availsExpected())
                .add("SpliceEventId", spliceEventId()).add("UniqueProgramId", uniqueProgramId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailNum":
            return Optional.ofNullable(clazz.cast(availNum()));
        case "AvailsExpected":
            return Optional.ofNullable(clazz.cast(availsExpected()));
        case "SpliceEventId":
            return Optional.ofNullable(clazz.cast(spliceEventId()));
        case "UniqueProgramId":
            return Optional.ofNullable(clazz.cast(uniqueProgramId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpliceInsertMessage, T> g) {
        return obj -> g.apply((SpliceInsertMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpliceInsertMessage> {
        /**
         * <p>
         * This is written to <code>splice_insert.avail_num</code>, as defined in section 9.7.3.1 of the SCTE-35
         * specification. The default value is <code>0</code>. Values must be between <code>0</code> and
         * <code>256</code>, inclusive.
         * </p>
         * 
         * @param availNum
         *        This is written to <code>splice_insert.avail_num</code>, as defined in section 9.7.3.1 of the SCTE-35
         *        specification. The default value is <code>0</code>. Values must be between <code>0</code> and
         *        <code>256</code>, inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availNum(Integer availNum);

        /**
         * <p>
         * This is written to <code>splice_insert.avails_expected</code>, as defined in section 9.7.3.1 of the SCTE-35
         * specification. The default value is <code>0</code>. Values must be between <code>0</code> and
         * <code>256</code>, inclusive.
         * </p>
         * 
         * @param availsExpected
         *        This is written to <code>splice_insert.avails_expected</code>, as defined in section 9.7.3.1 of the
         *        SCTE-35 specification. The default value is <code>0</code>. Values must be between <code>0</code> and
         *        <code>256</code>, inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availsExpected(Integer availsExpected);

        /**
         * <p>
         * This is written to <code>splice_insert.splice_event_id</code>, as defined in section 9.7.3.1 of the SCTE-35
         * specification. The default value is <code>1</code>.
         * </p>
         * 
         * @param spliceEventId
         *        This is written to <code>splice_insert.splice_event_id</code>, as defined in section 9.7.3.1 of the
         *        SCTE-35 specification. The default value is <code>1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spliceEventId(Integer spliceEventId);

        /**
         * <p>
         * This is written to <code>splice_insert.unique_program_id</code>, as defined in section 9.7.3.1 of the SCTE-35
         * specification. The default value is <code>0</code>. Values must be between <code>0</code> and
         * <code>256</code>, inclusive.
         * </p>
         * 
         * @param uniqueProgramId
         *        This is written to <code>splice_insert.unique_program_id</code>, as defined in section 9.7.3.1 of the
         *        SCTE-35 specification. The default value is <code>0</code>. Values must be between <code>0</code> and
         *        <code>256</code>, inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueProgramId(Integer uniqueProgramId);
    }

    static final class BuilderImpl implements Builder {
        private Integer availNum;

        private Integer availsExpected;

        private Integer spliceEventId;

        private Integer uniqueProgramId;

        private BuilderImpl() {
        }

        private BuilderImpl(SpliceInsertMessage model) {
            availNum(model.availNum);
            availsExpected(model.availsExpected);
            spliceEventId(model.spliceEventId);
            uniqueProgramId(model.uniqueProgramId);
        }

        public final Integer getAvailNum() {
            return availNum;
        }

        public final void setAvailNum(Integer availNum) {
            this.availNum = availNum;
        }

        @Override
        public final Builder availNum(Integer availNum) {
            this.availNum = availNum;
            return this;
        }

        public final Integer getAvailsExpected() {
            return availsExpected;
        }

        public final void setAvailsExpected(Integer availsExpected) {
            this.availsExpected = availsExpected;
        }

        @Override
        public final Builder availsExpected(Integer availsExpected) {
            this.availsExpected = availsExpected;
            return this;
        }

        public final Integer getSpliceEventId() {
            return spliceEventId;
        }

        public final void setSpliceEventId(Integer spliceEventId) {
            this.spliceEventId = spliceEventId;
        }

        @Override
        public final Builder spliceEventId(Integer spliceEventId) {
            this.spliceEventId = spliceEventId;
            return this;
        }

        public final Integer getUniqueProgramId() {
            return uniqueProgramId;
        }

        public final void setUniqueProgramId(Integer uniqueProgramId) {
            this.uniqueProgramId = uniqueProgramId;
        }

        @Override
        public final Builder uniqueProgramId(Integer uniqueProgramId) {
            this.uniqueProgramId = uniqueProgramId;
            return this;
        }

        @Override
        public SpliceInsertMessage build() {
            return new SpliceInsertMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
