/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSourceLocationRequest extends MediaTailorRequest implements
        ToCopyableBuilder<CreateSourceLocationRequest.Builder, CreateSourceLocationRequest> {
    private static final SdkField<AccessConfiguration> ACCESS_CONFIGURATION_FIELD = SdkField
            .<AccessConfiguration> builder(MarshallingType.SDK_POJO).memberName("AccessConfiguration")
            .getter(getter(CreateSourceLocationRequest::accessConfiguration)).setter(setter(Builder::accessConfiguration))
            .constructor(AccessConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessConfiguration").build())
            .build();

    private static final SdkField<DefaultSegmentDeliveryConfiguration> DEFAULT_SEGMENT_DELIVERY_CONFIGURATION_FIELD = SdkField
            .<DefaultSegmentDeliveryConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("DefaultSegmentDeliveryConfiguration")
            .getter(getter(CreateSourceLocationRequest::defaultSegmentDeliveryConfiguration))
            .setter(setter(Builder::defaultSegmentDeliveryConfiguration))
            .constructor(DefaultSegmentDeliveryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DefaultSegmentDeliveryConfiguration").build()).build();

    private static final SdkField<HttpConfiguration> HTTP_CONFIGURATION_FIELD = SdkField
            .<HttpConfiguration> builder(MarshallingType.SDK_POJO).memberName("HttpConfiguration")
            .getter(getter(CreateSourceLocationRequest::httpConfiguration)).setter(setter(Builder::httpConfiguration))
            .constructor(HttpConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpConfiguration").build()).build();

    private static final SdkField<List<SegmentDeliveryConfiguration>> SEGMENT_DELIVERY_CONFIGURATIONS_FIELD = SdkField
            .<List<SegmentDeliveryConfiguration>> builder(MarshallingType.LIST)
            .memberName("SegmentDeliveryConfigurations")
            .getter(getter(CreateSourceLocationRequest::segmentDeliveryConfigurations))
            .setter(setter(Builder::segmentDeliveryConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentDeliveryConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SegmentDeliveryConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(SegmentDeliveryConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_LOCATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceLocationName").getter(getter(CreateSourceLocationRequest::sourceLocationName))
            .setter(setter(Builder::sourceLocationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("SourceLocationName").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateSourceLocationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_CONFIGURATION_FIELD,
            DEFAULT_SEGMENT_DELIVERY_CONFIGURATION_FIELD, HTTP_CONFIGURATION_FIELD, SEGMENT_DELIVERY_CONFIGURATIONS_FIELD,
            SOURCE_LOCATION_NAME_FIELD, TAGS_FIELD));

    private final AccessConfiguration accessConfiguration;

    private final DefaultSegmentDeliveryConfiguration defaultSegmentDeliveryConfiguration;

    private final HttpConfiguration httpConfiguration;

    private final List<SegmentDeliveryConfiguration> segmentDeliveryConfigurations;

    private final String sourceLocationName;

    private final Map<String, String> tags;

    private CreateSourceLocationRequest(BuilderImpl builder) {
        super(builder);
        this.accessConfiguration = builder.accessConfiguration;
        this.defaultSegmentDeliveryConfiguration = builder.defaultSegmentDeliveryConfiguration;
        this.httpConfiguration = builder.httpConfiguration;
        this.segmentDeliveryConfigurations = builder.segmentDeliveryConfigurations;
        this.sourceLocationName = builder.sourceLocationName;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Access configuration parameters. Configures the type of authentication used to access content from your source
     * location.
     * </p>
     * 
     * @return Access configuration parameters. Configures the type of authentication used to access content from your
     *         source location.
     */
    public final AccessConfiguration accessConfiguration() {
        return accessConfiguration;
    }

    /**
     * <p>
     * The optional configuration for the server that serves segments.
     * </p>
     * 
     * @return The optional configuration for the server that serves segments.
     */
    public final DefaultSegmentDeliveryConfiguration defaultSegmentDeliveryConfiguration() {
        return defaultSegmentDeliveryConfiguration;
    }

    /**
     * <p>
     * The source's HTTP package configurations.
     * </p>
     * 
     * @return The source's HTTP package configurations.
     */
    public final HttpConfiguration httpConfiguration() {
        return httpConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the SegmentDeliveryConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSegmentDeliveryConfigurations() {
        return segmentDeliveryConfigurations != null && !(segmentDeliveryConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the segment delivery configurations associated with this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSegmentDeliveryConfigurations} method.
     * </p>
     * 
     * @return A list of the segment delivery configurations associated with this resource.
     */
    public final List<SegmentDeliveryConfiguration> segmentDeliveryConfigurations() {
        return segmentDeliveryConfigurations;
    }

    /**
     * <p>
     * The name associated with the source location.
     * </p>
     * 
     * @return The name associated with the source location.
     */
    public final String sourceLocationName() {
        return sourceLocationName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to assign to the source location. Tags are key-value pairs that you can associate with Amazon resources
     * to help with organization, access control, and cost tracking. For more information, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor
     * Resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to assign to the source location. Tags are key-value pairs that you can associate with Amazon
     *         resources to help with organization, access control, and cost tracking. For more information, see <a
     *         href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor
     *         Resources</a>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSegmentDeliveryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(httpConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasSegmentDeliveryConfigurations() ? segmentDeliveryConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceLocationName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSourceLocationRequest)) {
            return false;
        }
        CreateSourceLocationRequest other = (CreateSourceLocationRequest) obj;
        return Objects.equals(accessConfiguration(), other.accessConfiguration())
                && Objects.equals(defaultSegmentDeliveryConfiguration(), other.defaultSegmentDeliveryConfiguration())
                && Objects.equals(httpConfiguration(), other.httpConfiguration())
                && hasSegmentDeliveryConfigurations() == other.hasSegmentDeliveryConfigurations()
                && Objects.equals(segmentDeliveryConfigurations(), other.segmentDeliveryConfigurations())
                && Objects.equals(sourceLocationName(), other.sourceLocationName()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateSourceLocationRequest")
                .add("AccessConfiguration", accessConfiguration())
                .add("DefaultSegmentDeliveryConfiguration", defaultSegmentDeliveryConfiguration())
                .add("HttpConfiguration", httpConfiguration())
                .add("SegmentDeliveryConfigurations", hasSegmentDeliveryConfigurations() ? segmentDeliveryConfigurations() : null)
                .add("SourceLocationName", sourceLocationName()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessConfiguration":
            return Optional.ofNullable(clazz.cast(accessConfiguration()));
        case "DefaultSegmentDeliveryConfiguration":
            return Optional.ofNullable(clazz.cast(defaultSegmentDeliveryConfiguration()));
        case "HttpConfiguration":
            return Optional.ofNullable(clazz.cast(httpConfiguration()));
        case "SegmentDeliveryConfigurations":
            return Optional.ofNullable(clazz.cast(segmentDeliveryConfigurations()));
        case "SourceLocationName":
            return Optional.ofNullable(clazz.cast(sourceLocationName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSourceLocationRequest, T> g) {
        return obj -> g.apply((CreateSourceLocationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaTailorRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSourceLocationRequest> {
        /**
         * <p>
         * Access configuration parameters. Configures the type of authentication used to access content from your
         * source location.
         * </p>
         * 
         * @param accessConfiguration
         *        Access configuration parameters. Configures the type of authentication used to access content from
         *        your source location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessConfiguration(AccessConfiguration accessConfiguration);

        /**
         * <p>
         * Access configuration parameters. Configures the type of authentication used to access content from your
         * source location.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccessConfiguration.Builder} avoiding the
         * need to create one manually via {@link AccessConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccessConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #accessConfiguration(AccessConfiguration)}.
         * 
         * @param accessConfiguration
         *        a consumer that will call methods on {@link AccessConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessConfiguration(AccessConfiguration)
         */
        default Builder accessConfiguration(Consumer<AccessConfiguration.Builder> accessConfiguration) {
            return accessConfiguration(AccessConfiguration.builder().applyMutation(accessConfiguration).build());
        }

        /**
         * <p>
         * The optional configuration for the server that serves segments.
         * </p>
         * 
         * @param defaultSegmentDeliveryConfiguration
         *        The optional configuration for the server that serves segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSegmentDeliveryConfiguration(DefaultSegmentDeliveryConfiguration defaultSegmentDeliveryConfiguration);

        /**
         * <p>
         * The optional configuration for the server that serves segments.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DefaultSegmentDeliveryConfiguration.Builder} avoiding the need to create one manually via
         * {@link DefaultSegmentDeliveryConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultSegmentDeliveryConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #defaultSegmentDeliveryConfiguration(DefaultSegmentDeliveryConfiguration)}.
         * 
         * @param defaultSegmentDeliveryConfiguration
         *        a consumer that will call methods on {@link DefaultSegmentDeliveryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultSegmentDeliveryConfiguration(DefaultSegmentDeliveryConfiguration)
         */
        default Builder defaultSegmentDeliveryConfiguration(
                Consumer<DefaultSegmentDeliveryConfiguration.Builder> defaultSegmentDeliveryConfiguration) {
            return defaultSegmentDeliveryConfiguration(DefaultSegmentDeliveryConfiguration.builder()
                    .applyMutation(defaultSegmentDeliveryConfiguration).build());
        }

        /**
         * <p>
         * The source's HTTP package configurations.
         * </p>
         * 
         * @param httpConfiguration
         *        The source's HTTP package configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpConfiguration(HttpConfiguration httpConfiguration);

        /**
         * <p>
         * The source's HTTP package configurations.
         * </p>
         * This is a convenience method that creates an instance of the {@link HttpConfiguration.Builder} avoiding the
         * need to create one manually via {@link HttpConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HttpConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #httpConfiguration(HttpConfiguration)}.
         * 
         * @param httpConfiguration
         *        a consumer that will call methods on {@link HttpConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpConfiguration(HttpConfiguration)
         */
        default Builder httpConfiguration(Consumer<HttpConfiguration.Builder> httpConfiguration) {
            return httpConfiguration(HttpConfiguration.builder().applyMutation(httpConfiguration).build());
        }

        /**
         * <p>
         * A list of the segment delivery configurations associated with this resource.
         * </p>
         * 
         * @param segmentDeliveryConfigurations
         *        A list of the segment delivery configurations associated with this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentDeliveryConfigurations(Collection<SegmentDeliveryConfiguration> segmentDeliveryConfigurations);

        /**
         * <p>
         * A list of the segment delivery configurations associated with this resource.
         * </p>
         * 
         * @param segmentDeliveryConfigurations
         *        A list of the segment delivery configurations associated with this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentDeliveryConfigurations(SegmentDeliveryConfiguration... segmentDeliveryConfigurations);

        /**
         * <p>
         * A list of the segment delivery configurations associated with this resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediatailor.model.SegmentDeliveryConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.mediatailor.model.SegmentDeliveryConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediatailor.model.SegmentDeliveryConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #segmentDeliveryConfigurations(List<SegmentDeliveryConfiguration>)}.
         * 
         * @param segmentDeliveryConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediatailor.model.SegmentDeliveryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segmentDeliveryConfigurations(java.util.Collection<SegmentDeliveryConfiguration>)
         */
        Builder segmentDeliveryConfigurations(Consumer<SegmentDeliveryConfiguration.Builder>... segmentDeliveryConfigurations);

        /**
         * <p>
         * The name associated with the source location.
         * </p>
         * 
         * @param sourceLocationName
         *        The name associated with the source location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLocationName(String sourceLocationName);

        /**
         * <p>
         * The tags to assign to the source location. Tags are key-value pairs that you can associate with Amazon
         * resources to help with organization, access control, and cost tracking. For more information, see <a
         * href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor
         * Resources</a>.
         * </p>
         * 
         * @param tags
         *        The tags to assign to the source location. Tags are key-value pairs that you can associate with Amazon
         *        resources to help with organization, access control, and cost tracking. For more information, see <a
         *        href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental
         *        MediaTailor Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaTailorRequest.BuilderImpl implements Builder {
        private AccessConfiguration accessConfiguration;

        private DefaultSegmentDeliveryConfiguration defaultSegmentDeliveryConfiguration;

        private HttpConfiguration httpConfiguration;

        private List<SegmentDeliveryConfiguration> segmentDeliveryConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String sourceLocationName;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSourceLocationRequest model) {
            super(model);
            accessConfiguration(model.accessConfiguration);
            defaultSegmentDeliveryConfiguration(model.defaultSegmentDeliveryConfiguration);
            httpConfiguration(model.httpConfiguration);
            segmentDeliveryConfigurations(model.segmentDeliveryConfigurations);
            sourceLocationName(model.sourceLocationName);
            tags(model.tags);
        }

        public final AccessConfiguration.Builder getAccessConfiguration() {
            return accessConfiguration != null ? accessConfiguration.toBuilder() : null;
        }

        public final void setAccessConfiguration(AccessConfiguration.BuilderImpl accessConfiguration) {
            this.accessConfiguration = accessConfiguration != null ? accessConfiguration.build() : null;
        }

        @Override
        public final Builder accessConfiguration(AccessConfiguration accessConfiguration) {
            this.accessConfiguration = accessConfiguration;
            return this;
        }

        public final DefaultSegmentDeliveryConfiguration.Builder getDefaultSegmentDeliveryConfiguration() {
            return defaultSegmentDeliveryConfiguration != null ? defaultSegmentDeliveryConfiguration.toBuilder() : null;
        }

        public final void setDefaultSegmentDeliveryConfiguration(
                DefaultSegmentDeliveryConfiguration.BuilderImpl defaultSegmentDeliveryConfiguration) {
            this.defaultSegmentDeliveryConfiguration = defaultSegmentDeliveryConfiguration != null ? defaultSegmentDeliveryConfiguration
                    .build() : null;
        }

        @Override
        public final Builder defaultSegmentDeliveryConfiguration(
                DefaultSegmentDeliveryConfiguration defaultSegmentDeliveryConfiguration) {
            this.defaultSegmentDeliveryConfiguration = defaultSegmentDeliveryConfiguration;
            return this;
        }

        public final HttpConfiguration.Builder getHttpConfiguration() {
            return httpConfiguration != null ? httpConfiguration.toBuilder() : null;
        }

        public final void setHttpConfiguration(HttpConfiguration.BuilderImpl httpConfiguration) {
            this.httpConfiguration = httpConfiguration != null ? httpConfiguration.build() : null;
        }

        @Override
        public final Builder httpConfiguration(HttpConfiguration httpConfiguration) {
            this.httpConfiguration = httpConfiguration;
            return this;
        }

        public final List<SegmentDeliveryConfiguration.Builder> getSegmentDeliveryConfigurations() {
            List<SegmentDeliveryConfiguration.Builder> result = ___listOfSegmentDeliveryConfigurationCopier
                    .copyToBuilder(this.segmentDeliveryConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSegmentDeliveryConfigurations(
                Collection<SegmentDeliveryConfiguration.BuilderImpl> segmentDeliveryConfigurations) {
            this.segmentDeliveryConfigurations = ___listOfSegmentDeliveryConfigurationCopier
                    .copyFromBuilder(segmentDeliveryConfigurations);
        }

        @Override
        public final Builder segmentDeliveryConfigurations(Collection<SegmentDeliveryConfiguration> segmentDeliveryConfigurations) {
            this.segmentDeliveryConfigurations = ___listOfSegmentDeliveryConfigurationCopier.copy(segmentDeliveryConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentDeliveryConfigurations(SegmentDeliveryConfiguration... segmentDeliveryConfigurations) {
            segmentDeliveryConfigurations(Arrays.asList(segmentDeliveryConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentDeliveryConfigurations(
                Consumer<SegmentDeliveryConfiguration.Builder>... segmentDeliveryConfigurations) {
            segmentDeliveryConfigurations(Stream.of(segmentDeliveryConfigurations)
                    .map(c -> SegmentDeliveryConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSourceLocationName() {
            return sourceLocationName;
        }

        public final void setSourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
        }

        @Override
        public final Builder sourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSourceLocationRequest build() {
            return new CreateSourceLocationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
