/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastoredata;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.mediastoredata.DefaultMediaStoreDataClientBuilder;
import software.amazon.awssdk.services.mediastoredata.MediaStoreDataClientBuilder;
import software.amazon.awssdk.services.mediastoredata.model.ContainerNotFoundException;
import software.amazon.awssdk.services.mediastoredata.model.DeleteObjectRequest;
import software.amazon.awssdk.services.mediastoredata.model.DeleteObjectResponse;
import software.amazon.awssdk.services.mediastoredata.model.DescribeObjectRequest;
import software.amazon.awssdk.services.mediastoredata.model.DescribeObjectResponse;
import software.amazon.awssdk.services.mediastoredata.model.GetObjectRequest;
import software.amazon.awssdk.services.mediastoredata.model.GetObjectResponse;
import software.amazon.awssdk.services.mediastoredata.model.InternalServerErrorException;
import software.amazon.awssdk.services.mediastoredata.model.ListItemsRequest;
import software.amazon.awssdk.services.mediastoredata.model.ListItemsResponse;
import software.amazon.awssdk.services.mediastoredata.model.MediaStoreDataException;
import software.amazon.awssdk.services.mediastoredata.model.ObjectNotFoundException;
import software.amazon.awssdk.services.mediastoredata.model.PutObjectRequest;
import software.amazon.awssdk.services.mediastoredata.model.PutObjectResponse;
import software.amazon.awssdk.services.mediastoredata.model.RequestedRangeNotSatisfiableException;
import software.amazon.awssdk.services.mediastoredata.paginators.ListItemsIterable;

@SdkPublicApi
@ThreadSafe
public interface MediaStoreDataClient
extends SdkClient {
    public static final String SERVICE_NAME = "mediastore";
    public static final String SERVICE_METADATA_ID = "data.mediastore";

    public static MediaStoreDataClient create() {
        return (MediaStoreDataClient)MediaStoreDataClient.builder().build();
    }

    public static MediaStoreDataClientBuilder builder() {
        return new DefaultMediaStoreDataClientBuilder();
    }

    default public DeleteObjectResponse deleteObject(DeleteObjectRequest deleteObjectRequest) throws ContainerNotFoundException, ObjectNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreDataException {
        throw new UnsupportedOperationException();
    }

    default public DeleteObjectResponse deleteObject(Consumer<DeleteObjectRequest.Builder> deleteObjectRequest) throws ContainerNotFoundException, ObjectNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreDataException {
        return this.deleteObject((DeleteObjectRequest)((Object)((DeleteObjectRequest.Builder)DeleteObjectRequest.builder().applyMutation(deleteObjectRequest)).build()));
    }

    default public DescribeObjectResponse describeObject(DescribeObjectRequest describeObjectRequest) throws ContainerNotFoundException, ObjectNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreDataException {
        throw new UnsupportedOperationException();
    }

    default public DescribeObjectResponse describeObject(Consumer<DescribeObjectRequest.Builder> describeObjectRequest) throws ContainerNotFoundException, ObjectNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreDataException {
        return this.describeObject((DescribeObjectRequest)((Object)((DescribeObjectRequest.Builder)DescribeObjectRequest.builder().applyMutation(describeObjectRequest)).build()));
    }

    default public <ReturnT> ReturnT getObject(GetObjectRequest getObjectRequest, ResponseTransformer<GetObjectResponse, ReturnT> responseTransformer) throws ContainerNotFoundException, ObjectNotFoundException, RequestedRangeNotSatisfiableException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreDataException {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> ReturnT getObject(Consumer<GetObjectRequest.Builder> getObjectRequest, ResponseTransformer<GetObjectResponse, ReturnT> responseTransformer) throws ContainerNotFoundException, ObjectNotFoundException, RequestedRangeNotSatisfiableException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreDataException {
        return this.getObject((GetObjectRequest)((Object)((GetObjectRequest.Builder)GetObjectRequest.builder().applyMutation(getObjectRequest)).build()), responseTransformer);
    }

    default public GetObjectResponse getObject(GetObjectRequest getObjectRequest, Path destinationPath) throws ContainerNotFoundException, ObjectNotFoundException, RequestedRangeNotSatisfiableException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreDataException {
        return (GetObjectResponse)((Object)this.getObject(getObjectRequest, ResponseTransformer.toFile((Path)destinationPath)));
    }

    default public GetObjectResponse getObject(Consumer<GetObjectRequest.Builder> getObjectRequest, Path destinationPath) throws ContainerNotFoundException, ObjectNotFoundException, RequestedRangeNotSatisfiableException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreDataException {
        return this.getObject((GetObjectRequest)((Object)((GetObjectRequest.Builder)GetObjectRequest.builder().applyMutation(getObjectRequest)).build()), destinationPath);
    }

    default public ResponseInputStream<GetObjectResponse> getObject(GetObjectRequest getObjectRequest) throws ContainerNotFoundException, ObjectNotFoundException, RequestedRangeNotSatisfiableException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreDataException {
        return (ResponseInputStream)this.getObject(getObjectRequest, ResponseTransformer.toInputStream());
    }

    default public ResponseInputStream<GetObjectResponse> getObject(Consumer<GetObjectRequest.Builder> getObjectRequest) throws ContainerNotFoundException, ObjectNotFoundException, RequestedRangeNotSatisfiableException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreDataException {
        return this.getObject((GetObjectRequest)((Object)((GetObjectRequest.Builder)GetObjectRequest.builder().applyMutation(getObjectRequest)).build()));
    }

    default public ResponseBytes<GetObjectResponse> getObjectAsBytes(GetObjectRequest getObjectRequest) throws ContainerNotFoundException, ObjectNotFoundException, RequestedRangeNotSatisfiableException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreDataException {
        return (ResponseBytes)this.getObject(getObjectRequest, ResponseTransformer.toBytes());
    }

    default public ResponseBytes<GetObjectResponse> getObjectAsBytes(Consumer<GetObjectRequest.Builder> getObjectRequest) throws ContainerNotFoundException, ObjectNotFoundException, RequestedRangeNotSatisfiableException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreDataException {
        return this.getObjectAsBytes((GetObjectRequest)((Object)((GetObjectRequest.Builder)GetObjectRequest.builder().applyMutation(getObjectRequest)).build()));
    }

    default public ListItemsResponse listItems(ListItemsRequest listItemsRequest) throws ContainerNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreDataException {
        throw new UnsupportedOperationException();
    }

    default public ListItemsResponse listItems(Consumer<ListItemsRequest.Builder> listItemsRequest) throws ContainerNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreDataException {
        return this.listItems((ListItemsRequest)((Object)((ListItemsRequest.Builder)ListItemsRequest.builder().applyMutation(listItemsRequest)).build()));
    }

    default public ListItemsIterable listItemsPaginator(ListItemsRequest listItemsRequest) throws ContainerNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreDataException {
        throw new UnsupportedOperationException();
    }

    default public ListItemsIterable listItemsPaginator(Consumer<ListItemsRequest.Builder> listItemsRequest) throws ContainerNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreDataException {
        return this.listItemsPaginator((ListItemsRequest)((Object)((ListItemsRequest.Builder)ListItemsRequest.builder().applyMutation(listItemsRequest)).build()));
    }

    default public PutObjectResponse putObject(PutObjectRequest putObjectRequest, RequestBody requestBody) throws ContainerNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreDataException {
        throw new UnsupportedOperationException();
    }

    default public PutObjectResponse putObject(Consumer<PutObjectRequest.Builder> putObjectRequest, RequestBody requestBody) throws ContainerNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreDataException {
        return this.putObject((PutObjectRequest)((Object)((PutObjectRequest.Builder)PutObjectRequest.builder().applyMutation(putObjectRequest)).build()), requestBody);
    }

    default public PutObjectResponse putObject(PutObjectRequest putObjectRequest, Path sourcePath) throws ContainerNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreDataException {
        return this.putObject(putObjectRequest, RequestBody.fromFile((Path)sourcePath));
    }

    default public PutObjectResponse putObject(Consumer<PutObjectRequest.Builder> putObjectRequest, Path sourcePath) throws ContainerNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, MediaStoreDataException {
        return this.putObject((PutObjectRequest)((Object)((PutObjectRequest.Builder)PutObjectRequest.builder().applyMutation(putObjectRequest)).build()), sourcePath);
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_METADATA_ID);
    }
}

