/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediastore.model.MediaStoreRequest;
import software.amazon.awssdk.services.mediastore.model.MetricPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutMetricPolicyRequest
extends MediaStoreRequest
implements ToCopyableBuilder<Builder, PutMetricPolicyRequest> {
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerName").getter(PutMetricPolicyRequest.getter(PutMetricPolicyRequest::containerName)).setter(PutMetricPolicyRequest.setter(Builder::containerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerName").build()}).build();
    private static final SdkField<MetricPolicy> METRIC_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetricPolicy").getter(PutMetricPolicyRequest.getter(PutMetricPolicyRequest::metricPolicy)).setter(PutMetricPolicyRequest.setter(Builder::metricPolicy)).constructor(MetricPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_NAME_FIELD, METRIC_POLICY_FIELD));
    private final String containerName;
    private final MetricPolicy metricPolicy;

    private PutMetricPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.containerName = builder.containerName;
        this.metricPolicy = builder.metricPolicy;
    }

    public final String containerName() {
        return this.containerName;
    }

    public final MetricPolicy metricPolicy() {
        return this.metricPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.containerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetricPolicyRequest)) {
            return false;
        }
        PutMetricPolicyRequest other = (PutMetricPolicyRequest)((Object)obj);
        return Objects.equals(this.containerName(), other.containerName()) && Objects.equals(this.metricPolicy(), other.metricPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"PutMetricPolicyRequest").add("ContainerName", (Object)this.containerName()).add("MetricPolicy", (Object)this.metricPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerName": {
                return Optional.ofNullable(clazz.cast(this.containerName()));
            }
            case "MetricPolicy": {
                return Optional.ofNullable(clazz.cast(this.metricPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutMetricPolicyRequest, T> g) {
        return obj -> g.apply((PutMetricPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaStoreRequest.BuilderImpl
    implements Builder {
        private String containerName;
        private MetricPolicy metricPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutMetricPolicyRequest model) {
            super(model);
            this.containerName(model.containerName);
            this.metricPolicy(model.metricPolicy);
        }

        public final String getContainerName() {
            return this.containerName;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final MetricPolicy.Builder getMetricPolicy() {
            return this.metricPolicy != null ? this.metricPolicy.toBuilder() : null;
        }

        public final void setMetricPolicy(MetricPolicy.BuilderImpl metricPolicy) {
            this.metricPolicy = metricPolicy != null ? metricPolicy.build() : null;
        }

        @Override
        public final Builder metricPolicy(MetricPolicy metricPolicy) {
            this.metricPolicy = metricPolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMetricPolicyRequest build() {
            return new PutMetricPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaStoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutMetricPolicyRequest> {
        public Builder containerName(String var1);

        public Builder metricPolicy(MetricPolicy var1);

        default public Builder metricPolicy(Consumer<MetricPolicy.Builder> metricPolicy) {
            return this.metricPolicy((MetricPolicy)((MetricPolicy.Builder)MetricPolicy.builder().applyMutation(metricPolicy)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

