/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Key Provider Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeyProviderSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<KeyProviderSettings.Builder, KeyProviderSettings> {
    private static final SdkField<StaticKeySettings> STATIC_KEY_SETTINGS_FIELD = SdkField
            .<StaticKeySettings> builder(MarshallingType.SDK_POJO).memberName("StaticKeySettings")
            .getter(getter(KeyProviderSettings::staticKeySettings)).setter(setter(Builder::staticKeySettings))
            .constructor(StaticKeySettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("staticKeySettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATIC_KEY_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final StaticKeySettings staticKeySettings;

    private KeyProviderSettings(BuilderImpl builder) {
        this.staticKeySettings = builder.staticKeySettings;
    }

    /**
     * Returns the value of the StaticKeySettings property for this object.
     * 
     * @return The value of the StaticKeySettings property for this object.
     */
    public final StaticKeySettings staticKeySettings() {
        return staticKeySettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(staticKeySettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyProviderSettings)) {
            return false;
        }
        KeyProviderSettings other = (KeyProviderSettings) obj;
        return Objects.equals(staticKeySettings(), other.staticKeySettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeyProviderSettings").add("StaticKeySettings", staticKeySettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StaticKeySettings":
            return Optional.ofNullable(clazz.cast(staticKeySettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KeyProviderSettings, T> g) {
        return obj -> g.apply((KeyProviderSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeyProviderSettings> {
        /**
         * Sets the value of the StaticKeySettings property for this object.
         *
         * @param staticKeySettings
         *        The new value for the StaticKeySettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticKeySettings(StaticKeySettings staticKeySettings);

        /**
         * Sets the value of the StaticKeySettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StaticKeySettings.Builder} avoiding the
         * need to create one manually via {@link StaticKeySettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StaticKeySettings.Builder#build()} is called immediately and its
         * result is passed to {@link #staticKeySettings(StaticKeySettings)}.
         * 
         * @param staticKeySettings
         *        a consumer that will call methods on {@link StaticKeySettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #staticKeySettings(StaticKeySettings)
         */
        default Builder staticKeySettings(Consumer<StaticKeySettings.Builder> staticKeySettings) {
            return staticKeySettings(StaticKeySettings.builder().applyMutation(staticKeySettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StaticKeySettings staticKeySettings;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyProviderSettings model) {
            staticKeySettings(model.staticKeySettings);
        }

        public final StaticKeySettings.Builder getStaticKeySettings() {
            return staticKeySettings != null ? staticKeySettings.toBuilder() : null;
        }

        public final void setStaticKeySettings(StaticKeySettings.BuilderImpl staticKeySettings) {
            this.staticKeySettings = staticKeySettings != null ? staticKeySettings.build() : null;
        }

        @Override
        public final Builder staticKeySettings(StaticKeySettings staticKeySettings) {
            this.staticKeySettings = staticKeySettings;
            return this;
        }

        @Override
        public KeyProviderSettings build() {
            return new KeyProviderSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
