/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * If you are using the console, use the Frame rate setting to specify the frame rate for this output. If you want to
 * keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a
 * frame rate from the dropdown list. The framerates shown in the dropdown list are decimal approximations of fractions.
 * If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to
 * specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want
 * the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate that
 * you specify in the settings FramerateNumerator and FramerateDenominator.
 */
@Generated("software.amazon.awssdk:codegen")
public enum XavcFramerateControl {
    INITIALIZE_FROM_SOURCE("INITIALIZE_FROM_SOURCE"),

    SPECIFIED("SPECIFIED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, XavcFramerateControl> VALUE_MAP = EnumUtils.uniqueIndex(XavcFramerateControl.class,
            XavcFramerateControl::toString);

    private final String value;

    private XavcFramerateControl(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return XavcFramerateControl corresponding to the value
     */
    public static XavcFramerateControl fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link XavcFramerateControl}s
     */
    public static Set<XavcFramerateControl> knownValues() {
        Set<XavcFramerateControl> knownValues = EnumSet.allOf(XavcFramerateControl.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
