/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Group of outputs
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputGroup implements SdkPojo, Serializable, ToCopyableBuilder<OutputGroup.Builder, OutputGroup> {
    private static final SdkField<AutomatedEncodingSettings> AUTOMATED_ENCODING_SETTINGS_FIELD = SdkField
            .<AutomatedEncodingSettings> builder(MarshallingType.SDK_POJO).memberName("AutomatedEncodingSettings")
            .getter(getter(OutputGroup::automatedEncodingSettings)).setter(setter(Builder::automatedEncodingSettings))
            .constructor(AutomatedEncodingSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automatedEncodingSettings").build())
            .build();

    private static final SdkField<String> CUSTOM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomName").getter(getter(OutputGroup::customName)).setter(setter(Builder::customName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(OutputGroup::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<OutputGroupSettings> OUTPUT_GROUP_SETTINGS_FIELD = SdkField
            .<OutputGroupSettings> builder(MarshallingType.SDK_POJO).memberName("OutputGroupSettings")
            .getter(getter(OutputGroup::outputGroupSettings)).setter(setter(Builder::outputGroupSettings))
            .constructor(OutputGroupSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputGroupSettings").build())
            .build();

    private static final SdkField<List<Output>> OUTPUTS_FIELD = SdkField
            .<List<Output>> builder(MarshallingType.LIST)
            .memberName("Outputs")
            .getter(getter(OutputGroup::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Output> builder(MarshallingType.SDK_POJO)
                                            .constructor(Output::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTOMATED_ENCODING_SETTINGS_FIELD, CUSTOM_NAME_FIELD, NAME_FIELD, OUTPUT_GROUP_SETTINGS_FIELD, OUTPUTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AutomatedEncodingSettings automatedEncodingSettings;

    private final String customName;

    private final String name;

    private final OutputGroupSettings outputGroupSettings;

    private final List<Output> outputs;

    private OutputGroup(BuilderImpl builder) {
        this.automatedEncodingSettings = builder.automatedEncodingSettings;
        this.customName = builder.customName;
        this.name = builder.name;
        this.outputGroupSettings = builder.outputGroupSettings;
        this.outputs = builder.outputs;
    }

    /**
     * Use automated encoding to have MediaConvert choose your encoding settings for you, based on characteristics of
     * your input video.
     * 
     * @return Use automated encoding to have MediaConvert choose your encoding settings for you, based on
     *         characteristics of your input video.
     */
    public final AutomatedEncodingSettings automatedEncodingSettings() {
        return automatedEncodingSettings;
    }

    /**
     * Use Custom Group Name (CustomName) to specify a name for the output group. This value is displayed on the console
     * and can make your job settings JSON more human-readable. It does not affect your outputs. Use up to twelve
     * characters that are either letters, numbers, spaces, or underscores.
     * 
     * @return Use Custom Group Name (CustomName) to specify a name for the output group. This value is displayed on the
     *         console and can make your job settings JSON more human-readable. It does not affect your outputs. Use up
     *         to twelve characters that are either letters, numbers, spaces, or underscores.
     */
    public final String customName() {
        return customName;
    }

    /**
     * Name of the output group
     * 
     * @return Name of the output group
     */
    public final String name() {
        return name;
    }

    /**
     * Output Group settings, including type
     * 
     * @return Output Group settings, including type
     */
    public final OutputGroupSettings outputGroupSettings() {
        return outputGroupSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * This object holds groups of encoding settings, one group of settings per output.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputs} method.
     * </p>
     * 
     * @return This object holds groups of encoding settings, one group of settings per output.
     */
    public final List<Output> outputs() {
        return outputs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automatedEncodingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(customName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(outputGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputGroup)) {
            return false;
        }
        OutputGroup other = (OutputGroup) obj;
        return Objects.equals(automatedEncodingSettings(), other.automatedEncodingSettings())
                && Objects.equals(customName(), other.customName()) && Objects.equals(name(), other.name())
                && Objects.equals(outputGroupSettings(), other.outputGroupSettings()) && hasOutputs() == other.hasOutputs()
                && Objects.equals(outputs(), other.outputs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputGroup").add("AutomatedEncodingSettings", automatedEncodingSettings())
                .add("CustomName", customName()).add("Name", name()).add("OutputGroupSettings", outputGroupSettings())
                .add("Outputs", hasOutputs() ? outputs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomatedEncodingSettings":
            return Optional.ofNullable(clazz.cast(automatedEncodingSettings()));
        case "CustomName":
            return Optional.ofNullable(clazz.cast(customName()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "OutputGroupSettings":
            return Optional.ofNullable(clazz.cast(outputGroupSettings()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputGroup, T> g) {
        return obj -> g.apply((OutputGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputGroup> {
        /**
         * Use automated encoding to have MediaConvert choose your encoding settings for you, based on characteristics
         * of your input video.
         * 
         * @param automatedEncodingSettings
         *        Use automated encoding to have MediaConvert choose your encoding settings for you, based on
         *        characteristics of your input video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automatedEncodingSettings(AutomatedEncodingSettings automatedEncodingSettings);

        /**
         * Use automated encoding to have MediaConvert choose your encoding settings for you, based on characteristics
         * of your input video. This is a convenience method that creates an instance of the
         * {@link AutomatedEncodingSettings.Builder} avoiding the need to create one manually via
         * {@link AutomatedEncodingSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedEncodingSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #automatedEncodingSettings(AutomatedEncodingSettings)}.
         * 
         * @param automatedEncodingSettings
         *        a consumer that will call methods on {@link AutomatedEncodingSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automatedEncodingSettings(AutomatedEncodingSettings)
         */
        default Builder automatedEncodingSettings(Consumer<AutomatedEncodingSettings.Builder> automatedEncodingSettings) {
            return automatedEncodingSettings(AutomatedEncodingSettings.builder().applyMutation(automatedEncodingSettings).build());
        }

        /**
         * Use Custom Group Name (CustomName) to specify a name for the output group. This value is displayed on the
         * console and can make your job settings JSON more human-readable. It does not affect your outputs. Use up to
         * twelve characters that are either letters, numbers, spaces, or underscores.
         * 
         * @param customName
         *        Use Custom Group Name (CustomName) to specify a name for the output group. This value is displayed on
         *        the console and can make your job settings JSON more human-readable. It does not affect your outputs.
         *        Use up to twelve characters that are either letters, numbers, spaces, or underscores.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customName(String customName);

        /**
         * Name of the output group
         * 
         * @param name
         *        Name of the output group
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Output Group settings, including type
         * 
         * @param outputGroupSettings
         *        Output Group settings, including type
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputGroupSettings(OutputGroupSettings outputGroupSettings);

        /**
         * Output Group settings, including type This is a convenience method that creates an instance of the
         * {@link OutputGroupSettings.Builder} avoiding the need to create one manually via
         * {@link OutputGroupSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputGroupSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #outputGroupSettings(OutputGroupSettings)}.
         * 
         * @param outputGroupSettings
         *        a consumer that will call methods on {@link OutputGroupSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputGroupSettings(OutputGroupSettings)
         */
        default Builder outputGroupSettings(Consumer<OutputGroupSettings.Builder> outputGroupSettings) {
            return outputGroupSettings(OutputGroupSettings.builder().applyMutation(outputGroupSettings).build());
        }

        /**
         * This object holds groups of encoding settings, one group of settings per output.
         * 
         * @param outputs
         *        This object holds groups of encoding settings, one group of settings per output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<Output> outputs);

        /**
         * This object holds groups of encoding settings, one group of settings per output.
         * 
         * @param outputs
         *        This object holds groups of encoding settings, one group of settings per output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Output... outputs);

        /**
         * This object holds groups of encoding settings, one group of settings per output. This is a convenience method
         * that creates an instance of the {@link software.amazon.awssdk.services.mediaconvert.model.Output.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.mediaconvert.model.Output#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconvert.model.Output.Builder#build()} is called immediately and
         * its result is passed to {@link #outputs(List<Output>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconvert.model.Output.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(java.util.Collection<Output>)
         */
        Builder outputs(Consumer<Output.Builder>... outputs);
    }

    static final class BuilderImpl implements Builder {
        private AutomatedEncodingSettings automatedEncodingSettings;

        private String customName;

        private String name;

        private OutputGroupSettings outputGroupSettings;

        private List<Output> outputs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OutputGroup model) {
            automatedEncodingSettings(model.automatedEncodingSettings);
            customName(model.customName);
            name(model.name);
            outputGroupSettings(model.outputGroupSettings);
            outputs(model.outputs);
        }

        public final AutomatedEncodingSettings.Builder getAutomatedEncodingSettings() {
            return automatedEncodingSettings != null ? automatedEncodingSettings.toBuilder() : null;
        }

        public final void setAutomatedEncodingSettings(AutomatedEncodingSettings.BuilderImpl automatedEncodingSettings) {
            this.automatedEncodingSettings = automatedEncodingSettings != null ? automatedEncodingSettings.build() : null;
        }

        @Override
        public final Builder automatedEncodingSettings(AutomatedEncodingSettings automatedEncodingSettings) {
            this.automatedEncodingSettings = automatedEncodingSettings;
            return this;
        }

        public final String getCustomName() {
            return customName;
        }

        public final void setCustomName(String customName) {
            this.customName = customName;
        }

        @Override
        public final Builder customName(String customName) {
            this.customName = customName;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final OutputGroupSettings.Builder getOutputGroupSettings() {
            return outputGroupSettings != null ? outputGroupSettings.toBuilder() : null;
        }

        public final void setOutputGroupSettings(OutputGroupSettings.BuilderImpl outputGroupSettings) {
            this.outputGroupSettings = outputGroupSettings != null ? outputGroupSettings.build() : null;
        }

        @Override
        public final Builder outputGroupSettings(OutputGroupSettings outputGroupSettings) {
            this.outputGroupSettings = outputGroupSettings;
            return this;
        }

        public final List<Output.Builder> getOutputs() {
            List<Output.Builder> result = ___listOfOutputCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = ___listOfOutputCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = ___listOfOutputCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<Output.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> Output.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public OutputGroup build() {
            return new OutputGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
