/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Ignore these settings unless you are using Nielsen non-linear watermarking. Specify the values that MediaConvert uses
 * to generate and place Nielsen watermarks in your output audio. In addition to specifying these values, you also need
 * to set up your cloud TIC server. These settings apply to every output in your job. The MediaConvert implementation is
 * currently with the following Nielsen versions: Nielsen Watermark SDK Version 5.2.1 Nielsen NLM Watermark Engine
 * Version 1.2.7 Nielsen Watermark Authenticator [SID_TIC] Version [5.0.0]
 */
@Generated("software.amazon.awssdk:codegen")
public final class NielsenNonLinearWatermarkSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<NielsenNonLinearWatermarkSettings.Builder, NielsenNonLinearWatermarkSettings> {
    private static final SdkField<String> ACTIVE_WATERMARK_PROCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActiveWatermarkProcess")
            .getter(getter(NielsenNonLinearWatermarkSettings::activeWatermarkProcessAsString))
            .setter(setter(Builder::activeWatermarkProcess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeWatermarkProcess").build())
            .build();

    private static final SdkField<String> ADI_FILENAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdiFilename").getter(getter(NielsenNonLinearWatermarkSettings::adiFilename))
            .setter(setter(Builder::adiFilename))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adiFilename").build()).build();

    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssetId").getter(getter(NielsenNonLinearWatermarkSettings::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()).build();

    private static final SdkField<String> ASSET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssetName").getter(getter(NielsenNonLinearWatermarkSettings::assetName))
            .setter(setter(Builder::assetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetName").build()).build();

    private static final SdkField<String> CBET_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CbetSourceId").getter(getter(NielsenNonLinearWatermarkSettings::cbetSourceId))
            .setter(setter(Builder::cbetSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cbetSourceId").build()).build();

    private static final SdkField<String> EPISODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EpisodeId").getter(getter(NielsenNonLinearWatermarkSettings::episodeId))
            .setter(setter(Builder::episodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("episodeId").build()).build();

    private static final SdkField<String> METADATA_DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetadataDestination").getter(getter(NielsenNonLinearWatermarkSettings::metadataDestination))
            .setter(setter(Builder::metadataDestination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataDestination").build())
            .build();

    private static final SdkField<Integer> SOURCE_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SourceId").getter(getter(NielsenNonLinearWatermarkSettings::sourceId)).setter(setter(Builder::sourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceId").build()).build();

    private static final SdkField<String> SOURCE_WATERMARK_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceWatermarkStatus").getter(getter(NielsenNonLinearWatermarkSettings::sourceWatermarkStatusAsString))
            .setter(setter(Builder::sourceWatermarkStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceWatermarkStatus").build())
            .build();

    private static final SdkField<String> TIC_SERVER_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TicServerUrl").getter(getter(NielsenNonLinearWatermarkSettings::ticServerUrl))
            .setter(setter(Builder::ticServerUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ticServerUrl").build()).build();

    private static final SdkField<String> UNIQUE_TIC_PER_AUDIO_TRACK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UniqueTicPerAudioTrack")
            .getter(getter(NielsenNonLinearWatermarkSettings::uniqueTicPerAudioTrackAsString))
            .setter(setter(Builder::uniqueTicPerAudioTrack))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uniqueTicPerAudioTrack").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACTIVE_WATERMARK_PROCESS_FIELD, ADI_FILENAME_FIELD, ASSET_ID_FIELD, ASSET_NAME_FIELD, CBET_SOURCE_ID_FIELD,
            EPISODE_ID_FIELD, METADATA_DESTINATION_FIELD, SOURCE_ID_FIELD, SOURCE_WATERMARK_STATUS_FIELD, TIC_SERVER_URL_FIELD,
            UNIQUE_TIC_PER_AUDIO_TRACK_FIELD));

    private static final long serialVersionUID = 1L;

    private final String activeWatermarkProcess;

    private final String adiFilename;

    private final String assetId;

    private final String assetName;

    private final String cbetSourceId;

    private final String episodeId;

    private final String metadataDestination;

    private final Integer sourceId;

    private final String sourceWatermarkStatus;

    private final String ticServerUrl;

    private final String uniqueTicPerAudioTrack;

    private NielsenNonLinearWatermarkSettings(BuilderImpl builder) {
        this.activeWatermarkProcess = builder.activeWatermarkProcess;
        this.adiFilename = builder.adiFilename;
        this.assetId = builder.assetId;
        this.assetName = builder.assetName;
        this.cbetSourceId = builder.cbetSourceId;
        this.episodeId = builder.episodeId;
        this.metadataDestination = builder.metadataDestination;
        this.sourceId = builder.sourceId;
        this.sourceWatermarkStatus = builder.sourceWatermarkStatus;
        this.ticServerUrl = builder.ticServerUrl;
        this.uniqueTicPerAudioTrack = builder.uniqueTicPerAudioTrack;
    }

    /**
     * Choose the type of Nielsen watermarks that you want in your outputs. When you choose NAES 2 and NW
     * (NAES2_AND_NW), you must provide a value for the setting SID (sourceId). When you choose CBET (CBET), you must
     * provide a value for the setting CSID (cbetSourceId). When you choose NAES 2, NW, and CBET
     * (NAES2_AND_NW_AND_CBET), you must provide values for both of these settings.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #activeWatermarkProcess} will return {@link NielsenActiveWatermarkProcessType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #activeWatermarkProcessAsString}.
     * </p>
     * 
     * @return Choose the type of Nielsen watermarks that you want in your outputs. When you choose NAES 2 and NW
     *         (NAES2_AND_NW), you must provide a value for the setting SID (sourceId). When you choose CBET (CBET), you
     *         must provide a value for the setting CSID (cbetSourceId). When you choose NAES 2, NW, and CBET
     *         (NAES2_AND_NW_AND_CBET), you must provide values for both of these settings.
     * @see NielsenActiveWatermarkProcessType
     */
    public final NielsenActiveWatermarkProcessType activeWatermarkProcess() {
        return NielsenActiveWatermarkProcessType.fromValue(activeWatermarkProcess);
    }

    /**
     * Choose the type of Nielsen watermarks that you want in your outputs. When you choose NAES 2 and NW
     * (NAES2_AND_NW), you must provide a value for the setting SID (sourceId). When you choose CBET (CBET), you must
     * provide a value for the setting CSID (cbetSourceId). When you choose NAES 2, NW, and CBET
     * (NAES2_AND_NW_AND_CBET), you must provide values for both of these settings.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #activeWatermarkProcess} will return {@link NielsenActiveWatermarkProcessType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #activeWatermarkProcessAsString}.
     * </p>
     * 
     * @return Choose the type of Nielsen watermarks that you want in your outputs. When you choose NAES 2 and NW
     *         (NAES2_AND_NW), you must provide a value for the setting SID (sourceId). When you choose CBET (CBET), you
     *         must provide a value for the setting CSID (cbetSourceId). When you choose NAES 2, NW, and CBET
     *         (NAES2_AND_NW_AND_CBET), you must provide values for both of these settings.
     * @see NielsenActiveWatermarkProcessType
     */
    public final String activeWatermarkProcessAsString() {
        return activeWatermarkProcess;
    }

    /**
     * Optional. Use this setting when you want the service to include an ADI file in the Nielsen metadata .zip file. To
     * provide an ADI file, store it in Amazon S3 and provide a URL to it here. The URL should be in the following
     * format: S3://bucket/path/ADI-file. For more information about the metadata .zip file, see the setting Metadata
     * destination (metadataDestination).
     * 
     * @return Optional. Use this setting when you want the service to include an ADI file in the Nielsen metadata .zip
     *         file. To provide an ADI file, store it in Amazon S3 and provide a URL to it here. The URL should be in
     *         the following format: S3://bucket/path/ADI-file. For more information about the metadata .zip file, see
     *         the setting Metadata destination (metadataDestination).
     */
    public final String adiFilename() {
        return adiFilename;
    }

    /**
     * Use the asset ID that you provide to Nielsen to uniquely identify this asset. Required for all Nielsen non-linear
     * watermarking.
     * 
     * @return Use the asset ID that you provide to Nielsen to uniquely identify this asset. Required for all Nielsen
     *         non-linear watermarking.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * Use the asset name that you provide to Nielsen for this asset. Required for all Nielsen non-linear watermarking.
     * 
     * @return Use the asset name that you provide to Nielsen for this asset. Required for all Nielsen non-linear
     *         watermarking.
     */
    public final String assetName() {
        return assetName;
    }

    /**
     * Use the CSID that Nielsen provides to you. This CBET source ID should be unique to your Nielsen account but
     * common to all of your output assets that have CBET watermarking. Required when you choose a value for the setting
     * Watermark types (ActiveWatermarkProcess) that includes CBET.
     * 
     * @return Use the CSID that Nielsen provides to you. This CBET source ID should be unique to your Nielsen account
     *         but common to all of your output assets that have CBET watermarking. Required when you choose a value for
     *         the setting Watermark types (ActiveWatermarkProcess) that includes CBET.
     */
    public final String cbetSourceId() {
        return cbetSourceId;
    }

    /**
     * Optional. If this asset uses an episode ID with Nielsen, provide it here.
     * 
     * @return Optional. If this asset uses an episode ID with Nielsen, provide it here.
     */
    public final String episodeId() {
        return episodeId;
    }

    /**
     * Specify the Amazon S3 location where you want MediaConvert to save your Nielsen non-linear metadata .zip file.
     * This Amazon S3 bucket must be in the same Region as the one where you do your MediaConvert transcoding. If you
     * want to include an ADI file in this .zip file, use the setting ADI file (adiFilename) to specify it. MediaConvert
     * delivers the Nielsen metadata .zip files only to your metadata destination Amazon S3 bucket. It doesn't deliver
     * the .zip files to Nielsen. You are responsible for delivering the metadata .zip files to Nielsen.
     * 
     * @return Specify the Amazon S3 location where you want MediaConvert to save your Nielsen non-linear metadata .zip
     *         file. This Amazon S3 bucket must be in the same Region as the one where you do your MediaConvert
     *         transcoding. If you want to include an ADI file in this .zip file, use the setting ADI file (adiFilename)
     *         to specify it. MediaConvert delivers the Nielsen metadata .zip files only to your metadata destination
     *         Amazon S3 bucket. It doesn't deliver the .zip files to Nielsen. You are responsible for delivering the
     *         metadata .zip files to Nielsen.
     */
    public final String metadataDestination() {
        return metadataDestination;
    }

    /**
     * Use the SID that Nielsen provides to you. This source ID should be unique to your Nielsen account but common to
     * all of your output assets. Required for all Nielsen non-linear watermarking. This ID should be unique to your
     * Nielsen account but common to all of your output assets. Required for all Nielsen non-linear watermarking.
     * 
     * @return Use the SID that Nielsen provides to you. This source ID should be unique to your Nielsen account but
     *         common to all of your output assets. Required for all Nielsen non-linear watermarking. This ID should be
     *         unique to your Nielsen account but common to all of your output assets. Required for all Nielsen
     *         non-linear watermarking.
     */
    public final Integer sourceId() {
        return sourceId;
    }

    /**
     * Required. Specify whether your source content already contains Nielsen non-linear watermarks. When you set this
     * value to Watermarked (WATERMARKED), the service fails the job. Nielsen requires that you add non-linear
     * watermarking to only clean content that doesn't already have non-linear Nielsen watermarks.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sourceWatermarkStatus} will return {@link NielsenSourceWatermarkStatusType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #sourceWatermarkStatusAsString}.
     * </p>
     * 
     * @return Required. Specify whether your source content already contains Nielsen non-linear watermarks. When you
     *         set this value to Watermarked (WATERMARKED), the service fails the job. Nielsen requires that you add
     *         non-linear watermarking to only clean content that doesn't already have non-linear Nielsen watermarks.
     * @see NielsenSourceWatermarkStatusType
     */
    public final NielsenSourceWatermarkStatusType sourceWatermarkStatus() {
        return NielsenSourceWatermarkStatusType.fromValue(sourceWatermarkStatus);
    }

    /**
     * Required. Specify whether your source content already contains Nielsen non-linear watermarks. When you set this
     * value to Watermarked (WATERMARKED), the service fails the job. Nielsen requires that you add non-linear
     * watermarking to only clean content that doesn't already have non-linear Nielsen watermarks.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sourceWatermarkStatus} will return {@link NielsenSourceWatermarkStatusType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #sourceWatermarkStatusAsString}.
     * </p>
     * 
     * @return Required. Specify whether your source content already contains Nielsen non-linear watermarks. When you
     *         set this value to Watermarked (WATERMARKED), the service fails the job. Nielsen requires that you add
     *         non-linear watermarking to only clean content that doesn't already have non-linear Nielsen watermarks.
     * @see NielsenSourceWatermarkStatusType
     */
    public final String sourceWatermarkStatusAsString() {
        return sourceWatermarkStatus;
    }

    /**
     * Specify the endpoint for the TIC server that you have deployed and configured in the AWS Cloud. Required for all
     * Nielsen non-linear watermarking. MediaConvert can't connect directly to a TIC server. Instead, you must use API
     * Gateway to provide a RESTful interface between MediaConvert and a TIC server that you deploy in your AWS account.
     * For more information on deploying a TIC server in your AWS account and the required API Gateway, contact Nielsen
     * support.
     * 
     * @return Specify the endpoint for the TIC server that you have deployed and configured in the AWS Cloud. Required
     *         for all Nielsen non-linear watermarking. MediaConvert can't connect directly to a TIC server. Instead,
     *         you must use API Gateway to provide a RESTful interface between MediaConvert and a TIC server that you
     *         deploy in your AWS account. For more information on deploying a TIC server in your AWS account and the
     *         required API Gateway, contact Nielsen support.
     */
    public final String ticServerUrl() {
        return ticServerUrl;
    }

    /**
     * To create assets that have the same TIC values in each audio track, keep the default value Share TICs
     * (SAME_TICS_PER_TRACK). To create assets that have unique TIC values for each audio track, choose Use unique TICs
     * (RESERVE_UNIQUE_TICS_PER_TRACK).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #uniqueTicPerAudioTrack} will return {@link NielsenUniqueTicPerAudioTrackType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #uniqueTicPerAudioTrackAsString}.
     * </p>
     * 
     * @return To create assets that have the same TIC values in each audio track, keep the default value Share TICs
     *         (SAME_TICS_PER_TRACK). To create assets that have unique TIC values for each audio track, choose Use
     *         unique TICs (RESERVE_UNIQUE_TICS_PER_TRACK).
     * @see NielsenUniqueTicPerAudioTrackType
     */
    public final NielsenUniqueTicPerAudioTrackType uniqueTicPerAudioTrack() {
        return NielsenUniqueTicPerAudioTrackType.fromValue(uniqueTicPerAudioTrack);
    }

    /**
     * To create assets that have the same TIC values in each audio track, keep the default value Share TICs
     * (SAME_TICS_PER_TRACK). To create assets that have unique TIC values for each audio track, choose Use unique TICs
     * (RESERVE_UNIQUE_TICS_PER_TRACK).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #uniqueTicPerAudioTrack} will return {@link NielsenUniqueTicPerAudioTrackType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #uniqueTicPerAudioTrackAsString}.
     * </p>
     * 
     * @return To create assets that have the same TIC values in each audio track, keep the default value Share TICs
     *         (SAME_TICS_PER_TRACK). To create assets that have unique TIC values for each audio track, choose Use
     *         unique TICs (RESERVE_UNIQUE_TICS_PER_TRACK).
     * @see NielsenUniqueTicPerAudioTrackType
     */
    public final String uniqueTicPerAudioTrackAsString() {
        return uniqueTicPerAudioTrack;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activeWatermarkProcessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(adiFilename());
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(assetName());
        hashCode = 31 * hashCode + Objects.hashCode(cbetSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(episodeId());
        hashCode = 31 * hashCode + Objects.hashCode(metadataDestination());
        hashCode = 31 * hashCode + Objects.hashCode(sourceId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceWatermarkStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ticServerUrl());
        hashCode = 31 * hashCode + Objects.hashCode(uniqueTicPerAudioTrackAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NielsenNonLinearWatermarkSettings)) {
            return false;
        }
        NielsenNonLinearWatermarkSettings other = (NielsenNonLinearWatermarkSettings) obj;
        return Objects.equals(activeWatermarkProcessAsString(), other.activeWatermarkProcessAsString())
                && Objects.equals(adiFilename(), other.adiFilename()) && Objects.equals(assetId(), other.assetId())
                && Objects.equals(assetName(), other.assetName()) && Objects.equals(cbetSourceId(), other.cbetSourceId())
                && Objects.equals(episodeId(), other.episodeId())
                && Objects.equals(metadataDestination(), other.metadataDestination())
                && Objects.equals(sourceId(), other.sourceId())
                && Objects.equals(sourceWatermarkStatusAsString(), other.sourceWatermarkStatusAsString())
                && Objects.equals(ticServerUrl(), other.ticServerUrl())
                && Objects.equals(uniqueTicPerAudioTrackAsString(), other.uniqueTicPerAudioTrackAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NielsenNonLinearWatermarkSettings")
                .add("ActiveWatermarkProcess", activeWatermarkProcessAsString()).add("AdiFilename", adiFilename())
                .add("AssetId", assetId()).add("AssetName", assetName()).add("CbetSourceId", cbetSourceId())
                .add("EpisodeId", episodeId()).add("MetadataDestination", metadataDestination()).add("SourceId", sourceId())
                .add("SourceWatermarkStatus", sourceWatermarkStatusAsString()).add("TicServerUrl", ticServerUrl())
                .add("UniqueTicPerAudioTrack", uniqueTicPerAudioTrackAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActiveWatermarkProcess":
            return Optional.ofNullable(clazz.cast(activeWatermarkProcessAsString()));
        case "AdiFilename":
            return Optional.ofNullable(clazz.cast(adiFilename()));
        case "AssetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "AssetName":
            return Optional.ofNullable(clazz.cast(assetName()));
        case "CbetSourceId":
            return Optional.ofNullable(clazz.cast(cbetSourceId()));
        case "EpisodeId":
            return Optional.ofNullable(clazz.cast(episodeId()));
        case "MetadataDestination":
            return Optional.ofNullable(clazz.cast(metadataDestination()));
        case "SourceId":
            return Optional.ofNullable(clazz.cast(sourceId()));
        case "SourceWatermarkStatus":
            return Optional.ofNullable(clazz.cast(sourceWatermarkStatusAsString()));
        case "TicServerUrl":
            return Optional.ofNullable(clazz.cast(ticServerUrl()));
        case "UniqueTicPerAudioTrack":
            return Optional.ofNullable(clazz.cast(uniqueTicPerAudioTrackAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NielsenNonLinearWatermarkSettings, T> g) {
        return obj -> g.apply((NielsenNonLinearWatermarkSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NielsenNonLinearWatermarkSettings> {
        /**
         * Choose the type of Nielsen watermarks that you want in your outputs. When you choose NAES 2 and NW
         * (NAES2_AND_NW), you must provide a value for the setting SID (sourceId). When you choose CBET (CBET), you
         * must provide a value for the setting CSID (cbetSourceId). When you choose NAES 2, NW, and CBET
         * (NAES2_AND_NW_AND_CBET), you must provide values for both of these settings.
         * 
         * @param activeWatermarkProcess
         *        Choose the type of Nielsen watermarks that you want in your outputs. When you choose NAES 2 and NW
         *        (NAES2_AND_NW), you must provide a value for the setting SID (sourceId). When you choose CBET (CBET),
         *        you must provide a value for the setting CSID (cbetSourceId). When you choose NAES 2, NW, and CBET
         *        (NAES2_AND_NW_AND_CBET), you must provide values for both of these settings.
         * @see NielsenActiveWatermarkProcessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NielsenActiveWatermarkProcessType
         */
        Builder activeWatermarkProcess(String activeWatermarkProcess);

        /**
         * Choose the type of Nielsen watermarks that you want in your outputs. When you choose NAES 2 and NW
         * (NAES2_AND_NW), you must provide a value for the setting SID (sourceId). When you choose CBET (CBET), you
         * must provide a value for the setting CSID (cbetSourceId). When you choose NAES 2, NW, and CBET
         * (NAES2_AND_NW_AND_CBET), you must provide values for both of these settings.
         * 
         * @param activeWatermarkProcess
         *        Choose the type of Nielsen watermarks that you want in your outputs. When you choose NAES 2 and NW
         *        (NAES2_AND_NW), you must provide a value for the setting SID (sourceId). When you choose CBET (CBET),
         *        you must provide a value for the setting CSID (cbetSourceId). When you choose NAES 2, NW, and CBET
         *        (NAES2_AND_NW_AND_CBET), you must provide values for both of these settings.
         * @see NielsenActiveWatermarkProcessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NielsenActiveWatermarkProcessType
         */
        Builder activeWatermarkProcess(NielsenActiveWatermarkProcessType activeWatermarkProcess);

        /**
         * Optional. Use this setting when you want the service to include an ADI file in the Nielsen metadata .zip
         * file. To provide an ADI file, store it in Amazon S3 and provide a URL to it here. The URL should be in the
         * following format: S3://bucket/path/ADI-file. For more information about the metadata .zip file, see the
         * setting Metadata destination (metadataDestination).
         * 
         * @param adiFilename
         *        Optional. Use this setting when you want the service to include an ADI file in the Nielsen metadata
         *        .zip file. To provide an ADI file, store it in Amazon S3 and provide a URL to it here. The URL should
         *        be in the following format: S3://bucket/path/ADI-file. For more information about the metadata .zip
         *        file, see the setting Metadata destination (metadataDestination).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adiFilename(String adiFilename);

        /**
         * Use the asset ID that you provide to Nielsen to uniquely identify this asset. Required for all Nielsen
         * non-linear watermarking.
         * 
         * @param assetId
         *        Use the asset ID that you provide to Nielsen to uniquely identify this asset. Required for all Nielsen
         *        non-linear watermarking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * Use the asset name that you provide to Nielsen for this asset. Required for all Nielsen non-linear
         * watermarking.
         * 
         * @param assetName
         *        Use the asset name that you provide to Nielsen for this asset. Required for all Nielsen non-linear
         *        watermarking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetName(String assetName);

        /**
         * Use the CSID that Nielsen provides to you. This CBET source ID should be unique to your Nielsen account but
         * common to all of your output assets that have CBET watermarking. Required when you choose a value for the
         * setting Watermark types (ActiveWatermarkProcess) that includes CBET.
         * 
         * @param cbetSourceId
         *        Use the CSID that Nielsen provides to you. This CBET source ID should be unique to your Nielsen
         *        account but common to all of your output assets that have CBET watermarking. Required when you choose
         *        a value for the setting Watermark types (ActiveWatermarkProcess) that includes CBET.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cbetSourceId(String cbetSourceId);

        /**
         * Optional. If this asset uses an episode ID with Nielsen, provide it here.
         * 
         * @param episodeId
         *        Optional. If this asset uses an episode ID with Nielsen, provide it here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder episodeId(String episodeId);

        /**
         * Specify the Amazon S3 location where you want MediaConvert to save your Nielsen non-linear metadata .zip
         * file. This Amazon S3 bucket must be in the same Region as the one where you do your MediaConvert transcoding.
         * If you want to include an ADI file in this .zip file, use the setting ADI file (adiFilename) to specify it.
         * MediaConvert delivers the Nielsen metadata .zip files only to your metadata destination Amazon S3 bucket. It
         * doesn't deliver the .zip files to Nielsen. You are responsible for delivering the metadata .zip files to
         * Nielsen.
         * 
         * @param metadataDestination
         *        Specify the Amazon S3 location where you want MediaConvert to save your Nielsen non-linear metadata
         *        .zip file. This Amazon S3 bucket must be in the same Region as the one where you do your MediaConvert
         *        transcoding. If you want to include an ADI file in this .zip file, use the setting ADI file
         *        (adiFilename) to specify it. MediaConvert delivers the Nielsen metadata .zip files only to your
         *        metadata destination Amazon S3 bucket. It doesn't deliver the .zip files to Nielsen. You are
         *        responsible for delivering the metadata .zip files to Nielsen.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataDestination(String metadataDestination);

        /**
         * Use the SID that Nielsen provides to you. This source ID should be unique to your Nielsen account but common
         * to all of your output assets. Required for all Nielsen non-linear watermarking. This ID should be unique to
         * your Nielsen account but common to all of your output assets. Required for all Nielsen non-linear
         * watermarking.
         * 
         * @param sourceId
         *        Use the SID that Nielsen provides to you. This source ID should be unique to your Nielsen account but
         *        common to all of your output assets. Required for all Nielsen non-linear watermarking. This ID should
         *        be unique to your Nielsen account but common to all of your output assets. Required for all Nielsen
         *        non-linear watermarking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceId(Integer sourceId);

        /**
         * Required. Specify whether your source content already contains Nielsen non-linear watermarks. When you set
         * this value to Watermarked (WATERMARKED), the service fails the job. Nielsen requires that you add non-linear
         * watermarking to only clean content that doesn't already have non-linear Nielsen watermarks.
         * 
         * @param sourceWatermarkStatus
         *        Required. Specify whether your source content already contains Nielsen non-linear watermarks. When you
         *        set this value to Watermarked (WATERMARKED), the service fails the job. Nielsen requires that you add
         *        non-linear watermarking to only clean content that doesn't already have non-linear Nielsen watermarks.
         * @see NielsenSourceWatermarkStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NielsenSourceWatermarkStatusType
         */
        Builder sourceWatermarkStatus(String sourceWatermarkStatus);

        /**
         * Required. Specify whether your source content already contains Nielsen non-linear watermarks. When you set
         * this value to Watermarked (WATERMARKED), the service fails the job. Nielsen requires that you add non-linear
         * watermarking to only clean content that doesn't already have non-linear Nielsen watermarks.
         * 
         * @param sourceWatermarkStatus
         *        Required. Specify whether your source content already contains Nielsen non-linear watermarks. When you
         *        set this value to Watermarked (WATERMARKED), the service fails the job. Nielsen requires that you add
         *        non-linear watermarking to only clean content that doesn't already have non-linear Nielsen watermarks.
         * @see NielsenSourceWatermarkStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NielsenSourceWatermarkStatusType
         */
        Builder sourceWatermarkStatus(NielsenSourceWatermarkStatusType sourceWatermarkStatus);

        /**
         * Specify the endpoint for the TIC server that you have deployed and configured in the AWS Cloud. Required for
         * all Nielsen non-linear watermarking. MediaConvert can't connect directly to a TIC server. Instead, you must
         * use API Gateway to provide a RESTful interface between MediaConvert and a TIC server that you deploy in your
         * AWS account. For more information on deploying a TIC server in your AWS account and the required API Gateway,
         * contact Nielsen support.
         * 
         * @param ticServerUrl
         *        Specify the endpoint for the TIC server that you have deployed and configured in the AWS Cloud.
         *        Required for all Nielsen non-linear watermarking. MediaConvert can't connect directly to a TIC server.
         *        Instead, you must use API Gateway to provide a RESTful interface between MediaConvert and a TIC server
         *        that you deploy in your AWS account. For more information on deploying a TIC server in your AWS
         *        account and the required API Gateway, contact Nielsen support.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ticServerUrl(String ticServerUrl);

        /**
         * To create assets that have the same TIC values in each audio track, keep the default value Share TICs
         * (SAME_TICS_PER_TRACK). To create assets that have unique TIC values for each audio track, choose Use unique
         * TICs (RESERVE_UNIQUE_TICS_PER_TRACK).
         * 
         * @param uniqueTicPerAudioTrack
         *        To create assets that have the same TIC values in each audio track, keep the default value Share TICs
         *        (SAME_TICS_PER_TRACK). To create assets that have unique TIC values for each audio track, choose Use
         *        unique TICs (RESERVE_UNIQUE_TICS_PER_TRACK).
         * @see NielsenUniqueTicPerAudioTrackType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NielsenUniqueTicPerAudioTrackType
         */
        Builder uniqueTicPerAudioTrack(String uniqueTicPerAudioTrack);

        /**
         * To create assets that have the same TIC values in each audio track, keep the default value Share TICs
         * (SAME_TICS_PER_TRACK). To create assets that have unique TIC values for each audio track, choose Use unique
         * TICs (RESERVE_UNIQUE_TICS_PER_TRACK).
         * 
         * @param uniqueTicPerAudioTrack
         *        To create assets that have the same TIC values in each audio track, keep the default value Share TICs
         *        (SAME_TICS_PER_TRACK). To create assets that have unique TIC values for each audio track, choose Use
         *        unique TICs (RESERVE_UNIQUE_TICS_PER_TRACK).
         * @see NielsenUniqueTicPerAudioTrackType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NielsenUniqueTicPerAudioTrackType
         */
        Builder uniqueTicPerAudioTrack(NielsenUniqueTicPerAudioTrackType uniqueTicPerAudioTrack);
    }

    static final class BuilderImpl implements Builder {
        private String activeWatermarkProcess;

        private String adiFilename;

        private String assetId;

        private String assetName;

        private String cbetSourceId;

        private String episodeId;

        private String metadataDestination;

        private Integer sourceId;

        private String sourceWatermarkStatus;

        private String ticServerUrl;

        private String uniqueTicPerAudioTrack;

        private BuilderImpl() {
        }

        private BuilderImpl(NielsenNonLinearWatermarkSettings model) {
            activeWatermarkProcess(model.activeWatermarkProcess);
            adiFilename(model.adiFilename);
            assetId(model.assetId);
            assetName(model.assetName);
            cbetSourceId(model.cbetSourceId);
            episodeId(model.episodeId);
            metadataDestination(model.metadataDestination);
            sourceId(model.sourceId);
            sourceWatermarkStatus(model.sourceWatermarkStatus);
            ticServerUrl(model.ticServerUrl);
            uniqueTicPerAudioTrack(model.uniqueTicPerAudioTrack);
        }

        public final String getActiveWatermarkProcess() {
            return activeWatermarkProcess;
        }

        public final void setActiveWatermarkProcess(String activeWatermarkProcess) {
            this.activeWatermarkProcess = activeWatermarkProcess;
        }

        @Override
        public final Builder activeWatermarkProcess(String activeWatermarkProcess) {
            this.activeWatermarkProcess = activeWatermarkProcess;
            return this;
        }

        @Override
        public final Builder activeWatermarkProcess(NielsenActiveWatermarkProcessType activeWatermarkProcess) {
            this.activeWatermarkProcess(activeWatermarkProcess == null ? null : activeWatermarkProcess.toString());
            return this;
        }

        public final String getAdiFilename() {
            return adiFilename;
        }

        public final void setAdiFilename(String adiFilename) {
            this.adiFilename = adiFilename;
        }

        @Override
        public final Builder adiFilename(String adiFilename) {
            this.adiFilename = adiFilename;
            return this;
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getAssetName() {
            return assetName;
        }

        public final void setAssetName(String assetName) {
            this.assetName = assetName;
        }

        @Override
        public final Builder assetName(String assetName) {
            this.assetName = assetName;
            return this;
        }

        public final String getCbetSourceId() {
            return cbetSourceId;
        }

        public final void setCbetSourceId(String cbetSourceId) {
            this.cbetSourceId = cbetSourceId;
        }

        @Override
        public final Builder cbetSourceId(String cbetSourceId) {
            this.cbetSourceId = cbetSourceId;
            return this;
        }

        public final String getEpisodeId() {
            return episodeId;
        }

        public final void setEpisodeId(String episodeId) {
            this.episodeId = episodeId;
        }

        @Override
        public final Builder episodeId(String episodeId) {
            this.episodeId = episodeId;
            return this;
        }

        public final String getMetadataDestination() {
            return metadataDestination;
        }

        public final void setMetadataDestination(String metadataDestination) {
            this.metadataDestination = metadataDestination;
        }

        @Override
        public final Builder metadataDestination(String metadataDestination) {
            this.metadataDestination = metadataDestination;
            return this;
        }

        public final Integer getSourceId() {
            return sourceId;
        }

        public final void setSourceId(Integer sourceId) {
            this.sourceId = sourceId;
        }

        @Override
        public final Builder sourceId(Integer sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public final String getSourceWatermarkStatus() {
            return sourceWatermarkStatus;
        }

        public final void setSourceWatermarkStatus(String sourceWatermarkStatus) {
            this.sourceWatermarkStatus = sourceWatermarkStatus;
        }

        @Override
        public final Builder sourceWatermarkStatus(String sourceWatermarkStatus) {
            this.sourceWatermarkStatus = sourceWatermarkStatus;
            return this;
        }

        @Override
        public final Builder sourceWatermarkStatus(NielsenSourceWatermarkStatusType sourceWatermarkStatus) {
            this.sourceWatermarkStatus(sourceWatermarkStatus == null ? null : sourceWatermarkStatus.toString());
            return this;
        }

        public final String getTicServerUrl() {
            return ticServerUrl;
        }

        public final void setTicServerUrl(String ticServerUrl) {
            this.ticServerUrl = ticServerUrl;
        }

        @Override
        public final Builder ticServerUrl(String ticServerUrl) {
            this.ticServerUrl = ticServerUrl;
            return this;
        }

        public final String getUniqueTicPerAudioTrack() {
            return uniqueTicPerAudioTrack;
        }

        public final void setUniqueTicPerAudioTrack(String uniqueTicPerAudioTrack) {
            this.uniqueTicPerAudioTrack = uniqueTicPerAudioTrack;
        }

        @Override
        public final Builder uniqueTicPerAudioTrack(String uniqueTicPerAudioTrack) {
            this.uniqueTicPerAudioTrack = uniqueTicPerAudioTrack;
            return this;
        }

        @Override
        public final Builder uniqueTicPerAudioTrack(NielsenUniqueTicPerAudioTrackType uniqueTicPerAudioTrack) {
            this.uniqueTicPerAudioTrack(uniqueTicPerAudioTrack == null ? null : uniqueTicPerAudioTrack.toString());
            return this;
        }

        @Override
        public NielsenNonLinearWatermarkSettings build() {
            return new NielsenNonLinearWatermarkSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
