/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * To add an InbandEventStream element in your output MPD manifest for each type of event message, set Manifest metadata
 * signaling to Enabled. For ID3 event messages, the InbandEventStream element schemeIdUri will be same value that you
 * specify for ID3 metadata scheme ID URI. For SCTE35 event messages, the InbandEventStream element schemeIdUri will be
 * "urn:scte:scte35:2013:bin". To leave these elements out of your output MPD manifest, set Manifest metadata signaling
 * to Disabled. To enable Manifest metadata signaling, you must also set SCTE-35 source to Passthrough, ESAM SCTE-35 to
 * insert, or ID3 metadata (TimedMetadata) to Passthrough.
 */
@Generated("software.amazon.awssdk:codegen")
public enum MpdManifestMetadataSignaling {
    ENABLED("ENABLED"),

    DISABLED("DISABLED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MpdManifestMetadataSignaling> VALUE_MAP = EnumUtils.uniqueIndex(
            MpdManifestMetadataSignaling.class, MpdManifestMetadataSignaling::toString);

    private final String value;

    private MpdManifestMetadataSignaling(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return MpdManifestMetadataSignaling corresponding to the value
     */
    public static MpdManifestMetadataSignaling fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link MpdManifestMetadataSignaling}s
     */
    public static Set<MpdManifestMetadataSignaling> knownValues() {
        Set<MpdManifestMetadataSignaling> knownValues = EnumSet.allOf(MpdManifestMetadataSignaling.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
