/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Use this setting only in DASH output groups that include sidecar TTML or IMSC captions. You specify sidecar captions
 * in a separate output from your audio and video. Choose Raw (RAW) for captions in a single XML file in a raw
 * container. Choose Fragmented MPEG-4 (FRAGMENTED_MP4) for captions in XML format contained within fragmented MP4
 * files. This set of fragmented MP4 files is separate from your video and audio fragmented MP4 files.
 */
@Generated("software.amazon.awssdk:codegen")
public enum MpdCaptionContainerType {
    RAW("RAW"),

    FRAGMENTED_MP4("FRAGMENTED_MP4"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MpdCaptionContainerType> VALUE_MAP = EnumUtils.uniqueIndex(MpdCaptionContainerType.class,
            MpdCaptionContainerType::toString);

    private final String value;

    private MpdCaptionContainerType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return MpdCaptionContainerType corresponding to the value
     */
    public static MpdCaptionContainerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link MpdCaptionContainerType}s
     */
    public static Set<MpdCaptionContainerType> knownValues() {
        Set<MpdCaptionContainerType> knownValues = EnumSet.allOf(MpdCaptionContainerType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
