/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value H_264.
 */
@Generated("software.amazon.awssdk:codegen")
public final class H264Settings implements SdkPojo, Serializable, ToCopyableBuilder<H264Settings.Builder, H264Settings> {
    private static final SdkField<String> ADAPTIVE_QUANTIZATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdaptiveQuantization").getter(getter(H264Settings::adaptiveQuantizationAsString))
            .setter(setter(Builder::adaptiveQuantization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adaptiveQuantization").build())
            .build();

    private static final SdkField<BandwidthReductionFilter> BANDWIDTH_REDUCTION_FILTER_FIELD = SdkField
            .<BandwidthReductionFilter> builder(MarshallingType.SDK_POJO).memberName("BandwidthReductionFilter")
            .getter(getter(H264Settings::bandwidthReductionFilter)).setter(setter(Builder::bandwidthReductionFilter))
            .constructor(BandwidthReductionFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bandwidthReductionFilter").build())
            .build();

    private static final SdkField<Integer> BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Bitrate").getter(getter(H264Settings::bitrate)).setter(setter(Builder::bitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()).build();

    private static final SdkField<String> CODEC_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodecLevel").getter(getter(H264Settings::codecLevelAsString)).setter(setter(Builder::codecLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecLevel").build()).build();

    private static final SdkField<String> CODEC_PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodecProfile").getter(getter(H264Settings::codecProfileAsString)).setter(setter(Builder::codecProfile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecProfile").build()).build();

    private static final SdkField<String> DYNAMIC_SUB_GOP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DynamicSubGop").getter(getter(H264Settings::dynamicSubGopAsString))
            .setter(setter(Builder::dynamicSubGop))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicSubGop").build()).build();

    private static final SdkField<String> ENTROPY_ENCODING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntropyEncoding").getter(getter(H264Settings::entropyEncodingAsString))
            .setter(setter(Builder::entropyEncoding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entropyEncoding").build()).build();

    private static final SdkField<String> FIELD_ENCODING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldEncoding").getter(getter(H264Settings::fieldEncodingAsString))
            .setter(setter(Builder::fieldEncoding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldEncoding").build()).build();

    private static final SdkField<String> FLICKER_ADAPTIVE_QUANTIZATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FlickerAdaptiveQuantization")
            .getter(getter(H264Settings::flickerAdaptiveQuantizationAsString))
            .setter(setter(Builder::flickerAdaptiveQuantization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flickerAdaptiveQuantization")
                    .build()).build();

    private static final SdkField<String> FRAMERATE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FramerateControl").getter(getter(H264Settings::framerateControlAsString))
            .setter(setter(Builder::framerateControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateControl").build()).build();

    private static final SdkField<String> FRAMERATE_CONVERSION_ALGORITHM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FramerateConversionAlgorithm")
            .getter(getter(H264Settings::framerateConversionAlgorithmAsString))
            .setter(setter(Builder::framerateConversionAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateConversionAlgorithm")
                    .build()).build();

    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateDenominator").getter(getter(H264Settings::framerateDenominator))
            .setter(setter(Builder::framerateDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build())
            .build();

    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FramerateNumerator").getter(getter(H264Settings::framerateNumerator))
            .setter(setter(Builder::framerateNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build())
            .build();

    private static final SdkField<String> GOP_B_REFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GopBReference").getter(getter(H264Settings::gopBReferenceAsString))
            .setter(setter(Builder::gopBReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopBReference").build()).build();

    private static final SdkField<Integer> GOP_CLOSED_CADENCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("GopClosedCadence").getter(getter(H264Settings::gopClosedCadence))
            .setter(setter(Builder::gopClosedCadence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopClosedCadence").build()).build();

    private static final SdkField<Double> GOP_SIZE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("GopSize").getter(getter(H264Settings::gopSize)).setter(setter(Builder::gopSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSize").build()).build();

    private static final SdkField<String> GOP_SIZE_UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GopSizeUnits").getter(getter(H264Settings::gopSizeUnitsAsString)).setter(setter(Builder::gopSizeUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSizeUnits").build()).build();

    private static final SdkField<Integer> HRD_BUFFER_FINAL_FILL_PERCENTAGE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("HrdBufferFinalFillPercentage")
            .getter(getter(H264Settings::hrdBufferFinalFillPercentage))
            .setter(setter(Builder::hrdBufferFinalFillPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hrdBufferFinalFillPercentage")
                    .build()).build();

    private static final SdkField<Integer> HRD_BUFFER_INITIAL_FILL_PERCENTAGE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("HrdBufferInitialFillPercentage")
            .getter(getter(H264Settings::hrdBufferInitialFillPercentage))
            .setter(setter(Builder::hrdBufferInitialFillPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hrdBufferInitialFillPercentage")
                    .build()).build();

    private static final SdkField<Integer> HRD_BUFFER_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HrdBufferSize").getter(getter(H264Settings::hrdBufferSize)).setter(setter(Builder::hrdBufferSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hrdBufferSize").build()).build();

    private static final SdkField<String> INTERLACE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InterlaceMode").getter(getter(H264Settings::interlaceModeAsString))
            .setter(setter(Builder::interlaceMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interlaceMode").build()).build();

    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxBitrate").getter(getter(H264Settings::maxBitrate)).setter(setter(Builder::maxBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()).build();

    private static final SdkField<Integer> MIN_I_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinIInterval").getter(getter(H264Settings::minIInterval)).setter(setter(Builder::minIInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minIInterval").build()).build();

    private static final SdkField<Integer> NUMBER_B_FRAMES_BETWEEN_REFERENCE_FRAMES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberBFramesBetweenReferenceFrames")
            .getter(getter(H264Settings::numberBFramesBetweenReferenceFrames))
            .setter(setter(Builder::numberBFramesBetweenReferenceFrames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("numberBFramesBetweenReferenceFrames").build()).build();

    private static final SdkField<Integer> NUMBER_REFERENCE_FRAMES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberReferenceFrames").getter(getter(H264Settings::numberReferenceFrames))
            .setter(setter(Builder::numberReferenceFrames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberReferenceFrames").build())
            .build();

    private static final SdkField<String> PAR_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParControl").getter(getter(H264Settings::parControlAsString)).setter(setter(Builder::parControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parControl").build()).build();

    private static final SdkField<Integer> PAR_DENOMINATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ParDenominator").getter(getter(H264Settings::parDenominator)).setter(setter(Builder::parDenominator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parDenominator").build()).build();

    private static final SdkField<Integer> PAR_NUMERATOR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ParNumerator").getter(getter(H264Settings::parNumerator)).setter(setter(Builder::parNumerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parNumerator").build()).build();

    private static final SdkField<String> QUALITY_TUNING_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QualityTuningLevel").getter(getter(H264Settings::qualityTuningLevelAsString))
            .setter(setter(Builder::qualityTuningLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qualityTuningLevel").build())
            .build();

    private static final SdkField<H264QvbrSettings> QVBR_SETTINGS_FIELD = SdkField
            .<H264QvbrSettings> builder(MarshallingType.SDK_POJO).memberName("QvbrSettings")
            .getter(getter(H264Settings::qvbrSettings)).setter(setter(Builder::qvbrSettings))
            .constructor(H264QvbrSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qvbrSettings").build()).build();

    private static final SdkField<String> RATE_CONTROL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RateControlMode").getter(getter(H264Settings::rateControlModeAsString))
            .setter(setter(Builder::rateControlMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateControlMode").build()).build();

    private static final SdkField<String> REPEAT_PPS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepeatPps").getter(getter(H264Settings::repeatPpsAsString)).setter(setter(Builder::repeatPps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repeatPps").build()).build();

    private static final SdkField<String> SCAN_TYPE_CONVERSION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScanTypeConversionMode").getter(getter(H264Settings::scanTypeConversionModeAsString))
            .setter(setter(Builder::scanTypeConversionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanTypeConversionMode").build())
            .build();

    private static final SdkField<String> SCENE_CHANGE_DETECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SceneChangeDetect").getter(getter(H264Settings::sceneChangeDetectAsString))
            .setter(setter(Builder::sceneChangeDetect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneChangeDetect").build()).build();

    private static final SdkField<Integer> SLICES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Slices").getter(getter(H264Settings::slices)).setter(setter(Builder::slices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slices").build()).build();

    private static final SdkField<String> SLOW_PAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SlowPal").getter(getter(H264Settings::slowPalAsString)).setter(setter(Builder::slowPal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slowPal").build()).build();

    private static final SdkField<Integer> SOFTNESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Softness").getter(getter(H264Settings::softness)).setter(setter(Builder::softness))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softness").build()).build();

    private static final SdkField<String> SPATIAL_ADAPTIVE_QUANTIZATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SpatialAdaptiveQuantization")
            .getter(getter(H264Settings::spatialAdaptiveQuantizationAsString))
            .setter(setter(Builder::spatialAdaptiveQuantization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spatialAdaptiveQuantization")
                    .build()).build();

    private static final SdkField<String> SYNTAX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Syntax")
            .getter(getter(H264Settings::syntaxAsString)).setter(setter(Builder::syntax))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syntax").build()).build();

    private static final SdkField<String> TELECINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Telecine").getter(getter(H264Settings::telecineAsString)).setter(setter(Builder::telecine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telecine").build()).build();

    private static final SdkField<String> TEMPORAL_ADAPTIVE_QUANTIZATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TemporalAdaptiveQuantization")
            .getter(getter(H264Settings::temporalAdaptiveQuantizationAsString))
            .setter(setter(Builder::temporalAdaptiveQuantization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temporalAdaptiveQuantization")
                    .build()).build();

    private static final SdkField<String> UNREGISTERED_SEI_TIMECODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UnregisteredSeiTimecode").getter(getter(H264Settings::unregisteredSeiTimecodeAsString))
            .setter(setter(Builder::unregisteredSeiTimecode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unregisteredSeiTimecode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTIVE_QUANTIZATION_FIELD,
            BANDWIDTH_REDUCTION_FILTER_FIELD, BITRATE_FIELD, CODEC_LEVEL_FIELD, CODEC_PROFILE_FIELD, DYNAMIC_SUB_GOP_FIELD,
            ENTROPY_ENCODING_FIELD, FIELD_ENCODING_FIELD, FLICKER_ADAPTIVE_QUANTIZATION_FIELD, FRAMERATE_CONTROL_FIELD,
            FRAMERATE_CONVERSION_ALGORITHM_FIELD, FRAMERATE_DENOMINATOR_FIELD, FRAMERATE_NUMERATOR_FIELD, GOP_B_REFERENCE_FIELD,
            GOP_CLOSED_CADENCE_FIELD, GOP_SIZE_FIELD, GOP_SIZE_UNITS_FIELD, HRD_BUFFER_FINAL_FILL_PERCENTAGE_FIELD,
            HRD_BUFFER_INITIAL_FILL_PERCENTAGE_FIELD, HRD_BUFFER_SIZE_FIELD, INTERLACE_MODE_FIELD, MAX_BITRATE_FIELD,
            MIN_I_INTERVAL_FIELD, NUMBER_B_FRAMES_BETWEEN_REFERENCE_FRAMES_FIELD, NUMBER_REFERENCE_FRAMES_FIELD,
            PAR_CONTROL_FIELD, PAR_DENOMINATOR_FIELD, PAR_NUMERATOR_FIELD, QUALITY_TUNING_LEVEL_FIELD, QVBR_SETTINGS_FIELD,
            RATE_CONTROL_MODE_FIELD, REPEAT_PPS_FIELD, SCAN_TYPE_CONVERSION_MODE_FIELD, SCENE_CHANGE_DETECT_FIELD, SLICES_FIELD,
            SLOW_PAL_FIELD, SOFTNESS_FIELD, SPATIAL_ADAPTIVE_QUANTIZATION_FIELD, SYNTAX_FIELD, TELECINE_FIELD,
            TEMPORAL_ADAPTIVE_QUANTIZATION_FIELD, UNREGISTERED_SEI_TIMECODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String adaptiveQuantization;

    private final BandwidthReductionFilter bandwidthReductionFilter;

    private final Integer bitrate;

    private final String codecLevel;

    private final String codecProfile;

    private final String dynamicSubGop;

    private final String entropyEncoding;

    private final String fieldEncoding;

    private final String flickerAdaptiveQuantization;

    private final String framerateControl;

    private final String framerateConversionAlgorithm;

    private final Integer framerateDenominator;

    private final Integer framerateNumerator;

    private final String gopBReference;

    private final Integer gopClosedCadence;

    private final Double gopSize;

    private final String gopSizeUnits;

    private final Integer hrdBufferFinalFillPercentage;

    private final Integer hrdBufferInitialFillPercentage;

    private final Integer hrdBufferSize;

    private final String interlaceMode;

    private final Integer maxBitrate;

    private final Integer minIInterval;

    private final Integer numberBFramesBetweenReferenceFrames;

    private final Integer numberReferenceFrames;

    private final String parControl;

    private final Integer parDenominator;

    private final Integer parNumerator;

    private final String qualityTuningLevel;

    private final H264QvbrSettings qvbrSettings;

    private final String rateControlMode;

    private final String repeatPps;

    private final String scanTypeConversionMode;

    private final String sceneChangeDetect;

    private final Integer slices;

    private final String slowPal;

    private final Integer softness;

    private final String spatialAdaptiveQuantization;

    private final String syntax;

    private final String telecine;

    private final String temporalAdaptiveQuantization;

    private final String unregisteredSeiTimecode;

    private H264Settings(BuilderImpl builder) {
        this.adaptiveQuantization = builder.adaptiveQuantization;
        this.bandwidthReductionFilter = builder.bandwidthReductionFilter;
        this.bitrate = builder.bitrate;
        this.codecLevel = builder.codecLevel;
        this.codecProfile = builder.codecProfile;
        this.dynamicSubGop = builder.dynamicSubGop;
        this.entropyEncoding = builder.entropyEncoding;
        this.fieldEncoding = builder.fieldEncoding;
        this.flickerAdaptiveQuantization = builder.flickerAdaptiveQuantization;
        this.framerateControl = builder.framerateControl;
        this.framerateConversionAlgorithm = builder.framerateConversionAlgorithm;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.gopBReference = builder.gopBReference;
        this.gopClosedCadence = builder.gopClosedCadence;
        this.gopSize = builder.gopSize;
        this.gopSizeUnits = builder.gopSizeUnits;
        this.hrdBufferFinalFillPercentage = builder.hrdBufferFinalFillPercentage;
        this.hrdBufferInitialFillPercentage = builder.hrdBufferInitialFillPercentage;
        this.hrdBufferSize = builder.hrdBufferSize;
        this.interlaceMode = builder.interlaceMode;
        this.maxBitrate = builder.maxBitrate;
        this.minIInterval = builder.minIInterval;
        this.numberBFramesBetweenReferenceFrames = builder.numberBFramesBetweenReferenceFrames;
        this.numberReferenceFrames = builder.numberReferenceFrames;
        this.parControl = builder.parControl;
        this.parDenominator = builder.parDenominator;
        this.parNumerator = builder.parNumerator;
        this.qualityTuningLevel = builder.qualityTuningLevel;
        this.qvbrSettings = builder.qvbrSettings;
        this.rateControlMode = builder.rateControlMode;
        this.repeatPps = builder.repeatPps;
        this.scanTypeConversionMode = builder.scanTypeConversionMode;
        this.sceneChangeDetect = builder.sceneChangeDetect;
        this.slices = builder.slices;
        this.slowPal = builder.slowPal;
        this.softness = builder.softness;
        this.spatialAdaptiveQuantization = builder.spatialAdaptiveQuantization;
        this.syntax = builder.syntax;
        this.telecine = builder.telecine;
        this.temporalAdaptiveQuantization = builder.temporalAdaptiveQuantization;
        this.unregisteredSeiTimecode = builder.unregisteredSeiTimecode;
    }

    /**
     * Keep the default value, Auto (AUTO), for this setting to have MediaConvert automatically apply the best types of
     * quantization for your video content. When you want to apply your quantization settings manually, you must set
     * H264AdaptiveQuantization to a value other than Auto (AUTO). Use this setting to specify the strength of any
     * adaptive quantization filters that you enable. If you don't want MediaConvert to do any adaptive quantization in
     * this transcode, set Adaptive quantization (H264AdaptiveQuantization) to Off (OFF). Related settings: The value
     * that you choose here applies to the following settings: H264FlickerAdaptiveQuantization,
     * H264SpatialAdaptiveQuantization, and H264TemporalAdaptiveQuantization.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #adaptiveQuantization} will return {@link H264AdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #adaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Keep the default value, Auto (AUTO), for this setting to have MediaConvert automatically apply the best
     *         types of quantization for your video content. When you want to apply your quantization settings manually,
     *         you must set H264AdaptiveQuantization to a value other than Auto (AUTO). Use this setting to specify the
     *         strength of any adaptive quantization filters that you enable. If you don't want MediaConvert to do any
     *         adaptive quantization in this transcode, set Adaptive quantization (H264AdaptiveQuantization) to Off
     *         (OFF). Related settings: The value that you choose here applies to the following settings:
     *         H264FlickerAdaptiveQuantization, H264SpatialAdaptiveQuantization, and H264TemporalAdaptiveQuantization.
     * @see H264AdaptiveQuantization
     */
    public final H264AdaptiveQuantization adaptiveQuantization() {
        return H264AdaptiveQuantization.fromValue(adaptiveQuantization);
    }

    /**
     * Keep the default value, Auto (AUTO), for this setting to have MediaConvert automatically apply the best types of
     * quantization for your video content. When you want to apply your quantization settings manually, you must set
     * H264AdaptiveQuantization to a value other than Auto (AUTO). Use this setting to specify the strength of any
     * adaptive quantization filters that you enable. If you don't want MediaConvert to do any adaptive quantization in
     * this transcode, set Adaptive quantization (H264AdaptiveQuantization) to Off (OFF). Related settings: The value
     * that you choose here applies to the following settings: H264FlickerAdaptiveQuantization,
     * H264SpatialAdaptiveQuantization, and H264TemporalAdaptiveQuantization.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #adaptiveQuantization} will return {@link H264AdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #adaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Keep the default value, Auto (AUTO), for this setting to have MediaConvert automatically apply the best
     *         types of quantization for your video content. When you want to apply your quantization settings manually,
     *         you must set H264AdaptiveQuantization to a value other than Auto (AUTO). Use this setting to specify the
     *         strength of any adaptive quantization filters that you enable. If you don't want MediaConvert to do any
     *         adaptive quantization in this transcode, set Adaptive quantization (H264AdaptiveQuantization) to Off
     *         (OFF). Related settings: The value that you choose here applies to the following settings:
     *         H264FlickerAdaptiveQuantization, H264SpatialAdaptiveQuantization, and H264TemporalAdaptiveQuantization.
     * @see H264AdaptiveQuantization
     */
    public final String adaptiveQuantizationAsString() {
        return adaptiveQuantization;
    }

    /**
     * The Bandwidth reduction filter increases the video quality of your output relative to its bitrate. Use to lower
     * the bitrate of your constant quality QVBR output, with little or no perceptual decrease in quality. Or, use to
     * increase the video quality of outputs with other rate control modes relative to the bitrate that you specify.
     * Bandwidth reduction increases further when your input is low quality or noisy. Outputs that use this feature
     * incur pro-tier pricing. When you include Bandwidth reduction filter, you cannot include the Noise reducer
     * preprocessor.
     * 
     * @return The Bandwidth reduction filter increases the video quality of your output relative to its bitrate. Use to
     *         lower the bitrate of your constant quality QVBR output, with little or no perceptual decrease in quality.
     *         Or, use to increase the video quality of outputs with other rate control modes relative to the bitrate
     *         that you specify. Bandwidth reduction increases further when your input is low quality or noisy. Outputs
     *         that use this feature incur pro-tier pricing. When you include Bandwidth reduction filter, you cannot
     *         include the Noise reducer preprocessor.
     */
    public final BandwidthReductionFilter bandwidthReductionFilter() {
        return bandwidthReductionFilter;
    }

    /**
     * Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates must be
     * unique when rounded down to the nearest multiple of 1000.
     * 
     * @return Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates
     *         must be unique when rounded down to the nearest multiple of 1000.
     */
    public final Integer bitrate() {
        return bitrate;
    }

    /**
     * Specify an H.264 level that is consistent with your output video settings. If you aren't sure what level to
     * specify, choose Auto (AUTO).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codecLevel} will
     * return {@link H264CodecLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecLevelAsString}.
     * </p>
     * 
     * @return Specify an H.264 level that is consistent with your output video settings. If you aren't sure what level
     *         to specify, choose Auto (AUTO).
     * @see H264CodecLevel
     */
    public final H264CodecLevel codecLevel() {
        return H264CodecLevel.fromValue(codecLevel);
    }

    /**
     * Specify an H.264 level that is consistent with your output video settings. If you aren't sure what level to
     * specify, choose Auto (AUTO).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codecLevel} will
     * return {@link H264CodecLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecLevelAsString}.
     * </p>
     * 
     * @return Specify an H.264 level that is consistent with your output video settings. If you aren't sure what level
     *         to specify, choose Auto (AUTO).
     * @see H264CodecLevel
     */
    public final String codecLevelAsString() {
        return codecLevel;
    }

    /**
     * H.264 Profile. High 4:2:2 and 10-bit profiles are only available with the AVC-I License.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codecProfile} will
     * return {@link H264CodecProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecProfileAsString}.
     * </p>
     * 
     * @return H.264 Profile. High 4:2:2 and 10-bit profiles are only available with the AVC-I License.
     * @see H264CodecProfile
     */
    public final H264CodecProfile codecProfile() {
        return H264CodecProfile.fromValue(codecProfile);
    }

    /**
     * H.264 Profile. High 4:2:2 and 10-bit profiles are only available with the AVC-I License.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codecProfile} will
     * return {@link H264CodecProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecProfileAsString}.
     * </p>
     * 
     * @return H.264 Profile. High 4:2:2 and 10-bit profiles are only available with the AVC-I License.
     * @see H264CodecProfile
     */
    public final String codecProfileAsString() {
        return codecProfile;
    }

    /**
     * Specify whether to allow the number of B-frames in your output GOP structure to vary or not depending on your
     * input video content. To improve the subjective video quality of your output that has high-motion content: Leave
     * blank or keep the default value Adaptive. MediaConvert will use fewer B-frames for high-motion video content than
     * low-motion content. The maximum number of B- frames is limited by the value that you choose for B-frames between
     * reference frames. To use the same number B-frames for all types of content: Choose Static.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dynamicSubGop}
     * will return {@link H264DynamicSubGop#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dynamicSubGopAsString}.
     * </p>
     * 
     * @return Specify whether to allow the number of B-frames in your output GOP structure to vary or not depending on
     *         your input video content. To improve the subjective video quality of your output that has high-motion
     *         content: Leave blank or keep the default value Adaptive. MediaConvert will use fewer B-frames for
     *         high-motion video content than low-motion content. The maximum number of B- frames is limited by the
     *         value that you choose for B-frames between reference frames. To use the same number B-frames for all
     *         types of content: Choose Static.
     * @see H264DynamicSubGop
     */
    public final H264DynamicSubGop dynamicSubGop() {
        return H264DynamicSubGop.fromValue(dynamicSubGop);
    }

    /**
     * Specify whether to allow the number of B-frames in your output GOP structure to vary or not depending on your
     * input video content. To improve the subjective video quality of your output that has high-motion content: Leave
     * blank or keep the default value Adaptive. MediaConvert will use fewer B-frames for high-motion video content than
     * low-motion content. The maximum number of B- frames is limited by the value that you choose for B-frames between
     * reference frames. To use the same number B-frames for all types of content: Choose Static.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dynamicSubGop}
     * will return {@link H264DynamicSubGop#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dynamicSubGopAsString}.
     * </p>
     * 
     * @return Specify whether to allow the number of B-frames in your output GOP structure to vary or not depending on
     *         your input video content. To improve the subjective video quality of your output that has high-motion
     *         content: Leave blank or keep the default value Adaptive. MediaConvert will use fewer B-frames for
     *         high-motion video content than low-motion content. The maximum number of B- frames is limited by the
     *         value that you choose for B-frames between reference frames. To use the same number B-frames for all
     *         types of content: Choose Static.
     * @see H264DynamicSubGop
     */
    public final String dynamicSubGopAsString() {
        return dynamicSubGop;
    }

    /**
     * Entropy encoding mode. Use CABAC (must be in Main or High profile) or CAVLC.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entropyEncoding}
     * will return {@link H264EntropyEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #entropyEncodingAsString}.
     * </p>
     * 
     * @return Entropy encoding mode. Use CABAC (must be in Main or High profile) or CAVLC.
     * @see H264EntropyEncoding
     */
    public final H264EntropyEncoding entropyEncoding() {
        return H264EntropyEncoding.fromValue(entropyEncoding);
    }

    /**
     * Entropy encoding mode. Use CABAC (must be in Main or High profile) or CAVLC.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entropyEncoding}
     * will return {@link H264EntropyEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #entropyEncodingAsString}.
     * </p>
     * 
     * @return Entropy encoding mode. Use CABAC (must be in Main or High profile) or CAVLC.
     * @see H264EntropyEncoding
     */
    public final String entropyEncodingAsString() {
        return entropyEncoding;
    }

    /**
     * The video encoding method for your MPEG-4 AVC output. Keep the default value, PAFF, to have MediaConvert use PAFF
     * encoding for interlaced outputs. Choose Force field (FORCE_FIELD) to disable PAFF encoding and create separate
     * interlaced fields. Choose MBAFF to disable PAFF and have MediaConvert use MBAFF encoding for interlaced outputs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldEncoding}
     * will return {@link H264FieldEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fieldEncodingAsString}.
     * </p>
     * 
     * @return The video encoding method for your MPEG-4 AVC output. Keep the default value, PAFF, to have MediaConvert
     *         use PAFF encoding for interlaced outputs. Choose Force field (FORCE_FIELD) to disable PAFF encoding and
     *         create separate interlaced fields. Choose MBAFF to disable PAFF and have MediaConvert use MBAFF encoding
     *         for interlaced outputs.
     * @see H264FieldEncoding
     */
    public final H264FieldEncoding fieldEncoding() {
        return H264FieldEncoding.fromValue(fieldEncoding);
    }

    /**
     * The video encoding method for your MPEG-4 AVC output. Keep the default value, PAFF, to have MediaConvert use PAFF
     * encoding for interlaced outputs. Choose Force field (FORCE_FIELD) to disable PAFF encoding and create separate
     * interlaced fields. Choose MBAFF to disable PAFF and have MediaConvert use MBAFF encoding for interlaced outputs.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldEncoding}
     * will return {@link H264FieldEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fieldEncodingAsString}.
     * </p>
     * 
     * @return The video encoding method for your MPEG-4 AVC output. Keep the default value, PAFF, to have MediaConvert
     *         use PAFF encoding for interlaced outputs. Choose Force field (FORCE_FIELD) to disable PAFF encoding and
     *         create separate interlaced fields. Choose MBAFF to disable PAFF and have MediaConvert use MBAFF encoding
     *         for interlaced outputs.
     * @see H264FieldEncoding
     */
    public final String fieldEncodingAsString() {
        return fieldEncoding;
    }

    /**
     * Only use this setting when you change the default value, AUTO, for the setting H264AdaptiveQuantization. When you
     * keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON job
     * specification, MediaConvert automatically applies the best types of quantization for your video content. When you
     * set H264AdaptiveQuantization to a value other than AUTO, the default value for H264FlickerAdaptiveQuantization is
     * Disabled (DISABLED). Change this value to Enabled (ENABLED) to reduce I-frame pop. I-frame pop appears as a
     * visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to
     * frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these
     * macroblocks slightly more often to smooth out the flicker. To manually enable or disable
     * H264FlickerAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a value other
     * than AUTO.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #flickerAdaptiveQuantization} will return {@link H264FlickerAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #flickerAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Only use this setting when you change the default value, AUTO, for the setting H264AdaptiveQuantization.
     *         When you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from
     *         your JSON job specification, MediaConvert automatically applies the best types of quantization for your
     *         video content. When you set H264AdaptiveQuantization to a value other than AUTO, the default value for
     *         H264FlickerAdaptiveQuantization is Disabled (DISABLED). Change this value to Enabled (ENABLED) to reduce
     *         I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by
     *         copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you
     *         enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker.
     *         To manually enable or disable H264FlickerAdaptiveQuantization, you must set Adaptive quantization
     *         (H264AdaptiveQuantization) to a value other than AUTO.
     * @see H264FlickerAdaptiveQuantization
     */
    public final H264FlickerAdaptiveQuantization flickerAdaptiveQuantization() {
        return H264FlickerAdaptiveQuantization.fromValue(flickerAdaptiveQuantization);
    }

    /**
     * Only use this setting when you change the default value, AUTO, for the setting H264AdaptiveQuantization. When you
     * keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON job
     * specification, MediaConvert automatically applies the best types of quantization for your video content. When you
     * set H264AdaptiveQuantization to a value other than AUTO, the default value for H264FlickerAdaptiveQuantization is
     * Disabled (DISABLED). Change this value to Enabled (ENABLED) to reduce I-frame pop. I-frame pop appears as a
     * visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to
     * frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these
     * macroblocks slightly more often to smooth out the flicker. To manually enable or disable
     * H264FlickerAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a value other
     * than AUTO.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #flickerAdaptiveQuantization} will return {@link H264FlickerAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #flickerAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Only use this setting when you change the default value, AUTO, for the setting H264AdaptiveQuantization.
     *         When you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from
     *         your JSON job specification, MediaConvert automatically applies the best types of quantization for your
     *         video content. When you set H264AdaptiveQuantization to a value other than AUTO, the default value for
     *         H264FlickerAdaptiveQuantization is Disabled (DISABLED). Change this value to Enabled (ENABLED) to reduce
     *         I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by
     *         copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you
     *         enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker.
     *         To manually enable or disable H264FlickerAdaptiveQuantization, you must set Adaptive quantization
     *         (H264AdaptiveQuantization) to a value other than AUTO.
     * @see H264FlickerAdaptiveQuantization
     */
    public final String flickerAdaptiveQuantizationAsString() {
        return flickerAdaptiveQuantization;
    }

    /**
     * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to
     * keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion,
     * choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are
     * decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are
     * creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify
     * which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the
     * service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you
     * specify in the settings FramerateNumerator and FramerateDenominator.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framerateControl}
     * will return {@link H264FramerateControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateControlAsString}.
     * </p>
     * 
     * @return If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
     *         want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
     *         conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the
     *         dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a
     *         fraction. If you are creating your transcoding job specification as a JSON file without the console, use
     *         FramerateControl to specify which value the service uses for the frame rate for this output. Choose
     *         INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if
     *         you want the service to use the frame rate you specify in the settings FramerateNumerator and
     *         FramerateDenominator.
     * @see H264FramerateControl
     */
    public final H264FramerateControl framerateControl() {
        return H264FramerateControl.fromValue(framerateControl);
    }

    /**
     * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to
     * keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion,
     * choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are
     * decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are
     * creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify
     * which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the
     * service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you
     * specify in the settings FramerateNumerator and FramerateDenominator.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framerateControl}
     * will return {@link H264FramerateControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #framerateControlAsString}.
     * </p>
     * 
     * @return If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
     *         want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
     *         conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the
     *         dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a
     *         fraction. If you are creating your transcoding job specification as a JSON file without the console, use
     *         FramerateControl to specify which value the service uses for the frame rate for this output. Choose
     *         INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if
     *         you want the service to use the frame rate you specify in the settings FramerateNumerator and
     *         FramerateDenominator.
     * @see H264FramerateControl
     */
    public final String framerateControlAsString() {
        return framerateControl;
    }

    /**
     * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. For numerically
     * simple conversions, such as 60 fps to 30 fps: We recommend that you keep the default value, Drop duplicate. For
     * numerically complex conversions, to avoid stutter: Choose Interpolate. This results in a smooth picture, but
     * might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video
     * has already been converted from its original cadence: Choose FrameFormer to do motion-compensated interpolation.
     * FrameFormer uses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding
     * time and incurs a significant add-on cost. When you choose FrameFormer, your input video resolution must be at
     * least 128x96.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #framerateConversionAlgorithm} will return {@link H264FramerateConversionAlgorithm#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #framerateConversionAlgorithmAsString}.
     * </p>
     * 
     * @return Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. For
     *         numerically simple conversions, such as 60 fps to 30 fps: We recommend that you keep the default value,
     *         Drop duplicate. For numerically complex conversions, to avoid stutter: Choose Interpolate. This results
     *         in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions,
     *         especially if your source video has already been converted from its original cadence: Choose FrameFormer
     *         to do motion-compensated interpolation. FrameFormer uses the best conversion method frame by frame. Note
     *         that using FrameFormer increases the transcoding time and incurs a significant add-on cost. When you
     *         choose FrameFormer, your input video resolution must be at least 128x96.
     * @see H264FramerateConversionAlgorithm
     */
    public final H264FramerateConversionAlgorithm framerateConversionAlgorithm() {
        return H264FramerateConversionAlgorithm.fromValue(framerateConversionAlgorithm);
    }

    /**
     * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. For numerically
     * simple conversions, such as 60 fps to 30 fps: We recommend that you keep the default value, Drop duplicate. For
     * numerically complex conversions, to avoid stutter: Choose Interpolate. This results in a smooth picture, but
     * might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video
     * has already been converted from its original cadence: Choose FrameFormer to do motion-compensated interpolation.
     * FrameFormer uses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding
     * time and incurs a significant add-on cost. When you choose FrameFormer, your input video resolution must be at
     * least 128x96.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #framerateConversionAlgorithm} will return {@link H264FramerateConversionAlgorithm#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #framerateConversionAlgorithmAsString}.
     * </p>
     * 
     * @return Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. For
     *         numerically simple conversions, such as 60 fps to 30 fps: We recommend that you keep the default value,
     *         Drop duplicate. For numerically complex conversions, to avoid stutter: Choose Interpolate. This results
     *         in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions,
     *         especially if your source video has already been converted from its original cadence: Choose FrameFormer
     *         to do motion-compensated interpolation. FrameFormer uses the best conversion method frame by frame. Note
     *         that using FrameFormer increases the transcoding time and incurs a significant add-on cost. When you
     *         choose FrameFormer, your input video resolution must be at least 128x96.
     * @see H264FramerateConversionAlgorithm
     */
    public final String framerateConversionAlgorithmAsString() {
        return framerateConversionAlgorithm;
    }

    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For
     * example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this
     * example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use
     * frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     * 
     * @return When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
     *         fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of
     *         this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console
     *         for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate.
     *         In this example, specify 23.976.
     */
    public final Integer framerateDenominator() {
        return framerateDenominator;
    }

    /**
     * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For
     * example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this
     * example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use
     * frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
     * 
     * @return When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
     *         fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this
     *         fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for
     *         transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In
     *         this example, specify 23.976.
     */
    public final Integer framerateNumerator() {
        return framerateNumerator;
    }

    /**
     * Specify whether to allow B-frames to be referenced by other frame types. To use reference B-frames when your GOP
     * structure has 1 or more B-frames: Leave blank or keep the default value Enabled. We recommend that you choose
     * Enabled to help improve the video quality of your output relative to its bitrate. To not use reference B-frames:
     * Choose Disabled.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopBReference}
     * will return {@link H264GopBReference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #gopBReferenceAsString}.
     * </p>
     * 
     * @return Specify whether to allow B-frames to be referenced by other frame types. To use reference B-frames when
     *         your GOP structure has 1 or more B-frames: Leave blank or keep the default value Enabled. We recommend
     *         that you choose Enabled to help improve the video quality of your output relative to its bitrate. To not
     *         use reference B-frames: Choose Disabled.
     * @see H264GopBReference
     */
    public final H264GopBReference gopBReference() {
        return H264GopBReference.fromValue(gopBReference);
    }

    /**
     * Specify whether to allow B-frames to be referenced by other frame types. To use reference B-frames when your GOP
     * structure has 1 or more B-frames: Leave blank or keep the default value Enabled. We recommend that you choose
     * Enabled to help improve the video quality of your output relative to its bitrate. To not use reference B-frames:
     * Choose Disabled.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopBReference}
     * will return {@link H264GopBReference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #gopBReferenceAsString}.
     * </p>
     * 
     * @return Specify whether to allow B-frames to be referenced by other frame types. To use reference B-frames when
     *         your GOP structure has 1 or more B-frames: Leave blank or keep the default value Enabled. We recommend
     *         that you choose Enabled to help improve the video quality of your output relative to its bitrate. To not
     *         use reference B-frames: Choose Disabled.
     * @see H264GopBReference
     */
    public final String gopBReferenceAsString() {
        return gopBReference;
    }

    /**
     * Specify the relative frequency of open to closed GOPs in this output. For example, if you want to allow four open
     * GOPs and then require a closed GOP, set this value to 5. We recommend that you have the transcoder automatically
     * choose this value for you based on characteristics of your input video. To enable this automatic behavior, keep
     * the default value by leaving this setting out of your JSON job specification. In the console, do this by keeping
     * the default empty value. If you do explicitly specify a value, for segmented outputs, don't set this value to 0.
     * 
     * @return Specify the relative frequency of open to closed GOPs in this output. For example, if you want to allow
     *         four open GOPs and then require a closed GOP, set this value to 5. We recommend that you have the
     *         transcoder automatically choose this value for you based on characteristics of your input video. To
     *         enable this automatic behavior, keep the default value by leaving this setting out of your JSON job
     *         specification. In the console, do this by keeping the default empty value. If you do explicitly specify a
     *         value, for segmented outputs, don't set this value to 0.
     */
    public final Integer gopClosedCadence() {
        return gopClosedCadence;
    }

    /**
     * Use this setting only when you set GOP mode control (GopSizeUnits) to Specified, frames (FRAMES) or Specified,
     * seconds (SECONDS). Specify the GOP length using a whole number of frames or a decimal value of seconds.
     * MediaConvert will interpret this value as frames or seconds depending on the value you choose for GOP mode
     * control (GopSizeUnits). If you want to allow MediaConvert to automatically determine GOP size, leave GOP size
     * blank and set GOP mode control to Auto (AUTO). If your output group specifies HLS, DASH, or CMAF, leave GOP size
     * blank and set GOP mode control to Auto in each output in your output group.
     * 
     * @return Use this setting only when you set GOP mode control (GopSizeUnits) to Specified, frames (FRAMES) or
     *         Specified, seconds (SECONDS). Specify the GOP length using a whole number of frames or a decimal value of
     *         seconds. MediaConvert will interpret this value as frames or seconds depending on the value you choose
     *         for GOP mode control (GopSizeUnits). If you want to allow MediaConvert to automatically determine GOP
     *         size, leave GOP size blank and set GOP mode control to Auto (AUTO). If your output group specifies HLS,
     *         DASH, or CMAF, leave GOP size blank and set GOP mode control to Auto in each output in your output group.
     */
    public final Double gopSize() {
        return gopSize;
    }

    /**
     * Specify how the transcoder determines GOP size for this output. We recommend that you have the transcoder
     * automatically choose this value for you based on characteristics of your input video. To enable this automatic
     * behavior, choose Auto (AUTO) and and leave GOP size (GopSize) blank. By default, if you don't specify GOP mode
     * control (GopSizeUnits), MediaConvert will use automatic behavior. If your output group specifies HLS, DASH, or
     * CMAF, set GOP mode control to Auto and leave GOP size blank in each output in your output group. To explicitly
     * specify the GOP length, choose Specified, frames (FRAMES) or Specified, seconds (SECONDS) and then provide the
     * GOP length in the related setting GOP size (GopSize).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopSizeUnits} will
     * return {@link H264GopSizeUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gopSizeUnitsAsString}.
     * </p>
     * 
     * @return Specify how the transcoder determines GOP size for this output. We recommend that you have the transcoder
     *         automatically choose this value for you based on characteristics of your input video. To enable this
     *         automatic behavior, choose Auto (AUTO) and and leave GOP size (GopSize) blank. By default, if you don't
     *         specify GOP mode control (GopSizeUnits), MediaConvert will use automatic behavior. If your output group
     *         specifies HLS, DASH, or CMAF, set GOP mode control to Auto and leave GOP size blank in each output in
     *         your output group. To explicitly specify the GOP length, choose Specified, frames (FRAMES) or Specified,
     *         seconds (SECONDS) and then provide the GOP length in the related setting GOP size (GopSize).
     * @see H264GopSizeUnits
     */
    public final H264GopSizeUnits gopSizeUnits() {
        return H264GopSizeUnits.fromValue(gopSizeUnits);
    }

    /**
     * Specify how the transcoder determines GOP size for this output. We recommend that you have the transcoder
     * automatically choose this value for you based on characteristics of your input video. To enable this automatic
     * behavior, choose Auto (AUTO) and and leave GOP size (GopSize) blank. By default, if you don't specify GOP mode
     * control (GopSizeUnits), MediaConvert will use automatic behavior. If your output group specifies HLS, DASH, or
     * CMAF, set GOP mode control to Auto and leave GOP size blank in each output in your output group. To explicitly
     * specify the GOP length, choose Specified, frames (FRAMES) or Specified, seconds (SECONDS) and then provide the
     * GOP length in the related setting GOP size (GopSize).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopSizeUnits} will
     * return {@link H264GopSizeUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #gopSizeUnitsAsString}.
     * </p>
     * 
     * @return Specify how the transcoder determines GOP size for this output. We recommend that you have the transcoder
     *         automatically choose this value for you based on characteristics of your input video. To enable this
     *         automatic behavior, choose Auto (AUTO) and and leave GOP size (GopSize) blank. By default, if you don't
     *         specify GOP mode control (GopSizeUnits), MediaConvert will use automatic behavior. If your output group
     *         specifies HLS, DASH, or CMAF, set GOP mode control to Auto and leave GOP size blank in each output in
     *         your output group. To explicitly specify the GOP length, choose Specified, frames (FRAMES) or Specified,
     *         seconds (SECONDS) and then provide the GOP length in the related setting GOP size (GopSize).
     * @see H264GopSizeUnits
     */
    public final String gopSizeUnitsAsString() {
        return gopSizeUnits;
    }

    /**
     * If your downstream systems have strict buffer requirements: Specify the minimum percentage of the HRD buffer
     * that's available at the end of each encoded video segment. For the best video quality: Set to 0 or leave blank to
     * automatically determine the final buffer fill percentage.
     * 
     * @return If your downstream systems have strict buffer requirements: Specify the minimum percentage of the HRD
     *         buffer that's available at the end of each encoded video segment. For the best video quality: Set to 0 or
     *         leave blank to automatically determine the final buffer fill percentage.
     */
    public final Integer hrdBufferFinalFillPercentage() {
        return hrdBufferFinalFillPercentage;
    }

    /**
     * Percentage of the buffer that should initially be filled (HRD buffer model).
     * 
     * @return Percentage of the buffer that should initially be filled (HRD buffer model).
     */
    public final Integer hrdBufferInitialFillPercentage() {
        return hrdBufferInitialFillPercentage;
    }

    /**
     * Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
     * 
     * @return Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
     */
    public final Integer hrdBufferSize() {
        return hrdBufferSize;
    }

    /**
     * Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a
     * progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field
     * first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow,
     * default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same
     * field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the
     * course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output
     * will be interlaced with the same polarity as the source. If the source is progressive, the output will be
     * interlaced with top field bottom field first, depending on which of the Follow options you choose.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interlaceMode}
     * will return {@link H264InterlaceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interlaceModeAsString}.
     * </p>
     * 
     * @return Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a
     *         progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom
     *         field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout.
     *         Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce
     *         outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field
     *         polarity might change over the course of the output. Follow behavior depends on the input scan type. If
     *         the source is interlaced, the output will be interlaced with the same polarity as the source. If the
     *         source is progressive, the output will be interlaced with top field bottom field first, depending on
     *         which of the Follow options you choose.
     * @see H264InterlaceMode
     */
    public final H264InterlaceMode interlaceMode() {
        return H264InterlaceMode.fromValue(interlaceMode);
    }

    /**
     * Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a
     * progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field
     * first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow,
     * default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same
     * field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the
     * course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output
     * will be interlaced with the same polarity as the source. If the source is progressive, the output will be
     * interlaced with top field bottom field first, depending on which of the Follow options you choose.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #interlaceMode}
     * will return {@link H264InterlaceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #interlaceModeAsString}.
     * </p>
     * 
     * @return Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a
     *         progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom
     *         field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout.
     *         Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce
     *         outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field
     *         polarity might change over the course of the output. Follow behavior depends on the input scan type. If
     *         the source is interlaced, the output will be interlaced with the same polarity as the source. If the
     *         source is progressive, the output will be interlaced with top field bottom field first, depending on
     *         which of the Follow options you choose.
     * @see H264InterlaceMode
     */
    public final String interlaceModeAsString() {
        return interlaceMode;
    }

    /**
     * Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when Rate
     * control mode is QVBR.
     * 
     * @return Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when
     *         Rate control mode is QVBR.
     */
    public final Integer maxBitrate() {
        return maxBitrate;
    }

    /**
     * Use this setting only when you also enable Scene change detection (SceneChangeDetect). This setting determines
     * how the encoder manages the spacing between I-frames that it inserts as part of the I-frame cadence and the
     * I-frames that it inserts for Scene change detection. We recommend that you have the transcoder automatically
     * choose this value for you based on characteristics of your input video. To enable this automatic behavior, keep
     * the default value by leaving this setting out of your JSON job specification. In the console, do this by keeping
     * the default empty value. When you explicitly specify a value for this setting, the encoder determines whether to
     * skip a cadence-driven I-frame by the value you set. For example, if you set Min I interval (minIInterval) to 5
     * and a cadence-driven I-frame would fall within 5 frames of a scene-change I-frame, then the encoder skips the
     * cadence-driven I-frame. In this way, one GOP is shrunk slightly and one GOP is stretched slightly. When the
     * cadence-driven I-frames are farther from the scene-change I-frame than the value you set, then the encoder leaves
     * all I-frames in place and the GOPs surrounding the scene change are smaller than the usual cadence GOPs.
     * 
     * @return Use this setting only when you also enable Scene change detection (SceneChangeDetect). This setting
     *         determines how the encoder manages the spacing between I-frames that it inserts as part of the I-frame
     *         cadence and the I-frames that it inserts for Scene change detection. We recommend that you have the
     *         transcoder automatically choose this value for you based on characteristics of your input video. To
     *         enable this automatic behavior, keep the default value by leaving this setting out of your JSON job
     *         specification. In the console, do this by keeping the default empty value. When you explicitly specify a
     *         value for this setting, the encoder determines whether to skip a cadence-driven I-frame by the value you
     *         set. For example, if you set Min I interval (minIInterval) to 5 and a cadence-driven I-frame would fall
     *         within 5 frames of a scene-change I-frame, then the encoder skips the cadence-driven I-frame. In this
     *         way, one GOP is shrunk slightly and one GOP is stretched slightly. When the cadence-driven I-frames are
     *         farther from the scene-change I-frame than the value you set, then the encoder leaves all I-frames in
     *         place and the GOPs surrounding the scene change are smaller than the usual cadence GOPs.
     */
    public final Integer minIInterval() {
        return minIInterval;
    }

    /**
     * Specify the number of B-frames between reference frames in this output. For the best video quality: Leave blank.
     * MediaConvert automatically determines the number of B-frames to use based on the characteristics of your input
     * video. To manually specify the number of B-frames between reference frames: Enter an integer from 0 to 7.
     * 
     * @return Specify the number of B-frames between reference frames in this output. For the best video quality: Leave
     *         blank. MediaConvert automatically determines the number of B-frames to use based on the characteristics
     *         of your input video. To manually specify the number of B-frames between reference frames: Enter an
     *         integer from 0 to 7.
     */
    public final Integer numberBFramesBetweenReferenceFrames() {
        return numberBFramesBetweenReferenceFrames;
    }

    /**
     * Number of reference frames to use. The encoder may use more than requested if using B-frames and/or interlaced
     * encoding.
     * 
     * @return Number of reference frames to use. The encoder may use more than requested if using B-frames and/or
     *         interlaced encoding.
     */
    public final Integer numberReferenceFrames() {
        return numberReferenceFrames;
    }

    /**
     * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior,
     * Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a
     * different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing
     * the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify
     * values for the parNumerator and parDenominator settings.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parControl} will
     * return {@link H264ParControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parControlAsString}.
     * </p>
     * 
     * @return Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
     *         behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To
     *         specify a different PAR in the console, choose any value other than Follow source. To specify a different
     *         PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting,
     *         you must also specify values for the parNumerator and parDenominator settings.
     * @see H264ParControl
     */
    public final H264ParControl parControl() {
        return H264ParControl.fromValue(parControl);
    }

    /**
     * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior,
     * Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a
     * different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing
     * the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify
     * values for the parNumerator and parDenominator settings.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parControl} will
     * return {@link H264ParControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parControlAsString}.
     * </p>
     * 
     * @return Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
     *         behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To
     *         specify a different PAR in the console, choose any value other than Follow source. To specify a different
     *         PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting,
     *         you must also specify values for the parNumerator and parDenominator settings.
     * @see H264ParControl
     */
    public final String parControlAsString() {
        return parControl;
    }

    /**
     * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value
     * other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input
     * video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the
     * ratio 40:33. In this example, the value for parDenominator is 33.
     * 
     * @return Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to
     *         any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different
     *         from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen,
     *         you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
     */
    public final Integer parDenominator() {
        return parDenominator;
    }

    /**
     * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value
     * other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input
     * video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the
     * ratio 40:33. In this example, the value for parNumerator is 40.
     * 
     * @return Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to
     *         any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different
     *         from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen,
     *         you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
     */
    public final Integer parNumerator() {
        return parNumerator;
    }

    /**
     * The Quality tuning level you choose represents a trade-off between the encoding speed of your job and the output
     * video quality. For the fastest encoding speed at the cost of video quality: Choose Single pass. For a good
     * balance between encoding speed and video quality: Leave blank or keep the default value Single pass HQ. For the
     * best video quality, at the cost of encoding speed: Choose Multi pass HQ. MediaConvert performs an analysis pass
     * on your input followed by an encoding pass. Outputs that use this feature incur pro-tier pricing.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #qualityTuningLevel} will return {@link H264QualityTuningLevel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #qualityTuningLevelAsString}.
     * </p>
     * 
     * @return The Quality tuning level you choose represents a trade-off between the encoding speed of your job and the
     *         output video quality. For the fastest encoding speed at the cost of video quality: Choose Single pass.
     *         For a good balance between encoding speed and video quality: Leave blank or keep the default value Single
     *         pass HQ. For the best video quality, at the cost of encoding speed: Choose Multi pass HQ. MediaConvert
     *         performs an analysis pass on your input followed by an encoding pass. Outputs that use this feature incur
     *         pro-tier pricing.
     * @see H264QualityTuningLevel
     */
    public final H264QualityTuningLevel qualityTuningLevel() {
        return H264QualityTuningLevel.fromValue(qualityTuningLevel);
    }

    /**
     * The Quality tuning level you choose represents a trade-off between the encoding speed of your job and the output
     * video quality. For the fastest encoding speed at the cost of video quality: Choose Single pass. For a good
     * balance between encoding speed and video quality: Leave blank or keep the default value Single pass HQ. For the
     * best video quality, at the cost of encoding speed: Choose Multi pass HQ. MediaConvert performs an analysis pass
     * on your input followed by an encoding pass. Outputs that use this feature incur pro-tier pricing.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #qualityTuningLevel} will return {@link H264QualityTuningLevel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #qualityTuningLevelAsString}.
     * </p>
     * 
     * @return The Quality tuning level you choose represents a trade-off between the encoding speed of your job and the
     *         output video quality. For the fastest encoding speed at the cost of video quality: Choose Single pass.
     *         For a good balance between encoding speed and video quality: Leave blank or keep the default value Single
     *         pass HQ. For the best video quality, at the cost of encoding speed: Choose Multi pass HQ. MediaConvert
     *         performs an analysis pass on your input followed by an encoding pass. Outputs that use this feature incur
     *         pro-tier pricing.
     * @see H264QualityTuningLevel
     */
    public final String qualityTuningLevelAsString() {
        return qualityTuningLevel;
    }

    /**
     * Settings for quality-defined variable bitrate encoding with the H.265 codec. Use these settings only when you set
     * QVBR for Rate control mode (RateControlMode).
     * 
     * @return Settings for quality-defined variable bitrate encoding with the H.265 codec. Use these settings only when
     *         you set QVBR for Rate control mode (RateControlMode).
     */
    public final H264QvbrSettings qvbrSettings() {
        return qvbrSettings;
    }

    /**
     * Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or
     * quality-defined variable bitrate (QVBR).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateControlMode}
     * will return {@link H264RateControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #rateControlModeAsString}.
     * </p>
     * 
     * @return Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or
     *         quality-defined variable bitrate (QVBR).
     * @see H264RateControlMode
     */
    public final H264RateControlMode rateControlMode() {
        return H264RateControlMode.fromValue(rateControlMode);
    }

    /**
     * Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or
     * quality-defined variable bitrate (QVBR).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateControlMode}
     * will return {@link H264RateControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #rateControlModeAsString}.
     * </p>
     * 
     * @return Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or
     *         quality-defined variable bitrate (QVBR).
     * @see H264RateControlMode
     */
    public final String rateControlModeAsString() {
        return rateControlMode;
    }

    /**
     * Places a PPS header on each encoded picture, even if repeated.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #repeatPps} will
     * return {@link H264RepeatPps#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #repeatPpsAsString}.
     * </p>
     * 
     * @return Places a PPS header on each encoded picture, even if repeated.
     * @see H264RepeatPps
     */
    public final H264RepeatPps repeatPps() {
        return H264RepeatPps.fromValue(repeatPps);
    }

    /**
     * Places a PPS header on each encoded picture, even if repeated.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #repeatPps} will
     * return {@link H264RepeatPps#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #repeatPpsAsString}.
     * </p>
     * 
     * @return Places a PPS header on each encoded picture, even if repeated.
     * @see H264RepeatPps
     */
    public final String repeatPpsAsString() {
        return repeatPps;
    }

    /**
     * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this
     * situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In
     * this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the
     * default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing,
     * MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized
     * interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing,
     * MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you
     * must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine
     * outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #scanTypeConversionMode} will return {@link H264ScanTypeConversionMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #scanTypeConversionModeAsString}.
     * </p>
     * 
     * @return Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In
     *         this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced
     *         output. In this case, each progressive frame from the input corresponds to an interlaced field in the
     *         output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With
     *         basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames.
     *         When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable
     *         for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings:
     *         To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't
     *         use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to
     *         a value other than Progressive (PROGRESSIVE).
     * @see H264ScanTypeConversionMode
     */
    public final H264ScanTypeConversionMode scanTypeConversionMode() {
        return H264ScanTypeConversionMode.fromValue(scanTypeConversionMode);
    }

    /**
     * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this
     * situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In
     * this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the
     * default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing,
     * MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized
     * interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing,
     * MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you
     * must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine
     * outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #scanTypeConversionMode} will return {@link H264ScanTypeConversionMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #scanTypeConversionModeAsString}.
     * </p>
     * 
     * @return Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In
     *         this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced
     *         output. In this case, each progressive frame from the input corresponds to an interlaced field in the
     *         output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With
     *         basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames.
     *         When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable
     *         for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings:
     *         To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't
     *         use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to
     *         a value other than Progressive (PROGRESSIVE).
     * @see H264ScanTypeConversionMode
     */
    public final String scanTypeConversionModeAsString() {
        return scanTypeConversionMode;
    }

    /**
     * Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves
     * video quality and is enabled by default. If this output uses QVBR, choose Transition detection
     * (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see
     * https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sceneChangeDetect}
     * will return {@link H264SceneChangeDetect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sceneChangeDetectAsString}.
     * </p>
     * 
     * @return Enable this setting to insert I-frames at scene changes that the service automatically detects. This
     *         improves video quality and is enabled by default. If this output uses QVBR, choose Transition detection
     *         (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see
     *         https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
     * @see H264SceneChangeDetect
     */
    public final H264SceneChangeDetect sceneChangeDetect() {
        return H264SceneChangeDetect.fromValue(sceneChangeDetect);
    }

    /**
     * Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves
     * video quality and is enabled by default. If this output uses QVBR, choose Transition detection
     * (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see
     * https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sceneChangeDetect}
     * will return {@link H264SceneChangeDetect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sceneChangeDetectAsString}.
     * </p>
     * 
     * @return Enable this setting to insert I-frames at scene changes that the service automatically detects. This
     *         improves video quality and is enabled by default. If this output uses QVBR, choose Transition detection
     *         (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see
     *         https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
     * @see H264SceneChangeDetect
     */
    public final String sceneChangeDetectAsString() {
        return sceneChangeDetect;
    }

    /**
     * Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive
     * pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
     * 
     * @return Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive
     *         pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
     */
    public final Integer slices() {
        return slices;
    }

    /**
     * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to
     * create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples
     * your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the
     * duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set
     * (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slowPal} will
     * return {@link H264SlowPal#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #slowPalAsString}.
     * </p>
     * 
     * @return Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL
     *         to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and
     *         resamples your audio to keep it synchronized with the video. Note that enabling this setting will
     *         slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your
     *         JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and
     *         (framerateDenominator) to 1.
     * @see H264SlowPal
     */
    public final H264SlowPal slowPal() {
        return H264SlowPal.fromValue(slowPal);
    }

    /**
     * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to
     * create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples
     * your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the
     * duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set
     * (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slowPal} will
     * return {@link H264SlowPal#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #slowPalAsString}.
     * </p>
     * 
     * @return Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL
     *         to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and
     *         resamples your audio to keep it synchronized with the video. Note that enabling this setting will
     *         slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your
     *         JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and
     *         (framerateDenominator) to 1.
     * @see H264SlowPal
     */
    public final String slowPalAsString() {
        return slowPal;
    }

    /**
     * Ignore this setting unless you need to comply with a specification that requires a specific value. If you don't
     * have a specification requirement, we recommend that you adjust the softness of your output by using a lower value
     * for the setting Sharpness (sharpness) or by enabling a noise reducer filter (noiseReducerFilter). The Softness
     * (softness) setting specifies the quantization matrices that the encoder uses. Keep the default value, 0, for flat
     * quantization. Choose the value 1 or 16 to use the default JVT softening quantization matricies from the H.264
     * specification. Choose a value from 17 to 128 to use planar interpolation. Increasing values from 17 to 128 result
     * in increasing reduction of high-frequency data. The value 128 results in the softest video.
     * 
     * @return Ignore this setting unless you need to comply with a specification that requires a specific value. If you
     *         don't have a specification requirement, we recommend that you adjust the softness of your output by using
     *         a lower value for the setting Sharpness (sharpness) or by enabling a noise reducer filter
     *         (noiseReducerFilter). The Softness (softness) setting specifies the quantization matrices that the
     *         encoder uses. Keep the default value, 0, for flat quantization. Choose the value 1 or 16 to use the
     *         default JVT softening quantization matricies from the H.264 specification. Choose a value from 17 to 128
     *         to use planar interpolation. Increasing values from 17 to 128 result in increasing reduction of
     *         high-frequency data. The value 128 results in the softest video.
     */
    public final Integer softness() {
        return softness;
    }

    /**
     * Only use this setting when you change the default value, Auto (AUTO), for the setting H264AdaptiveQuantization.
     * When you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON
     * job specification, MediaConvert automatically applies the best types of quantization for your video content. When
     * you set H264AdaptiveQuantization to a value other than AUTO, the default value for
     * H264SpatialAdaptiveQuantization is Enabled (ENABLED). Keep this default value to adjust quantization within each
     * frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits
     * on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where
     * any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and
     * smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video
     * quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be.
     * If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you
     * might choose to set H264SpatialAdaptiveQuantization to Disabled (DISABLED). Related setting: When you enable
     * spatial adaptive quantization, set the value for Adaptive quantization (H264AdaptiveQuantization) depending on
     * your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider
     * variety of textures, set it to High or Higher. To manually enable or disable H264SpatialAdaptiveQuantization, you
     * must set Adaptive quantization (H264AdaptiveQuantization) to a value other than AUTO.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #spatialAdaptiveQuantization} will return {@link H264SpatialAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #spatialAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Only use this setting when you change the default value, Auto (AUTO), for the setting
     *         H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other
     *         adaptive quantization from your JSON job specification, MediaConvert automatically applies the best types
     *         of quantization for your video content. When you set H264AdaptiveQuantization to a value other than AUTO,
     *         the default value for H264SpatialAdaptiveQuantization is Enabled (ENABLED). Keep this default value to
     *         adjust quantization within each frame based on spatial variation of content complexity. When you enable
     *         this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable
     *         visual degradation and uses more bits on areas where any small distortion will be noticeable. For
     *         example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with
     *         more bits. Enabling this feature will almost always improve your video quality. Note, though, that this
     *         feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to
     *         be focusing their attention on a part of the screen with a lot of complex texture, you might choose to
     *         set H264SpatialAdaptiveQuantization to Disabled (DISABLED). Related setting: When you enable spatial
     *         adaptive quantization, set the value for Adaptive quantization (H264AdaptiveQuantization) depending on
     *         your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with
     *         a wider variety of textures, set it to High or Higher. To manually enable or disable
     *         H264SpatialAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a value
     *         other than AUTO.
     * @see H264SpatialAdaptiveQuantization
     */
    public final H264SpatialAdaptiveQuantization spatialAdaptiveQuantization() {
        return H264SpatialAdaptiveQuantization.fromValue(spatialAdaptiveQuantization);
    }

    /**
     * Only use this setting when you change the default value, Auto (AUTO), for the setting H264AdaptiveQuantization.
     * When you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON
     * job specification, MediaConvert automatically applies the best types of quantization for your video content. When
     * you set H264AdaptiveQuantization to a value other than AUTO, the default value for
     * H264SpatialAdaptiveQuantization is Enabled (ENABLED). Keep this default value to adjust quantization within each
     * frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits
     * on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where
     * any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and
     * smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video
     * quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be.
     * If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you
     * might choose to set H264SpatialAdaptiveQuantization to Disabled (DISABLED). Related setting: When you enable
     * spatial adaptive quantization, set the value for Adaptive quantization (H264AdaptiveQuantization) depending on
     * your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider
     * variety of textures, set it to High or Higher. To manually enable or disable H264SpatialAdaptiveQuantization, you
     * must set Adaptive quantization (H264AdaptiveQuantization) to a value other than AUTO.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #spatialAdaptiveQuantization} will return {@link H264SpatialAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #spatialAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Only use this setting when you change the default value, Auto (AUTO), for the setting
     *         H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other
     *         adaptive quantization from your JSON job specification, MediaConvert automatically applies the best types
     *         of quantization for your video content. When you set H264AdaptiveQuantization to a value other than AUTO,
     *         the default value for H264SpatialAdaptiveQuantization is Enabled (ENABLED). Keep this default value to
     *         adjust quantization within each frame based on spatial variation of content complexity. When you enable
     *         this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable
     *         visual degradation and uses more bits on areas where any small distortion will be noticeable. For
     *         example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with
     *         more bits. Enabling this feature will almost always improve your video quality. Note, though, that this
     *         feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to
     *         be focusing their attention on a part of the screen with a lot of complex texture, you might choose to
     *         set H264SpatialAdaptiveQuantization to Disabled (DISABLED). Related setting: When you enable spatial
     *         adaptive quantization, set the value for Adaptive quantization (H264AdaptiveQuantization) depending on
     *         your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with
     *         a wider variety of textures, set it to High or Higher. To manually enable or disable
     *         H264SpatialAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a value
     *         other than AUTO.
     * @see H264SpatialAdaptiveQuantization
     */
    public final String spatialAdaptiveQuantizationAsString() {
        return spatialAdaptiveQuantization;
    }

    /**
     * Produces a bitstream compliant with SMPTE RP-2027.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syntax} will
     * return {@link H264Syntax#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #syntaxAsString}.
     * </p>
     * 
     * @return Produces a bitstream compliant with SMPTE RP-2027.
     * @see H264Syntax
     */
    public final H264Syntax syntax() {
        return H264Syntax.fromValue(syntax);
    }

    /**
     * Produces a bitstream compliant with SMPTE RP-2027.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syntax} will
     * return {@link H264Syntax#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #syntaxAsString}.
     * </p>
     * 
     * @return Produces a bitstream compliant with SMPTE RP-2027.
     * @see H264Syntax
     */
    public final String syntaxAsString() {
        return syntax;
    }

    /**
     * When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is
     * interlaced, you can optionally enable hard or soft telecine to create a smoother picture. Hard telecine (HARD)
     * produces a 29.97i output. Soft telecine (SOFT) produces an output with a 23.976 output that signals to the video
     * player device to do the conversion during play back. When you keep the default value, None (NONE), MediaConvert
     * does a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a
     * smoother picture.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #telecine} will
     * return {@link H264Telecine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #telecineAsString}.
     * </p>
     * 
     * @return When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan
     *         type is interlaced, you can optionally enable hard or soft telecine to create a smoother picture. Hard
     *         telecine (HARD) produces a 29.97i output. Soft telecine (SOFT) produces an output with a 23.976 output
     *         that signals to the video player device to do the conversion during play back. When you keep the default
     *         value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything
     *         with the field polarity to create a smoother picture.
     * @see H264Telecine
     */
    public final H264Telecine telecine() {
        return H264Telecine.fromValue(telecine);
    }

    /**
     * When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is
     * interlaced, you can optionally enable hard or soft telecine to create a smoother picture. Hard telecine (HARD)
     * produces a 29.97i output. Soft telecine (SOFT) produces an output with a 23.976 output that signals to the video
     * player device to do the conversion during play back. When you keep the default value, None (NONE), MediaConvert
     * does a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a
     * smoother picture.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #telecine} will
     * return {@link H264Telecine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #telecineAsString}.
     * </p>
     * 
     * @return When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan
     *         type is interlaced, you can optionally enable hard or soft telecine to create a smoother picture. Hard
     *         telecine (HARD) produces a 29.97i output. Soft telecine (SOFT) produces an output with a 23.976 output
     *         that signals to the video player device to do the conversion during play back. When you keep the default
     *         value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything
     *         with the field polarity to create a smoother picture.
     * @see H264Telecine
     */
    public final String telecineAsString() {
        return telecine;
    }

    /**
     * Only use this setting when you change the default value, AUTO, for the setting H264AdaptiveQuantization. When you
     * keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON job
     * specification, MediaConvert automatically applies the best types of quantization for your video content. When you
     * set H264AdaptiveQuantization to a value other than AUTO, the default value for H264TemporalAdaptiveQuantization
     * is Enabled (ENABLED). Keep this default value to adjust quantization within each frame based on temporal
     * variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame
     * that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this
     * feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this
     * feature will almost always improve your video quality. Note, though, that this feature doesn't take into account
     * where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of
     * the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to
     * set H264TemporalAdaptiveQuantization to Disabled (DISABLED). Related setting: When you enable temporal
     * quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization). To
     * manually enable or disable H264TemporalAdaptiveQuantization, you must set Adaptive quantization
     * (H264AdaptiveQuantization) to a value other than AUTO.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #temporalAdaptiveQuantization} will return {@link H264TemporalAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #temporalAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Only use this setting when you change the default value, AUTO, for the setting H264AdaptiveQuantization.
     *         When you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from
     *         your JSON job specification, MediaConvert automatically applies the best types of quantization for your
     *         video content. When you set H264AdaptiveQuantization to a value other than AUTO, the default value for
     *         H264TemporalAdaptiveQuantization is Enabled (ENABLED). Keep this default value to adjust quantization
     *         within each frame based on temporal variation of content complexity. When you enable this feature, the
     *         encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects
     *         with sharp edges that move a lot. For example, this feature improves the readability of text tickers on
     *         newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video
     *         quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely
     *         to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have
     *         moving objects with sharp edges, such as sports athletes' faces, you might choose to set
     *         H264TemporalAdaptiveQuantization to Disabled (DISABLED). Related setting: When you enable temporal
     *         quantization, adjust the strength of the filter with the setting Adaptive quantization
     *         (adaptiveQuantization). To manually enable or disable H264TemporalAdaptiveQuantization, you must set
     *         Adaptive quantization (H264AdaptiveQuantization) to a value other than AUTO.
     * @see H264TemporalAdaptiveQuantization
     */
    public final H264TemporalAdaptiveQuantization temporalAdaptiveQuantization() {
        return H264TemporalAdaptiveQuantization.fromValue(temporalAdaptiveQuantization);
    }

    /**
     * Only use this setting when you change the default value, AUTO, for the setting H264AdaptiveQuantization. When you
     * keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON job
     * specification, MediaConvert automatically applies the best types of quantization for your video content. When you
     * set H264AdaptiveQuantization to a value other than AUTO, the default value for H264TemporalAdaptiveQuantization
     * is Enabled (ENABLED). Keep this default value to adjust quantization within each frame based on temporal
     * variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame
     * that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this
     * feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this
     * feature will almost always improve your video quality. Note, though, that this feature doesn't take into account
     * where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of
     * the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to
     * set H264TemporalAdaptiveQuantization to Disabled (DISABLED). Related setting: When you enable temporal
     * quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization). To
     * manually enable or disable H264TemporalAdaptiveQuantization, you must set Adaptive quantization
     * (H264AdaptiveQuantization) to a value other than AUTO.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #temporalAdaptiveQuantization} will return {@link H264TemporalAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #temporalAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return Only use this setting when you change the default value, AUTO, for the setting H264AdaptiveQuantization.
     *         When you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from
     *         your JSON job specification, MediaConvert automatically applies the best types of quantization for your
     *         video content. When you set H264AdaptiveQuantization to a value other than AUTO, the default value for
     *         H264TemporalAdaptiveQuantization is Enabled (ENABLED). Keep this default value to adjust quantization
     *         within each frame based on temporal variation of content complexity. When you enable this feature, the
     *         encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects
     *         with sharp edges that move a lot. For example, this feature improves the readability of text tickers on
     *         newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video
     *         quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely
     *         to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have
     *         moving objects with sharp edges, such as sports athletes' faces, you might choose to set
     *         H264TemporalAdaptiveQuantization to Disabled (DISABLED). Related setting: When you enable temporal
     *         quantization, adjust the strength of the filter with the setting Adaptive quantization
     *         (adaptiveQuantization). To manually enable or disable H264TemporalAdaptiveQuantization, you must set
     *         Adaptive quantization (H264AdaptiveQuantization) to a value other than AUTO.
     * @see H264TemporalAdaptiveQuantization
     */
    public final String temporalAdaptiveQuantizationAsString() {
        return temporalAdaptiveQuantization;
    }

    /**
     * Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #unregisteredSeiTimecode} will return {@link H264UnregisteredSeiTimecode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #unregisteredSeiTimecodeAsString}.
     * </p>
     * 
     * @return Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
     * @see H264UnregisteredSeiTimecode
     */
    public final H264UnregisteredSeiTimecode unregisteredSeiTimecode() {
        return H264UnregisteredSeiTimecode.fromValue(unregisteredSeiTimecode);
    }

    /**
     * Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #unregisteredSeiTimecode} will return {@link H264UnregisteredSeiTimecode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #unregisteredSeiTimecodeAsString}.
     * </p>
     * 
     * @return Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
     * @see H264UnregisteredSeiTimecode
     */
    public final String unregisteredSeiTimecodeAsString() {
        return unregisteredSeiTimecode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bandwidthReductionFilter());
        hashCode = 31 * hashCode + Objects.hashCode(bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(codecLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(codecProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dynamicSubGopAsString());
        hashCode = 31 * hashCode + Objects.hashCode(entropyEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fieldEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(flickerAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateConversionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(gopBReferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(gopClosedCadence());
        hashCode = 31 * hashCode + Objects.hashCode(gopSize());
        hashCode = 31 * hashCode + Objects.hashCode(gopSizeUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hrdBufferFinalFillPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(hrdBufferInitialFillPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(hrdBufferSize());
        hashCode = 31 * hashCode + Objects.hashCode(interlaceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(minIInterval());
        hashCode = 31 * hashCode + Objects.hashCode(numberBFramesBetweenReferenceFrames());
        hashCode = 31 * hashCode + Objects.hashCode(numberReferenceFrames());
        hashCode = 31 * hashCode + Objects.hashCode(parControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(parNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(qualityTuningLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(qvbrSettings());
        hashCode = 31 * hashCode + Objects.hashCode(rateControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(repeatPpsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scanTypeConversionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sceneChangeDetectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(slices());
        hashCode = 31 * hashCode + Objects.hashCode(slowPalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(softness());
        hashCode = 31 * hashCode + Objects.hashCode(spatialAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(syntaxAsString());
        hashCode = 31 * hashCode + Objects.hashCode(telecineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(temporalAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(unregisteredSeiTimecodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof H264Settings)) {
            return false;
        }
        H264Settings other = (H264Settings) obj;
        return Objects.equals(adaptiveQuantizationAsString(), other.adaptiveQuantizationAsString())
                && Objects.equals(bandwidthReductionFilter(), other.bandwidthReductionFilter())
                && Objects.equals(bitrate(), other.bitrate()) && Objects.equals(codecLevelAsString(), other.codecLevelAsString())
                && Objects.equals(codecProfileAsString(), other.codecProfileAsString())
                && Objects.equals(dynamicSubGopAsString(), other.dynamicSubGopAsString())
                && Objects.equals(entropyEncodingAsString(), other.entropyEncodingAsString())
                && Objects.equals(fieldEncodingAsString(), other.fieldEncodingAsString())
                && Objects.equals(flickerAdaptiveQuantizationAsString(), other.flickerAdaptiveQuantizationAsString())
                && Objects.equals(framerateControlAsString(), other.framerateControlAsString())
                && Objects.equals(framerateConversionAlgorithmAsString(), other.framerateConversionAlgorithmAsString())
                && Objects.equals(framerateDenominator(), other.framerateDenominator())
                && Objects.equals(framerateNumerator(), other.framerateNumerator())
                && Objects.equals(gopBReferenceAsString(), other.gopBReferenceAsString())
                && Objects.equals(gopClosedCadence(), other.gopClosedCadence()) && Objects.equals(gopSize(), other.gopSize())
                && Objects.equals(gopSizeUnitsAsString(), other.gopSizeUnitsAsString())
                && Objects.equals(hrdBufferFinalFillPercentage(), other.hrdBufferFinalFillPercentage())
                && Objects.equals(hrdBufferInitialFillPercentage(), other.hrdBufferInitialFillPercentage())
                && Objects.equals(hrdBufferSize(), other.hrdBufferSize())
                && Objects.equals(interlaceModeAsString(), other.interlaceModeAsString())
                && Objects.equals(maxBitrate(), other.maxBitrate()) && Objects.equals(minIInterval(), other.minIInterval())
                && Objects.equals(numberBFramesBetweenReferenceFrames(), other.numberBFramesBetweenReferenceFrames())
                && Objects.equals(numberReferenceFrames(), other.numberReferenceFrames())
                && Objects.equals(parControlAsString(), other.parControlAsString())
                && Objects.equals(parDenominator(), other.parDenominator())
                && Objects.equals(parNumerator(), other.parNumerator())
                && Objects.equals(qualityTuningLevelAsString(), other.qualityTuningLevelAsString())
                && Objects.equals(qvbrSettings(), other.qvbrSettings())
                && Objects.equals(rateControlModeAsString(), other.rateControlModeAsString())
                && Objects.equals(repeatPpsAsString(), other.repeatPpsAsString())
                && Objects.equals(scanTypeConversionModeAsString(), other.scanTypeConversionModeAsString())
                && Objects.equals(sceneChangeDetectAsString(), other.sceneChangeDetectAsString())
                && Objects.equals(slices(), other.slices()) && Objects.equals(slowPalAsString(), other.slowPalAsString())
                && Objects.equals(softness(), other.softness())
                && Objects.equals(spatialAdaptiveQuantizationAsString(), other.spatialAdaptiveQuantizationAsString())
                && Objects.equals(syntaxAsString(), other.syntaxAsString())
                && Objects.equals(telecineAsString(), other.telecineAsString())
                && Objects.equals(temporalAdaptiveQuantizationAsString(), other.temporalAdaptiveQuantizationAsString())
                && Objects.equals(unregisteredSeiTimecodeAsString(), other.unregisteredSeiTimecodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("H264Settings").add("AdaptiveQuantization", adaptiveQuantizationAsString())
                .add("BandwidthReductionFilter", bandwidthReductionFilter()).add("Bitrate", bitrate())
                .add("CodecLevel", codecLevelAsString()).add("CodecProfile", codecProfileAsString())
                .add("DynamicSubGop", dynamicSubGopAsString()).add("EntropyEncoding", entropyEncodingAsString())
                .add("FieldEncoding", fieldEncodingAsString())
                .add("FlickerAdaptiveQuantization", flickerAdaptiveQuantizationAsString())
                .add("FramerateControl", framerateControlAsString())
                .add("FramerateConversionAlgorithm", framerateConversionAlgorithmAsString())
                .add("FramerateDenominator", framerateDenominator()).add("FramerateNumerator", framerateNumerator())
                .add("GopBReference", gopBReferenceAsString()).add("GopClosedCadence", gopClosedCadence())
                .add("GopSize", gopSize()).add("GopSizeUnits", gopSizeUnitsAsString())
                .add("HrdBufferFinalFillPercentage", hrdBufferFinalFillPercentage())
                .add("HrdBufferInitialFillPercentage", hrdBufferInitialFillPercentage()).add("HrdBufferSize", hrdBufferSize())
                .add("InterlaceMode", interlaceModeAsString()).add("MaxBitrate", maxBitrate())
                .add("MinIInterval", minIInterval())
                .add("NumberBFramesBetweenReferenceFrames", numberBFramesBetweenReferenceFrames())
                .add("NumberReferenceFrames", numberReferenceFrames()).add("ParControl", parControlAsString())
                .add("ParDenominator", parDenominator()).add("ParNumerator", parNumerator())
                .add("QualityTuningLevel", qualityTuningLevelAsString()).add("QvbrSettings", qvbrSettings())
                .add("RateControlMode", rateControlModeAsString()).add("RepeatPps", repeatPpsAsString())
                .add("ScanTypeConversionMode", scanTypeConversionModeAsString())
                .add("SceneChangeDetect", sceneChangeDetectAsString()).add("Slices", slices()).add("SlowPal", slowPalAsString())
                .add("Softness", softness()).add("SpatialAdaptiveQuantization", spatialAdaptiveQuantizationAsString())
                .add("Syntax", syntaxAsString()).add("Telecine", telecineAsString())
                .add("TemporalAdaptiveQuantization", temporalAdaptiveQuantizationAsString())
                .add("UnregisteredSeiTimecode", unregisteredSeiTimecodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdaptiveQuantization":
            return Optional.ofNullable(clazz.cast(adaptiveQuantizationAsString()));
        case "BandwidthReductionFilter":
            return Optional.ofNullable(clazz.cast(bandwidthReductionFilter()));
        case "Bitrate":
            return Optional.ofNullable(clazz.cast(bitrate()));
        case "CodecLevel":
            return Optional.ofNullable(clazz.cast(codecLevelAsString()));
        case "CodecProfile":
            return Optional.ofNullable(clazz.cast(codecProfileAsString()));
        case "DynamicSubGop":
            return Optional.ofNullable(clazz.cast(dynamicSubGopAsString()));
        case "EntropyEncoding":
            return Optional.ofNullable(clazz.cast(entropyEncodingAsString()));
        case "FieldEncoding":
            return Optional.ofNullable(clazz.cast(fieldEncodingAsString()));
        case "FlickerAdaptiveQuantization":
            return Optional.ofNullable(clazz.cast(flickerAdaptiveQuantizationAsString()));
        case "FramerateControl":
            return Optional.ofNullable(clazz.cast(framerateControlAsString()));
        case "FramerateConversionAlgorithm":
            return Optional.ofNullable(clazz.cast(framerateConversionAlgorithmAsString()));
        case "FramerateDenominator":
            return Optional.ofNullable(clazz.cast(framerateDenominator()));
        case "FramerateNumerator":
            return Optional.ofNullable(clazz.cast(framerateNumerator()));
        case "GopBReference":
            return Optional.ofNullable(clazz.cast(gopBReferenceAsString()));
        case "GopClosedCadence":
            return Optional.ofNullable(clazz.cast(gopClosedCadence()));
        case "GopSize":
            return Optional.ofNullable(clazz.cast(gopSize()));
        case "GopSizeUnits":
            return Optional.ofNullable(clazz.cast(gopSizeUnitsAsString()));
        case "HrdBufferFinalFillPercentage":
            return Optional.ofNullable(clazz.cast(hrdBufferFinalFillPercentage()));
        case "HrdBufferInitialFillPercentage":
            return Optional.ofNullable(clazz.cast(hrdBufferInitialFillPercentage()));
        case "HrdBufferSize":
            return Optional.ofNullable(clazz.cast(hrdBufferSize()));
        case "InterlaceMode":
            return Optional.ofNullable(clazz.cast(interlaceModeAsString()));
        case "MaxBitrate":
            return Optional.ofNullable(clazz.cast(maxBitrate()));
        case "MinIInterval":
            return Optional.ofNullable(clazz.cast(minIInterval()));
        case "NumberBFramesBetweenReferenceFrames":
            return Optional.ofNullable(clazz.cast(numberBFramesBetweenReferenceFrames()));
        case "NumberReferenceFrames":
            return Optional.ofNullable(clazz.cast(numberReferenceFrames()));
        case "ParControl":
            return Optional.ofNullable(clazz.cast(parControlAsString()));
        case "ParDenominator":
            return Optional.ofNullable(clazz.cast(parDenominator()));
        case "ParNumerator":
            return Optional.ofNullable(clazz.cast(parNumerator()));
        case "QualityTuningLevel":
            return Optional.ofNullable(clazz.cast(qualityTuningLevelAsString()));
        case "QvbrSettings":
            return Optional.ofNullable(clazz.cast(qvbrSettings()));
        case "RateControlMode":
            return Optional.ofNullable(clazz.cast(rateControlModeAsString()));
        case "RepeatPps":
            return Optional.ofNullable(clazz.cast(repeatPpsAsString()));
        case "ScanTypeConversionMode":
            return Optional.ofNullable(clazz.cast(scanTypeConversionModeAsString()));
        case "SceneChangeDetect":
            return Optional.ofNullable(clazz.cast(sceneChangeDetectAsString()));
        case "Slices":
            return Optional.ofNullable(clazz.cast(slices()));
        case "SlowPal":
            return Optional.ofNullable(clazz.cast(slowPalAsString()));
        case "Softness":
            return Optional.ofNullable(clazz.cast(softness()));
        case "SpatialAdaptiveQuantization":
            return Optional.ofNullable(clazz.cast(spatialAdaptiveQuantizationAsString()));
        case "Syntax":
            return Optional.ofNullable(clazz.cast(syntaxAsString()));
        case "Telecine":
            return Optional.ofNullable(clazz.cast(telecineAsString()));
        case "TemporalAdaptiveQuantization":
            return Optional.ofNullable(clazz.cast(temporalAdaptiveQuantizationAsString()));
        case "UnregisteredSeiTimecode":
            return Optional.ofNullable(clazz.cast(unregisteredSeiTimecodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<H264Settings, T> g) {
        return obj -> g.apply((H264Settings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, H264Settings> {
        /**
         * Keep the default value, Auto (AUTO), for this setting to have MediaConvert automatically apply the best types
         * of quantization for your video content. When you want to apply your quantization settings manually, you must
         * set H264AdaptiveQuantization to a value other than Auto (AUTO). Use this setting to specify the strength of
         * any adaptive quantization filters that you enable. If you don't want MediaConvert to do any adaptive
         * quantization in this transcode, set Adaptive quantization (H264AdaptiveQuantization) to Off (OFF). Related
         * settings: The value that you choose here applies to the following settings: H264FlickerAdaptiveQuantization,
         * H264SpatialAdaptiveQuantization, and H264TemporalAdaptiveQuantization.
         * 
         * @param adaptiveQuantization
         *        Keep the default value, Auto (AUTO), for this setting to have MediaConvert automatically apply the
         *        best types of quantization for your video content. When you want to apply your quantization settings
         *        manually, you must set H264AdaptiveQuantization to a value other than Auto (AUTO). Use this setting to
         *        specify the strength of any adaptive quantization filters that you enable. If you don't want
         *        MediaConvert to do any adaptive quantization in this transcode, set Adaptive quantization
         *        (H264AdaptiveQuantization) to Off (OFF). Related settings: The value that you choose here applies to
         *        the following settings: H264FlickerAdaptiveQuantization, H264SpatialAdaptiveQuantization, and
         *        H264TemporalAdaptiveQuantization.
         * @see H264AdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264AdaptiveQuantization
         */
        Builder adaptiveQuantization(String adaptiveQuantization);

        /**
         * Keep the default value, Auto (AUTO), for this setting to have MediaConvert automatically apply the best types
         * of quantization for your video content. When you want to apply your quantization settings manually, you must
         * set H264AdaptiveQuantization to a value other than Auto (AUTO). Use this setting to specify the strength of
         * any adaptive quantization filters that you enable. If you don't want MediaConvert to do any adaptive
         * quantization in this transcode, set Adaptive quantization (H264AdaptiveQuantization) to Off (OFF). Related
         * settings: The value that you choose here applies to the following settings: H264FlickerAdaptiveQuantization,
         * H264SpatialAdaptiveQuantization, and H264TemporalAdaptiveQuantization.
         * 
         * @param adaptiveQuantization
         *        Keep the default value, Auto (AUTO), for this setting to have MediaConvert automatically apply the
         *        best types of quantization for your video content. When you want to apply your quantization settings
         *        manually, you must set H264AdaptiveQuantization to a value other than Auto (AUTO). Use this setting to
         *        specify the strength of any adaptive quantization filters that you enable. If you don't want
         *        MediaConvert to do any adaptive quantization in this transcode, set Adaptive quantization
         *        (H264AdaptiveQuantization) to Off (OFF). Related settings: The value that you choose here applies to
         *        the following settings: H264FlickerAdaptiveQuantization, H264SpatialAdaptiveQuantization, and
         *        H264TemporalAdaptiveQuantization.
         * @see H264AdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264AdaptiveQuantization
         */
        Builder adaptiveQuantization(H264AdaptiveQuantization adaptiveQuantization);

        /**
         * The Bandwidth reduction filter increases the video quality of your output relative to its bitrate. Use to
         * lower the bitrate of your constant quality QVBR output, with little or no perceptual decrease in quality. Or,
         * use to increase the video quality of outputs with other rate control modes relative to the bitrate that you
         * specify. Bandwidth reduction increases further when your input is low quality or noisy. Outputs that use this
         * feature incur pro-tier pricing. When you include Bandwidth reduction filter, you cannot include the Noise
         * reducer preprocessor.
         * 
         * @param bandwidthReductionFilter
         *        The Bandwidth reduction filter increases the video quality of your output relative to its bitrate. Use
         *        to lower the bitrate of your constant quality QVBR output, with little or no perceptual decrease in
         *        quality. Or, use to increase the video quality of outputs with other rate control modes relative to
         *        the bitrate that you specify. Bandwidth reduction increases further when your input is low quality or
         *        noisy. Outputs that use this feature incur pro-tier pricing. When you include Bandwidth reduction
         *        filter, you cannot include the Noise reducer preprocessor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bandwidthReductionFilter(BandwidthReductionFilter bandwidthReductionFilter);

        /**
         * The Bandwidth reduction filter increases the video quality of your output relative to its bitrate. Use to
         * lower the bitrate of your constant quality QVBR output, with little or no perceptual decrease in quality. Or,
         * use to increase the video quality of outputs with other rate control modes relative to the bitrate that you
         * specify. Bandwidth reduction increases further when your input is low quality or noisy. Outputs that use this
         * feature incur pro-tier pricing. When you include Bandwidth reduction filter, you cannot include the Noise
         * reducer preprocessor. This is a convenience method that creates an instance of the
         * {@link BandwidthReductionFilter.Builder} avoiding the need to create one manually via
         * {@link BandwidthReductionFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BandwidthReductionFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #bandwidthReductionFilter(BandwidthReductionFilter)}.
         * 
         * @param bandwidthReductionFilter
         *        a consumer that will call methods on {@link BandwidthReductionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bandwidthReductionFilter(BandwidthReductionFilter)
         */
        default Builder bandwidthReductionFilter(Consumer<BandwidthReductionFilter.Builder> bandwidthReductionFilter) {
            return bandwidthReductionFilter(BandwidthReductionFilter.builder().applyMutation(bandwidthReductionFilter).build());
        }

        /**
         * Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates
         * must be unique when rounded down to the nearest multiple of 1000.
         * 
         * @param bitrate
         *        Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs,
         *        bitrates must be unique when rounded down to the nearest multiple of 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitrate(Integer bitrate);

        /**
         * Specify an H.264 level that is consistent with your output video settings. If you aren't sure what level to
         * specify, choose Auto (AUTO).
         * 
         * @param codecLevel
         *        Specify an H.264 level that is consistent with your output video settings. If you aren't sure what
         *        level to specify, choose Auto (AUTO).
         * @see H264CodecLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264CodecLevel
         */
        Builder codecLevel(String codecLevel);

        /**
         * Specify an H.264 level that is consistent with your output video settings. If you aren't sure what level to
         * specify, choose Auto (AUTO).
         * 
         * @param codecLevel
         *        Specify an H.264 level that is consistent with your output video settings. If you aren't sure what
         *        level to specify, choose Auto (AUTO).
         * @see H264CodecLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264CodecLevel
         */
        Builder codecLevel(H264CodecLevel codecLevel);

        /**
         * H.264 Profile. High 4:2:2 and 10-bit profiles are only available with the AVC-I License.
         * 
         * @param codecProfile
         *        H.264 Profile. High 4:2:2 and 10-bit profiles are only available with the AVC-I License.
         * @see H264CodecProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264CodecProfile
         */
        Builder codecProfile(String codecProfile);

        /**
         * H.264 Profile. High 4:2:2 and 10-bit profiles are only available with the AVC-I License.
         * 
         * @param codecProfile
         *        H.264 Profile. High 4:2:2 and 10-bit profiles are only available with the AVC-I License.
         * @see H264CodecProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264CodecProfile
         */
        Builder codecProfile(H264CodecProfile codecProfile);

        /**
         * Specify whether to allow the number of B-frames in your output GOP structure to vary or not depending on your
         * input video content. To improve the subjective video quality of your output that has high-motion content:
         * Leave blank or keep the default value Adaptive. MediaConvert will use fewer B-frames for high-motion video
         * content than low-motion content. The maximum number of B- frames is limited by the value that you choose for
         * B-frames between reference frames. To use the same number B-frames for all types of content: Choose Static.
         * 
         * @param dynamicSubGop
         *        Specify whether to allow the number of B-frames in your output GOP structure to vary or not depending
         *        on your input video content. To improve the subjective video quality of your output that has
         *        high-motion content: Leave blank or keep the default value Adaptive. MediaConvert will use fewer
         *        B-frames for high-motion video content than low-motion content. The maximum number of B- frames is
         *        limited by the value that you choose for B-frames between reference frames. To use the same number
         *        B-frames for all types of content: Choose Static.
         * @see H264DynamicSubGop
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264DynamicSubGop
         */
        Builder dynamicSubGop(String dynamicSubGop);

        /**
         * Specify whether to allow the number of B-frames in your output GOP structure to vary or not depending on your
         * input video content. To improve the subjective video quality of your output that has high-motion content:
         * Leave blank or keep the default value Adaptive. MediaConvert will use fewer B-frames for high-motion video
         * content than low-motion content. The maximum number of B- frames is limited by the value that you choose for
         * B-frames between reference frames. To use the same number B-frames for all types of content: Choose Static.
         * 
         * @param dynamicSubGop
         *        Specify whether to allow the number of B-frames in your output GOP structure to vary or not depending
         *        on your input video content. To improve the subjective video quality of your output that has
         *        high-motion content: Leave blank or keep the default value Adaptive. MediaConvert will use fewer
         *        B-frames for high-motion video content than low-motion content. The maximum number of B- frames is
         *        limited by the value that you choose for B-frames between reference frames. To use the same number
         *        B-frames for all types of content: Choose Static.
         * @see H264DynamicSubGop
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264DynamicSubGop
         */
        Builder dynamicSubGop(H264DynamicSubGop dynamicSubGop);

        /**
         * Entropy encoding mode. Use CABAC (must be in Main or High profile) or CAVLC.
         * 
         * @param entropyEncoding
         *        Entropy encoding mode. Use CABAC (must be in Main or High profile) or CAVLC.
         * @see H264EntropyEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264EntropyEncoding
         */
        Builder entropyEncoding(String entropyEncoding);

        /**
         * Entropy encoding mode. Use CABAC (must be in Main or High profile) or CAVLC.
         * 
         * @param entropyEncoding
         *        Entropy encoding mode. Use CABAC (must be in Main or High profile) or CAVLC.
         * @see H264EntropyEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264EntropyEncoding
         */
        Builder entropyEncoding(H264EntropyEncoding entropyEncoding);

        /**
         * The video encoding method for your MPEG-4 AVC output. Keep the default value, PAFF, to have MediaConvert use
         * PAFF encoding for interlaced outputs. Choose Force field (FORCE_FIELD) to disable PAFF encoding and create
         * separate interlaced fields. Choose MBAFF to disable PAFF and have MediaConvert use MBAFF encoding for
         * interlaced outputs.
         * 
         * @param fieldEncoding
         *        The video encoding method for your MPEG-4 AVC output. Keep the default value, PAFF, to have
         *        MediaConvert use PAFF encoding for interlaced outputs. Choose Force field (FORCE_FIELD) to disable
         *        PAFF encoding and create separate interlaced fields. Choose MBAFF to disable PAFF and have
         *        MediaConvert use MBAFF encoding for interlaced outputs.
         * @see H264FieldEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264FieldEncoding
         */
        Builder fieldEncoding(String fieldEncoding);

        /**
         * The video encoding method for your MPEG-4 AVC output. Keep the default value, PAFF, to have MediaConvert use
         * PAFF encoding for interlaced outputs. Choose Force field (FORCE_FIELD) to disable PAFF encoding and create
         * separate interlaced fields. Choose MBAFF to disable PAFF and have MediaConvert use MBAFF encoding for
         * interlaced outputs.
         * 
         * @param fieldEncoding
         *        The video encoding method for your MPEG-4 AVC output. Keep the default value, PAFF, to have
         *        MediaConvert use PAFF encoding for interlaced outputs. Choose Force field (FORCE_FIELD) to disable
         *        PAFF encoding and create separate interlaced fields. Choose MBAFF to disable PAFF and have
         *        MediaConvert use MBAFF encoding for interlaced outputs.
         * @see H264FieldEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264FieldEncoding
         */
        Builder fieldEncoding(H264FieldEncoding fieldEncoding);

        /**
         * Only use this setting when you change the default value, AUTO, for the setting H264AdaptiveQuantization. When
         * you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON
         * job specification, MediaConvert automatically applies the best types of quantization for your video content.
         * When you set H264AdaptiveQuantization to a value other than AUTO, the default value for
         * H264FlickerAdaptiveQuantization is Disabled (DISABLED). Change this value to Enabled (ENABLED) to reduce
         * I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying
         * some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this
         * setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. To manually
         * enable or disable H264FlickerAdaptiveQuantization, you must set Adaptive quantization
         * (H264AdaptiveQuantization) to a value other than AUTO.
         * 
         * @param flickerAdaptiveQuantization
         *        Only use this setting when you change the default value, AUTO, for the setting
         *        H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other
         *        adaptive quantization from your JSON job specification, MediaConvert automatically applies the best
         *        types of quantization for your video content. When you set H264AdaptiveQuantization to a value other
         *        than AUTO, the default value for H264FlickerAdaptiveQuantization is Disabled (DISABLED). Change this
         *        value to Enabled (ENABLED) to reduce I-frame pop. I-frame pop appears as a visual flicker that can
         *        arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then
         *        refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks
         *        slightly more often to smooth out the flicker. To manually enable or disable
         *        H264FlickerAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a
         *        value other than AUTO.
         * @see H264FlickerAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264FlickerAdaptiveQuantization
         */
        Builder flickerAdaptiveQuantization(String flickerAdaptiveQuantization);

        /**
         * Only use this setting when you change the default value, AUTO, for the setting H264AdaptiveQuantization. When
         * you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON
         * job specification, MediaConvert automatically applies the best types of quantization for your video content.
         * When you set H264AdaptiveQuantization to a value other than AUTO, the default value for
         * H264FlickerAdaptiveQuantization is Disabled (DISABLED). Change this value to Enabled (ENABLED) to reduce
         * I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying
         * some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this
         * setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. To manually
         * enable or disable H264FlickerAdaptiveQuantization, you must set Adaptive quantization
         * (H264AdaptiveQuantization) to a value other than AUTO.
         * 
         * @param flickerAdaptiveQuantization
         *        Only use this setting when you change the default value, AUTO, for the setting
         *        H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other
         *        adaptive quantization from your JSON job specification, MediaConvert automatically applies the best
         *        types of quantization for your video content. When you set H264AdaptiveQuantization to a value other
         *        than AUTO, the default value for H264FlickerAdaptiveQuantization is Disabled (DISABLED). Change this
         *        value to Enabled (ENABLED) to reduce I-frame pop. I-frame pop appears as a visual flicker that can
         *        arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then
         *        refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks
         *        slightly more often to smooth out the flicker. To manually enable or disable
         *        H264FlickerAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a
         *        value other than AUTO.
         * @see H264FlickerAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264FlickerAdaptiveQuantization
         */
        Builder flickerAdaptiveQuantization(H264FlickerAdaptiveQuantization flickerAdaptiveQuantization);

        /**
         * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
         * want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
         * conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown
         * list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If
         * you are creating your transcoding job specification as a JSON file without the console, use FramerateControl
         * to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if
         * you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use
         * the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
         * 
         * @param framerateControl
         *        If you are using the console, use the Framerate setting to specify the frame rate for this output. If
         *        you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame
         *        rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in
         *        the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame
         *        rate as a fraction. If you are creating your transcoding job specification as a JSON file without the
         *        console, use FramerateControl to specify which value the service uses for the frame rate for this
         *        output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input.
         *        Choose SPECIFIED if you want the service to use the frame rate you specify in the settings
         *        FramerateNumerator and FramerateDenominator.
         * @see H264FramerateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264FramerateControl
         */
        Builder framerateControl(String framerateControl);

        /**
         * If you are using the console, use the Framerate setting to specify the frame rate for this output. If you
         * want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate
         * conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown
         * list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If
         * you are creating your transcoding job specification as a JSON file without the console, use FramerateControl
         * to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if
         * you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use
         * the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
         * 
         * @param framerateControl
         *        If you are using the console, use the Framerate setting to specify the frame rate for this output. If
         *        you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame
         *        rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in
         *        the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame
         *        rate as a fraction. If you are creating your transcoding job specification as a JSON file without the
         *        console, use FramerateControl to specify which value the service uses for the frame rate for this
         *        output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input.
         *        Choose SPECIFIED if you want the service to use the frame rate you specify in the settings
         *        FramerateNumerator and FramerateDenominator.
         * @see H264FramerateControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264FramerateControl
         */
        Builder framerateControl(H264FramerateControl framerateControl);

        /**
         * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. For
         * numerically simple conversions, such as 60 fps to 30 fps: We recommend that you keep the default value, Drop
         * duplicate. For numerically complex conversions, to avoid stutter: Choose Interpolate. This results in a
         * smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions,
         * especially if your source video has already been converted from its original cadence: Choose FrameFormer to
         * do motion-compensated interpolation. FrameFormer uses the best conversion method frame by frame. Note that
         * using FrameFormer increases the transcoding time and incurs a significant add-on cost. When you choose
         * FrameFormer, your input video resolution must be at least 128x96.
         * 
         * @param framerateConversionAlgorithm
         *        Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. For
         *        numerically simple conversions, such as 60 fps to 30 fps: We recommend that you keep the default
         *        value, Drop duplicate. For numerically complex conversions, to avoid stutter: Choose Interpolate. This
         *        results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate
         *        conversions, especially if your source video has already been converted from its original cadence:
         *        Choose FrameFormer to do motion-compensated interpolation. FrameFormer uses the best conversion method
         *        frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant
         *        add-on cost. When you choose FrameFormer, your input video resolution must be at least 128x96.
         * @see H264FramerateConversionAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264FramerateConversionAlgorithm
         */
        Builder framerateConversionAlgorithm(String framerateConversionAlgorithm);

        /**
         * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. For
         * numerically simple conversions, such as 60 fps to 30 fps: We recommend that you keep the default value, Drop
         * duplicate. For numerically complex conversions, to avoid stutter: Choose Interpolate. This results in a
         * smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions,
         * especially if your source video has already been converted from its original cadence: Choose FrameFormer to
         * do motion-compensated interpolation. FrameFormer uses the best conversion method frame by frame. Note that
         * using FrameFormer increases the transcoding time and incurs a significant add-on cost. When you choose
         * FrameFormer, your input video resolution must be at least 128x96.
         * 
         * @param framerateConversionAlgorithm
         *        Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. For
         *        numerically simple conversions, such as 60 fps to 30 fps: We recommend that you keep the default
         *        value, Drop duplicate. For numerically complex conversions, to avoid stutter: Choose Interpolate. This
         *        results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate
         *        conversions, especially if your source video has already been converted from its original cadence:
         *        Choose FrameFormer to do motion-compensated interpolation. FrameFormer uses the best conversion method
         *        frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant
         *        add-on cost. When you choose FrameFormer, your input video resolution must be at least 128x96.
         * @see H264FramerateConversionAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264FramerateConversionAlgorithm
         */
        Builder framerateConversionAlgorithm(H264FramerateConversionAlgorithm framerateConversionAlgorithm);

        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction.
         * For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction.
         * In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs
         * that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify
         * 23.976.
         * 
         * @param framerateDenominator
         *        When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
         *        fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator
         *        of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the
         *        console for transcode jobs that use frame rate conversion, provide the value as a decimal number for
         *        Framerate. In this example, specify 23.976.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateDenominator(Integer framerateDenominator);

        /**
         * When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction.
         * For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In
         * this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that
         * use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify
         * 23.976.
         * 
         * @param framerateNumerator
         *        When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a
         *        fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of
         *        this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the
         *        console for transcode jobs that use frame rate conversion, provide the value as a decimal number for
         *        Framerate. In this example, specify 23.976.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerateNumerator(Integer framerateNumerator);

        /**
         * Specify whether to allow B-frames to be referenced by other frame types. To use reference B-frames when your
         * GOP structure has 1 or more B-frames: Leave blank or keep the default value Enabled. We recommend that you
         * choose Enabled to help improve the video quality of your output relative to its bitrate. To not use reference
         * B-frames: Choose Disabled.
         * 
         * @param gopBReference
         *        Specify whether to allow B-frames to be referenced by other frame types. To use reference B-frames
         *        when your GOP structure has 1 or more B-frames: Leave blank or keep the default value Enabled. We
         *        recommend that you choose Enabled to help improve the video quality of your output relative to its
         *        bitrate. To not use reference B-frames: Choose Disabled.
         * @see H264GopBReference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264GopBReference
         */
        Builder gopBReference(String gopBReference);

        /**
         * Specify whether to allow B-frames to be referenced by other frame types. To use reference B-frames when your
         * GOP structure has 1 or more B-frames: Leave blank or keep the default value Enabled. We recommend that you
         * choose Enabled to help improve the video quality of your output relative to its bitrate. To not use reference
         * B-frames: Choose Disabled.
         * 
         * @param gopBReference
         *        Specify whether to allow B-frames to be referenced by other frame types. To use reference B-frames
         *        when your GOP structure has 1 or more B-frames: Leave blank or keep the default value Enabled. We
         *        recommend that you choose Enabled to help improve the video quality of your output relative to its
         *        bitrate. To not use reference B-frames: Choose Disabled.
         * @see H264GopBReference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264GopBReference
         */
        Builder gopBReference(H264GopBReference gopBReference);

        /**
         * Specify the relative frequency of open to closed GOPs in this output. For example, if you want to allow four
         * open GOPs and then require a closed GOP, set this value to 5. We recommend that you have the transcoder
         * automatically choose this value for you based on characteristics of your input video. To enable this
         * automatic behavior, keep the default value by leaving this setting out of your JSON job specification. In the
         * console, do this by keeping the default empty value. If you do explicitly specify a value, for segmented
         * outputs, don't set this value to 0.
         * 
         * @param gopClosedCadence
         *        Specify the relative frequency of open to closed GOPs in this output. For example, if you want to
         *        allow four open GOPs and then require a closed GOP, set this value to 5. We recommend that you have
         *        the transcoder automatically choose this value for you based on characteristics of your input video.
         *        To enable this automatic behavior, keep the default value by leaving this setting out of your JSON job
         *        specification. In the console, do this by keeping the default empty value. If you do explicitly
         *        specify a value, for segmented outputs, don't set this value to 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gopClosedCadence(Integer gopClosedCadence);

        /**
         * Use this setting only when you set GOP mode control (GopSizeUnits) to Specified, frames (FRAMES) or
         * Specified, seconds (SECONDS). Specify the GOP length using a whole number of frames or a decimal value of
         * seconds. MediaConvert will interpret this value as frames or seconds depending on the value you choose for
         * GOP mode control (GopSizeUnits). If you want to allow MediaConvert to automatically determine GOP size, leave
         * GOP size blank and set GOP mode control to Auto (AUTO). If your output group specifies HLS, DASH, or CMAF,
         * leave GOP size blank and set GOP mode control to Auto in each output in your output group.
         * 
         * @param gopSize
         *        Use this setting only when you set GOP mode control (GopSizeUnits) to Specified, frames (FRAMES) or
         *        Specified, seconds (SECONDS). Specify the GOP length using a whole number of frames or a decimal value
         *        of seconds. MediaConvert will interpret this value as frames or seconds depending on the value you
         *        choose for GOP mode control (GopSizeUnits). If you want to allow MediaConvert to automatically
         *        determine GOP size, leave GOP size blank and set GOP mode control to Auto (AUTO). If your output group
         *        specifies HLS, DASH, or CMAF, leave GOP size blank and set GOP mode control to Auto in each output in
         *        your output group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gopSize(Double gopSize);

        /**
         * Specify how the transcoder determines GOP size for this output. We recommend that you have the transcoder
         * automatically choose this value for you based on characteristics of your input video. To enable this
         * automatic behavior, choose Auto (AUTO) and and leave GOP size (GopSize) blank. By default, if you don't
         * specify GOP mode control (GopSizeUnits), MediaConvert will use automatic behavior. If your output group
         * specifies HLS, DASH, or CMAF, set GOP mode control to Auto and leave GOP size blank in each output in your
         * output group. To explicitly specify the GOP length, choose Specified, frames (FRAMES) or Specified, seconds
         * (SECONDS) and then provide the GOP length in the related setting GOP size (GopSize).
         * 
         * @param gopSizeUnits
         *        Specify how the transcoder determines GOP size for this output. We recommend that you have the
         *        transcoder automatically choose this value for you based on characteristics of your input video. To
         *        enable this automatic behavior, choose Auto (AUTO) and and leave GOP size (GopSize) blank. By default,
         *        if you don't specify GOP mode control (GopSizeUnits), MediaConvert will use automatic behavior. If
         *        your output group specifies HLS, DASH, or CMAF, set GOP mode control to Auto and leave GOP size blank
         *        in each output in your output group. To explicitly specify the GOP length, choose Specified, frames
         *        (FRAMES) or Specified, seconds (SECONDS) and then provide the GOP length in the related setting GOP
         *        size (GopSize).
         * @see H264GopSizeUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264GopSizeUnits
         */
        Builder gopSizeUnits(String gopSizeUnits);

        /**
         * Specify how the transcoder determines GOP size for this output. We recommend that you have the transcoder
         * automatically choose this value for you based on characteristics of your input video. To enable this
         * automatic behavior, choose Auto (AUTO) and and leave GOP size (GopSize) blank. By default, if you don't
         * specify GOP mode control (GopSizeUnits), MediaConvert will use automatic behavior. If your output group
         * specifies HLS, DASH, or CMAF, set GOP mode control to Auto and leave GOP size blank in each output in your
         * output group. To explicitly specify the GOP length, choose Specified, frames (FRAMES) or Specified, seconds
         * (SECONDS) and then provide the GOP length in the related setting GOP size (GopSize).
         * 
         * @param gopSizeUnits
         *        Specify how the transcoder determines GOP size for this output. We recommend that you have the
         *        transcoder automatically choose this value for you based on characteristics of your input video. To
         *        enable this automatic behavior, choose Auto (AUTO) and and leave GOP size (GopSize) blank. By default,
         *        if you don't specify GOP mode control (GopSizeUnits), MediaConvert will use automatic behavior. If
         *        your output group specifies HLS, DASH, or CMAF, set GOP mode control to Auto and leave GOP size blank
         *        in each output in your output group. To explicitly specify the GOP length, choose Specified, frames
         *        (FRAMES) or Specified, seconds (SECONDS) and then provide the GOP length in the related setting GOP
         *        size (GopSize).
         * @see H264GopSizeUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264GopSizeUnits
         */
        Builder gopSizeUnits(H264GopSizeUnits gopSizeUnits);

        /**
         * If your downstream systems have strict buffer requirements: Specify the minimum percentage of the HRD buffer
         * that's available at the end of each encoded video segment. For the best video quality: Set to 0 or leave
         * blank to automatically determine the final buffer fill percentage.
         * 
         * @param hrdBufferFinalFillPercentage
         *        If your downstream systems have strict buffer requirements: Specify the minimum percentage of the HRD
         *        buffer that's available at the end of each encoded video segment. For the best video quality: Set to 0
         *        or leave blank to automatically determine the final buffer fill percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hrdBufferFinalFillPercentage(Integer hrdBufferFinalFillPercentage);

        /**
         * Percentage of the buffer that should initially be filled (HRD buffer model).
         * 
         * @param hrdBufferInitialFillPercentage
         *        Percentage of the buffer that should initially be filled (HRD buffer model).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hrdBufferInitialFillPercentage(Integer hrdBufferInitialFillPercentage);

        /**
         * Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
         * 
         * @param hrdBufferSize
         *        Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hrdBufferSize(Integer hrdBufferSize);

        /**
         * Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a
         * progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom
         * field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use
         * Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs
         * with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity
         * might change over the course of the output. Follow behavior depends on the input scan type. If the source is
         * interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive,
         * the output will be interlaced with top field bottom field first, depending on which of the Follow options you
         * choose.
         * 
         * @param interlaceMode
         *        Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create
         *        a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or
         *        Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity
         *        throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD)
         *        to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the
         *        output field polarity might change over the course of the output. Follow behavior depends on the input
         *        scan type. If the source is interlaced, the output will be interlaced with the same polarity as the
         *        source. If the source is progressive, the output will be interlaced with top field bottom field first,
         *        depending on which of the Follow options you choose.
         * @see H264InterlaceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264InterlaceMode
         */
        Builder interlaceMode(String interlaceMode);

        /**
         * Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a
         * progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom
         * field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use
         * Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs
         * with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity
         * might change over the course of the output. Follow behavior depends on the input scan type. If the source is
         * interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive,
         * the output will be interlaced with top field bottom field first, depending on which of the Follow options you
         * choose.
         * 
         * @param interlaceMode
         *        Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create
         *        a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or
         *        Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity
         *        throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD)
         *        to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the
         *        output field polarity might change over the course of the output. Follow behavior depends on the input
         *        scan type. If the source is interlaced, the output will be interlaced with the same polarity as the
         *        source. If the source is progressive, the output will be interlaced with top field bottom field first,
         *        depending on which of the Follow options you choose.
         * @see H264InterlaceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264InterlaceMode
         */
        Builder interlaceMode(H264InterlaceMode interlaceMode);

        /**
         * Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when Rate
         * control mode is QVBR.
         * 
         * @param maxBitrate
         *        Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when
         *        Rate control mode is QVBR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBitrate(Integer maxBitrate);

        /**
         * Use this setting only when you also enable Scene change detection (SceneChangeDetect). This setting
         * determines how the encoder manages the spacing between I-frames that it inserts as part of the I-frame
         * cadence and the I-frames that it inserts for Scene change detection. We recommend that you have the
         * transcoder automatically choose this value for you based on characteristics of your input video. To enable
         * this automatic behavior, keep the default value by leaving this setting out of your JSON job specification.
         * In the console, do this by keeping the default empty value. When you explicitly specify a value for this
         * setting, the encoder determines whether to skip a cadence-driven I-frame by the value you set. For example,
         * if you set Min I interval (minIInterval) to 5 and a cadence-driven I-frame would fall within 5 frames of a
         * scene-change I-frame, then the encoder skips the cadence-driven I-frame. In this way, one GOP is shrunk
         * slightly and one GOP is stretched slightly. When the cadence-driven I-frames are farther from the
         * scene-change I-frame than the value you set, then the encoder leaves all I-frames in place and the GOPs
         * surrounding the scene change are smaller than the usual cadence GOPs.
         * 
         * @param minIInterval
         *        Use this setting only when you also enable Scene change detection (SceneChangeDetect). This setting
         *        determines how the encoder manages the spacing between I-frames that it inserts as part of the I-frame
         *        cadence and the I-frames that it inserts for Scene change detection. We recommend that you have the
         *        transcoder automatically choose this value for you based on characteristics of your input video. To
         *        enable this automatic behavior, keep the default value by leaving this setting out of your JSON job
         *        specification. In the console, do this by keeping the default empty value. When you explicitly specify
         *        a value for this setting, the encoder determines whether to skip a cadence-driven I-frame by the value
         *        you set. For example, if you set Min I interval (minIInterval) to 5 and a cadence-driven I-frame would
         *        fall within 5 frames of a scene-change I-frame, then the encoder skips the cadence-driven I-frame. In
         *        this way, one GOP is shrunk slightly and one GOP is stretched slightly. When the cadence-driven
         *        I-frames are farther from the scene-change I-frame than the value you set, then the encoder leaves all
         *        I-frames in place and the GOPs surrounding the scene change are smaller than the usual cadence GOPs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minIInterval(Integer minIInterval);

        /**
         * Specify the number of B-frames between reference frames in this output. For the best video quality: Leave
         * blank. MediaConvert automatically determines the number of B-frames to use based on the characteristics of
         * your input video. To manually specify the number of B-frames between reference frames: Enter an integer from
         * 0 to 7.
         * 
         * @param numberBFramesBetweenReferenceFrames
         *        Specify the number of B-frames between reference frames in this output. For the best video quality:
         *        Leave blank. MediaConvert automatically determines the number of B-frames to use based on the
         *        characteristics of your input video. To manually specify the number of B-frames between reference
         *        frames: Enter an integer from 0 to 7.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames);

        /**
         * Number of reference frames to use. The encoder may use more than requested if using B-frames and/or
         * interlaced encoding.
         * 
         * @param numberReferenceFrames
         *        Number of reference frames to use. The encoder may use more than requested if using B-frames and/or
         *        interlaced encoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberReferenceFrames(Integer numberReferenceFrames);

        /**
         * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
         * behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To
         * specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR
         * by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must
         * also specify values for the parNumerator and parDenominator settings.
         * 
         * @param parControl
         *        Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
         *        behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output.
         *        To specify a different PAR in the console, choose any value other than Follow source. To specify a
         *        different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for
         *        this setting, you must also specify values for the parNumerator and parDenominator settings.
         * @see H264ParControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264ParControl
         */
        Builder parControl(String parControl);

        /**
         * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
         * behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To
         * specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR
         * by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must
         * also specify values for the parNumerator and parDenominator settings.
         * 
         * @param parControl
         *        Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default
         *        behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output.
         *        To specify a different PAR in the console, choose any value other than Follow source. To specify a
         *        different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for
         *        this setting, you must also specify values for the parNumerator and parDenominator settings.
         * @see H264ParControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264ParControl
         */
        Builder parControl(H264ParControl parControl);

        /**
         * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any
         * value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from
         * your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would
         * specify the ratio 40:33. In this example, the value for parDenominator is 33.
         * 
         * @param parDenominator
         *        Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds
         *        to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is
         *        different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC
         *        widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parDenominator(Integer parDenominator);

        /**
         * Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any
         * value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from
         * your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would
         * specify the ratio 40:33. In this example, the value for parNumerator is 40.
         * 
         * @param parNumerator
         *        Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds
         *        to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is
         *        different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC
         *        widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parNumerator(Integer parNumerator);

        /**
         * The Quality tuning level you choose represents a trade-off between the encoding speed of your job and the
         * output video quality. For the fastest encoding speed at the cost of video quality: Choose Single pass. For a
         * good balance between encoding speed and video quality: Leave blank or keep the default value Single pass HQ.
         * For the best video quality, at the cost of encoding speed: Choose Multi pass HQ. MediaConvert performs an
         * analysis pass on your input followed by an encoding pass. Outputs that use this feature incur pro-tier
         * pricing.
         * 
         * @param qualityTuningLevel
         *        The Quality tuning level you choose represents a trade-off between the encoding speed of your job and
         *        the output video quality. For the fastest encoding speed at the cost of video quality: Choose Single
         *        pass. For a good balance between encoding speed and video quality: Leave blank or keep the default
         *        value Single pass HQ. For the best video quality, at the cost of encoding speed: Choose Multi pass HQ.
         *        MediaConvert performs an analysis pass on your input followed by an encoding pass. Outputs that use
         *        this feature incur pro-tier pricing.
         * @see H264QualityTuningLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264QualityTuningLevel
         */
        Builder qualityTuningLevel(String qualityTuningLevel);

        /**
         * The Quality tuning level you choose represents a trade-off between the encoding speed of your job and the
         * output video quality. For the fastest encoding speed at the cost of video quality: Choose Single pass. For a
         * good balance between encoding speed and video quality: Leave blank or keep the default value Single pass HQ.
         * For the best video quality, at the cost of encoding speed: Choose Multi pass HQ. MediaConvert performs an
         * analysis pass on your input followed by an encoding pass. Outputs that use this feature incur pro-tier
         * pricing.
         * 
         * @param qualityTuningLevel
         *        The Quality tuning level you choose represents a trade-off between the encoding speed of your job and
         *        the output video quality. For the fastest encoding speed at the cost of video quality: Choose Single
         *        pass. For a good balance between encoding speed and video quality: Leave blank or keep the default
         *        value Single pass HQ. For the best video quality, at the cost of encoding speed: Choose Multi pass HQ.
         *        MediaConvert performs an analysis pass on your input followed by an encoding pass. Outputs that use
         *        this feature incur pro-tier pricing.
         * @see H264QualityTuningLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264QualityTuningLevel
         */
        Builder qualityTuningLevel(H264QualityTuningLevel qualityTuningLevel);

        /**
         * Settings for quality-defined variable bitrate encoding with the H.265 codec. Use these settings only when you
         * set QVBR for Rate control mode (RateControlMode).
         * 
         * @param qvbrSettings
         *        Settings for quality-defined variable bitrate encoding with the H.265 codec. Use these settings only
         *        when you set QVBR for Rate control mode (RateControlMode).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qvbrSettings(H264QvbrSettings qvbrSettings);

        /**
         * Settings for quality-defined variable bitrate encoding with the H.265 codec. Use these settings only when you
         * set QVBR for Rate control mode (RateControlMode). This is a convenience method that creates an instance of
         * the {@link H264QvbrSettings.Builder} avoiding the need to create one manually via
         * {@link H264QvbrSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link H264QvbrSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #qvbrSettings(H264QvbrSettings)}.
         * 
         * @param qvbrSettings
         *        a consumer that will call methods on {@link H264QvbrSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qvbrSettings(H264QvbrSettings)
         */
        default Builder qvbrSettings(Consumer<H264QvbrSettings.Builder> qvbrSettings) {
            return qvbrSettings(H264QvbrSettings.builder().applyMutation(qvbrSettings).build());
        }

        /**
         * Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or
         * quality-defined variable bitrate (QVBR).
         * 
         * @param rateControlMode
         *        Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR)
         *        or quality-defined variable bitrate (QVBR).
         * @see H264RateControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264RateControlMode
         */
        Builder rateControlMode(String rateControlMode);

        /**
         * Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or
         * quality-defined variable bitrate (QVBR).
         * 
         * @param rateControlMode
         *        Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR)
         *        or quality-defined variable bitrate (QVBR).
         * @see H264RateControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264RateControlMode
         */
        Builder rateControlMode(H264RateControlMode rateControlMode);

        /**
         * Places a PPS header on each encoded picture, even if repeated.
         * 
         * @param repeatPps
         *        Places a PPS header on each encoded picture, even if repeated.
         * @see H264RepeatPps
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264RepeatPps
         */
        Builder repeatPps(String repeatPps);

        /**
         * Places a PPS header on each encoded picture, even if repeated.
         * 
         * @param repeatPps
         *        Places a PPS header on each encoded picture, even if repeated.
         * @see H264RepeatPps
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264RepeatPps
         */
        Builder repeatPps(H264RepeatPps repeatPps);

        /**
         * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In
         * this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced
         * output. In this case, each progressive frame from the input corresponds to an interlaced field in the output.
         * Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic
         * interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you
         * choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized
         * interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized
         * interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized
         * interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than
         * Progressive (PROGRESSIVE).
         * 
         * @param scanTypeConversionMode
         *        Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate.
         *        In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality
         *        interlaced output. In this case, each progressive frame from the input corresponds to an interlaced
         *        field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output
         *        frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then
         *        interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a
         *        value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic
         *        interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None
         *        (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also
         *        set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
         * @see H264ScanTypeConversionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264ScanTypeConversionMode
         */
        Builder scanTypeConversionMode(String scanTypeConversionMode);

        /**
         * Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In
         * this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced
         * output. In this case, each progressive frame from the input corresponds to an interlaced field in the output.
         * Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic
         * interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you
         * choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized
         * interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized
         * interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized
         * interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than
         * Progressive (PROGRESSIVE).
         * 
         * @param scanTypeConversionMode
         *        Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate.
         *        In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality
         *        interlaced output. In this case, each progressive frame from the input corresponds to an interlaced
         *        field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output
         *        frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then
         *        interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a
         *        value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic
         *        interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None
         *        (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also
         *        set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
         * @see H264ScanTypeConversionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264ScanTypeConversionMode
         */
        Builder scanTypeConversionMode(H264ScanTypeConversionMode scanTypeConversionMode);

        /**
         * Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves
         * video quality and is enabled by default. If this output uses QVBR, choose Transition detection
         * (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see
         * https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
         * 
         * @param sceneChangeDetect
         *        Enable this setting to insert I-frames at scene changes that the service automatically detects. This
         *        improves video quality and is enabled by default. If this output uses QVBR, choose Transition
         *        detection (TRANSITION_DETECTION) for further video quality improvement. For more information about
         *        QVBR, see https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
         * @see H264SceneChangeDetect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264SceneChangeDetect
         */
        Builder sceneChangeDetect(String sceneChangeDetect);

        /**
         * Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves
         * video quality and is enabled by default. If this output uses QVBR, choose Transition detection
         * (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see
         * https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
         * 
         * @param sceneChangeDetect
         *        Enable this setting to insert I-frames at scene changes that the service automatically detects. This
         *        improves video quality and is enabled by default. If this output uses QVBR, choose Transition
         *        detection (TRANSITION_DETECTION) for further video quality improvement. For more information about
         *        QVBR, see https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
         * @see H264SceneChangeDetect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264SceneChangeDetect
         */
        Builder sceneChangeDetect(H264SceneChangeDetect sceneChangeDetect);

        /**
         * Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive
         * pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
         * 
         * @param slices
         *        Number of slices per picture. Must be less than or equal to the number of macroblock rows for
         *        progressive pictures, and less than or equal to half the number of macroblock rows for interlaced
         *        pictures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slices(Integer slices);

        /**
         * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to
         * create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and
         * resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly
         * reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job
         * specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator)
         * to 1.
         * 
         * @param slowPal
         *        Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow
         *        PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25
         *        fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting
         *        will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25.
         *        In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and
         *        (framerateDenominator) to 1.
         * @see H264SlowPal
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264SlowPal
         */
        Builder slowPal(String slowPal);

        /**
         * Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to
         * create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and
         * resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly
         * reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job
         * specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator)
         * to 1.
         * 
         * @param slowPal
         *        Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow
         *        PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25
         *        fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting
         *        will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25.
         *        In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and
         *        (framerateDenominator) to 1.
         * @see H264SlowPal
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264SlowPal
         */
        Builder slowPal(H264SlowPal slowPal);

        /**
         * Ignore this setting unless you need to comply with a specification that requires a specific value. If you
         * don't have a specification requirement, we recommend that you adjust the softness of your output by using a
         * lower value for the setting Sharpness (sharpness) or by enabling a noise reducer filter (noiseReducerFilter).
         * The Softness (softness) setting specifies the quantization matrices that the encoder uses. Keep the default
         * value, 0, for flat quantization. Choose the value 1 or 16 to use the default JVT softening quantization
         * matricies from the H.264 specification. Choose a value from 17 to 128 to use planar interpolation. Increasing
         * values from 17 to 128 result in increasing reduction of high-frequency data. The value 128 results in the
         * softest video.
         * 
         * @param softness
         *        Ignore this setting unless you need to comply with a specification that requires a specific value. If
         *        you don't have a specification requirement, we recommend that you adjust the softness of your output
         *        by using a lower value for the setting Sharpness (sharpness) or by enabling a noise reducer filter
         *        (noiseReducerFilter). The Softness (softness) setting specifies the quantization matrices that the
         *        encoder uses. Keep the default value, 0, for flat quantization. Choose the value 1 or 16 to use the
         *        default JVT softening quantization matricies from the H.264 specification. Choose a value from 17 to
         *        128 to use planar interpolation. Increasing values from 17 to 128 result in increasing reduction of
         *        high-frequency data. The value 128 results in the softest video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softness(Integer softness);

        /**
         * Only use this setting when you change the default value, Auto (AUTO), for the setting
         * H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other
         * adaptive quantization from your JSON job specification, MediaConvert automatically applies the best types of
         * quantization for your video content. When you set H264AdaptiveQuantization to a value other than AUTO, the
         * default value for H264SpatialAdaptiveQuantization is Enabled (ENABLED). Keep this default value to adjust
         * quantization within each frame based on spatial variation of content complexity. When you enable this
         * feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual
         * degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex
         * textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling
         * this feature will almost always improve your video quality. Note, though, that this feature doesn't take into
         * account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on
         * a part of the screen with a lot of complex texture, you might choose to set H264SpatialAdaptiveQuantization
         * to Disabled (DISABLED). Related setting: When you enable spatial adaptive quantization, set the value for
         * Adaptive quantization (H264AdaptiveQuantization) depending on your content. For homogeneous content, such as
         * cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or
         * Higher. To manually enable or disable H264SpatialAdaptiveQuantization, you must set Adaptive quantization
         * (H264AdaptiveQuantization) to a value other than AUTO.
         * 
         * @param spatialAdaptiveQuantization
         *        Only use this setting when you change the default value, Auto (AUTO), for the setting
         *        H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other
         *        adaptive quantization from your JSON job specification, MediaConvert automatically applies the best
         *        types of quantization for your video content. When you set H264AdaptiveQuantization to a value other
         *        than AUTO, the default value for H264SpatialAdaptiveQuantization is Enabled (ENABLED). Keep this
         *        default value to adjust quantization within each frame based on spatial variation of content
         *        complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more
         *        distortion with no noticeable visual degradation and uses more bits on areas where any small
         *        distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and
         *        smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve
         *        your video quality. Note, though, that this feature doesn't take into account where the viewer's
         *        attention is likely to be. If viewers are likely to be focusing their attention on a part of the
         *        screen with a lot of complex texture, you might choose to set H264SpatialAdaptiveQuantization to
         *        Disabled (DISABLED). Related setting: When you enable spatial adaptive quantization, set the value for
         *        Adaptive quantization (H264AdaptiveQuantization) depending on your content. For homogeneous content,
         *        such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it
         *        to High or Higher. To manually enable or disable H264SpatialAdaptiveQuantization, you must set
         *        Adaptive quantization (H264AdaptiveQuantization) to a value other than AUTO.
         * @see H264SpatialAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264SpatialAdaptiveQuantization
         */
        Builder spatialAdaptiveQuantization(String spatialAdaptiveQuantization);

        /**
         * Only use this setting when you change the default value, Auto (AUTO), for the setting
         * H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other
         * adaptive quantization from your JSON job specification, MediaConvert automatically applies the best types of
         * quantization for your video content. When you set H264AdaptiveQuantization to a value other than AUTO, the
         * default value for H264SpatialAdaptiveQuantization is Enabled (ENABLED). Keep this default value to adjust
         * quantization within each frame based on spatial variation of content complexity. When you enable this
         * feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual
         * degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex
         * textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling
         * this feature will almost always improve your video quality. Note, though, that this feature doesn't take into
         * account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on
         * a part of the screen with a lot of complex texture, you might choose to set H264SpatialAdaptiveQuantization
         * to Disabled (DISABLED). Related setting: When you enable spatial adaptive quantization, set the value for
         * Adaptive quantization (H264AdaptiveQuantization) depending on your content. For homogeneous content, such as
         * cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or
         * Higher. To manually enable or disable H264SpatialAdaptiveQuantization, you must set Adaptive quantization
         * (H264AdaptiveQuantization) to a value other than AUTO.
         * 
         * @param spatialAdaptiveQuantization
         *        Only use this setting when you change the default value, Auto (AUTO), for the setting
         *        H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other
         *        adaptive quantization from your JSON job specification, MediaConvert automatically applies the best
         *        types of quantization for your video content. When you set H264AdaptiveQuantization to a value other
         *        than AUTO, the default value for H264SpatialAdaptiveQuantization is Enabled (ENABLED). Keep this
         *        default value to adjust quantization within each frame based on spatial variation of content
         *        complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more
         *        distortion with no noticeable visual degradation and uses more bits on areas where any small
         *        distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and
         *        smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve
         *        your video quality. Note, though, that this feature doesn't take into account where the viewer's
         *        attention is likely to be. If viewers are likely to be focusing their attention on a part of the
         *        screen with a lot of complex texture, you might choose to set H264SpatialAdaptiveQuantization to
         *        Disabled (DISABLED). Related setting: When you enable spatial adaptive quantization, set the value for
         *        Adaptive quantization (H264AdaptiveQuantization) depending on your content. For homogeneous content,
         *        such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it
         *        to High or Higher. To manually enable or disable H264SpatialAdaptiveQuantization, you must set
         *        Adaptive quantization (H264AdaptiveQuantization) to a value other than AUTO.
         * @see H264SpatialAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264SpatialAdaptiveQuantization
         */
        Builder spatialAdaptiveQuantization(H264SpatialAdaptiveQuantization spatialAdaptiveQuantization);

        /**
         * Produces a bitstream compliant with SMPTE RP-2027.
         * 
         * @param syntax
         *        Produces a bitstream compliant with SMPTE RP-2027.
         * @see H264Syntax
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264Syntax
         */
        Builder syntax(String syntax);

        /**
         * Produces a bitstream compliant with SMPTE RP-2027.
         * 
         * @param syntax
         *        Produces a bitstream compliant with SMPTE RP-2027.
         * @see H264Syntax
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264Syntax
         */
        Builder syntax(H264Syntax syntax);

        /**
         * When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type
         * is interlaced, you can optionally enable hard or soft telecine to create a smoother picture. Hard telecine
         * (HARD) produces a 29.97i output. Soft telecine (SOFT) produces an output with a 23.976 output that signals to
         * the video player device to do the conversion during play back. When you keep the default value, None (NONE),
         * MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field polarity to
         * create a smoother picture.
         * 
         * @param telecine
         *        When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output
         *        scan type is interlaced, you can optionally enable hard or soft telecine to create a smoother picture.
         *        Hard telecine (HARD) produces a 29.97i output. Soft telecine (SOFT) produces an output with a 23.976
         *        output that signals to the video player device to do the conversion during play back. When you keep
         *        the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without
         *        doing anything with the field polarity to create a smoother picture.
         * @see H264Telecine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264Telecine
         */
        Builder telecine(String telecine);

        /**
         * When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type
         * is interlaced, you can optionally enable hard or soft telecine to create a smoother picture. Hard telecine
         * (HARD) produces a 29.97i output. Soft telecine (SOFT) produces an output with a 23.976 output that signals to
         * the video player device to do the conversion during play back. When you keep the default value, None (NONE),
         * MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field polarity to
         * create a smoother picture.
         * 
         * @param telecine
         *        When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output
         *        scan type is interlaced, you can optionally enable hard or soft telecine to create a smoother picture.
         *        Hard telecine (HARD) produces a 29.97i output. Soft telecine (SOFT) produces an output with a 23.976
         *        output that signals to the video player device to do the conversion during play back. When you keep
         *        the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without
         *        doing anything with the field polarity to create a smoother picture.
         * @see H264Telecine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264Telecine
         */
        Builder telecine(H264Telecine telecine);

        /**
         * Only use this setting when you change the default value, AUTO, for the setting H264AdaptiveQuantization. When
         * you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON
         * job specification, MediaConvert automatically applies the best types of quantization for your video content.
         * When you set H264AdaptiveQuantization to a value other than AUTO, the default value for
         * H264TemporalAdaptiveQuantization is Enabled (ENABLED). Keep this default value to adjust quantization within
         * each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses
         * fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges
         * that move a lot. For example, this feature improves the readability of text tickers on newscasts and
         * scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note,
         * though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers
         * are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp
         * edges, such as sports athletes' faces, you might choose to set H264TemporalAdaptiveQuantization to Disabled
         * (DISABLED). Related setting: When you enable temporal quantization, adjust the strength of the filter with
         * the setting Adaptive quantization (adaptiveQuantization). To manually enable or disable
         * H264TemporalAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a value
         * other than AUTO.
         * 
         * @param temporalAdaptiveQuantization
         *        Only use this setting when you change the default value, AUTO, for the setting
         *        H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other
         *        adaptive quantization from your JSON job specification, MediaConvert automatically applies the best
         *        types of quantization for your video content. When you set H264AdaptiveQuantization to a value other
         *        than AUTO, the default value for H264TemporalAdaptiveQuantization is Enabled (ENABLED). Keep this
         *        default value to adjust quantization within each frame based on temporal variation of content
         *        complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that
         *        aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example,
         *        this feature improves the readability of text tickers on newscasts and scoreboards on sports matches.
         *        Enabling this feature will almost always improve your video quality. Note, though, that this feature
         *        doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be
         *        focusing their attention on a part of the screen that doesn't have moving objects with sharp edges,
         *        such as sports athletes' faces, you might choose to set H264TemporalAdaptiveQuantization to Disabled
         *        (DISABLED). Related setting: When you enable temporal quantization, adjust the strength of the filter
         *        with the setting Adaptive quantization (adaptiveQuantization). To manually enable or disable
         *        H264TemporalAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a
         *        value other than AUTO.
         * @see H264TemporalAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264TemporalAdaptiveQuantization
         */
        Builder temporalAdaptiveQuantization(String temporalAdaptiveQuantization);

        /**
         * Only use this setting when you change the default value, AUTO, for the setting H264AdaptiveQuantization. When
         * you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON
         * job specification, MediaConvert automatically applies the best types of quantization for your video content.
         * When you set H264AdaptiveQuantization to a value other than AUTO, the default value for
         * H264TemporalAdaptiveQuantization is Enabled (ENABLED). Keep this default value to adjust quantization within
         * each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses
         * fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges
         * that move a lot. For example, this feature improves the readability of text tickers on newscasts and
         * scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note,
         * though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers
         * are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp
         * edges, such as sports athletes' faces, you might choose to set H264TemporalAdaptiveQuantization to Disabled
         * (DISABLED). Related setting: When you enable temporal quantization, adjust the strength of the filter with
         * the setting Adaptive quantization (adaptiveQuantization). To manually enable or disable
         * H264TemporalAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a value
         * other than AUTO.
         * 
         * @param temporalAdaptiveQuantization
         *        Only use this setting when you change the default value, AUTO, for the setting
         *        H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other
         *        adaptive quantization from your JSON job specification, MediaConvert automatically applies the best
         *        types of quantization for your video content. When you set H264AdaptiveQuantization to a value other
         *        than AUTO, the default value for H264TemporalAdaptiveQuantization is Enabled (ENABLED). Keep this
         *        default value to adjust quantization within each frame based on temporal variation of content
         *        complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that
         *        aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example,
         *        this feature improves the readability of text tickers on newscasts and scoreboards on sports matches.
         *        Enabling this feature will almost always improve your video quality. Note, though, that this feature
         *        doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be
         *        focusing their attention on a part of the screen that doesn't have moving objects with sharp edges,
         *        such as sports athletes' faces, you might choose to set H264TemporalAdaptiveQuantization to Disabled
         *        (DISABLED). Related setting: When you enable temporal quantization, adjust the strength of the filter
         *        with the setting Adaptive quantization (adaptiveQuantization). To manually enable or disable
         *        H264TemporalAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a
         *        value other than AUTO.
         * @see H264TemporalAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264TemporalAdaptiveQuantization
         */
        Builder temporalAdaptiveQuantization(H264TemporalAdaptiveQuantization temporalAdaptiveQuantization);

        /**
         * Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
         * 
         * @param unregisteredSeiTimecode
         *        Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
         * @see H264UnregisteredSeiTimecode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264UnregisteredSeiTimecode
         */
        Builder unregisteredSeiTimecode(String unregisteredSeiTimecode);

        /**
         * Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
         * 
         * @param unregisteredSeiTimecode
         *        Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
         * @see H264UnregisteredSeiTimecode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see H264UnregisteredSeiTimecode
         */
        Builder unregisteredSeiTimecode(H264UnregisteredSeiTimecode unregisteredSeiTimecode);
    }

    static final class BuilderImpl implements Builder {
        private String adaptiveQuantization;

        private BandwidthReductionFilter bandwidthReductionFilter;

        private Integer bitrate;

        private String codecLevel;

        private String codecProfile;

        private String dynamicSubGop;

        private String entropyEncoding;

        private String fieldEncoding;

        private String flickerAdaptiveQuantization;

        private String framerateControl;

        private String framerateConversionAlgorithm;

        private Integer framerateDenominator;

        private Integer framerateNumerator;

        private String gopBReference;

        private Integer gopClosedCadence;

        private Double gopSize;

        private String gopSizeUnits;

        private Integer hrdBufferFinalFillPercentage;

        private Integer hrdBufferInitialFillPercentage;

        private Integer hrdBufferSize;

        private String interlaceMode;

        private Integer maxBitrate;

        private Integer minIInterval;

        private Integer numberBFramesBetweenReferenceFrames;

        private Integer numberReferenceFrames;

        private String parControl;

        private Integer parDenominator;

        private Integer parNumerator;

        private String qualityTuningLevel;

        private H264QvbrSettings qvbrSettings;

        private String rateControlMode;

        private String repeatPps;

        private String scanTypeConversionMode;

        private String sceneChangeDetect;

        private Integer slices;

        private String slowPal;

        private Integer softness;

        private String spatialAdaptiveQuantization;

        private String syntax;

        private String telecine;

        private String temporalAdaptiveQuantization;

        private String unregisteredSeiTimecode;

        private BuilderImpl() {
        }

        private BuilderImpl(H264Settings model) {
            adaptiveQuantization(model.adaptiveQuantization);
            bandwidthReductionFilter(model.bandwidthReductionFilter);
            bitrate(model.bitrate);
            codecLevel(model.codecLevel);
            codecProfile(model.codecProfile);
            dynamicSubGop(model.dynamicSubGop);
            entropyEncoding(model.entropyEncoding);
            fieldEncoding(model.fieldEncoding);
            flickerAdaptiveQuantization(model.flickerAdaptiveQuantization);
            framerateControl(model.framerateControl);
            framerateConversionAlgorithm(model.framerateConversionAlgorithm);
            framerateDenominator(model.framerateDenominator);
            framerateNumerator(model.framerateNumerator);
            gopBReference(model.gopBReference);
            gopClosedCadence(model.gopClosedCadence);
            gopSize(model.gopSize);
            gopSizeUnits(model.gopSizeUnits);
            hrdBufferFinalFillPercentage(model.hrdBufferFinalFillPercentage);
            hrdBufferInitialFillPercentage(model.hrdBufferInitialFillPercentage);
            hrdBufferSize(model.hrdBufferSize);
            interlaceMode(model.interlaceMode);
            maxBitrate(model.maxBitrate);
            minIInterval(model.minIInterval);
            numberBFramesBetweenReferenceFrames(model.numberBFramesBetweenReferenceFrames);
            numberReferenceFrames(model.numberReferenceFrames);
            parControl(model.parControl);
            parDenominator(model.parDenominator);
            parNumerator(model.parNumerator);
            qualityTuningLevel(model.qualityTuningLevel);
            qvbrSettings(model.qvbrSettings);
            rateControlMode(model.rateControlMode);
            repeatPps(model.repeatPps);
            scanTypeConversionMode(model.scanTypeConversionMode);
            sceneChangeDetect(model.sceneChangeDetect);
            slices(model.slices);
            slowPal(model.slowPal);
            softness(model.softness);
            spatialAdaptiveQuantization(model.spatialAdaptiveQuantization);
            syntax(model.syntax);
            telecine(model.telecine);
            temporalAdaptiveQuantization(model.temporalAdaptiveQuantization);
            unregisteredSeiTimecode(model.unregisteredSeiTimecode);
        }

        public final String getAdaptiveQuantization() {
            return adaptiveQuantization;
        }

        public final void setAdaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
        }

        @Override
        public final Builder adaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
            return this;
        }

        @Override
        public final Builder adaptiveQuantization(H264AdaptiveQuantization adaptiveQuantization) {
            this.adaptiveQuantization(adaptiveQuantization == null ? null : adaptiveQuantization.toString());
            return this;
        }

        public final BandwidthReductionFilter.Builder getBandwidthReductionFilter() {
            return bandwidthReductionFilter != null ? bandwidthReductionFilter.toBuilder() : null;
        }

        public final void setBandwidthReductionFilter(BandwidthReductionFilter.BuilderImpl bandwidthReductionFilter) {
            this.bandwidthReductionFilter = bandwidthReductionFilter != null ? bandwidthReductionFilter.build() : null;
        }

        @Override
        public final Builder bandwidthReductionFilter(BandwidthReductionFilter bandwidthReductionFilter) {
            this.bandwidthReductionFilter = bandwidthReductionFilter;
            return this;
        }

        public final Integer getBitrate() {
            return bitrate;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final String getCodecLevel() {
            return codecLevel;
        }

        public final void setCodecLevel(String codecLevel) {
            this.codecLevel = codecLevel;
        }

        @Override
        public final Builder codecLevel(String codecLevel) {
            this.codecLevel = codecLevel;
            return this;
        }

        @Override
        public final Builder codecLevel(H264CodecLevel codecLevel) {
            this.codecLevel(codecLevel == null ? null : codecLevel.toString());
            return this;
        }

        public final String getCodecProfile() {
            return codecProfile;
        }

        public final void setCodecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
        }

        @Override
        public final Builder codecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
            return this;
        }

        @Override
        public final Builder codecProfile(H264CodecProfile codecProfile) {
            this.codecProfile(codecProfile == null ? null : codecProfile.toString());
            return this;
        }

        public final String getDynamicSubGop() {
            return dynamicSubGop;
        }

        public final void setDynamicSubGop(String dynamicSubGop) {
            this.dynamicSubGop = dynamicSubGop;
        }

        @Override
        public final Builder dynamicSubGop(String dynamicSubGop) {
            this.dynamicSubGop = dynamicSubGop;
            return this;
        }

        @Override
        public final Builder dynamicSubGop(H264DynamicSubGop dynamicSubGop) {
            this.dynamicSubGop(dynamicSubGop == null ? null : dynamicSubGop.toString());
            return this;
        }

        public final String getEntropyEncoding() {
            return entropyEncoding;
        }

        public final void setEntropyEncoding(String entropyEncoding) {
            this.entropyEncoding = entropyEncoding;
        }

        @Override
        public final Builder entropyEncoding(String entropyEncoding) {
            this.entropyEncoding = entropyEncoding;
            return this;
        }

        @Override
        public final Builder entropyEncoding(H264EntropyEncoding entropyEncoding) {
            this.entropyEncoding(entropyEncoding == null ? null : entropyEncoding.toString());
            return this;
        }

        public final String getFieldEncoding() {
            return fieldEncoding;
        }

        public final void setFieldEncoding(String fieldEncoding) {
            this.fieldEncoding = fieldEncoding;
        }

        @Override
        public final Builder fieldEncoding(String fieldEncoding) {
            this.fieldEncoding = fieldEncoding;
            return this;
        }

        @Override
        public final Builder fieldEncoding(H264FieldEncoding fieldEncoding) {
            this.fieldEncoding(fieldEncoding == null ? null : fieldEncoding.toString());
            return this;
        }

        public final String getFlickerAdaptiveQuantization() {
            return flickerAdaptiveQuantization;
        }

        public final void setFlickerAdaptiveQuantization(String flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization = flickerAdaptiveQuantization;
        }

        @Override
        public final Builder flickerAdaptiveQuantization(String flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization = flickerAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder flickerAdaptiveQuantization(H264FlickerAdaptiveQuantization flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization(flickerAdaptiveQuantization == null ? null : flickerAdaptiveQuantization.toString());
            return this;
        }

        public final String getFramerateControl() {
            return framerateControl;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(H264FramerateControl framerateControl) {
            this.framerateControl(framerateControl == null ? null : framerateControl.toString());
            return this;
        }

        public final String getFramerateConversionAlgorithm() {
            return framerateConversionAlgorithm;
        }

        public final void setFramerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
        }

        @Override
        public final Builder framerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
            return this;
        }

        @Override
        public final Builder framerateConversionAlgorithm(H264FramerateConversionAlgorithm framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm(framerateConversionAlgorithm == null ? null : framerateConversionAlgorithm
                    .toString());
            return this;
        }

        public final Integer getFramerateDenominator() {
            return framerateDenominator;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final Integer getFramerateNumerator() {
            return framerateNumerator;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final String getGopBReference() {
            return gopBReference;
        }

        public final void setGopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
        }

        @Override
        public final Builder gopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
            return this;
        }

        @Override
        public final Builder gopBReference(H264GopBReference gopBReference) {
            this.gopBReference(gopBReference == null ? null : gopBReference.toString());
            return this;
        }

        public final Integer getGopClosedCadence() {
            return gopClosedCadence;
        }

        public final void setGopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
        }

        @Override
        public final Builder gopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
            return this;
        }

        public final Double getGopSize() {
            return gopSize;
        }

        public final void setGopSize(Double gopSize) {
            this.gopSize = gopSize;
        }

        @Override
        public final Builder gopSize(Double gopSize) {
            this.gopSize = gopSize;
            return this;
        }

        public final String getGopSizeUnits() {
            return gopSizeUnits;
        }

        public final void setGopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
        }

        @Override
        public final Builder gopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
            return this;
        }

        @Override
        public final Builder gopSizeUnits(H264GopSizeUnits gopSizeUnits) {
            this.gopSizeUnits(gopSizeUnits == null ? null : gopSizeUnits.toString());
            return this;
        }

        public final Integer getHrdBufferFinalFillPercentage() {
            return hrdBufferFinalFillPercentage;
        }

        public final void setHrdBufferFinalFillPercentage(Integer hrdBufferFinalFillPercentage) {
            this.hrdBufferFinalFillPercentage = hrdBufferFinalFillPercentage;
        }

        @Override
        public final Builder hrdBufferFinalFillPercentage(Integer hrdBufferFinalFillPercentage) {
            this.hrdBufferFinalFillPercentage = hrdBufferFinalFillPercentage;
            return this;
        }

        public final Integer getHrdBufferInitialFillPercentage() {
            return hrdBufferInitialFillPercentage;
        }

        public final void setHrdBufferInitialFillPercentage(Integer hrdBufferInitialFillPercentage) {
            this.hrdBufferInitialFillPercentage = hrdBufferInitialFillPercentage;
        }

        @Override
        public final Builder hrdBufferInitialFillPercentage(Integer hrdBufferInitialFillPercentage) {
            this.hrdBufferInitialFillPercentage = hrdBufferInitialFillPercentage;
            return this;
        }

        public final Integer getHrdBufferSize() {
            return hrdBufferSize;
        }

        public final void setHrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
        }

        @Override
        public final Builder hrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
            return this;
        }

        public final String getInterlaceMode() {
            return interlaceMode;
        }

        public final void setInterlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
        }

        @Override
        public final Builder interlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
            return this;
        }

        @Override
        public final Builder interlaceMode(H264InterlaceMode interlaceMode) {
            this.interlaceMode(interlaceMode == null ? null : interlaceMode.toString());
            return this;
        }

        public final Integer getMaxBitrate() {
            return maxBitrate;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final Integer getMinIInterval() {
            return minIInterval;
        }

        public final void setMinIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
        }

        @Override
        public final Builder minIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
            return this;
        }

        public final Integer getNumberBFramesBetweenReferenceFrames() {
            return numberBFramesBetweenReferenceFrames;
        }

        public final void setNumberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames) {
            this.numberBFramesBetweenReferenceFrames = numberBFramesBetweenReferenceFrames;
        }

        @Override
        public final Builder numberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames) {
            this.numberBFramesBetweenReferenceFrames = numberBFramesBetweenReferenceFrames;
            return this;
        }

        public final Integer getNumberReferenceFrames() {
            return numberReferenceFrames;
        }

        public final void setNumberReferenceFrames(Integer numberReferenceFrames) {
            this.numberReferenceFrames = numberReferenceFrames;
        }

        @Override
        public final Builder numberReferenceFrames(Integer numberReferenceFrames) {
            this.numberReferenceFrames = numberReferenceFrames;
            return this;
        }

        public final String getParControl() {
            return parControl;
        }

        public final void setParControl(String parControl) {
            this.parControl = parControl;
        }

        @Override
        public final Builder parControl(String parControl) {
            this.parControl = parControl;
            return this;
        }

        @Override
        public final Builder parControl(H264ParControl parControl) {
            this.parControl(parControl == null ? null : parControl.toString());
            return this;
        }

        public final Integer getParDenominator() {
            return parDenominator;
        }

        public final void setParDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
        }

        @Override
        public final Builder parDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
            return this;
        }

        public final Integer getParNumerator() {
            return parNumerator;
        }

        public final void setParNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
        }

        @Override
        public final Builder parNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
            return this;
        }

        public final String getQualityTuningLevel() {
            return qualityTuningLevel;
        }

        public final void setQualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
        }

        @Override
        public final Builder qualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
            return this;
        }

        @Override
        public final Builder qualityTuningLevel(H264QualityTuningLevel qualityTuningLevel) {
            this.qualityTuningLevel(qualityTuningLevel == null ? null : qualityTuningLevel.toString());
            return this;
        }

        public final H264QvbrSettings.Builder getQvbrSettings() {
            return qvbrSettings != null ? qvbrSettings.toBuilder() : null;
        }

        public final void setQvbrSettings(H264QvbrSettings.BuilderImpl qvbrSettings) {
            this.qvbrSettings = qvbrSettings != null ? qvbrSettings.build() : null;
        }

        @Override
        public final Builder qvbrSettings(H264QvbrSettings qvbrSettings) {
            this.qvbrSettings = qvbrSettings;
            return this;
        }

        public final String getRateControlMode() {
            return rateControlMode;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        @Override
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        public final Builder rateControlMode(H264RateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode == null ? null : rateControlMode.toString());
            return this;
        }

        public final String getRepeatPps() {
            return repeatPps;
        }

        public final void setRepeatPps(String repeatPps) {
            this.repeatPps = repeatPps;
        }

        @Override
        public final Builder repeatPps(String repeatPps) {
            this.repeatPps = repeatPps;
            return this;
        }

        @Override
        public final Builder repeatPps(H264RepeatPps repeatPps) {
            this.repeatPps(repeatPps == null ? null : repeatPps.toString());
            return this;
        }

        public final String getScanTypeConversionMode() {
            return scanTypeConversionMode;
        }

        public final void setScanTypeConversionMode(String scanTypeConversionMode) {
            this.scanTypeConversionMode = scanTypeConversionMode;
        }

        @Override
        public final Builder scanTypeConversionMode(String scanTypeConversionMode) {
            this.scanTypeConversionMode = scanTypeConversionMode;
            return this;
        }

        @Override
        public final Builder scanTypeConversionMode(H264ScanTypeConversionMode scanTypeConversionMode) {
            this.scanTypeConversionMode(scanTypeConversionMode == null ? null : scanTypeConversionMode.toString());
            return this;
        }

        public final String getSceneChangeDetect() {
            return sceneChangeDetect;
        }

        public final void setSceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
        }

        @Override
        public final Builder sceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
            return this;
        }

        @Override
        public final Builder sceneChangeDetect(H264SceneChangeDetect sceneChangeDetect) {
            this.sceneChangeDetect(sceneChangeDetect == null ? null : sceneChangeDetect.toString());
            return this;
        }

        public final Integer getSlices() {
            return slices;
        }

        public final void setSlices(Integer slices) {
            this.slices = slices;
        }

        @Override
        public final Builder slices(Integer slices) {
            this.slices = slices;
            return this;
        }

        public final String getSlowPal() {
            return slowPal;
        }

        public final void setSlowPal(String slowPal) {
            this.slowPal = slowPal;
        }

        @Override
        public final Builder slowPal(String slowPal) {
            this.slowPal = slowPal;
            return this;
        }

        @Override
        public final Builder slowPal(H264SlowPal slowPal) {
            this.slowPal(slowPal == null ? null : slowPal.toString());
            return this;
        }

        public final Integer getSoftness() {
            return softness;
        }

        public final void setSoftness(Integer softness) {
            this.softness = softness;
        }

        @Override
        public final Builder softness(Integer softness) {
            this.softness = softness;
            return this;
        }

        public final String getSpatialAdaptiveQuantization() {
            return spatialAdaptiveQuantization;
        }

        public final void setSpatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(H264SpatialAdaptiveQuantization spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization(spatialAdaptiveQuantization == null ? null : spatialAdaptiveQuantization.toString());
            return this;
        }

        public final String getSyntax() {
            return syntax;
        }

        public final void setSyntax(String syntax) {
            this.syntax = syntax;
        }

        @Override
        public final Builder syntax(String syntax) {
            this.syntax = syntax;
            return this;
        }

        @Override
        public final Builder syntax(H264Syntax syntax) {
            this.syntax(syntax == null ? null : syntax.toString());
            return this;
        }

        public final String getTelecine() {
            return telecine;
        }

        public final void setTelecine(String telecine) {
            this.telecine = telecine;
        }

        @Override
        public final Builder telecine(String telecine) {
            this.telecine = telecine;
            return this;
        }

        @Override
        public final Builder telecine(H264Telecine telecine) {
            this.telecine(telecine == null ? null : telecine.toString());
            return this;
        }

        public final String getTemporalAdaptiveQuantization() {
            return temporalAdaptiveQuantization;
        }

        public final void setTemporalAdaptiveQuantization(String temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization = temporalAdaptiveQuantization;
        }

        @Override
        public final Builder temporalAdaptiveQuantization(String temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization = temporalAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder temporalAdaptiveQuantization(H264TemporalAdaptiveQuantization temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization(temporalAdaptiveQuantization == null ? null : temporalAdaptiveQuantization
                    .toString());
            return this;
        }

        public final String getUnregisteredSeiTimecode() {
            return unregisteredSeiTimecode;
        }

        public final void setUnregisteredSeiTimecode(String unregisteredSeiTimecode) {
            this.unregisteredSeiTimecode = unregisteredSeiTimecode;
        }

        @Override
        public final Builder unregisteredSeiTimecode(String unregisteredSeiTimecode) {
            this.unregisteredSeiTimecode = unregisteredSeiTimecode;
            return this;
        }

        @Override
        public final Builder unregisteredSeiTimecode(H264UnregisteredSeiTimecode unregisteredSeiTimecode) {
            this.unregisteredSeiTimecode(unregisteredSeiTimecode == null ? null : unregisteredSeiTimecode.toString());
            return this;
        }

        @Override
        public H264Settings build() {
            return new H264Settings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
