/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Only use this setting when you change the default value, AUTO, for the setting H264AdaptiveQuantization. When you
 * keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON job
 * specification, MediaConvert automatically applies the best types of quantization for your video content. When you set
 * H264AdaptiveQuantization to a value other than AUTO, the default value for H264FlickerAdaptiveQuantization is
 * Disabled (DISABLED). Change this value to Enabled (ENABLED) to reduce I-frame pop. I-frame pop appears as a visual
 * flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and
 * then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more
 * often to smooth out the flicker. To manually enable or disable H264FlickerAdaptiveQuantization, you must set Adaptive
 * quantization (H264AdaptiveQuantization) to a value other than AUTO.
 */
@Generated("software.amazon.awssdk:codegen")
public enum H264FlickerAdaptiveQuantization {
    DISABLED("DISABLED"),

    ENABLED("ENABLED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H264FlickerAdaptiveQuantization> VALUE_MAP = EnumUtils.uniqueIndex(
            H264FlickerAdaptiveQuantization.class, H264FlickerAdaptiveQuantization::toString);

    private final String value;

    private H264FlickerAdaptiveQuantization(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return H264FlickerAdaptiveQuantization corresponding to the value
     */
    public static H264FlickerAdaptiveQuantization fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link H264FlickerAdaptiveQuantization}s
     */
    public static Set<H264FlickerAdaptiveQuantization> knownValues() {
        Set<H264FlickerAdaptiveQuantization> knownValues = EnumSet.allOf(H264FlickerAdaptiveQuantization.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
