/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * When set to WHEN_POSSIBLE, input DD+ audio will be passed through if it is present on the input. this detection is
 * dynamic over the life of the transcode. Inputs that alternate between DD+ and non-DD+ content will have a consistent
 * DD+ output as the system alternates between passthrough and encoding.
 */
@Generated("software.amazon.awssdk:codegen")
public enum Eac3PassthroughControl {
    WHEN_POSSIBLE("WHEN_POSSIBLE"),

    NO_PASSTHROUGH("NO_PASSTHROUGH"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Eac3PassthroughControl> VALUE_MAP = EnumUtils.uniqueIndex(Eac3PassthroughControl.class,
            Eac3PassthroughControl::toString);

    private final String value;

    private Eac3PassthroughControl(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return Eac3PassthroughControl corresponding to the value
     */
    public static Eac3PassthroughControl fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link Eac3PassthroughControl}s
     */
    public static Set<Eac3PassthroughControl> knownValues() {
        Set<Eac3PassthroughControl> knownValues = EnumSet.allOf(Eac3PassthroughControl.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
