/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Use to remove noise, blocking, blurriness, or ringing from your input as a pre-filter step before encoding. The
 * Advanced input filter removes more types of compression artifacts and is an improvement when compared to basic
 * Deblock and Denoise filters. To remove video compression artifacts from your input and improve the video quality:
 * Choose Enabled. Additionally, this filter can help increase the video quality of your output relative to its bitrate,
 * since noisy inputs are more complex and require more bits to encode. To help restore loss of detail after applying
 * the filter, you can optionally add texture or sharpening as an additional step. Jobs that use this feature incur
 * pro-tier pricing. To not apply advanced input filtering: Choose Disabled. Note that you can still apply basic
 * filtering with Deblock and Denoise.
 */
@Generated("software.amazon.awssdk:codegen")
public enum AdvancedInputFilter {
    ENABLED("ENABLED"),

    DISABLED("DISABLED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AdvancedInputFilter> VALUE_MAP = EnumUtils.uniqueIndex(AdvancedInputFilter.class,
            AdvancedInputFilter::toString);

    private final String value;

    private AdvancedInputFilter(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return AdvancedInputFilter corresponding to the value
     */
    public static AdvancedInputFilter fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link AdvancedInputFilter}s
     */
    public static Set<AdvancedInputFilter> knownValues() {
        Set<AdvancedInputFilter> knownValues = EnumSet.allOf(AdvancedInputFilter.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
