/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CmafManifestCompression {
    GZIP("GZIP"),
    NONE("NONE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CmafManifestCompression> VALUE_MAP;
    private final String value;

    private CmafManifestCompression(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CmafManifestCompression fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CmafManifestCompression> knownValues() {
        EnumSet<CmafManifestCompression> knownValues = EnumSet.allOf(CmafManifestCompression.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CmafManifestCompression.class, CmafManifestCompression::toString);
    }
}

