/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.WatermarkingStrength;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NexGuardFileMarkerSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NexGuardFileMarkerSettings> {
    private static final SdkField<String> LICENSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("License").getter(NexGuardFileMarkerSettings.getter(NexGuardFileMarkerSettings::license)).setter(NexGuardFileMarkerSettings.setter(Builder::license)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("license").build()}).build();
    private static final SdkField<Integer> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Payload").getter(NexGuardFileMarkerSettings.getter(NexGuardFileMarkerSettings::payload)).setter(NexGuardFileMarkerSettings.setter(Builder::payload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()}).build();
    private static final SdkField<String> PRESET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Preset").getter(NexGuardFileMarkerSettings.getter(NexGuardFileMarkerSettings::preset)).setter(NexGuardFileMarkerSettings.setter(Builder::preset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preset").build()}).build();
    private static final SdkField<String> STRENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Strength").getter(NexGuardFileMarkerSettings.getter(NexGuardFileMarkerSettings::strengthAsString)).setter(NexGuardFileMarkerSettings.setter(Builder::strength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strength").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_FIELD, PAYLOAD_FIELD, PRESET_FIELD, STRENGTH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String license;
    private final Integer payload;
    private final String preset;
    private final String strength;

    private NexGuardFileMarkerSettings(BuilderImpl builder) {
        this.license = builder.license;
        this.payload = builder.payload;
        this.preset = builder.preset;
        this.strength = builder.strength;
    }

    public final String license() {
        return this.license;
    }

    public final Integer payload() {
        return this.payload;
    }

    public final String preset() {
        return this.preset;
    }

    public final WatermarkingStrength strength() {
        return WatermarkingStrength.fromValue(this.strength);
    }

    public final String strengthAsString() {
        return this.strength;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.license());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        hashCode = 31 * hashCode + Objects.hashCode(this.preset());
        hashCode = 31 * hashCode + Objects.hashCode(this.strengthAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NexGuardFileMarkerSettings)) {
            return false;
        }
        NexGuardFileMarkerSettings other = (NexGuardFileMarkerSettings)obj;
        return Objects.equals(this.license(), other.license()) && Objects.equals(this.payload(), other.payload()) && Objects.equals(this.preset(), other.preset()) && Objects.equals(this.strengthAsString(), other.strengthAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NexGuardFileMarkerSettings").add("License", (Object)this.license()).add("Payload", (Object)this.payload()).add("Preset", (Object)this.preset()).add("Strength", (Object)this.strengthAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "License": {
                return Optional.ofNullable(clazz.cast(this.license()));
            }
            case "Payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
            case "Preset": {
                return Optional.ofNullable(clazz.cast(this.preset()));
            }
            case "Strength": {
                return Optional.ofNullable(clazz.cast(this.strengthAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NexGuardFileMarkerSettings, T> g) {
        return obj -> g.apply((NexGuardFileMarkerSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String license;
        private Integer payload;
        private String preset;
        private String strength;

        private BuilderImpl() {
        }

        private BuilderImpl(NexGuardFileMarkerSettings model) {
            this.license(model.license);
            this.payload(model.payload);
            this.preset(model.preset);
            this.strength(model.strength);
        }

        public final String getLicense() {
            return this.license;
        }

        public final void setLicense(String license) {
            this.license = license;
        }

        @Override
        public final Builder license(String license) {
            this.license = license;
            return this;
        }

        public final Integer getPayload() {
            return this.payload;
        }

        public final void setPayload(Integer payload) {
            this.payload = payload;
        }

        @Override
        public final Builder payload(Integer payload) {
            this.payload = payload;
            return this;
        }

        public final String getPreset() {
            return this.preset;
        }

        public final void setPreset(String preset) {
            this.preset = preset;
        }

        @Override
        public final Builder preset(String preset) {
            this.preset = preset;
            return this;
        }

        public final String getStrength() {
            return this.strength;
        }

        public final void setStrength(String strength) {
            this.strength = strength;
        }

        @Override
        public final Builder strength(String strength) {
            this.strength = strength;
            return this;
        }

        @Override
        public final Builder strength(WatermarkingStrength strength) {
            this.strength(strength == null ? null : strength.toString());
            return this;
        }

        public NexGuardFileMarkerSettings build() {
            return new NexGuardFileMarkerSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NexGuardFileMarkerSettings> {
        public Builder license(String var1);

        public Builder payload(Integer var1);

        public Builder preset(String var1);

        public Builder strength(String var1);

        public Builder strength(WatermarkingStrength var1);
    }
}

