/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueueTransition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueueTransition> {
    private static final SdkField<String> DESTINATION_QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationQueue").getter(QueueTransition.getter(QueueTransition::destinationQueue)).setter(QueueTransition.setter(Builder::destinationQueue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationQueue").build()}).build();
    private static final SdkField<String> SOURCE_QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceQueue").getter(QueueTransition.getter(QueueTransition::sourceQueue)).setter(QueueTransition.setter(Builder::sourceQueue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceQueue").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(QueueTransition.getter(QueueTransition::timestamp)).setter(QueueTransition.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_QUEUE_FIELD, SOURCE_QUEUE_FIELD, TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String destinationQueue;
    private final String sourceQueue;
    private final Instant timestamp;

    private QueueTransition(BuilderImpl builder) {
        this.destinationQueue = builder.destinationQueue;
        this.sourceQueue = builder.sourceQueue;
        this.timestamp = builder.timestamp;
    }

    public final String destinationQueue() {
        return this.destinationQueue;
    }

    public final String sourceQueue() {
        return this.sourceQueue;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationQueue());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceQueue());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueueTransition)) {
            return false;
        }
        QueueTransition other = (QueueTransition)obj;
        return Objects.equals(this.destinationQueue(), other.destinationQueue()) && Objects.equals(this.sourceQueue(), other.sourceQueue()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public final String toString() {
        return ToString.builder((String)"QueueTransition").add("DestinationQueue", (Object)this.destinationQueue()).add("SourceQueue", (Object)this.sourceQueue()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationQueue": {
                return Optional.ofNullable(clazz.cast(this.destinationQueue()));
            }
            case "SourceQueue": {
                return Optional.ofNullable(clazz.cast(this.sourceQueue()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueueTransition, T> g) {
        return obj -> g.apply((QueueTransition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationQueue;
        private String sourceQueue;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(QueueTransition model) {
            this.destinationQueue(model.destinationQueue);
            this.sourceQueue(model.sourceQueue);
            this.timestamp(model.timestamp);
        }

        public final String getDestinationQueue() {
            return this.destinationQueue;
        }

        public final void setDestinationQueue(String destinationQueue) {
            this.destinationQueue = destinationQueue;
        }

        @Override
        public final Builder destinationQueue(String destinationQueue) {
            this.destinationQueue = destinationQueue;
            return this;
        }

        public final String getSourceQueue() {
            return this.sourceQueue;
        }

        public final void setSourceQueue(String sourceQueue) {
            this.sourceQueue = sourceQueue;
        }

        @Override
        public final Builder sourceQueue(String sourceQueue) {
            this.sourceQueue = sourceQueue;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public QueueTransition build() {
            return new QueueTransition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueueTransition> {
        public Builder destinationQueue(String var1);

        public Builder sourceQueue(String var1);

        public Builder timestamp(Instant var1);
    }
}

