/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.HlsAudioOnlyContainer;
import software.amazon.awssdk.services.mediaconvert.model.HlsAudioTrackType;
import software.amazon.awssdk.services.mediaconvert.model.HlsDescriptiveVideoServiceFlag;
import software.amazon.awssdk.services.mediaconvert.model.HlsIFrameOnlyManifest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HlsSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HlsSettings> {
    private static final SdkField<String> AUDIO_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioGroupId").getter(HlsSettings.getter(HlsSettings::audioGroupId)).setter(HlsSettings.setter(Builder::audioGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioGroupId").build()}).build();
    private static final SdkField<String> AUDIO_ONLY_CONTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioOnlyContainer").getter(HlsSettings.getter(HlsSettings::audioOnlyContainerAsString)).setter(HlsSettings.setter(Builder::audioOnlyContainer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioOnlyContainer").build()}).build();
    private static final SdkField<String> AUDIO_RENDITION_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioRenditionSets").getter(HlsSettings.getter(HlsSettings::audioRenditionSets)).setter(HlsSettings.setter(Builder::audioRenditionSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioRenditionSets").build()}).build();
    private static final SdkField<String> AUDIO_TRACK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioTrackType").getter(HlsSettings.getter(HlsSettings::audioTrackTypeAsString)).setter(HlsSettings.setter(Builder::audioTrackType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioTrackType").build()}).build();
    private static final SdkField<String> DESCRIPTIVE_VIDEO_SERVICE_FLAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DescriptiveVideoServiceFlag").getter(HlsSettings.getter(HlsSettings::descriptiveVideoServiceFlagAsString)).setter(HlsSettings.setter(Builder::descriptiveVideoServiceFlag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("descriptiveVideoServiceFlag").build()}).build();
    private static final SdkField<String> I_FRAME_ONLY_MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IFrameOnlyManifest").getter(HlsSettings.getter(HlsSettings::iFrameOnlyManifestAsString)).setter(HlsSettings.setter(Builder::iFrameOnlyManifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iFrameOnlyManifest").build()}).build();
    private static final SdkField<String> SEGMENT_MODIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentModifier").getter(HlsSettings.getter(HlsSettings::segmentModifier)).setter(HlsSettings.setter(Builder::segmentModifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentModifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_GROUP_ID_FIELD, AUDIO_ONLY_CONTAINER_FIELD, AUDIO_RENDITION_SETS_FIELD, AUDIO_TRACK_TYPE_FIELD, DESCRIPTIVE_VIDEO_SERVICE_FLAG_FIELD, I_FRAME_ONLY_MANIFEST_FIELD, SEGMENT_MODIFIER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String audioGroupId;
    private final String audioOnlyContainer;
    private final String audioRenditionSets;
    private final String audioTrackType;
    private final String descriptiveVideoServiceFlag;
    private final String iFrameOnlyManifest;
    private final String segmentModifier;

    private HlsSettings(BuilderImpl builder) {
        this.audioGroupId = builder.audioGroupId;
        this.audioOnlyContainer = builder.audioOnlyContainer;
        this.audioRenditionSets = builder.audioRenditionSets;
        this.audioTrackType = builder.audioTrackType;
        this.descriptiveVideoServiceFlag = builder.descriptiveVideoServiceFlag;
        this.iFrameOnlyManifest = builder.iFrameOnlyManifest;
        this.segmentModifier = builder.segmentModifier;
    }

    public final String audioGroupId() {
        return this.audioGroupId;
    }

    public final HlsAudioOnlyContainer audioOnlyContainer() {
        return HlsAudioOnlyContainer.fromValue(this.audioOnlyContainer);
    }

    public final String audioOnlyContainerAsString() {
        return this.audioOnlyContainer;
    }

    public final String audioRenditionSets() {
        return this.audioRenditionSets;
    }

    public final HlsAudioTrackType audioTrackType() {
        return HlsAudioTrackType.fromValue(this.audioTrackType);
    }

    public final String audioTrackTypeAsString() {
        return this.audioTrackType;
    }

    public final HlsDescriptiveVideoServiceFlag descriptiveVideoServiceFlag() {
        return HlsDescriptiveVideoServiceFlag.fromValue(this.descriptiveVideoServiceFlag);
    }

    public final String descriptiveVideoServiceFlagAsString() {
        return this.descriptiveVideoServiceFlag;
    }

    public final HlsIFrameOnlyManifest iFrameOnlyManifest() {
        return HlsIFrameOnlyManifest.fromValue(this.iFrameOnlyManifest);
    }

    public final String iFrameOnlyManifestAsString() {
        return this.iFrameOnlyManifest;
    }

    public final String segmentModifier() {
        return this.segmentModifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioOnlyContainerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioRenditionSets());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioTrackTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.descriptiveVideoServiceFlagAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.iFrameOnlyManifestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentModifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsSettings)) {
            return false;
        }
        HlsSettings other = (HlsSettings)obj;
        return Objects.equals(this.audioGroupId(), other.audioGroupId()) && Objects.equals(this.audioOnlyContainerAsString(), other.audioOnlyContainerAsString()) && Objects.equals(this.audioRenditionSets(), other.audioRenditionSets()) && Objects.equals(this.audioTrackTypeAsString(), other.audioTrackTypeAsString()) && Objects.equals(this.descriptiveVideoServiceFlagAsString(), other.descriptiveVideoServiceFlagAsString()) && Objects.equals(this.iFrameOnlyManifestAsString(), other.iFrameOnlyManifestAsString()) && Objects.equals(this.segmentModifier(), other.segmentModifier());
    }

    public final String toString() {
        return ToString.builder((String)"HlsSettings").add("AudioGroupId", (Object)this.audioGroupId()).add("AudioOnlyContainer", (Object)this.audioOnlyContainerAsString()).add("AudioRenditionSets", (Object)this.audioRenditionSets()).add("AudioTrackType", (Object)this.audioTrackTypeAsString()).add("DescriptiveVideoServiceFlag", (Object)this.descriptiveVideoServiceFlagAsString()).add("IFrameOnlyManifest", (Object)this.iFrameOnlyManifestAsString()).add("SegmentModifier", (Object)this.segmentModifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioGroupId": {
                return Optional.ofNullable(clazz.cast(this.audioGroupId()));
            }
            case "AudioOnlyContainer": {
                return Optional.ofNullable(clazz.cast(this.audioOnlyContainerAsString()));
            }
            case "AudioRenditionSets": {
                return Optional.ofNullable(clazz.cast(this.audioRenditionSets()));
            }
            case "AudioTrackType": {
                return Optional.ofNullable(clazz.cast(this.audioTrackTypeAsString()));
            }
            case "DescriptiveVideoServiceFlag": {
                return Optional.ofNullable(clazz.cast(this.descriptiveVideoServiceFlagAsString()));
            }
            case "IFrameOnlyManifest": {
                return Optional.ofNullable(clazz.cast(this.iFrameOnlyManifestAsString()));
            }
            case "SegmentModifier": {
                return Optional.ofNullable(clazz.cast(this.segmentModifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsSettings, T> g) {
        return obj -> g.apply((HlsSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String audioGroupId;
        private String audioOnlyContainer;
        private String audioRenditionSets;
        private String audioTrackType;
        private String descriptiveVideoServiceFlag;
        private String iFrameOnlyManifest;
        private String segmentModifier;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsSettings model) {
            this.audioGroupId(model.audioGroupId);
            this.audioOnlyContainer(model.audioOnlyContainer);
            this.audioRenditionSets(model.audioRenditionSets);
            this.audioTrackType(model.audioTrackType);
            this.descriptiveVideoServiceFlag(model.descriptiveVideoServiceFlag);
            this.iFrameOnlyManifest(model.iFrameOnlyManifest);
            this.segmentModifier(model.segmentModifier);
        }

        public final String getAudioGroupId() {
            return this.audioGroupId;
        }

        public final void setAudioGroupId(String audioGroupId) {
            this.audioGroupId = audioGroupId;
        }

        @Override
        public final Builder audioGroupId(String audioGroupId) {
            this.audioGroupId = audioGroupId;
            return this;
        }

        public final String getAudioOnlyContainer() {
            return this.audioOnlyContainer;
        }

        public final void setAudioOnlyContainer(String audioOnlyContainer) {
            this.audioOnlyContainer = audioOnlyContainer;
        }

        @Override
        public final Builder audioOnlyContainer(String audioOnlyContainer) {
            this.audioOnlyContainer = audioOnlyContainer;
            return this;
        }

        @Override
        public final Builder audioOnlyContainer(HlsAudioOnlyContainer audioOnlyContainer) {
            this.audioOnlyContainer(audioOnlyContainer == null ? null : audioOnlyContainer.toString());
            return this;
        }

        public final String getAudioRenditionSets() {
            return this.audioRenditionSets;
        }

        public final void setAudioRenditionSets(String audioRenditionSets) {
            this.audioRenditionSets = audioRenditionSets;
        }

        @Override
        public final Builder audioRenditionSets(String audioRenditionSets) {
            this.audioRenditionSets = audioRenditionSets;
            return this;
        }

        public final String getAudioTrackType() {
            return this.audioTrackType;
        }

        public final void setAudioTrackType(String audioTrackType) {
            this.audioTrackType = audioTrackType;
        }

        @Override
        public final Builder audioTrackType(String audioTrackType) {
            this.audioTrackType = audioTrackType;
            return this;
        }

        @Override
        public final Builder audioTrackType(HlsAudioTrackType audioTrackType) {
            this.audioTrackType(audioTrackType == null ? null : audioTrackType.toString());
            return this;
        }

        public final String getDescriptiveVideoServiceFlag() {
            return this.descriptiveVideoServiceFlag;
        }

        public final void setDescriptiveVideoServiceFlag(String descriptiveVideoServiceFlag) {
            this.descriptiveVideoServiceFlag = descriptiveVideoServiceFlag;
        }

        @Override
        public final Builder descriptiveVideoServiceFlag(String descriptiveVideoServiceFlag) {
            this.descriptiveVideoServiceFlag = descriptiveVideoServiceFlag;
            return this;
        }

        @Override
        public final Builder descriptiveVideoServiceFlag(HlsDescriptiveVideoServiceFlag descriptiveVideoServiceFlag) {
            this.descriptiveVideoServiceFlag(descriptiveVideoServiceFlag == null ? null : descriptiveVideoServiceFlag.toString());
            return this;
        }

        public final String getIFrameOnlyManifest() {
            return this.iFrameOnlyManifest;
        }

        public final void setIFrameOnlyManifest(String iFrameOnlyManifest) {
            this.iFrameOnlyManifest = iFrameOnlyManifest;
        }

        @Override
        public final Builder iFrameOnlyManifest(String iFrameOnlyManifest) {
            this.iFrameOnlyManifest = iFrameOnlyManifest;
            return this;
        }

        @Override
        public final Builder iFrameOnlyManifest(HlsIFrameOnlyManifest iFrameOnlyManifest) {
            this.iFrameOnlyManifest(iFrameOnlyManifest == null ? null : iFrameOnlyManifest.toString());
            return this;
        }

        public final String getSegmentModifier() {
            return this.segmentModifier;
        }

        public final void setSegmentModifier(String segmentModifier) {
            this.segmentModifier = segmentModifier;
        }

        @Override
        public final Builder segmentModifier(String segmentModifier) {
            this.segmentModifier = segmentModifier;
            return this;
        }

        public HlsSettings build() {
            return new HlsSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HlsSettings> {
        public Builder audioGroupId(String var1);

        public Builder audioOnlyContainer(String var1);

        public Builder audioOnlyContainer(HlsAudioOnlyContainer var1);

        public Builder audioRenditionSets(String var1);

        public Builder audioTrackType(String var1);

        public Builder audioTrackType(HlsAudioTrackType var1);

        public Builder descriptiveVideoServiceFlag(String var1);

        public Builder descriptiveVideoServiceFlag(HlsDescriptiveVideoServiceFlag var1);

        public Builder iFrameOnlyManifest(String var1);

        public Builder iFrameOnlyManifest(HlsIFrameOnlyManifest var1);

        public Builder segmentModifier(String var1);
    }
}

