/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.Eac3AtmosBitstreamMode;
import software.amazon.awssdk.services.mediaconvert.model.Eac3AtmosCodingMode;
import software.amazon.awssdk.services.mediaconvert.model.Eac3AtmosDialogueIntelligence;
import software.amazon.awssdk.services.mediaconvert.model.Eac3AtmosDownmixControl;
import software.amazon.awssdk.services.mediaconvert.model.Eac3AtmosDynamicRangeCompressionLine;
import software.amazon.awssdk.services.mediaconvert.model.Eac3AtmosDynamicRangeCompressionRf;
import software.amazon.awssdk.services.mediaconvert.model.Eac3AtmosDynamicRangeControl;
import software.amazon.awssdk.services.mediaconvert.model.Eac3AtmosMeteringMode;
import software.amazon.awssdk.services.mediaconvert.model.Eac3AtmosStereoDownmix;
import software.amazon.awssdk.services.mediaconvert.model.Eac3AtmosSurroundExMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Eac3AtmosSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Eac3AtmosSettings> {
    private static final SdkField<Integer> BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Bitrate").getter(Eac3AtmosSettings.getter(Eac3AtmosSettings::bitrate)).setter(Eac3AtmosSettings.setter(Builder::bitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()}).build();
    private static final SdkField<String> BITSTREAM_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BitstreamMode").getter(Eac3AtmosSettings.getter(Eac3AtmosSettings::bitstreamModeAsString)).setter(Eac3AtmosSettings.setter(Builder::bitstreamMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitstreamMode").build()}).build();
    private static final SdkField<String> CODING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodingMode").getter(Eac3AtmosSettings.getter(Eac3AtmosSettings::codingModeAsString)).setter(Eac3AtmosSettings.setter(Builder::codingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codingMode").build()}).build();
    private static final SdkField<String> DIALOGUE_INTELLIGENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DialogueIntelligence").getter(Eac3AtmosSettings.getter(Eac3AtmosSettings::dialogueIntelligenceAsString)).setter(Eac3AtmosSettings.setter(Builder::dialogueIntelligence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogueIntelligence").build()}).build();
    private static final SdkField<String> DOWNMIX_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DownmixControl").getter(Eac3AtmosSettings.getter(Eac3AtmosSettings::downmixControlAsString)).setter(Eac3AtmosSettings.setter(Builder::downmixControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downmixControl").build()}).build();
    private static final SdkField<String> DYNAMIC_RANGE_COMPRESSION_LINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DynamicRangeCompressionLine").getter(Eac3AtmosSettings.getter(Eac3AtmosSettings::dynamicRangeCompressionLineAsString)).setter(Eac3AtmosSettings.setter(Builder::dynamicRangeCompressionLine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicRangeCompressionLine").build()}).build();
    private static final SdkField<String> DYNAMIC_RANGE_COMPRESSION_RF_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DynamicRangeCompressionRf").getter(Eac3AtmosSettings.getter(Eac3AtmosSettings::dynamicRangeCompressionRfAsString)).setter(Eac3AtmosSettings.setter(Builder::dynamicRangeCompressionRf)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicRangeCompressionRf").build()}).build();
    private static final SdkField<String> DYNAMIC_RANGE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DynamicRangeControl").getter(Eac3AtmosSettings.getter(Eac3AtmosSettings::dynamicRangeControlAsString)).setter(Eac3AtmosSettings.setter(Builder::dynamicRangeControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicRangeControl").build()}).build();
    private static final SdkField<Double> LO_RO_CENTER_MIX_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("LoRoCenterMixLevel").getter(Eac3AtmosSettings.getter(Eac3AtmosSettings::loRoCenterMixLevel)).setter(Eac3AtmosSettings.setter(Builder::loRoCenterMixLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loRoCenterMixLevel").build()}).build();
    private static final SdkField<Double> LO_RO_SURROUND_MIX_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("LoRoSurroundMixLevel").getter(Eac3AtmosSettings.getter(Eac3AtmosSettings::loRoSurroundMixLevel)).setter(Eac3AtmosSettings.setter(Builder::loRoSurroundMixLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loRoSurroundMixLevel").build()}).build();
    private static final SdkField<Double> LT_RT_CENTER_MIX_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("LtRtCenterMixLevel").getter(Eac3AtmosSettings.getter(Eac3AtmosSettings::ltRtCenterMixLevel)).setter(Eac3AtmosSettings.setter(Builder::ltRtCenterMixLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ltRtCenterMixLevel").build()}).build();
    private static final SdkField<Double> LT_RT_SURROUND_MIX_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("LtRtSurroundMixLevel").getter(Eac3AtmosSettings.getter(Eac3AtmosSettings::ltRtSurroundMixLevel)).setter(Eac3AtmosSettings.setter(Builder::ltRtSurroundMixLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ltRtSurroundMixLevel").build()}).build();
    private static final SdkField<String> METERING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeteringMode").getter(Eac3AtmosSettings.getter(Eac3AtmosSettings::meteringModeAsString)).setter(Eac3AtmosSettings.setter(Builder::meteringMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meteringMode").build()}).build();
    private static final SdkField<Integer> SAMPLE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SampleRate").getter(Eac3AtmosSettings.getter(Eac3AtmosSettings::sampleRate)).setter(Eac3AtmosSettings.setter(Builder::sampleRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()}).build();
    private static final SdkField<Integer> SPEECH_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SpeechThreshold").getter(Eac3AtmosSettings.getter(Eac3AtmosSettings::speechThreshold)).setter(Eac3AtmosSettings.setter(Builder::speechThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speechThreshold").build()}).build();
    private static final SdkField<String> STEREO_DOWNMIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StereoDownmix").getter(Eac3AtmosSettings.getter(Eac3AtmosSettings::stereoDownmixAsString)).setter(Eac3AtmosSettings.setter(Builder::stereoDownmix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stereoDownmix").build()}).build();
    private static final SdkField<String> SURROUND_EX_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SurroundExMode").getter(Eac3AtmosSettings.getter(Eac3AtmosSettings::surroundExModeAsString)).setter(Eac3AtmosSettings.setter(Builder::surroundExMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("surroundExMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BITRATE_FIELD, BITSTREAM_MODE_FIELD, CODING_MODE_FIELD, DIALOGUE_INTELLIGENCE_FIELD, DOWNMIX_CONTROL_FIELD, DYNAMIC_RANGE_COMPRESSION_LINE_FIELD, DYNAMIC_RANGE_COMPRESSION_RF_FIELD, DYNAMIC_RANGE_CONTROL_FIELD, LO_RO_CENTER_MIX_LEVEL_FIELD, LO_RO_SURROUND_MIX_LEVEL_FIELD, LT_RT_CENTER_MIX_LEVEL_FIELD, LT_RT_SURROUND_MIX_LEVEL_FIELD, METERING_MODE_FIELD, SAMPLE_RATE_FIELD, SPEECH_THRESHOLD_FIELD, STEREO_DOWNMIX_FIELD, SURROUND_EX_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer bitrate;
    private final String bitstreamMode;
    private final String codingMode;
    private final String dialogueIntelligence;
    private final String downmixControl;
    private final String dynamicRangeCompressionLine;
    private final String dynamicRangeCompressionRf;
    private final String dynamicRangeControl;
    private final Double loRoCenterMixLevel;
    private final Double loRoSurroundMixLevel;
    private final Double ltRtCenterMixLevel;
    private final Double ltRtSurroundMixLevel;
    private final String meteringMode;
    private final Integer sampleRate;
    private final Integer speechThreshold;
    private final String stereoDownmix;
    private final String surroundExMode;

    private Eac3AtmosSettings(BuilderImpl builder) {
        this.bitrate = builder.bitrate;
        this.bitstreamMode = builder.bitstreamMode;
        this.codingMode = builder.codingMode;
        this.dialogueIntelligence = builder.dialogueIntelligence;
        this.downmixControl = builder.downmixControl;
        this.dynamicRangeCompressionLine = builder.dynamicRangeCompressionLine;
        this.dynamicRangeCompressionRf = builder.dynamicRangeCompressionRf;
        this.dynamicRangeControl = builder.dynamicRangeControl;
        this.loRoCenterMixLevel = builder.loRoCenterMixLevel;
        this.loRoSurroundMixLevel = builder.loRoSurroundMixLevel;
        this.ltRtCenterMixLevel = builder.ltRtCenterMixLevel;
        this.ltRtSurroundMixLevel = builder.ltRtSurroundMixLevel;
        this.meteringMode = builder.meteringMode;
        this.sampleRate = builder.sampleRate;
        this.speechThreshold = builder.speechThreshold;
        this.stereoDownmix = builder.stereoDownmix;
        this.surroundExMode = builder.surroundExMode;
    }

    public final Integer bitrate() {
        return this.bitrate;
    }

    public final Eac3AtmosBitstreamMode bitstreamMode() {
        return Eac3AtmosBitstreamMode.fromValue(this.bitstreamMode);
    }

    public final String bitstreamModeAsString() {
        return this.bitstreamMode;
    }

    public final Eac3AtmosCodingMode codingMode() {
        return Eac3AtmosCodingMode.fromValue(this.codingMode);
    }

    public final String codingModeAsString() {
        return this.codingMode;
    }

    public final Eac3AtmosDialogueIntelligence dialogueIntelligence() {
        return Eac3AtmosDialogueIntelligence.fromValue(this.dialogueIntelligence);
    }

    public final String dialogueIntelligenceAsString() {
        return this.dialogueIntelligence;
    }

    public final Eac3AtmosDownmixControl downmixControl() {
        return Eac3AtmosDownmixControl.fromValue(this.downmixControl);
    }

    public final String downmixControlAsString() {
        return this.downmixControl;
    }

    public final Eac3AtmosDynamicRangeCompressionLine dynamicRangeCompressionLine() {
        return Eac3AtmosDynamicRangeCompressionLine.fromValue(this.dynamicRangeCompressionLine);
    }

    public final String dynamicRangeCompressionLineAsString() {
        return this.dynamicRangeCompressionLine;
    }

    public final Eac3AtmosDynamicRangeCompressionRf dynamicRangeCompressionRf() {
        return Eac3AtmosDynamicRangeCompressionRf.fromValue(this.dynamicRangeCompressionRf);
    }

    public final String dynamicRangeCompressionRfAsString() {
        return this.dynamicRangeCompressionRf;
    }

    public final Eac3AtmosDynamicRangeControl dynamicRangeControl() {
        return Eac3AtmosDynamicRangeControl.fromValue(this.dynamicRangeControl);
    }

    public final String dynamicRangeControlAsString() {
        return this.dynamicRangeControl;
    }

    public final Double loRoCenterMixLevel() {
        return this.loRoCenterMixLevel;
    }

    public final Double loRoSurroundMixLevel() {
        return this.loRoSurroundMixLevel;
    }

    public final Double ltRtCenterMixLevel() {
        return this.ltRtCenterMixLevel;
    }

    public final Double ltRtSurroundMixLevel() {
        return this.ltRtSurroundMixLevel;
    }

    public final Eac3AtmosMeteringMode meteringMode() {
        return Eac3AtmosMeteringMode.fromValue(this.meteringMode);
    }

    public final String meteringModeAsString() {
        return this.meteringMode;
    }

    public final Integer sampleRate() {
        return this.sampleRate;
    }

    public final Integer speechThreshold() {
        return this.speechThreshold;
    }

    public final Eac3AtmosStereoDownmix stereoDownmix() {
        return Eac3AtmosStereoDownmix.fromValue(this.stereoDownmix);
    }

    public final String stereoDownmixAsString() {
        return this.stereoDownmix;
    }

    public final Eac3AtmosSurroundExMode surroundExMode() {
        return Eac3AtmosSurroundExMode.fromValue(this.surroundExMode);
    }

    public final String surroundExModeAsString() {
        return this.surroundExMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitstreamModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dialogueIntelligenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.downmixControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamicRangeCompressionLineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamicRangeCompressionRfAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamicRangeControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.loRoCenterMixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.loRoSurroundMixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.ltRtCenterMixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.ltRtSurroundMixLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.meteringModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.speechThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.stereoDownmixAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.surroundExModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Eac3AtmosSettings)) {
            return false;
        }
        Eac3AtmosSettings other = (Eac3AtmosSettings)obj;
        return Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.bitstreamModeAsString(), other.bitstreamModeAsString()) && Objects.equals(this.codingModeAsString(), other.codingModeAsString()) && Objects.equals(this.dialogueIntelligenceAsString(), other.dialogueIntelligenceAsString()) && Objects.equals(this.downmixControlAsString(), other.downmixControlAsString()) && Objects.equals(this.dynamicRangeCompressionLineAsString(), other.dynamicRangeCompressionLineAsString()) && Objects.equals(this.dynamicRangeCompressionRfAsString(), other.dynamicRangeCompressionRfAsString()) && Objects.equals(this.dynamicRangeControlAsString(), other.dynamicRangeControlAsString()) && Objects.equals(this.loRoCenterMixLevel(), other.loRoCenterMixLevel()) && Objects.equals(this.loRoSurroundMixLevel(), other.loRoSurroundMixLevel()) && Objects.equals(this.ltRtCenterMixLevel(), other.ltRtCenterMixLevel()) && Objects.equals(this.ltRtSurroundMixLevel(), other.ltRtSurroundMixLevel()) && Objects.equals(this.meteringModeAsString(), other.meteringModeAsString()) && Objects.equals(this.sampleRate(), other.sampleRate()) && Objects.equals(this.speechThreshold(), other.speechThreshold()) && Objects.equals(this.stereoDownmixAsString(), other.stereoDownmixAsString()) && Objects.equals(this.surroundExModeAsString(), other.surroundExModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Eac3AtmosSettings").add("Bitrate", (Object)this.bitrate()).add("BitstreamMode", (Object)this.bitstreamModeAsString()).add("CodingMode", (Object)this.codingModeAsString()).add("DialogueIntelligence", (Object)this.dialogueIntelligenceAsString()).add("DownmixControl", (Object)this.downmixControlAsString()).add("DynamicRangeCompressionLine", (Object)this.dynamicRangeCompressionLineAsString()).add("DynamicRangeCompressionRf", (Object)this.dynamicRangeCompressionRfAsString()).add("DynamicRangeControl", (Object)this.dynamicRangeControlAsString()).add("LoRoCenterMixLevel", (Object)this.loRoCenterMixLevel()).add("LoRoSurroundMixLevel", (Object)this.loRoSurroundMixLevel()).add("LtRtCenterMixLevel", (Object)this.ltRtCenterMixLevel()).add("LtRtSurroundMixLevel", (Object)this.ltRtSurroundMixLevel()).add("MeteringMode", (Object)this.meteringModeAsString()).add("SampleRate", (Object)this.sampleRate()).add("SpeechThreshold", (Object)this.speechThreshold()).add("StereoDownmix", (Object)this.stereoDownmixAsString()).add("SurroundExMode", (Object)this.surroundExModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bitrate": {
                return Optional.ofNullable(clazz.cast(this.bitrate()));
            }
            case "BitstreamMode": {
                return Optional.ofNullable(clazz.cast(this.bitstreamModeAsString()));
            }
            case "CodingMode": {
                return Optional.ofNullable(clazz.cast(this.codingModeAsString()));
            }
            case "DialogueIntelligence": {
                return Optional.ofNullable(clazz.cast(this.dialogueIntelligenceAsString()));
            }
            case "DownmixControl": {
                return Optional.ofNullable(clazz.cast(this.downmixControlAsString()));
            }
            case "DynamicRangeCompressionLine": {
                return Optional.ofNullable(clazz.cast(this.dynamicRangeCompressionLineAsString()));
            }
            case "DynamicRangeCompressionRf": {
                return Optional.ofNullable(clazz.cast(this.dynamicRangeCompressionRfAsString()));
            }
            case "DynamicRangeControl": {
                return Optional.ofNullable(clazz.cast(this.dynamicRangeControlAsString()));
            }
            case "LoRoCenterMixLevel": {
                return Optional.ofNullable(clazz.cast(this.loRoCenterMixLevel()));
            }
            case "LoRoSurroundMixLevel": {
                return Optional.ofNullable(clazz.cast(this.loRoSurroundMixLevel()));
            }
            case "LtRtCenterMixLevel": {
                return Optional.ofNullable(clazz.cast(this.ltRtCenterMixLevel()));
            }
            case "LtRtSurroundMixLevel": {
                return Optional.ofNullable(clazz.cast(this.ltRtSurroundMixLevel()));
            }
            case "MeteringMode": {
                return Optional.ofNullable(clazz.cast(this.meteringModeAsString()));
            }
            case "SampleRate": {
                return Optional.ofNullable(clazz.cast(this.sampleRate()));
            }
            case "SpeechThreshold": {
                return Optional.ofNullable(clazz.cast(this.speechThreshold()));
            }
            case "StereoDownmix": {
                return Optional.ofNullable(clazz.cast(this.stereoDownmixAsString()));
            }
            case "SurroundExMode": {
                return Optional.ofNullable(clazz.cast(this.surroundExModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Eac3AtmosSettings, T> g) {
        return obj -> g.apply((Eac3AtmosSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer bitrate;
        private String bitstreamMode;
        private String codingMode;
        private String dialogueIntelligence;
        private String downmixControl;
        private String dynamicRangeCompressionLine;
        private String dynamicRangeCompressionRf;
        private String dynamicRangeControl;
        private Double loRoCenterMixLevel;
        private Double loRoSurroundMixLevel;
        private Double ltRtCenterMixLevel;
        private Double ltRtSurroundMixLevel;
        private String meteringMode;
        private Integer sampleRate;
        private Integer speechThreshold;
        private String stereoDownmix;
        private String surroundExMode;

        private BuilderImpl() {
        }

        private BuilderImpl(Eac3AtmosSettings model) {
            this.bitrate(model.bitrate);
            this.bitstreamMode(model.bitstreamMode);
            this.codingMode(model.codingMode);
            this.dialogueIntelligence(model.dialogueIntelligence);
            this.downmixControl(model.downmixControl);
            this.dynamicRangeCompressionLine(model.dynamicRangeCompressionLine);
            this.dynamicRangeCompressionRf(model.dynamicRangeCompressionRf);
            this.dynamicRangeControl(model.dynamicRangeControl);
            this.loRoCenterMixLevel(model.loRoCenterMixLevel);
            this.loRoSurroundMixLevel(model.loRoSurroundMixLevel);
            this.ltRtCenterMixLevel(model.ltRtCenterMixLevel);
            this.ltRtSurroundMixLevel(model.ltRtSurroundMixLevel);
            this.meteringMode(model.meteringMode);
            this.sampleRate(model.sampleRate);
            this.speechThreshold(model.speechThreshold);
            this.stereoDownmix(model.stereoDownmix);
            this.surroundExMode(model.surroundExMode);
        }

        public final Integer getBitrate() {
            return this.bitrate;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final String getBitstreamMode() {
            return this.bitstreamMode;
        }

        public final void setBitstreamMode(String bitstreamMode) {
            this.bitstreamMode = bitstreamMode;
        }

        @Override
        public final Builder bitstreamMode(String bitstreamMode) {
            this.bitstreamMode = bitstreamMode;
            return this;
        }

        @Override
        public final Builder bitstreamMode(Eac3AtmosBitstreamMode bitstreamMode) {
            this.bitstreamMode(bitstreamMode == null ? null : bitstreamMode.toString());
            return this;
        }

        public final String getCodingMode() {
            return this.codingMode;
        }

        public final void setCodingMode(String codingMode) {
            this.codingMode = codingMode;
        }

        @Override
        public final Builder codingMode(String codingMode) {
            this.codingMode = codingMode;
            return this;
        }

        @Override
        public final Builder codingMode(Eac3AtmosCodingMode codingMode) {
            this.codingMode(codingMode == null ? null : codingMode.toString());
            return this;
        }

        public final String getDialogueIntelligence() {
            return this.dialogueIntelligence;
        }

        public final void setDialogueIntelligence(String dialogueIntelligence) {
            this.dialogueIntelligence = dialogueIntelligence;
        }

        @Override
        public final Builder dialogueIntelligence(String dialogueIntelligence) {
            this.dialogueIntelligence = dialogueIntelligence;
            return this;
        }

        @Override
        public final Builder dialogueIntelligence(Eac3AtmosDialogueIntelligence dialogueIntelligence) {
            this.dialogueIntelligence(dialogueIntelligence == null ? null : dialogueIntelligence.toString());
            return this;
        }

        public final String getDownmixControl() {
            return this.downmixControl;
        }

        public final void setDownmixControl(String downmixControl) {
            this.downmixControl = downmixControl;
        }

        @Override
        public final Builder downmixControl(String downmixControl) {
            this.downmixControl = downmixControl;
            return this;
        }

        @Override
        public final Builder downmixControl(Eac3AtmosDownmixControl downmixControl) {
            this.downmixControl(downmixControl == null ? null : downmixControl.toString());
            return this;
        }

        public final String getDynamicRangeCompressionLine() {
            return this.dynamicRangeCompressionLine;
        }

        public final void setDynamicRangeCompressionLine(String dynamicRangeCompressionLine) {
            this.dynamicRangeCompressionLine = dynamicRangeCompressionLine;
        }

        @Override
        public final Builder dynamicRangeCompressionLine(String dynamicRangeCompressionLine) {
            this.dynamicRangeCompressionLine = dynamicRangeCompressionLine;
            return this;
        }

        @Override
        public final Builder dynamicRangeCompressionLine(Eac3AtmosDynamicRangeCompressionLine dynamicRangeCompressionLine) {
            this.dynamicRangeCompressionLine(dynamicRangeCompressionLine == null ? null : dynamicRangeCompressionLine.toString());
            return this;
        }

        public final String getDynamicRangeCompressionRf() {
            return this.dynamicRangeCompressionRf;
        }

        public final void setDynamicRangeCompressionRf(String dynamicRangeCompressionRf) {
            this.dynamicRangeCompressionRf = dynamicRangeCompressionRf;
        }

        @Override
        public final Builder dynamicRangeCompressionRf(String dynamicRangeCompressionRf) {
            this.dynamicRangeCompressionRf = dynamicRangeCompressionRf;
            return this;
        }

        @Override
        public final Builder dynamicRangeCompressionRf(Eac3AtmosDynamicRangeCompressionRf dynamicRangeCompressionRf) {
            this.dynamicRangeCompressionRf(dynamicRangeCompressionRf == null ? null : dynamicRangeCompressionRf.toString());
            return this;
        }

        public final String getDynamicRangeControl() {
            return this.dynamicRangeControl;
        }

        public final void setDynamicRangeControl(String dynamicRangeControl) {
            this.dynamicRangeControl = dynamicRangeControl;
        }

        @Override
        public final Builder dynamicRangeControl(String dynamicRangeControl) {
            this.dynamicRangeControl = dynamicRangeControl;
            return this;
        }

        @Override
        public final Builder dynamicRangeControl(Eac3AtmosDynamicRangeControl dynamicRangeControl) {
            this.dynamicRangeControl(dynamicRangeControl == null ? null : dynamicRangeControl.toString());
            return this;
        }

        public final Double getLoRoCenterMixLevel() {
            return this.loRoCenterMixLevel;
        }

        public final void setLoRoCenterMixLevel(Double loRoCenterMixLevel) {
            this.loRoCenterMixLevel = loRoCenterMixLevel;
        }

        @Override
        public final Builder loRoCenterMixLevel(Double loRoCenterMixLevel) {
            this.loRoCenterMixLevel = loRoCenterMixLevel;
            return this;
        }

        public final Double getLoRoSurroundMixLevel() {
            return this.loRoSurroundMixLevel;
        }

        public final void setLoRoSurroundMixLevel(Double loRoSurroundMixLevel) {
            this.loRoSurroundMixLevel = loRoSurroundMixLevel;
        }

        @Override
        public final Builder loRoSurroundMixLevel(Double loRoSurroundMixLevel) {
            this.loRoSurroundMixLevel = loRoSurroundMixLevel;
            return this;
        }

        public final Double getLtRtCenterMixLevel() {
            return this.ltRtCenterMixLevel;
        }

        public final void setLtRtCenterMixLevel(Double ltRtCenterMixLevel) {
            this.ltRtCenterMixLevel = ltRtCenterMixLevel;
        }

        @Override
        public final Builder ltRtCenterMixLevel(Double ltRtCenterMixLevel) {
            this.ltRtCenterMixLevel = ltRtCenterMixLevel;
            return this;
        }

        public final Double getLtRtSurroundMixLevel() {
            return this.ltRtSurroundMixLevel;
        }

        public final void setLtRtSurroundMixLevel(Double ltRtSurroundMixLevel) {
            this.ltRtSurroundMixLevel = ltRtSurroundMixLevel;
        }

        @Override
        public final Builder ltRtSurroundMixLevel(Double ltRtSurroundMixLevel) {
            this.ltRtSurroundMixLevel = ltRtSurroundMixLevel;
            return this;
        }

        public final String getMeteringMode() {
            return this.meteringMode;
        }

        public final void setMeteringMode(String meteringMode) {
            this.meteringMode = meteringMode;
        }

        @Override
        public final Builder meteringMode(String meteringMode) {
            this.meteringMode = meteringMode;
            return this;
        }

        @Override
        public final Builder meteringMode(Eac3AtmosMeteringMode meteringMode) {
            this.meteringMode(meteringMode == null ? null : meteringMode.toString());
            return this;
        }

        public final Integer getSampleRate() {
            return this.sampleRate;
        }

        public final void setSampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
        }

        @Override
        public final Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final Integer getSpeechThreshold() {
            return this.speechThreshold;
        }

        public final void setSpeechThreshold(Integer speechThreshold) {
            this.speechThreshold = speechThreshold;
        }

        @Override
        public final Builder speechThreshold(Integer speechThreshold) {
            this.speechThreshold = speechThreshold;
            return this;
        }

        public final String getStereoDownmix() {
            return this.stereoDownmix;
        }

        public final void setStereoDownmix(String stereoDownmix) {
            this.stereoDownmix = stereoDownmix;
        }

        @Override
        public final Builder stereoDownmix(String stereoDownmix) {
            this.stereoDownmix = stereoDownmix;
            return this;
        }

        @Override
        public final Builder stereoDownmix(Eac3AtmosStereoDownmix stereoDownmix) {
            this.stereoDownmix(stereoDownmix == null ? null : stereoDownmix.toString());
            return this;
        }

        public final String getSurroundExMode() {
            return this.surroundExMode;
        }

        public final void setSurroundExMode(String surroundExMode) {
            this.surroundExMode = surroundExMode;
        }

        @Override
        public final Builder surroundExMode(String surroundExMode) {
            this.surroundExMode = surroundExMode;
            return this;
        }

        @Override
        public final Builder surroundExMode(Eac3AtmosSurroundExMode surroundExMode) {
            this.surroundExMode(surroundExMode == null ? null : surroundExMode.toString());
            return this;
        }

        public Eac3AtmosSettings build() {
            return new Eac3AtmosSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Eac3AtmosSettings> {
        public Builder bitrate(Integer var1);

        public Builder bitstreamMode(String var1);

        public Builder bitstreamMode(Eac3AtmosBitstreamMode var1);

        public Builder codingMode(String var1);

        public Builder codingMode(Eac3AtmosCodingMode var1);

        public Builder dialogueIntelligence(String var1);

        public Builder dialogueIntelligence(Eac3AtmosDialogueIntelligence var1);

        public Builder downmixControl(String var1);

        public Builder downmixControl(Eac3AtmosDownmixControl var1);

        public Builder dynamicRangeCompressionLine(String var1);

        public Builder dynamicRangeCompressionLine(Eac3AtmosDynamicRangeCompressionLine var1);

        public Builder dynamicRangeCompressionRf(String var1);

        public Builder dynamicRangeCompressionRf(Eac3AtmosDynamicRangeCompressionRf var1);

        public Builder dynamicRangeControl(String var1);

        public Builder dynamicRangeControl(Eac3AtmosDynamicRangeControl var1);

        public Builder loRoCenterMixLevel(Double var1);

        public Builder loRoSurroundMixLevel(Double var1);

        public Builder ltRtCenterMixLevel(Double var1);

        public Builder ltRtSurroundMixLevel(Double var1);

        public Builder meteringMode(String var1);

        public Builder meteringMode(Eac3AtmosMeteringMode var1);

        public Builder sampleRate(Integer var1);

        public Builder speechThreshold(Integer var1);

        public Builder stereoDownmix(String var1);

        public Builder stereoDownmix(Eac3AtmosStereoDownmix var1);

        public Builder surroundExMode(String var1);

        public Builder surroundExMode(Eac3AtmosSurroundExMode var1);
    }
}

