/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeregisterGatewayInstanceResponse extends MediaConnectResponse implements
        ToCopyableBuilder<DeregisterGatewayInstanceResponse.Builder, DeregisterGatewayInstanceResponse> {
    private static final SdkField<String> GATEWAY_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayInstanceArn").getter(getter(DeregisterGatewayInstanceResponse::gatewayInstanceArn))
            .setter(setter(Builder::gatewayInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayInstanceArn").build())
            .build();

    private static final SdkField<String> INSTANCE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceState").getter(getter(DeregisterGatewayInstanceResponse::instanceStateAsString))
            .setter(setter(Builder::instanceState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_INSTANCE_ARN_FIELD,
            INSTANCE_STATE_FIELD));

    private final String gatewayInstanceArn;

    private final String instanceState;

    private DeregisterGatewayInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayInstanceArn = builder.gatewayInstanceArn;
        this.instanceState = builder.instanceState;
    }

    /**
     * The Amazon Resource Name (ARN) of the instance.
     * 
     * @return The Amazon Resource Name (ARN) of the instance.
     */
    public final String gatewayInstanceArn() {
        return gatewayInstanceArn;
    }

    /**
     * The status of the instance.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceState}
     * will return {@link InstanceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceStateAsString}.
     * </p>
     * 
     * @return The status of the instance.
     * @see InstanceState
     */
    public final InstanceState instanceState() {
        return InstanceState.fromValue(instanceState);
    }

    /**
     * The status of the instance.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceState}
     * will return {@link InstanceState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceStateAsString}.
     * </p>
     * 
     * @return The status of the instance.
     * @see InstanceState
     */
    public final String instanceStateAsString() {
        return instanceState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterGatewayInstanceResponse)) {
            return false;
        }
        DeregisterGatewayInstanceResponse other = (DeregisterGatewayInstanceResponse) obj;
        return Objects.equals(gatewayInstanceArn(), other.gatewayInstanceArn())
                && Objects.equals(instanceStateAsString(), other.instanceStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeregisterGatewayInstanceResponse").add("GatewayInstanceArn", gatewayInstanceArn())
                .add("InstanceState", instanceStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayInstanceArn":
            return Optional.ofNullable(clazz.cast(gatewayInstanceArn()));
        case "InstanceState":
            return Optional.ofNullable(clazz.cast(instanceStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeregisterGatewayInstanceResponse, T> g) {
        return obj -> g.apply((DeregisterGatewayInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeregisterGatewayInstanceResponse> {
        /**
         * The Amazon Resource Name (ARN) of the instance.
         * 
         * @param gatewayInstanceArn
         *        The Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayInstanceArn(String gatewayInstanceArn);

        /**
         * The status of the instance.
         * 
         * @param instanceState
         *        The status of the instance.
         * @see InstanceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceState
         */
        Builder instanceState(String instanceState);

        /**
         * The status of the instance.
         * 
         * @param instanceState
         *        The status of the instance.
         * @see InstanceState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceState
         */
        Builder instanceState(InstanceState instanceState);
    }

    static final class BuilderImpl extends MediaConnectResponse.BuilderImpl implements Builder {
        private String gatewayInstanceArn;

        private String instanceState;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterGatewayInstanceResponse model) {
            super(model);
            gatewayInstanceArn(model.gatewayInstanceArn);
            instanceState(model.instanceState);
        }

        public final String getGatewayInstanceArn() {
            return gatewayInstanceArn;
        }

        public final void setGatewayInstanceArn(String gatewayInstanceArn) {
            this.gatewayInstanceArn = gatewayInstanceArn;
        }

        @Override
        public final Builder gatewayInstanceArn(String gatewayInstanceArn) {
            this.gatewayInstanceArn = gatewayInstanceArn;
            return this;
        }

        public final String getInstanceState() {
            return instanceState;
        }

        public final void setInstanceState(String instanceState) {
            this.instanceState = instanceState;
        }

        @Override
        public final Builder instanceState(String instanceState) {
            this.instanceState = instanceState;
            return this;
        }

        @Override
        public final Builder instanceState(InstanceState instanceState) {
            this.instanceState(instanceState == null ? null : instanceState.toString());
            return this;
        }

        @Override
        public DeregisterGatewayInstanceResponse build() {
            return new DeregisterGatewayInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
