/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Range {
    NARROW("NARROW"),
    FULL("FULL"),
    FULLPROTECT("FULLPROTECT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Range> VALUE_MAP;
    private final String value;

    private Range(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Range fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Range> knownValues() {
        EnumSet<Range> knownValues = EnumSet.allOf(Range.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Range.class, Range::toString);
    }
}

