/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TimeRange {
    MONTH_TO_DATE("MONTH_TO_DATE"),
    PAST_30_DAYS("PAST_30_DAYS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TimeRange> VALUE_MAP;
    private final String value;

    private TimeRange(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TimeRange fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TimeRange> knownValues() {
        EnumSet<TimeRange> knownValues = EnumSet.allOf(TimeRange.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TimeRange.class, TimeRange::toString);
    }
}

