/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutvision.LookoutVisionAsyncClient;
import software.amazon.awssdk.services.lookoutvision.internal.UserAgentUtils;
import software.amazon.awssdk.services.lookoutvision.model.ListModelsRequest;
import software.amazon.awssdk.services.lookoutvision.model.ListModelsResponse;
import software.amazon.awssdk.services.lookoutvision.model.ModelMetadata;

public class ListModelsPublisher
implements SdkPublisher<ListModelsResponse> {
    private final LookoutVisionAsyncClient client;
    private final ListModelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListModelsPublisher(LookoutVisionAsyncClient client, ListModelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListModelsPublisher(LookoutVisionAsyncClient client, ListModelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListModelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListModelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ModelMetadata> models() {
        Function<ListModelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.models() != null) {
                return response.models().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListModelsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListModelsResponseFetcher
    implements AsyncPageFetcher<ListModelsResponse> {
        private ListModelsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListModelsResponse> nextPage(ListModelsResponse previousPage) {
            if (previousPage == null) {
                return ListModelsPublisher.this.client.listModels(ListModelsPublisher.this.firstRequest);
            }
            return ListModelsPublisher.this.client.listModels((ListModelsRequest)((Object)ListModelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

