/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutvision.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ModelHostingStatus {
    STARTING_HOSTING("STARTING_HOSTING"),
    HOSTED("HOSTED"),
    HOSTING_FAILED("HOSTING_FAILED"),
    STOPPING_HOSTING("STOPPING_HOSTING"),
    SYSTEM_UPDATING("SYSTEM_UPDATING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ModelHostingStatus> VALUE_MAP;
    private final String value;

    private ModelHostingStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelHostingStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelHostingStatus> knownValues() {
        EnumSet<ModelHostingStatus> knownValues = EnumSet.allOf(ModelHostingStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ModelHostingStatus.class, ModelHostingStatus::toString);
    }
}

