/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionStatus;
import software.amazon.awssdk.services.lookoutequipment.model.InferenceInputConfiguration;
import software.amazon.awssdk.services.lookoutequipment.model.InferenceOutputConfiguration;
import software.amazon.awssdk.services.lookoutequipment.model.S3Object;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferenceExecutionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InferenceExecutionSummary> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(InferenceExecutionSummary.getter(InferenceExecutionSummary::modelName)).setter(InferenceExecutionSummary.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelArn").getter(InferenceExecutionSummary.getter(InferenceExecutionSummary::modelArn)).setter(InferenceExecutionSummary.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()}).build();
    private static final SdkField<String> INFERENCE_SCHEDULER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceSchedulerName").getter(InferenceExecutionSummary.getter(InferenceExecutionSummary::inferenceSchedulerName)).setter(InferenceExecutionSummary.setter(Builder::inferenceSchedulerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerName").build()}).build();
    private static final SdkField<String> INFERENCE_SCHEDULER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceSchedulerArn").getter(InferenceExecutionSummary.getter(InferenceExecutionSummary::inferenceSchedulerArn)).setter(InferenceExecutionSummary.setter(Builder::inferenceSchedulerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerArn").build()}).build();
    private static final SdkField<Instant> SCHEDULED_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScheduledStartTime").getter(InferenceExecutionSummary.getter(InferenceExecutionSummary::scheduledStartTime)).setter(InferenceExecutionSummary.setter(Builder::scheduledStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledStartTime").build()}).build();
    private static final SdkField<Instant> DATA_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DataStartTime").getter(InferenceExecutionSummary.getter(InferenceExecutionSummary::dataStartTime)).setter(InferenceExecutionSummary.setter(Builder::dataStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStartTime").build()}).build();
    private static final SdkField<Instant> DATA_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DataEndTime").getter(InferenceExecutionSummary.getter(InferenceExecutionSummary::dataEndTime)).setter(InferenceExecutionSummary.setter(Builder::dataEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataEndTime").build()}).build();
    private static final SdkField<InferenceInputConfiguration> DATA_INPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataInputConfiguration").getter(InferenceExecutionSummary.getter(InferenceExecutionSummary::dataInputConfiguration)).setter(InferenceExecutionSummary.setter(Builder::dataInputConfiguration)).constructor(InferenceInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataInputConfiguration").build()}).build();
    private static final SdkField<InferenceOutputConfiguration> DATA_OUTPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataOutputConfiguration").getter(InferenceExecutionSummary.getter(InferenceExecutionSummary::dataOutputConfiguration)).setter(InferenceExecutionSummary.setter(Builder::dataOutputConfiguration)).constructor(InferenceOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataOutputConfiguration").build()}).build();
    private static final SdkField<S3Object> CUSTOMER_RESULT_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomerResultObject").getter(InferenceExecutionSummary.getter(InferenceExecutionSummary::customerResultObject)).setter(InferenceExecutionSummary.setter(Builder::customerResultObject)).constructor(S3Object::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerResultObject").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(InferenceExecutionSummary.getter(InferenceExecutionSummary::statusAsString)).setter(InferenceExecutionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> FAILED_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailedReason").getter(InferenceExecutionSummary.getter(InferenceExecutionSummary::failedReason)).setter(InferenceExecutionSummary.setter(Builder::failedReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedReason").build()}).build();
    private static final SdkField<Long> MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ModelVersion").getter(InferenceExecutionSummary.getter(InferenceExecutionSummary::modelVersion)).setter(InferenceExecutionSummary.setter(Builder::modelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()}).build();
    private static final SdkField<String> MODEL_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelVersionArn").getter(InferenceExecutionSummary.getter(InferenceExecutionSummary::modelVersionArn)).setter(InferenceExecutionSummary.setter(Builder::modelVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersionArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, MODEL_ARN_FIELD, INFERENCE_SCHEDULER_NAME_FIELD, INFERENCE_SCHEDULER_ARN_FIELD, SCHEDULED_START_TIME_FIELD, DATA_START_TIME_FIELD, DATA_END_TIME_FIELD, DATA_INPUT_CONFIGURATION_FIELD, DATA_OUTPUT_CONFIGURATION_FIELD, CUSTOMER_RESULT_OBJECT_FIELD, STATUS_FIELD, FAILED_REASON_FIELD, MODEL_VERSION_FIELD, MODEL_VERSION_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String modelName;
    private final String modelArn;
    private final String inferenceSchedulerName;
    private final String inferenceSchedulerArn;
    private final Instant scheduledStartTime;
    private final Instant dataStartTime;
    private final Instant dataEndTime;
    private final InferenceInputConfiguration dataInputConfiguration;
    private final InferenceOutputConfiguration dataOutputConfiguration;
    private final S3Object customerResultObject;
    private final String status;
    private final String failedReason;
    private final Long modelVersion;
    private final String modelVersionArn;

    private InferenceExecutionSummary(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.modelArn = builder.modelArn;
        this.inferenceSchedulerName = builder.inferenceSchedulerName;
        this.inferenceSchedulerArn = builder.inferenceSchedulerArn;
        this.scheduledStartTime = builder.scheduledStartTime;
        this.dataStartTime = builder.dataStartTime;
        this.dataEndTime = builder.dataEndTime;
        this.dataInputConfiguration = builder.dataInputConfiguration;
        this.dataOutputConfiguration = builder.dataOutputConfiguration;
        this.customerResultObject = builder.customerResultObject;
        this.status = builder.status;
        this.failedReason = builder.failedReason;
        this.modelVersion = builder.modelVersion;
        this.modelVersionArn = builder.modelVersionArn;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final String inferenceSchedulerName() {
        return this.inferenceSchedulerName;
    }

    public final String inferenceSchedulerArn() {
        return this.inferenceSchedulerArn;
    }

    public final Instant scheduledStartTime() {
        return this.scheduledStartTime;
    }

    public final Instant dataStartTime() {
        return this.dataStartTime;
    }

    public final Instant dataEndTime() {
        return this.dataEndTime;
    }

    public final InferenceInputConfiguration dataInputConfiguration() {
        return this.dataInputConfiguration;
    }

    public final InferenceOutputConfiguration dataOutputConfiguration() {
        return this.dataOutputConfiguration;
    }

    public final S3Object customerResultObject() {
        return this.customerResultObject;
    }

    public final InferenceExecutionStatus status() {
        return InferenceExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String failedReason() {
        return this.failedReason;
    }

    public final Long modelVersion() {
        return this.modelVersion;
    }

    public final String modelVersionArn() {
        return this.modelVersionArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSchedulerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSchedulerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataOutputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerResultObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersionArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceExecutionSummary)) {
            return false;
        }
        InferenceExecutionSummary other = (InferenceExecutionSummary)obj;
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.inferenceSchedulerName(), other.inferenceSchedulerName()) && Objects.equals(this.inferenceSchedulerArn(), other.inferenceSchedulerArn()) && Objects.equals(this.scheduledStartTime(), other.scheduledStartTime()) && Objects.equals(this.dataStartTime(), other.dataStartTime()) && Objects.equals(this.dataEndTime(), other.dataEndTime()) && Objects.equals(this.dataInputConfiguration(), other.dataInputConfiguration()) && Objects.equals(this.dataOutputConfiguration(), other.dataOutputConfiguration()) && Objects.equals(this.customerResultObject(), other.customerResultObject()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failedReason(), other.failedReason()) && Objects.equals(this.modelVersion(), other.modelVersion()) && Objects.equals(this.modelVersionArn(), other.modelVersionArn());
    }

    public final String toString() {
        return ToString.builder((String)"InferenceExecutionSummary").add("ModelName", (Object)this.modelName()).add("ModelArn", (Object)this.modelArn()).add("InferenceSchedulerName", (Object)this.inferenceSchedulerName()).add("InferenceSchedulerArn", (Object)this.inferenceSchedulerArn()).add("ScheduledStartTime", (Object)this.scheduledStartTime()).add("DataStartTime", (Object)this.dataStartTime()).add("DataEndTime", (Object)this.dataEndTime()).add("DataInputConfiguration", (Object)this.dataInputConfiguration()).add("DataOutputConfiguration", (Object)this.dataOutputConfiguration()).add("CustomerResultObject", (Object)this.customerResultObject()).add("Status", (Object)this.statusAsString()).add("FailedReason", (Object)this.failedReason()).add("ModelVersion", (Object)this.modelVersion()).add("ModelVersionArn", (Object)this.modelVersionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "ModelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "InferenceSchedulerName": {
                return Optional.ofNullable(clazz.cast(this.inferenceSchedulerName()));
            }
            case "InferenceSchedulerArn": {
                return Optional.ofNullable(clazz.cast(this.inferenceSchedulerArn()));
            }
            case "ScheduledStartTime": {
                return Optional.ofNullable(clazz.cast(this.scheduledStartTime()));
            }
            case "DataStartTime": {
                return Optional.ofNullable(clazz.cast(this.dataStartTime()));
            }
            case "DataEndTime": {
                return Optional.ofNullable(clazz.cast(this.dataEndTime()));
            }
            case "DataInputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataInputConfiguration()));
            }
            case "DataOutputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataOutputConfiguration()));
            }
            case "CustomerResultObject": {
                return Optional.ofNullable(clazz.cast(this.customerResultObject()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "FailedReason": {
                return Optional.ofNullable(clazz.cast(this.failedReason()));
            }
            case "ModelVersion": {
                return Optional.ofNullable(clazz.cast(this.modelVersion()));
            }
            case "ModelVersionArn": {
                return Optional.ofNullable(clazz.cast(this.modelVersionArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferenceExecutionSummary, T> g) {
        return obj -> g.apply((InferenceExecutionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelName;
        private String modelArn;
        private String inferenceSchedulerName;
        private String inferenceSchedulerArn;
        private Instant scheduledStartTime;
        private Instant dataStartTime;
        private Instant dataEndTime;
        private InferenceInputConfiguration dataInputConfiguration;
        private InferenceOutputConfiguration dataOutputConfiguration;
        private S3Object customerResultObject;
        private String status;
        private String failedReason;
        private Long modelVersion;
        private String modelVersionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceExecutionSummary model) {
            this.modelName(model.modelName);
            this.modelArn(model.modelArn);
            this.inferenceSchedulerName(model.inferenceSchedulerName);
            this.inferenceSchedulerArn(model.inferenceSchedulerArn);
            this.scheduledStartTime(model.scheduledStartTime);
            this.dataStartTime(model.dataStartTime);
            this.dataEndTime(model.dataEndTime);
            this.dataInputConfiguration(model.dataInputConfiguration);
            this.dataOutputConfiguration(model.dataOutputConfiguration);
            this.customerResultObject(model.customerResultObject);
            this.status(model.status);
            this.failedReason(model.failedReason);
            this.modelVersion(model.modelVersion);
            this.modelVersionArn(model.modelVersionArn);
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getInferenceSchedulerName() {
            return this.inferenceSchedulerName;
        }

        public final void setInferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
        }

        @Override
        public final Builder inferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
            return this;
        }

        public final String getInferenceSchedulerArn() {
            return this.inferenceSchedulerArn;
        }

        public final void setInferenceSchedulerArn(String inferenceSchedulerArn) {
            this.inferenceSchedulerArn = inferenceSchedulerArn;
        }

        @Override
        public final Builder inferenceSchedulerArn(String inferenceSchedulerArn) {
            this.inferenceSchedulerArn = inferenceSchedulerArn;
            return this;
        }

        public final Instant getScheduledStartTime() {
            return this.scheduledStartTime;
        }

        public final void setScheduledStartTime(Instant scheduledStartTime) {
            this.scheduledStartTime = scheduledStartTime;
        }

        @Override
        public final Builder scheduledStartTime(Instant scheduledStartTime) {
            this.scheduledStartTime = scheduledStartTime;
            return this;
        }

        public final Instant getDataStartTime() {
            return this.dataStartTime;
        }

        public final void setDataStartTime(Instant dataStartTime) {
            this.dataStartTime = dataStartTime;
        }

        @Override
        public final Builder dataStartTime(Instant dataStartTime) {
            this.dataStartTime = dataStartTime;
            return this;
        }

        public final Instant getDataEndTime() {
            return this.dataEndTime;
        }

        public final void setDataEndTime(Instant dataEndTime) {
            this.dataEndTime = dataEndTime;
        }

        @Override
        public final Builder dataEndTime(Instant dataEndTime) {
            this.dataEndTime = dataEndTime;
            return this;
        }

        public final InferenceInputConfiguration.Builder getDataInputConfiguration() {
            return this.dataInputConfiguration != null ? this.dataInputConfiguration.toBuilder() : null;
        }

        public final void setDataInputConfiguration(InferenceInputConfiguration.BuilderImpl dataInputConfiguration) {
            this.dataInputConfiguration = dataInputConfiguration != null ? dataInputConfiguration.build() : null;
        }

        @Override
        public final Builder dataInputConfiguration(InferenceInputConfiguration dataInputConfiguration) {
            this.dataInputConfiguration = dataInputConfiguration;
            return this;
        }

        public final InferenceOutputConfiguration.Builder getDataOutputConfiguration() {
            return this.dataOutputConfiguration != null ? this.dataOutputConfiguration.toBuilder() : null;
        }

        public final void setDataOutputConfiguration(InferenceOutputConfiguration.BuilderImpl dataOutputConfiguration) {
            this.dataOutputConfiguration = dataOutputConfiguration != null ? dataOutputConfiguration.build() : null;
        }

        @Override
        public final Builder dataOutputConfiguration(InferenceOutputConfiguration dataOutputConfiguration) {
            this.dataOutputConfiguration = dataOutputConfiguration;
            return this;
        }

        public final S3Object.Builder getCustomerResultObject() {
            return this.customerResultObject != null ? this.customerResultObject.toBuilder() : null;
        }

        public final void setCustomerResultObject(S3Object.BuilderImpl customerResultObject) {
            this.customerResultObject = customerResultObject != null ? customerResultObject.build() : null;
        }

        @Override
        public final Builder customerResultObject(S3Object customerResultObject) {
            this.customerResultObject = customerResultObject;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InferenceExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailedReason() {
            return this.failedReason;
        }

        public final void setFailedReason(String failedReason) {
            this.failedReason = failedReason;
        }

        @Override
        public final Builder failedReason(String failedReason) {
            this.failedReason = failedReason;
            return this;
        }

        public final Long getModelVersion() {
            return this.modelVersion;
        }

        public final void setModelVersion(Long modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public final Builder modelVersion(Long modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final String getModelVersionArn() {
            return this.modelVersionArn;
        }

        public final void setModelVersionArn(String modelVersionArn) {
            this.modelVersionArn = modelVersionArn;
        }

        @Override
        public final Builder modelVersionArn(String modelVersionArn) {
            this.modelVersionArn = modelVersionArn;
            return this;
        }

        public InferenceExecutionSummary build() {
            return new InferenceExecutionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InferenceExecutionSummary> {
        public Builder modelName(String var1);

        public Builder modelArn(String var1);

        public Builder inferenceSchedulerName(String var1);

        public Builder inferenceSchedulerArn(String var1);

        public Builder scheduledStartTime(Instant var1);

        public Builder dataStartTime(Instant var1);

        public Builder dataEndTime(Instant var1);

        public Builder dataInputConfiguration(InferenceInputConfiguration var1);

        default public Builder dataInputConfiguration(Consumer<InferenceInputConfiguration.Builder> dataInputConfiguration) {
            return this.dataInputConfiguration((InferenceInputConfiguration)((InferenceInputConfiguration.Builder)InferenceInputConfiguration.builder().applyMutation(dataInputConfiguration)).build());
        }

        public Builder dataOutputConfiguration(InferenceOutputConfiguration var1);

        default public Builder dataOutputConfiguration(Consumer<InferenceOutputConfiguration.Builder> dataOutputConfiguration) {
            return this.dataOutputConfiguration((InferenceOutputConfiguration)((InferenceOutputConfiguration.Builder)InferenceOutputConfiguration.builder().applyMutation(dataOutputConfiguration)).build());
        }

        public Builder customerResultObject(S3Object var1);

        default public Builder customerResultObject(Consumer<S3Object.Builder> customerResultObject) {
            return this.customerResultObject((S3Object)((S3Object.Builder)S3Object.builder().applyMutation(customerResultObject)).build());
        }

        public Builder status(String var1);

        public Builder status(InferenceExecutionStatus var1);

        public Builder failedReason(String var1);

        public Builder modelVersion(Long var1);

        public Builder modelVersionArn(String var1);
    }
}

