/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListModelVersionsResponse extends LookoutEquipmentResponse implements
        ToCopyableBuilder<ListModelVersionsResponse.Builder, ListModelVersionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListModelVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ModelVersionSummary>> MODEL_VERSION_SUMMARIES_FIELD = SdkField
            .<List<ModelVersionSummary>> builder(MarshallingType.LIST)
            .memberName("ModelVersionSummaries")
            .getter(getter(ListModelVersionsResponse::modelVersionSummaries))
            .setter(setter(Builder::modelVersionSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersionSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MODEL_VERSION_SUMMARIES_FIELD));

    private final String nextToken;

    private final List<ModelVersionSummary> modelVersionSummaries;

    private ListModelVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.modelVersionSummaries = builder.modelVersionSummaries;
    }

    /**
     * <p>
     * If the total number of results exceeds the limit that the response can display, the response returns an opaque
     * pagination token indicating where to continue the listing of machine learning model versions. Use this token in
     * the <code>NextToken</code> field in the request to list the next page of results.
     * </p>
     * 
     * @return If the total number of results exceeds the limit that the response can display, the response returns an
     *         opaque pagination token indicating where to continue the listing of machine learning model versions. Use
     *         this token in the <code>NextToken</code> field in the request to list the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModelVersionSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasModelVersionSummaries() {
        return modelVersionSummaries != null && !(modelVersionSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides information on the specified model version, including the created time, model and dataset ARNs, and
     * status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModelVersionSummaries} method.
     * </p>
     * 
     * @return Provides information on the specified model version, including the created time, model and dataset ARNs,
     *         and status.
     */
    public final List<ModelVersionSummary> modelVersionSummaries() {
        return modelVersionSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasModelVersionSummaries() ? modelVersionSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelVersionsResponse)) {
            return false;
        }
        ListModelVersionsResponse other = (ListModelVersionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasModelVersionSummaries() == other.hasModelVersionSummaries()
                && Objects.equals(modelVersionSummaries(), other.modelVersionSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListModelVersionsResponse").add("NextToken", nextToken())
                .add("ModelVersionSummaries", hasModelVersionSummaries() ? modelVersionSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ModelVersionSummaries":
            return Optional.ofNullable(clazz.cast(modelVersionSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListModelVersionsResponse, T> g) {
        return obj -> g.apply((ListModelVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListModelVersionsResponse> {
        /**
         * <p>
         * If the total number of results exceeds the limit that the response can display, the response returns an
         * opaque pagination token indicating where to continue the listing of machine learning model versions. Use this
         * token in the <code>NextToken</code> field in the request to list the next page of results.
         * </p>
         * 
         * @param nextToken
         *        If the total number of results exceeds the limit that the response can display, the response returns
         *        an opaque pagination token indicating where to continue the listing of machine learning model
         *        versions. Use this token in the <code>NextToken</code> field in the request to list the next page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Provides information on the specified model version, including the created time, model and dataset ARNs, and
         * status.
         * </p>
         * 
         * @param modelVersionSummaries
         *        Provides information on the specified model version, including the created time, model and dataset
         *        ARNs, and status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersionSummaries(Collection<ModelVersionSummary> modelVersionSummaries);

        /**
         * <p>
         * Provides information on the specified model version, including the created time, model and dataset ARNs, and
         * status.
         * </p>
         * 
         * @param modelVersionSummaries
         *        Provides information on the specified model version, including the created time, model and dataset
         *        ARNs, and status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersionSummaries(ModelVersionSummary... modelVersionSummaries);

        /**
         * <p>
         * Provides information on the specified model version, including the created time, model and dataset ARNs, and
         * status.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #modelVersionSummaries(List<ModelVersionSummary>)}.
         * 
         * @param modelVersionSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelVersionSummaries(java.util.Collection<ModelVersionSummary>)
         */
        Builder modelVersionSummaries(Consumer<ModelVersionSummary.Builder>... modelVersionSummaries);
    }

    static final class BuilderImpl extends LookoutEquipmentResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ModelVersionSummary> modelVersionSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelVersionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            modelVersionSummaries(model.modelVersionSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ModelVersionSummary.Builder> getModelVersionSummaries() {
            List<ModelVersionSummary.Builder> result = ModelVersionSummariesCopier.copyToBuilder(this.modelVersionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelVersionSummaries(Collection<ModelVersionSummary.BuilderImpl> modelVersionSummaries) {
            this.modelVersionSummaries = ModelVersionSummariesCopier.copyFromBuilder(modelVersionSummaries);
        }

        @Override
        public final Builder modelVersionSummaries(Collection<ModelVersionSummary> modelVersionSummaries) {
            this.modelVersionSummaries = ModelVersionSummariesCopier.copy(modelVersionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVersionSummaries(ModelVersionSummary... modelVersionSummaries) {
            modelVersionSummaries(Arrays.asList(modelVersionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelVersionSummaries(Consumer<ModelVersionSummary.Builder>... modelVersionSummaries) {
            modelVersionSummaries(Stream.of(modelVersionSummaries)
                    .map(c -> ModelVersionSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListModelVersionsResponse build() {
            return new ListModelVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
